/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotWorld;
import com.plotsquared.core.util.PlotAreaConverter;
import com.plotsquared.core.util.RegionUtil;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.khelekore.prtree.PRTree;
import org.khelekore.prtree.SimpleMBR;

public class ScatteredPlotWorld
extends PlotWorld {
    private static final PlotAreaConverter MBR_CONVERTER = new PlotAreaConverter();
    private static final int BRANCH_FACTOR = 30;
    private final List<PlotArea> areas = new LinkedList<PlotArea>();
    private final Object treeLock = new Object();
    private PRTree<PlotArea> areaTree;

    public ScatteredPlotWorld(@NonNull String world) {
        super(world);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable PlotArea getArea(@NonNull Location location) {
        if (this.areas.isEmpty()) {
            return null;
        }
        Object object = this.treeLock;
        synchronized (object) {
            for (PlotArea area : this.areaTree.find(location.toMBR())) {
                if (!area.contains(location)) continue;
                return area;
            }
        }
        return null;
    }

    @Override
    public @NonNull Collection<PlotArea> getAreas() {
        return Collections.unmodifiableCollection(this.areas);
    }

    @Override
    public void addArea(@NonNull PlotArea area) {
        this.areas.add(area);
        this.buildTree();
    }

    @Override
    public void removeArea(@NonNull PlotArea area) {
        this.areas.remove(area);
        this.buildTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Collection<PlotArea> getAreasInRegion(@NonNull CuboidRegion region) {
        if (this.areas.isEmpty()) {
            return Collections.emptyList();
        }
        Object object = this.treeLock;
        synchronized (object) {
            LinkedList<PlotArea> areas = new LinkedList<PlotArea>();
            BlockVector3 min = region.getMinimumPoint();
            BlockVector3 max = region.getMaximumPoint();
            SimpleMBR mbr = new SimpleMBR(min.getX(), max.getX(), min.getY(), max.getY(), min.getZ(), max.getZ());
            for (PlotArea area : this.areaTree.find(mbr)) {
                if (!RegionUtil.intersects(area.getRegion(), region)) continue;
                areas.add(area);
            }
            return areas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildTree() {
        Object object = this.treeLock;
        synchronized (object) {
            this.areaTree = new PRTree<PlotArea>(MBR_CONVERTER, 30);
            this.areaTree.load(this.areas);
        }
    }
}

