/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.setup;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.setup.SetupStep;
import com.plotsquared.core.util.TabCompletions;
import java.util.Collection;
import java.util.Collections;
import net.kyori.adventure.text.minimessage.Template;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SettingsNodeStep
implements SetupStep {
    private final ConfigurationNode configurationNode;
    private final int id;
    private final SetupStep next;

    public SettingsNodeStep(ConfigurationNode configurationNode, int id, SettingsNodesWrapper wrapper) {
        this.configurationNode = configurationNode;
        this.id = id;
        this.next = wrapper.getSettingsNodes().length > id + 1 ? new SettingsNodeStep(wrapper.getSettingsNodes()[id + 1], id + 1, wrapper) : wrapper.getAfterwards();
    }

    @Override
    public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder builder, String argument) {
        if (this.configurationNode.isValid(argument)) {
            this.configurationNode.setValue(argument);
        }
        return this.next;
    }

    @Override
    public @NonNull Collection<String> getSuggestions() {
        return this.configurationNode.getSuggestions();
    }

    @Override
    public @Nullable String getDefaultValue() {
        return String.valueOf(this.configurationNode.getDefaultValue());
    }

    @Override
    public void announce(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage(TranslatableCaption.of("setup.setup_step"), Template.of("step", String.valueOf(this.getId() + 1)), Template.of("description", this.configurationNode.getDescription().getComponent(plotPlayer)), Template.of("type", this.configurationNode.getType().getType()), Template.of("value", String.valueOf(this.configurationNode.getDefaultValue())));
    }

    @Override
    public Collection<Command> createSuggestions(PlotPlayer<?> plotPlayer, String argument) {
        switch (this.configurationNode.getType().getType()) {
            case "BLOCK_BUCKET": {
                return TabCompletions.completePatterns(argument);
            }
            case "INTEGER": {
                if (this.getDefaultValue() != null && this.getDefaultValue().startsWith(argument)) {
                    return Collections.singletonList(new Command(null, false, this.getDefaultValue(), "", RequiredType.NONE, null){});
                }
            }
            case "BOOLEAN": {
                return TabCompletions.completeBoolean(argument);
            }
        }
        return Collections.emptyList();
    }

    public ConfigurationNode getConfigurationNode() {
        return this.configurationNode;
    }

    public int getId() {
        return this.id;
    }
}

