/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.accessors;

import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.DefaultConstrutorAccessor;
import com.comphenix.protocol.reflect.accessors.DefaultFieldAccessor;
import com.comphenix.protocol.reflect.accessors.DefaultMethodAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import sun.misc.Unsafe;

final class MethodHandleHelper {
    private static final MethodHandles.Lookup LOOKUP;
    private static final MethodType STATIC_FIELD_GETTER;
    private static final MethodType STATIC_FIELD_SETTER;
    private static final MethodType VIRTUAL_FIELD_GETTER;
    private static final MethodType VIRTUAL_FIELD_SETTER;

    private MethodHandleHelper() {
    }

    public static MethodAccessor getMethodAccessor(Method method) {
        Preconditions.checkNotNull((Object)method, (Object)"method");
        try {
            MethodHandle unreflected = LOOKUP.unreflect(method);
            boolean staticMethod = Modifier.isStatic(method.getModifiers());
            MethodHandle generified = MethodHandleHelper.convertToGeneric(unreflected, staticMethod, false);
            return new DefaultMethodAccessor(method, generified, staticMethod);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unable to access method " + method, ex);
        }
    }

    public static ConstructorAccessor getConstructorAccessor(Constructor<?> constructor) {
        Preconditions.checkNotNull(constructor, (Object)"constructor");
        try {
            MethodHandle unreflected = LOOKUP.unreflectConstructor(constructor);
            MethodHandle generified = MethodHandleHelper.convertToGeneric(unreflected, false, true);
            return new DefaultConstrutorAccessor(constructor, generified);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Unable to access constructor " + constructor, ex);
        }
    }

    public static FieldAccessor getFieldAccessor(Field field) {
        Preconditions.checkNotNull((Object)field, (Object)"field");
        try {
            MethodHandle setter;
            MethodHandle getter;
            boolean staticField = Modifier.isStatic(field.getModifiers());
            if (staticField) {
                getter = LOOKUP.findStaticGetter(field.getDeclaringClass(), field.getName(), field.getType());
                setter = LOOKUP.findStaticSetter(field.getDeclaringClass(), field.getName(), field.getType());
            } else {
                getter = LOOKUP.findGetter(field.getDeclaringClass(), field.getName(), field.getType());
                setter = LOOKUP.findSetter(field.getDeclaringClass(), field.getName(), field.getType());
            }
            if (staticField) {
                getter = getter.asType(STATIC_FIELD_GETTER);
                setter = setter.asType(STATIC_FIELD_SETTER);
            } else {
                getter = getter.asType(VIRTUAL_FIELD_GETTER);
                setter = setter.asType(VIRTUAL_FIELD_SETTER);
            }
            if (getter == null) {
                throw new IllegalStateException("Unable to access field " + field + ". Could not find getter");
            }
            if (setter == null) {
                throw new IllegalStateException("Unable to access field " + field + ". Could not find setter");
            }
            return new DefaultFieldAccessor(field, setter, getter, staticField);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            throw new IllegalStateException("Unable to access field " + field, ex);
        }
    }

    private static MethodHandle convertToGeneric(MethodHandle handle, boolean staticMethod, boolean ctor) {
        MethodHandle target = handle.asFixedArity();
        int paramCount = handle.type().parameterCount() - (ctor || staticMethod ? 0 : 1);
        MethodType methodType = MethodType.genericMethodType(ctor ? 0 : 1, true);
        target = target.asSpreader(Object[].class, paramCount);
        if (staticMethod) {
            target = MethodHandles.dropArguments(target, 0, new Class[]{Object.class});
        }
        return target.asType(methodType);
    }

    static {
        MethodHandles.Lookup lookup;
        STATIC_FIELD_GETTER = MethodType.methodType(Object.class);
        STATIC_FIELD_SETTER = MethodType.methodType(Void.TYPE, Object.class);
        VIRTUAL_FIELD_GETTER = MethodType.methodType(Object.class, Object.class);
        VIRTUAL_FIELD_SETTER = MethodType.methodType(Void.TYPE, Object.class, Object.class);
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClass.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            Unsafe unsafe = (Unsafe)theUnsafe.get(null);
            Field trustedLookup = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long offset = unsafe.staticFieldOffset(trustedLookup);
            Object baseValue = unsafe.staticFieldBase(trustedLookup);
            lookup = (MethodHandles.Lookup)unsafe.getObject(baseValue, offset);
        }
        catch (Exception exception) {
            ProtocolLogger.log(Level.SEVERE, "Unable to retrieve trusted lookup", exception);
            lookup = MethodHandles.lookup();
        }
        LOOKUP = lookup;
    }
}

