/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.cloning;

import com.comphenix.protocol.reflect.cloning.Cloner;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class SerializableCloner
implements Cloner {
    @Override
    public boolean canClone(Object source) {
        if (source == null) {
            return false;
        }
        return source instanceof Serializable;
    }

    @Override
    public Object clone(Object source) {
        return SerializableCloner.clone((Serializable)source);
    }

    public static <T extends Serializable> T clone(T obj) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(out);
            oout.writeObject(obj);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(out.toByteArray()));
            return (T)((Serializable)in.readObject());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to clone object " + obj + " (" + obj.getClass().getName() + ")", e);
        }
    }
}

