/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.scheduler;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.MethodAccessor;
import com.comphenix.protocol.scheduler.FoliaTask;
import com.comphenix.protocol.scheduler.ProtocolScheduler;
import com.comphenix.protocol.scheduler.Task;
import com.comphenix.protocol.utility.MinecraftReflection;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class FoliaScheduler
implements ProtocolScheduler {
    private final Object foliaRegionScheduler;
    private final MethodAccessor runAtFixedRate;
    private final MethodAccessor runDelayed;
    private final MethodAccessor execute;
    private final MethodAccessor cancel;
    private final Object foliaAsyncScheduler;
    private final MethodAccessor executeAsync;
    private final Plugin plugin;

    public FoliaScheduler(Plugin plugin) {
        this.plugin = plugin;
        MethodAccessor getScheduler = Accessors.getMethodAccessor(Bukkit.getServer().getClass(), "getGlobalRegionScheduler", new Class[0]);
        this.foliaRegionScheduler = getScheduler.invoke(Bukkit.getServer(), new Object[0]);
        this.runAtFixedRate = Accessors.getMethodAccessor(this.foliaRegionScheduler.getClass(), "runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
        this.execute = Accessors.getMethodAccessor(this.foliaRegionScheduler.getClass(), "run", Plugin.class, Consumer.class);
        this.runDelayed = Accessors.getMethodAccessor(this.foliaRegionScheduler.getClass(), "runDelayed", Plugin.class, Consumer.class, Long.TYPE);
        MethodAccessor getAsyncScheduler = Accessors.getMethodAccessor(Bukkit.getServer().getClass(), "getAsyncScheduler", new Class[0]);
        this.foliaAsyncScheduler = getAsyncScheduler.invoke(Bukkit.getServer(), new Object[0]);
        this.executeAsync = Accessors.getMethodAccessor(this.foliaAsyncScheduler.getClass(), "runNow", Plugin.class, Consumer.class);
        Class<?> taskClass = MinecraftReflection.getLibraryClass("io.papermc.paper.threadedregions.scheduler.ScheduledTask");
        this.cancel = Accessors.getMethodAccessor(taskClass, "cancel", new Class[0]);
    }

    @Override
    public Task scheduleSyncRepeatingTask(Runnable task, long delay, long period) {
        Object taskHandle = this.runAtFixedRate.invoke(this.foliaRegionScheduler, this.plugin, t -> task.run(), delay, period);
        return new FoliaTask(this.cancel, taskHandle);
    }

    @Override
    public Task runTask(Runnable task) {
        Object taskHandle = this.execute.invoke(this.foliaRegionScheduler, this.plugin, t -> task.run());
        return new FoliaTask(this.cancel, taskHandle);
    }

    @Override
    public Task scheduleSyncDelayedTask(Runnable task, long delay) {
        Object taskHandle = this.runDelayed.invoke(this.foliaRegionScheduler, this.plugin, t -> task.run(), delay);
        return new FoliaTask(this.cancel, taskHandle);
    }

    @Override
    public Task runTaskAsync(Runnable task) {
        Object taskHandle = this.executeAsync.invoke(this.foliaAsyncScheduler, this.plugin, t -> task.run());
        return new FoliaTask(this.cancel, taskHandle);
    }
}

