/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray.antixray;

import com.destroystokyo.paper.antixray.BitStorageReader;
import com.destroystokyo.paper.antixray.BitStorageWriter;
import com.destroystokyo.paper.antixray.ChunkPacketBlockController;
import com.destroystokyo.paper.antixray.ChunkPacketInfo;
import com.vanillage.raytraceantixray.RayTraceAntiXray;
import com.vanillage.raytraceantixray.antixray.ChunkPacketInfoAntiXray;
import com.vanillage.raytraceantixray.data.ChunkBlocks;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.EngineMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntSupplier;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteGlobal;
import net.minecraft.world.level.chunk.MissingPaletteEntryException;
import org.bukkit.Bukkit;

public final class ChunkPacketBlockControllerAntiXray
extends ChunkPacketBlockController {
    public static final DataPalette<IBlockData> GLOBAL_BLOCKSTATE_PALETTE = new DataPaletteGlobal((Registry)Block.o);
    private static final ChunkSection EMPTY_SECTION = null;
    private final RayTraceAntiXray plugin;
    private final Executor executor;
    private final EngineMode engineMode;
    private final int maxBlockHeight;
    private final int updateRadius;
    private final boolean usePermission;
    private final int maxRayTraceBlockCountPerChunk;
    private final IBlockData[] presetBlockStates;
    private final IBlockData[] presetBlockStatesFull;
    private final IBlockData[] presetBlockStatesStone;
    private final IBlockData[] presetBlockStatesDeepslate;
    private final IBlockData[] presetBlockStatesNetherrack;
    private final IBlockData[] presetBlockStatesEndStone;
    private final int[] presetBlockStateBitsGlobal;
    private final int[] presetBlockStateBitsStoneGlobal;
    private final int[] presetBlockStateBitsDeepslateGlobal;
    private final int[] presetBlockStateBitsNetherrackGlobal;
    private final int[] presetBlockStateBitsEndStoneGlobal;
    public final boolean[] solidGlobal = new boolean[Block.o.b()];
    private final boolean[] obfuscateGlobal = new boolean[Block.o.b()];
    private final boolean[] traceGlobal;
    private final ChunkSection[] emptyNearbyChunkSections = new ChunkSection[]{EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION, EMPTY_SECTION};
    public final boolean rayTraceThirdPerson;
    public final double rayTraceDistance;
    public final boolean rehideBlocks;
    private final int maxBlockHeightUpdatePosition;
    private final ThreadLocal<int[]> presetBlockStateBits = ThreadLocal.withInitial(() -> new int[this.getPresetBlockStatesFullLength()]);
    private static final ThreadLocal<boolean[]> SOLID = ThreadLocal.withInitial(() -> new boolean[Block.o.b()]);
    private static final ThreadLocal<boolean[]> OBFUSCATE = ThreadLocal.withInitial(() -> new boolean[Block.o.b()]);
    private static final ThreadLocal<boolean[]> TRACE = ThreadLocal.withInitial(() -> new boolean[Block.o.b()]);
    private static final ThreadLocal<boolean[][]> CURRENT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> NEXT_NEXT = ThreadLocal.withInitial(() -> new boolean[16][16]);
    private static final ThreadLocal<boolean[][]> TRACE_CACHE = ThreadLocal.withInitial(() -> new boolean[16][16]);

    public ChunkPacketBlockControllerAntiXray(RayTraceAntiXray plugin, boolean rayTraceThirdPerson, double rayTraceDistance, int maxRayTraceBlockCountPerChunk, boolean rehideBlocks, Iterable<? extends String> toTrace, World level, Executor executor) {
        ArrayList<String> toObfuscate;
        this.plugin = plugin;
        this.executor = executor;
        WorldConfiguration.Anticheat.AntiXray paperWorldConfig = level.paperConfig().anticheat.antiXray;
        this.engineMode = paperWorldConfig.engineMode;
        this.maxBlockHeight = paperWorldConfig.maxBlockHeight >> 4 << 4;
        this.updateRadius = paperWorldConfig.updateRadius;
        this.usePermission = paperWorldConfig.usePermission;
        this.rayTraceThirdPerson = rayTraceThirdPerson;
        this.rayTraceDistance = rayTraceDistance;
        this.maxRayTraceBlockCountPerChunk = maxRayTraceBlockCountPerChunk;
        this.rehideBlocks = rehideBlocks;
        if (this.engineMode == EngineMode.HIDE) {
            toObfuscate = paperWorldConfig.hiddenBlocks;
            this.presetBlockStates = null;
            this.presetBlockStatesFull = null;
            this.presetBlockStatesStone = new IBlockData[]{Blocks.b.o()};
            this.presetBlockStatesDeepslate = new IBlockData[]{Blocks.rD.o()};
            this.presetBlockStatesNetherrack = new IBlockData[]{Blocks.dV.o()};
            this.presetBlockStatesEndStone = new IBlockData[]{Blocks.fy.o()};
            this.presetBlockStateBitsGlobal = null;
            this.presetBlockStateBitsStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a((Object)Blocks.b.o())};
            this.presetBlockStateBitsDeepslateGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a((Object)Blocks.rD.o())};
            this.presetBlockStateBitsNetherrackGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a((Object)Blocks.dV.o())};
            this.presetBlockStateBitsEndStoneGlobal = new int[]{GLOBAL_BLOCKSTATE_PALETTE.a((Object)Blocks.fy.o())};
        } else {
            IBlockData[] iBlockDataArray;
            IBlockData[] iBlockDataArray2;
            toObfuscate = new ArrayList<String>(paperWorldConfig.replacementBlocks);
            Iterator<? extends String> presetBlockStateList = new LinkedList<IBlockData>();
            for (String id : paperWorldConfig.hiddenBlocks) {
                Block block = BuiltInRegistries.f.b(new MinecraftKey(id)).orElse(null);
                if (block == null || block instanceof ITileEntity) continue;
                toObfuscate.add(id);
                presetBlockStateList.add((String)block.o());
            }
            LinkedHashSet<IBlockData> linkedHashSet = new LinkedHashSet<IBlockData>();
            linkedHashSet.addAll((Collection<IBlockData>)((Object)presetBlockStateList));
            if (linkedHashSet.isEmpty()) {
                IBlockData[] iBlockDataArray3 = new IBlockData[1];
                iBlockDataArray2 = iBlockDataArray3;
                iBlockDataArray3[0] = Blocks.cw.o();
            } else {
                iBlockDataArray2 = this.presetBlockStates = linkedHashSet.toArray(new IBlockData[0]);
            }
            if (linkedHashSet.isEmpty()) {
                IBlockData[] iBlockDataArray4 = new IBlockData[1];
                iBlockDataArray = iBlockDataArray4;
                iBlockDataArray4[0] = Blocks.cw.o();
            } else {
                iBlockDataArray = presetBlockStateList.toArray(new IBlockData[0]);
            }
            this.presetBlockStatesFull = iBlockDataArray;
            this.presetBlockStatesStone = null;
            this.presetBlockStatesDeepslate = null;
            this.presetBlockStatesNetherrack = null;
            this.presetBlockStatesEndStone = null;
            this.presetBlockStateBitsGlobal = new int[this.presetBlockStatesFull.length];
            for (int i = 0; i < this.presetBlockStatesFull.length; ++i) {
                this.presetBlockStateBitsGlobal[i] = GLOBAL_BLOCKSTATE_PALETTE.a((Object)this.presetBlockStatesFull[i]);
            }
            this.presetBlockStateBitsStoneGlobal = null;
            this.presetBlockStateBitsDeepslateGlobal = null;
            this.presetBlockStateBitsNetherrackGlobal = null;
            this.presetBlockStateBitsEndStoneGlobal = null;
        }
        for (String string : toObfuscate) {
            Block block = BuiltInRegistries.f.b(new MinecraftKey(string)).orElse(null);
            if (block == null || block.o().h()) continue;
            for (IBlockData blockState : block.n().a()) {
                this.obfuscateGlobal[ChunkPacketBlockControllerAntiXray.GLOBAL_BLOCKSTATE_PALETTE.a((Object)blockState)] = true;
            }
        }
        if (toTrace == null) {
            this.traceGlobal = this.obfuscateGlobal;
        } else {
            this.traceGlobal = new boolean[Block.o.b()];
            for (String string : toTrace) {
                Block block = BuiltInRegistries.f.b(new MinecraftKey(string)).orElse(null);
                if (block == null || block.o().h()) continue;
                for (IBlockData blockState : block.n().a()) {
                    this.traceGlobal[ChunkPacketBlockControllerAntiXray.GLOBAL_BLOCKSTATE_PALETTE.a((Object)blockState)] = true;
                    this.obfuscateGlobal[ChunkPacketBlockControllerAntiXray.GLOBAL_BLOCKSTATE_PALETTE.a((Object)blockState)] = true;
                }
            }
        }
        ChunkEmpty emptyChunk = new ChunkEmpty(level, new ChunkCoordIntPair(0, 0), (Holder)MinecraftServer.getServer().aX().d(Registries.an).f(Biomes.b));
        BlockPosition blockPosition = new BlockPosition(0, 0, 0);
        for (int i = 0; i < this.solidGlobal.length; ++i) {
            IBlockData blockState = (IBlockData)GLOBAL_BLOCKSTATE_PALETTE.a(i);
            if (blockState == null) continue;
            this.solidGlobal[i] = blockState.g((IBlockAccess)emptyChunk, blockPosition) && blockState.b() != Blocks.cs && blockState.b() != Blocks.hV && blockState.b() != Blocks.kM && blockState.b() != Blocks.hU && blockState.b() != Blocks.ab || paperWorldConfig.lavaObscures && blockState == Blocks.H.o();
        }
        this.maxBlockHeightUpdatePosition = this.maxBlockHeight + this.updateRadius - 1;
    }

    private int getPresetBlockStatesFullLength() {
        return this.engineMode == EngineMode.HIDE ? 1 : this.presetBlockStatesFull.length;
    }

    public IBlockData[] getPresetBlockStates(World level, ChunkCoordIntPair chunkPos, int bottomBlockY) {
        if (bottomBlockY < this.maxBlockHeight) {
            if (this.engineMode == EngineMode.HIDE) {
                switch (level.getWorld().getEnvironment()) {
                    case NETHER: {
                        return this.presetBlockStatesNetherrack;
                    }
                    case THE_END: {
                        return this.presetBlockStatesEndStone;
                    }
                }
                return bottomBlockY < 0 ? this.presetBlockStatesDeepslate : this.presetBlockStatesStone;
            }
            return this.presetBlockStates;
        }
        return null;
    }

    public boolean shouldModify(EntityPlayer player, Chunk chunk) {
        return !this.usePermission || !player.getBukkitEntity().hasPermission("paper.antixray.bypass");
    }

    public ChunkPacketInfoAntiXray getChunkPacketInfo(ClientboundLevelChunkWithLightPacket chunkPacket, Chunk chunk) {
        return new ChunkPacketInfoAntiXray(chunkPacket, chunk, this);
    }

    public void modifyBlocks(ClientboundLevelChunkWithLightPacket chunkPacket, ChunkPacketInfo<IBlockData> chunkPacketInfo) {
        if (!(chunkPacketInfo instanceof ChunkPacketInfoAntiXray)) {
            chunkPacket.setReady(true);
            return;
        }
        if (!Bukkit.isPrimaryThread()) {
            MinecraftServer.getServer().scheduleOnMain(() -> this.modifyBlocks(chunkPacket, chunkPacketInfo));
            return;
        }
        Chunk chunk = chunkPacketInfo.getChunk();
        int x = chunk.f().e;
        int z = chunk.f().f;
        World level = chunk.D();
        ((ChunkPacketInfoAntiXray)chunkPacketInfo).setNearbyChunks(level.getChunkIfLoaded(x - 1, z), level.getChunkIfLoaded(x + 1, z), level.getChunkIfLoaded(x, z - 1), level.getChunkIfLoaded(x, z + 1));
        this.executor.execute((Runnable)chunkPacketInfo);
    }

    public void obfuscate(ChunkPacketInfoAntiXray chunkPacketInfoAntiXray) {
        int[] presetBlockStateBits = this.presetBlockStateBits.get();
        boolean[] solid = SOLID.get();
        boolean[] obfuscate = OBFUSCATE.get();
        boolean[] trace = this.traceGlobal == this.obfuscateGlobal ? obfuscate : TRACE.get();
        boolean[][] current = CURRENT.get();
        boolean[][] next = NEXT.get();
        boolean[][] nextNext = NEXT_NEXT.get();
        boolean[][] traceCache = TRACE_CACHE.get();
        BitStorageReader bitStorageReader = new BitStorageReader();
        BitStorageWriter bitStorageWriter = new BitStorageWriter();
        ChunkSection[] nearbyChunkSections = new ChunkSection[4];
        Chunk chunk = chunkPacketInfoAntiXray.getChunk();
        World level = chunk.D();
        int maxChunkSectionIndex = Math.min((this.maxBlockHeight >> 4) - chunk.ak(), chunk.aj()) - 1;
        boolean[] solidTemp = null;
        boolean[] obfuscateTemp = null;
        boolean[] traceTemp = null;
        bitStorageReader.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        bitStorageWriter.setBuffer(chunkPacketInfoAntiXray.getBuffer());
        final int numberOfBlocks = presetBlockStateBits.length;
        LayeredIntSupplier random = numberOfBlocks == 1 ? () -> 0 : (this.engineMode == EngineMode.OBFUSCATE_LAYER ? new LayeredIntSupplier(){
            private int state;
            private int next;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public void nextLayer() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                this.next = (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }

            @Override
            public int getAsInt() {
                return this.next;
            }
        } : new LayeredIntSupplier(){
            private int state;
            {
                while ((this.state = ThreadLocalRandom.current().nextInt()) == 0) {
                }
            }

            @Override
            public int getAsInt() {
                this.state ^= this.state << 13;
                this.state ^= this.state >>> 17;
                this.state ^= this.state << 5;
                return (int)(Integer.toUnsignedLong(this.state) * (long)numberOfBlocks >>> 32);
            }
        });
        HashMap<BlockPosition, Boolean> blocks = new HashMap<BlockPosition, Boolean>();
        for (int chunkSectionIndex = 0; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
            int x;
            int z;
            int[] presetBlockStateBitsTemp;
            if (!chunkPacketInfoAntiXray.isWritten(chunkSectionIndex) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == null) continue;
            if (chunkPacketInfoAntiXray.getPalette(chunkSectionIndex) instanceof DataPaletteGlobal) {
                if (this.engineMode == EngineMode.HIDE) {
                    switch (level.getWorld().getEnvironment()) {
                        case NETHER: {
                            presetBlockStateBitsTemp = this.presetBlockStateBitsNetherrackGlobal;
                            break;
                        }
                        case THE_END: {
                            presetBlockStateBitsTemp = this.presetBlockStateBitsEndStoneGlobal;
                            break;
                        }
                        default: {
                            presetBlockStateBitsTemp = chunkSectionIndex + chunk.ak() < 0 ? this.presetBlockStateBitsDeepslateGlobal : this.presetBlockStateBitsStoneGlobal;
                            break;
                        }
                    }
                } else {
                    presetBlockStateBitsTemp = this.presetBlockStateBitsGlobal;
                }
            } else {
                IBlockData[] presetBlockStatesFull = chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex) == this.presetBlockStates ? this.presetBlockStatesFull : (IBlockData[])chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex);
                presetBlockStateBitsTemp = presetBlockStateBits;
                for (int i = 0; i < presetBlockStateBitsTemp.length; ++i) {
                    presetBlockStateBitsTemp[i] = chunkPacketInfoAntiXray.getPalette(chunkSectionIndex).a((Object)presetBlockStatesFull[i]);
                }
            }
            bitStorageWriter.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
            if (chunkSectionIndex == 0 || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex - 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex - 1) == null) {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex));
                solidTemp = this.readPalette((DataPalette<IBlockData>)chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), solid, this.solidGlobal);
                obfuscateTemp = this.readPalette((DataPalette<IBlockData>)chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), obfuscate, this.obfuscateGlobal);
                traceTemp = trace == obfuscate ? obfuscateTemp : this.readPalette((DataPalette<IBlockData>)chunkPacketInfoAntiXray.getPalette(chunkSectionIndex), trace, this.traceGlobal);
                ChunkSection belowChunkSection = null;
                boolean skipFirstLayer = chunkSectionIndex == 0 || (belowChunkSection = chunk.d()[chunkSectionIndex - 1]) == EMPTY_SECTION;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        current[z][x] = true;
                        next[z][x] = skipFirstLayer || this.isTransparent(belowChunkSection, x, 15, z);
                        traceCache[z][x] = false;
                    }
                }
                bitStorageWriter.setBits(0);
                this.obfuscateLayer(chunk.f(), chunk.ak(), chunkSectionIndex, -1, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, traceTemp, presetBlockStateBitsTemp, current, next, nextNext, traceCache, this.emptyNearbyChunkSections, random, blocks);
            }
            bitStorageWriter.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex));
            nearbyChunkSections[0] = chunkPacketInfoAntiXray.getNearbyChunks()[0] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[0].d()[chunkSectionIndex];
            nearbyChunkSections[1] = chunkPacketInfoAntiXray.getNearbyChunks()[1] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[1].d()[chunkSectionIndex];
            nearbyChunkSections[2] = chunkPacketInfoAntiXray.getNearbyChunks()[2] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[2].d()[chunkSectionIndex];
            nearbyChunkSections[3] = chunkPacketInfoAntiXray.getNearbyChunks()[3] == null ? EMPTY_SECTION : chunkPacketInfoAntiXray.getNearbyChunks()[3].d()[chunkSectionIndex];
            for (int y = 0; y < 15; ++y) {
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                random.nextLayer();
                this.obfuscateLayer(chunk.f(), chunk.ak(), chunkSectionIndex, y, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, traceTemp, presetBlockStateBitsTemp, current, next, nextNext, traceCache, nearbyChunkSections, random, blocks);
            }
            if (chunkSectionIndex == maxChunkSectionIndex || !chunkPacketInfoAntiXray.isWritten(chunkSectionIndex + 1) || chunkPacketInfoAntiXray.getPresetValues(chunkSectionIndex + 1) == null) {
                ChunkSection aboveChunkSection = chunkSectionIndex == chunk.aj() - 1 ? EMPTY_SECTION : chunk.d()[chunkSectionIndex + 1];
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        if (aboveChunkSection != EMPTY_SECTION && !this.isTransparent(aboveChunkSection, x, 0, z)) continue;
                        current[z][x] = true;
                    }
                }
                bitStorageReader.setBits(0);
                solid[0] = true;
                random.nextLayer();
                this.obfuscateLayer(chunk.f(), chunk.ak(), chunkSectionIndex, 15, bitStorageReader, bitStorageWriter, solid, obfuscateTemp, traceTemp, presetBlockStateBitsTemp, current, next, nextNext, traceCache, nearbyChunkSections, random, blocks);
            } else {
                bitStorageReader.setBits(chunkPacketInfoAntiXray.getBits(chunkSectionIndex + 1));
                bitStorageReader.setIndex(chunkPacketInfoAntiXray.getIndex(chunkSectionIndex + 1));
                solidTemp = this.readPalette((DataPalette<IBlockData>)chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), solid, this.solidGlobal);
                obfuscateTemp = this.readPalette((DataPalette<IBlockData>)chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), obfuscate, this.obfuscateGlobal);
                traceTemp = trace == obfuscate ? obfuscateTemp : this.readPalette((DataPalette<IBlockData>)chunkPacketInfoAntiXray.getPalette(chunkSectionIndex + 1), trace, this.traceGlobal);
                boolean[][] temp = current;
                current = next;
                next = nextNext;
                nextNext = temp;
                random.nextLayer();
                this.obfuscateLayer(chunk.f(), chunk.ak(), chunkSectionIndex, 15, bitStorageReader, bitStorageWriter, solidTemp, obfuscateTemp, traceTemp, presetBlockStateBitsTemp, current, next, nextNext, traceCache, nearbyChunkSections, random, blocks);
            }
            bitStorageWriter.flush();
        }
        if (this.plugin.isRunning()) {
            this.plugin.getPacketChunkBlocksCache().put(chunkPacketInfoAntiXray.getChunkPacket(), new ChunkBlocks(chunkPacketInfoAntiXray.getChunk(), blocks));
        }
        chunkPacketInfoAntiXray.getChunkPacket().setReady(true);
    }

    private void obfuscateLayer(ChunkCoordIntPair chunkPos, int minSection, int chunkSectionIndex, int y, BitStorageReader bitStorageReader, BitStorageWriter bitStorageWriter, boolean[] solid, boolean[] obfuscate, boolean[] trace, int[] presetBlockStateBits, boolean[][] current, boolean[][] next, boolean[][] nextNext, boolean[][] traceCache, ChunkSection[] nearbyChunkSections, IntSupplier random, Map<? super BlockPosition, ? super Boolean> blocks) {
        int x;
        int minX = chunkPos.d();
        int minZ = chunkPos.e();
        int realY = (chunkSectionIndex + minSection << 4) + y;
        int bits = bitStorageReader.read();
        nextNext[0][0] = !solid[bits];
        if (nextNext[0][0]) {
            if (traceCache[0][0] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 0, realY, minZ + 0), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
            next[0][1] = true;
            next[1][0] = true;
        } else if (current[0][0] || this.isTransparent(nearbyChunkSections[2], 0, y, 15) || this.isTransparent(nearbyChunkSections[0], 15, y, 0)) {
            if (traceCache[0][0] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 0, realY, minZ + 0), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (trace[bits]) {
            traceCache[0][0] = true;
        } else {
            traceCache[0][0] = false;
            if (!obfuscate[bits]) {
                next[0][0] = true;
            }
        }
        for (x = 1; x < 15; ++x) {
            bits = bitStorageReader.read();
            nextNext[0][x] = !solid[bits];
            if (nextNext[0][x]) {
                if (traceCache[0][x] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + x, realY, minZ + 0), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
                next[0][x - 1] = true;
                next[0][x + 1] = true;
                next[1][x] = true;
            } else if (current[0][x] || this.isTransparent(nearbyChunkSections[2], x, y, 15)) {
                if (traceCache[0][x] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + x, realY, minZ + 0), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (trace[bits]) {
                traceCache[0][x] = true;
                continue;
            }
            traceCache[0][x] = false;
            if (obfuscate[bits]) continue;
            next[0][x] = true;
        }
        bits = bitStorageReader.read();
        nextNext[0][15] = !solid[bits];
        if (nextNext[0][15]) {
            if (traceCache[0][15] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 15, realY, minZ + 0), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
            next[0][14] = true;
            next[1][15] = true;
        } else if (current[0][15] || this.isTransparent(nearbyChunkSections[2], 15, y, 15) || this.isTransparent(nearbyChunkSections[1], 0, y, 0)) {
            if (traceCache[0][15] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 15, realY, minZ + 0), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (trace[bits]) {
            traceCache[0][15] = true;
        } else {
            traceCache[0][15] = false;
            if (!obfuscate[bits]) {
                next[0][15] = true;
            }
        }
        for (int z = 1; z < 15; ++z) {
            bits = bitStorageReader.read();
            nextNext[z][0] = !solid[bits];
            if (nextNext[z][0]) {
                if (traceCache[z][0] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + 0, realY, minZ + z), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
                next[z][1] = true;
                next[z - 1][0] = true;
                next[z + 1][0] = true;
            } else if (current[z][0] || this.isTransparent(nearbyChunkSections[0], 15, y, z)) {
                if (traceCache[z][0] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + 0, realY, minZ + z), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (trace[bits]) {
                traceCache[z][0] = true;
            } else {
                traceCache[z][0] = false;
                if (!obfuscate[bits]) {
                    next[z][0] = true;
                }
            }
            for (int x2 = 1; x2 < 15; ++x2) {
                bits = bitStorageReader.read();
                nextNext[z][x2] = !solid[bits];
                if (nextNext[z][x2]) {
                    if (traceCache[z][x2] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                        bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                        blocks.put((BlockPosition)new BlockPosition(minX + x2, realY, minZ + z), (Boolean)true);
                    } else {
                        bitStorageWriter.skip();
                    }
                    next[z][x2 - 1] = true;
                    next[z][x2 + 1] = true;
                    next[z - 1][x2] = true;
                    next[z + 1][x2] = true;
                } else if (current[z][x2]) {
                    if (traceCache[z][x2] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                        bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                        blocks.put((BlockPosition)new BlockPosition(minX + x2, realY, minZ + z), (Boolean)true);
                    } else {
                        bitStorageWriter.skip();
                    }
                } else {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                }
                if (trace[bits]) {
                    traceCache[z][x2] = true;
                    continue;
                }
                traceCache[z][x2] = false;
                if (obfuscate[bits]) continue;
                next[z][x2] = true;
            }
            bits = bitStorageReader.read();
            nextNext[z][15] = !solid[bits];
            if (nextNext[z][15]) {
                if (traceCache[z][15] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + 15, realY, minZ + z), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
                next[z][14] = true;
                next[z - 1][15] = true;
                next[z + 1][15] = true;
            } else if (current[z][15] || this.isTransparent(nearbyChunkSections[1], 0, y, z)) {
                if (traceCache[z][15] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + 15, realY, minZ + z), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (trace[bits]) {
                traceCache[z][15] = true;
                continue;
            }
            traceCache[z][15] = false;
            if (obfuscate[bits]) continue;
            next[z][15] = true;
        }
        bits = bitStorageReader.read();
        nextNext[15][0] = !solid[bits];
        if (nextNext[15][0]) {
            if (traceCache[15][0] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 0, realY, minZ + 15), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
            next[15][1] = true;
            next[14][0] = true;
        } else if (current[15][0] || this.isTransparent(nearbyChunkSections[3], 0, y, 0) || this.isTransparent(nearbyChunkSections[0], 15, y, 15)) {
            if (traceCache[15][0] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 0, realY, minZ + 15), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (trace[bits]) {
            traceCache[15][0] = true;
        } else {
            traceCache[15][0] = false;
            if (!obfuscate[bits]) {
                next[15][0] = true;
            }
        }
        for (x = 1; x < 15; ++x) {
            bits = bitStorageReader.read();
            nextNext[15][x] = !solid[bits];
            if (nextNext[15][x]) {
                if (traceCache[15][x] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + x, realY, minZ + 15), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
                next[15][x - 1] = true;
                next[15][x + 1] = true;
                next[14][x] = true;
            } else if (current[15][x] || this.isTransparent(nearbyChunkSections[3], x, y, 0)) {
                if (traceCache[15][x] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                    bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                    blocks.put((BlockPosition)new BlockPosition(minX + x, realY, minZ + 15), (Boolean)true);
                } else {
                    bitStorageWriter.skip();
                }
            } else {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
            }
            if (trace[bits]) {
                traceCache[15][x] = true;
                continue;
            }
            traceCache[15][x] = false;
            if (obfuscate[bits]) continue;
            next[15][x] = true;
        }
        bits = bitStorageReader.read();
        nextNext[15][15] = !solid[bits];
        if (nextNext[15][15]) {
            if (traceCache[15][15] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 15, realY, minZ + 15), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
            next[15][14] = true;
            next[14][15] = true;
        } else if (current[15][15] || this.isTransparent(nearbyChunkSections[3], 15, y, 0) || this.isTransparent(nearbyChunkSections[1], 0, y, 15)) {
            if (traceCache[15][15] && blocks.size() < this.maxRayTraceBlockCountPerChunk) {
                bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
                blocks.put((BlockPosition)new BlockPosition(minX + 15, realY, minZ + 15), (Boolean)true);
            } else {
                bitStorageWriter.skip();
            }
        } else {
            bitStorageWriter.write(presetBlockStateBits[random.getAsInt()]);
        }
        if (trace[bits]) {
            traceCache[15][15] = true;
        } else {
            traceCache[15][15] = false;
            if (!obfuscate[bits]) {
                next[15][15] = true;
            }
        }
    }

    private boolean isTransparent(ChunkSection chunkSection, int x, int y, int z) {
        if (chunkSection == EMPTY_SECTION) {
            return true;
        }
        try {
            return !this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.a((Object)chunkSection.a(x, y, z))];
        }
        catch (MissingPaletteEntryException e) {
            return true;
        }
    }

    private boolean[] readPalette(DataPalette<IBlockData> palette, boolean[] temp, boolean[] global) {
        if (palette instanceof DataPaletteGlobal) {
            return global;
        }
        try {
            for (int i = 0; i < palette.b(); ++i) {
                temp[i] = global[GLOBAL_BLOCKSTATE_PALETTE.a((Object)((IBlockData)palette.a(i)))];
            }
        }
        catch (MissingPaletteEntryException missingPaletteEntryException) {
            // empty catch block
        }
        return temp;
    }

    public void onBlockChange(World level, BlockPosition blockPos, IBlockData newBlockState, IBlockData oldBlockState, int flags, int maxUpdateDepth) {
        if (oldBlockState != null && this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.a((Object)oldBlockState)] && !this.solidGlobal[GLOBAL_BLOCKSTATE_PALETTE.a((Object)newBlockState)] && blockPos.v() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks(level, blockPos);
        }
    }

    public void onPlayerLeftClickBlock(PlayerInteractManager serverPlayerGameMode, BlockPosition blockPos, PacketPlayInBlockDig.EnumPlayerDigType action, EnumDirection direction, int worldHeight, int sequence) {
        if (blockPos.v() <= this.maxBlockHeightUpdatePosition) {
            this.updateNearbyBlocks((World)serverPlayerGameMode.c, blockPos);
        }
    }

    private void updateNearbyBlocks(World level, BlockPosition blockPos) {
        if (this.updateRadius >= 2) {
            BlockPosition temp = blockPos.g();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.g());
            this.updateBlock(level, temp.d());
            this.updateBlock(level, temp.c());
            this.updateBlock(level, temp.e());
            this.updateBlock(level, temp.f());
            temp = blockPos.h();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.h());
            this.updateBlock(level, temp.d());
            this.updateBlock(level, temp.c());
            this.updateBlock(level, temp.e());
            this.updateBlock(level, temp.f());
            temp = blockPos.d();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.d());
            this.updateBlock(level, temp.e());
            this.updateBlock(level, temp.f());
            temp = blockPos.c();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.c());
            this.updateBlock(level, temp.e());
            this.updateBlock(level, temp.f());
            temp = blockPos.e();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.e());
            temp = blockPos.f();
            this.updateBlock(level, temp);
            this.updateBlock(level, temp.f());
        } else if (this.updateRadius == 1) {
            this.updateBlock(level, blockPos.g());
            this.updateBlock(level, blockPos.h());
            this.updateBlock(level, blockPos.d());
            this.updateBlock(level, blockPos.c());
            this.updateBlock(level, blockPos.e());
            this.updateBlock(level, blockPos.f());
        }
    }

    public void updateBlock(World level, BlockPosition blockPos) {
        IBlockData blockState = level.getBlockStateIfLoaded(blockPos);
        if (blockState != null && this.obfuscateGlobal[GLOBAL_BLOCKSTATE_PALETTE.a((Object)blockState)]) {
            ((WorldServer)level).k().a(blockPos);
        }
    }

    @FunctionalInterface
    private static interface LayeredIntSupplier
    extends IntSupplier {
        default public void nextLayer() {
        }
    }
}

