/*
 * Decompiled with CFR 0.152.
 */
package com.vanillage.raytraceantixray.tasks;

import com.destroystokyo.paper.antixray.ChunkPacketBlockController;
import com.vanillage.raytraceantixray.antixray.ChunkPacketBlockControllerAntiXray;
import com.vanillage.raytraceantixray.data.ChunkBlocks;
import com.vanillage.raytraceantixray.data.PlayerData;
import com.vanillage.raytraceantixray.data.Result;
import com.vanillage.raytraceantixray.data.VectorialLocation;
import com.vanillage.raytraceantixray.util.BlockIterator;
import com.vanillage.raytraceantixray.util.BlockOcclusionCulling;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.chunk.Chunk;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.util.Vector;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;

public final class RayTraceCallable
implements Callable<Void> {
    private final PlayerData playerData;
    private final BlockOcclusionCulling blockOcclusionCulling;
    private final Collection<ChunkBlocks> chunks;
    private final double rayTraceDistance;
    private final double rayTraceDistanceSquared;
    private final boolean rehideBlocks;

    public RayTraceCallable(PlayerData playerData) {
        ChunkPacketBlockController chunkPacketBlockController = ((CraftWorld)playerData.getLocations()[0].getWorld()).getHandle().chunkPacketBlockController;
        if (!(chunkPacketBlockController instanceof ChunkPacketBlockControllerAntiXray)) {
            this.playerData = null;
            this.blockOcclusionCulling = null;
            this.chunks = null;
            this.rayTraceDistance = 0.0;
            this.rayTraceDistanceSquared = 0.0;
            this.rehideBlocks = false;
            return;
        }
        this.playerData = playerData;
        NonBlockingHashMapLong<ChunkBlocks> chunks = playerData.getChunks();
        ChunkPacketBlockControllerAntiXray chunkPacketBlockControllerAntiXray = (ChunkPacketBlockControllerAntiXray)chunkPacketBlockController;
        boolean[] solidGlobal = chunkPacketBlockControllerAntiXray.solidGlobal;
        BlockIterator blockIterator = new BlockIterator(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.blockOcclusionCulling = new BlockOcclusionCulling(l -> {
            ChunkBlocks chunkBlocks = (ChunkBlocks)chunks.get(l);
            if (chunkBlocks == null) {
                return null;
            }
            return chunkBlocks.getChunk();
        }, b -> solidGlobal[ChunkPacketBlockControllerAntiXray.GLOBAL_BLOCKSTATE_PALETTE.a(b)], blockIterator::initializeNormalized, true, true);
        this.chunks = chunks.values();
        this.rayTraceDistance = chunkPacketBlockControllerAntiXray.rayTraceDistance;
        this.rayTraceDistanceSquared = this.rayTraceDistance * this.rayTraceDistance;
        this.rehideBlocks = chunkPacketBlockControllerAntiXray.rehideBlocks;
    }

    @Override
    public Void call() {
        try {
            this.rayTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        return null;
    }

    private void rayTrace() {
        if (this.blockOcclusionCulling == null) {
            return;
        }
        VectorialLocation[] locations = this.playerData.getLocations();
        Vector playerVector = locations[0].getVector();
        double playerX = playerVector.getX();
        double playerY = playerVector.getY();
        double playerZ = playerVector.getZ();
        playerVector.setX(playerX - this.rayTraceDistance);
        playerVector.setZ(playerZ - this.rayTraceDistance);
        int chunkXMin = playerVector.getBlockX() >> 4;
        int chunkZMin = playerVector.getBlockZ() >> 4;
        playerVector.setX(playerX + this.rayTraceDistance);
        playerVector.setZ(playerZ + this.rayTraceDistance);
        int chunkXMax = playerVector.getBlockX() >> 4;
        int chunkZMax = playerVector.getBlockZ() >> 4;
        playerVector.setX(playerX);
        playerVector.setZ(playerZ);
        for (ChunkBlocks chunkBlocks : this.chunks) {
            Chunk chunk = chunkBlocks.getChunk();
            if (chunk == null) {
                this.playerData.getChunks().remove(chunkBlocks.getKey(), (Object)chunkBlocks);
                continue;
            }
            int chunkX = chunk.f().e;
            int chunkZ = chunk.f().f;
            if (chunkX < chunkXMin || chunkX > chunkXMax || chunkZ < chunkZMin || chunkZ > chunkZMax) continue;
            Iterator<Map.Entry<BlockPosition, Boolean>> iterator = chunkBlocks.getBlocks().entrySet().iterator();
            while (iterator.hasNext()) {
                int z;
                double centerZ;
                double differenceZ;
                int y;
                double centerY;
                double differenceY;
                Map.Entry<BlockPosition, Boolean> blockHidden = iterator.next();
                BlockPosition block = blockHidden.getKey();
                int x = block.u();
                double centerX = (double)x + 0.5;
                double differenceX = playerX - centerX;
                double distanceSquared = differenceX * differenceX + (differenceY = playerY - (centerY = (double)(y = block.v()) + 0.5)) * differenceY + (differenceZ = playerZ - (centerZ = (double)(z = block.w()) + 0.5)) * differenceZ;
                if (!(distanceSquared <= this.rayTraceDistanceSquared)) continue;
                boolean visible = false;
                for (int i = 0; i < locations.length; ++i) {
                    double vectorDistanceSquared;
                    double vectorDifferenceZ;
                    double vectorDifferenceY;
                    VectorialLocation location = locations[i];
                    Vector direction = location.getDirection();
                    if (i == 0) {
                        if (!this.blockOcclusionCulling.isVisible(x, y, z, centerX, centerY, centerZ, differenceX, differenceY, differenceZ, distanceSquared, direction.getX(), direction.getY(), direction.getZ(), chunk, chunkX, chunkZ)) continue;
                        visible = true;
                        break;
                    }
                    Vector vector = location.getVector();
                    double vectorDifferenceX = vector.getX() - centerX;
                    if (!this.blockOcclusionCulling.isVisible(x, y, z, centerX, centerY, centerZ, vectorDifferenceX, vectorDifferenceY = vector.getY() - centerY, vectorDifferenceZ = vector.getZ() - centerZ, vectorDistanceSquared = vectorDifferenceX * vectorDifferenceX + vectorDifferenceY * vectorDifferenceY + vectorDifferenceZ * vectorDifferenceZ, direction.getX(), direction.getY(), direction.getZ(), chunk, chunkX, chunkZ)) continue;
                    visible = true;
                    break;
                }
                if (visible) {
                    if (!blockHidden.getValue().booleanValue()) continue;
                    this.playerData.getResults().add(new Result(chunkBlocks, block, true));
                    if (this.rehideBlocks) {
                        blockHidden.setValue(false);
                        continue;
                    }
                    iterator.remove();
                    continue;
                }
                if (blockHidden.getValue().booleanValue()) continue;
                this.playerData.getResults().add(new Result(chunkBlocks, block, false));
                blockHidden.setValue(true);
            }
        }
    }
}

