/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.ELMessageType;
import com.bekvon.bukkit.residence.containers.EconomyType;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.RandomTeleport;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.YmlMaker;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    protected String defaultGroup;
    protected boolean useLeases;
    protected boolean ResMoneyBack;
    private boolean ResBankBack;
    protected boolean enableEconomy;
    protected boolean chargeOnCreation;
    protected boolean chargeOnExpansion;
    protected boolean chargeOnAreaAdd;
    private EconomyType VaultEconomy;
    protected boolean ExtraEnterMessage;
    protected boolean adminsOnly;
    protected boolean allowEmptyResidences;
    protected boolean NoLava;
    protected boolean NoWater;
    protected boolean NoLavaPlace;
    protected boolean useBlockFall;
    protected boolean NoWaterPlace;
    protected boolean AutoCleanUp;
    protected boolean SellSubzone;
    protected boolean LwcOnDelete = false;
    protected boolean LwcOnBuy = false;
    protected boolean LwcOnUnrent = false;
    protected List<Material> LwcMatList = new ArrayList<Material>();
    protected boolean UseClean = false;
    protected boolean PvPFlagPrevent;
    protected boolean OverridePvp;
    protected boolean BlockAnyTeleportation;
    protected CMIMaterial infoTool;
    protected int AutoCleanUpDays;
    protected boolean AutoCleanUpRegenerate;
    protected boolean CanTeleportIncludeOwner;
    private boolean LoadEveryWorld;
    public boolean CleanerStartupLog;
    protected CMIMaterial selectionTool;
    protected boolean adminOps;
    protected boolean AdminFullAccess;
    protected String multiworldPlugin;
    protected boolean enableRentSystem;
    protected boolean RentPreventRemoval;
    private boolean DeductFromBank;
    private boolean DeductFromBankThenPlayer;
    protected boolean RentInformOnEnding;
    protected boolean RentAllowRenewing;
    protected boolean RentStayInMarket;
    protected boolean RentAllowAutoPay;
    protected boolean RentPlayerAutoPay;
    protected boolean leaseAutoRenew;
    protected boolean ShortInfoUse;
    private boolean InfoExcludeDFlags;
    protected boolean OnlyLike;
    protected int RentInformBefore;
    protected int RentInformDelay;
    protected int rentCheckInterval;
    protected int chatPrefixLength;
    protected int leaseCheckInterval;
    protected int autoSaveInt;
    protected boolean NewSaveMechanic;
    private int ItemPickUpDelay;
    private boolean ARCRatioInform;
    private boolean ARCRatioConfirmation;
    private int ARCRatioValue;
    private boolean ARCCheckCollision;
    private boolean ARCOldMethod;
    private String ARCIncrementFormat;
    private int ARCSizePercentage;
    private boolean ARCSizeEnabled;
    private int ARCSizeMin;
    private int ARCSizeMax;
    private boolean ConsoleLogsShowFlagChanges = true;
    protected boolean BackupAutoCleanUpUse;
    protected int BackupAutoCleanUpDays;
    protected boolean UseZipBackup;
    protected boolean BackupWorldFiles;
    protected boolean BackupforsaleFile;
    protected boolean BackupleasesFile;
    protected boolean BackuppermlistsFile;
    protected boolean BackuprentFile;
    protected boolean BackupflagsFile;
    protected boolean BackupgroupsFile;
    protected boolean BackupconfigFile;
    protected int FlowLevel;
    protected int PlaceLevel;
    protected int BlockFallLevel;
    protected int CleanLevel = 63;
    protected int NewPlayerRangeX;
    protected int NewPlayerRangeY;
    protected int NewPlayerRangeZ;
    protected int VisualizerRange;
    protected int VisualizerShowFor;
    protected int VisualizerUpdateInterval;
    protected int TeleportDelay;
    protected boolean TeleportTitleMessage;
    protected int VisualizerRowSpacing;
    protected int VisualizerCollumnSpacing;
    protected int VisualizerSkipBy;
    private int VisualizerFrameCap;
    private int VisualizerSidesCap;
    protected boolean flagsInherit;
    protected boolean ignoreGroupedFlagAcess;
    protected CMIChatColor chatColor;
    protected boolean chatEnable;
    private boolean chatListening;
    private ELMessageType EnterLeaveMessageType;
    protected boolean ActionBarOnSelection;
    protected boolean visualizer;
    protected int minMoveUpdate;
    protected int VoteRangeFrom;
    protected int HealInterval;
    protected int FeedInterval;
    protected int SafeZoneInterval;
    protected int VoteRangeTo;
    protected FlagPermissions globalCreatorDefaults;
    protected FlagPermissions globalRentedDefaults;
    protected FlagPermissions globalResidenceDefaults;
    protected Map<String, FlagPermissions> globalGroupDefaults;
    protected String language;
    protected String DefaultWorld;
    protected String DateFormat;
    protected String DateFormatShort;
    protected String TimeZone;
    protected boolean preventBuildInRent;
    protected boolean PreventSubZoneRemoval;
    protected boolean stopOnSaveError;
    protected String namefix;
    protected boolean showIntervalMessages;
    protected boolean ShowNoobMessage;
    protected boolean NewPlayerUse;
    protected boolean NewPlayerFree;
    protected boolean spoutEnable;
    protected boolean AutoMobRemoval;
    protected boolean BounceAnimation;
    private boolean EnterAnimation;
    protected boolean useFlagGUI;
    protected int AutoMobRemovalInterval;
    protected boolean enableLeaseMoneyAccount;
    protected boolean Couldroncompatibility;
    protected boolean enableDebug = false;
    protected boolean versionCheck = true;
    protected boolean UUIDConvertion = true;
    protected boolean OfflineMode = false;
    protected boolean SelectionIgnoreY = false;
    protected boolean SelectionIgnoreYInSubzone = false;
    private int SelectionNetherHeight = 128;
    protected boolean NoCostForYBlocks = false;
    protected boolean WorldEditIntegration = false;
    protected boolean useVisualizer;
    protected boolean DisableListeners;
    protected boolean DisableCommands;
    private boolean DisableResidenceCreation;
    private HashMap<String, Integer> AntiGreefRangeGaps = new HashMap();
    protected boolean TNTExplodeBelow;
    protected int TNTExplodeBelowLevel;
    protected boolean CreeperExplodeBelow;
    protected int CreeperExplodeBelowLevel;
    protected List<CMIMaterial> customContainers = new ArrayList<CMIMaterial>();
    protected List<CMIMaterial> customBothClick = new ArrayList<CMIMaterial>();
    protected List<CMIMaterial> customRightClick = new ArrayList<CMIMaterial>();
    protected List<Material> CleanBlocks = new ArrayList<Material>();
    protected List<String> NoFlowWorlds;
    protected List<String> AutoCleanUpWorlds;
    private boolean AutoCleanTrasnferToUser;
    private String AutoCleanUserName;
    protected List<String> NoPlaceWorlds;
    protected List<String> BlockFallWorlds;
    protected List<String> CleanWorlds;
    protected List<String> FlagsList;
    protected List<String> NegativePotionEffects;
    protected List<String> NegativeLingeringPotionEffects;
    private double WalkSpeed1;
    private double WalkSpeed2;
    private int SignsMaxPerResidence;
    protected Location KickLocation;
    protected Location FlyLandLocation;
    protected List<RandomTeleport> RTeleport = new ArrayList<RandomTeleport>();
    protected List<String> DisabledWorldsList = new ArrayList<String>();
    protected int rtCooldown;
    protected int rtMaxTries;
    private HashMap<FlagPermissions.FlagState, ItemStack> guiBottonStates = new HashMap();
    private boolean enforceAreaInsideArea;
    protected CMIEffectManager.CMIParticle SelectedFrame;
    protected CMIEffectManager.CMIParticle SelectedSides;
    protected CMIEffectManager.CMIParticle OverlapFrame;
    protected CMIEffectManager.CMIParticle OverlapSides;
    public boolean DynMapHideByDefault;
    public boolean DynMapUse;
    public boolean DynMapShowFlags;
    public boolean DynMapExcludeDefaultFlags;
    public boolean DynMapHideHidden;
    public boolean DynMapLayer3dRegions;
    public int DynMapLayerSubZoneDepth;
    public String DynMapBorderColor;
    public double DynMapBorderOpacity;
    public int DynMapBorderWeight;
    public String DynMapFillColor;
    public double DynMapFillOpacity;
    public String DynMapFillForRent;
    public String DynMapFillRented;
    public String DynMapFillForSale;
    public List<String> DynMapVisibleRegions;
    public List<String> DynMapHiddenRegions;
    public boolean Pl3xMapHideByDefault;
    public boolean Pl3xMapUse;
    public boolean Pl3xMapShowFlags;
    public boolean Pl3xMapExcludeDefaultFlags;
    public boolean Pl3xMapHideHidden;
    public int Pl3xMapLayerSubZoneDepth;
    public int Pl3xBorderColor = 0;
    public int Pl3xFillColor = 0;
    public int Pl3xMapBorderWeight;
    public int Pl3xMapFillForRent = 0;
    public int Pl3xMapFillRented = 0;
    public int Pl3xMapFillForSale = 0;
    public List<String> Pl3xMapVisibleRegions;
    public List<String> Pl3xMapHiddenRegions;
    public static boolean RaidEnabled = false;
    public static boolean RaidAttackerBlockBreak = false;
    public static boolean RaidAttackerBlockPlace = false;
    public static boolean RaidDefenderBlockBreak = false;
    public static boolean RaidDefenderBlockPlace = false;
    public static boolean RaidDefenderTeleport = false;
    public static boolean RaidDefenderContainerUsage = false;
    public static boolean RaidFriendlyFire = false;
    public static int PreRaidTimer = 120;
    public static int RaidTimer = 120;
    public static int RaidCooldown = 120;
    public static int RaidPlayerCooldown = 120;
    public double BankCapacity = 0.0;
    public boolean RestoreAfterRentEnds;
    public boolean SchematicsSaveOnFlagChange;
    public boolean GlobalChatEnabled;
    public boolean GlobalChatSelfModify;
    public String GlobalChatFormat;
    private Residence plugin;

    public ConfigManager(Residence plugin) {
        this.plugin = plugin;
        this.globalCreatorDefaults = new FlagPermissions();
        this.globalRentedDefaults = new FlagPermissions();
        this.globalResidenceDefaults = new FlagPermissions();
        this.globalGroupDefaults = new HashMap<String, FlagPermissions>();
        this.UpdateConfigFile();
        this.loadFlags();
    }

    public static String Colors(String text) {
        return CMIChatColor.translate((String)text);
    }

    public static List<String> getClassesFromPackage(String pckgname, String cleaner) throws ClassNotFoundException {
        ArrayList<String> result = new ArrayList<String>();
        try {
            URL[] uRLArray = ((URLClassLoader)Residence.class.getClassLoader()).getURLs();
            int n = uRLArray.length;
            int n2 = 0;
            while (n2 < n) {
                URL jarURL = uRLArray[n2];
                try {
                    result.addAll(ConfigManager.getClassesInSamePackageFromJar(pckgname, jarURL.toURI().getPath(), cleaner));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        catch (NullPointerException x) {
            throw new ClassNotFoundException(String.valueOf(pckgname) + " does not appear to be a valid package (Null pointer exception)");
        }
        return result;
    }

    private static List<String> getClassesInSamePackageFromJar(String packageName, String jarPath, String cleaner) {
        ArrayList<String> listOfCommands;
        block15: {
            JarFile jarFile = null;
            listOfCommands = new ArrayList<String>();
            try {
                try {
                    jarFile = new JarFile(jarPath);
                    Enumeration<JarEntry> en = jarFile.entries();
                    while (en.hasMoreElements()) {
                        JarEntry entry = en.nextElement();
                        String entryName = entry.getName();
                        packageName = packageName.replace(".", "/");
                        if (entryName == null || !entryName.endsWith(".yml") || !entryName.startsWith(packageName)) continue;
                        String name = entryName.replace(packageName, "").replace(".yml", "").replace("/", "");
                        if (name.contains("$")) {
                            name = name.split("\\$")[0];
                        }
                        if (cleaner != null) {
                            name = name.replace(cleaner, "");
                        }
                        listOfCommands.add(name);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (jarFile == null) break block15;
                    try {
                        jarFile.close();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return listOfCommands;
    }

    public void copyOverTranslations() {
        ArrayList<String> languages = new ArrayList<String>();
        try {
            languages.addAll(ConfigManager.getClassesFromPackage("Language", null));
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        for (String one : languages) {
            File file = new File(this.plugin.getDataFolder(), "Language" + File.separator + one + ".yml");
            if (file.exists()) continue;
            YmlMaker f = new YmlMaker((JavaPlugin)this.plugin, "Language" + File.separator + one + ".yml");
            f.saveDefaultConfig();
            f.ConfigFile.renameTo(file);
        }
    }

    public void ChangeConfig(String path, Boolean stage) {
        File f = new File(this.plugin.getDataFolder(), "config.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        if (!conf.isBoolean(path)) {
            return;
        }
        conf.set(path, (Object)stage);
        try {
            conf.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.plugin.getConfigManager().UpdateConfigFile();
    }

    public static List<String> ColorsArray(List<String> text, Boolean colorize) {
        ArrayList<String> temp = new ArrayList<String>();
        for (String part : text) {
            if (colorize.booleanValue()) {
                part = ConfigManager.Colors(part);
            }
            temp.add(ConfigManager.Colors(part));
        }
        return temp;
    }

    private static int argb(int alpha, Color color) {
        return alpha << 24 | color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    void UpdateFlagFile() {
        File f = new File(this.plugin.getDataFolder(), "flags.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        if (!conf.isList("Global.TotalFlagDisabling")) {
            conf.set("Global.TotalFlagDisabling", Arrays.asList("Completely", "Disable", "Particular", "Flags"));
        }
        if (!conf.isBoolean("Global.CommandLimits.Global.Inherit")) {
            conf.set("Global.CommandLimits.Global.Inherit", (Object)false);
        }
        if (!conf.isList("Global.CommandLimits.Global.WhiteList")) {
            conf.set("Global.CommandLimits.Global.WhiteList", Arrays.asList("some allowed command"));
        }
        if (!conf.isList("Global.CommandLimits.Global.BlackList")) {
            conf.set("Global.CommandLimits.Global.BlackList", Arrays.asList("some blocked command"));
        }
        TreeMap<String, Flags> sorted = new TreeMap<String, Flags>();
        Flags[] flagsArray = Flags.values();
        int n = flagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags flags2 = flagsArray[n2];
            sorted.put(flags2.getName(), flags2);
            ++n2;
        }
        for (Flags flags3 : sorted.values()) {
            if (conf.isBoolean("Global.FlagPermission." + (Object)((Object)flags3))) continue;
            conf.createSection("Global.FlagPermission." + (Object)((Object)flags3));
            conf.set("Global.FlagPermission." + (Object)((Object)flags3), (Object)flags3.isEnabled());
        }
        if (!conf.isConfigurationSection("Global.FlagGui")) {
            conf.createSection("Global.FlagGui");
        }
        if (!conf.isConfigurationSection("Global.RentedDefault")) {
            for (Map.Entry entry : this.getGlobalCreatorDefaultFlags().getFlags().entrySet()) {
                conf.set("Global.RentedDefault." + (String)entry.getKey(), entry.getValue());
            }
            conf.set("Global.RentedDefault.admin", (Object)true);
        }
        ConfigurationSection configurationSection = conf.getConfigurationSection("Global.FlagGui");
        for (Flags fl : sorted.values()) {
            configurationSection.set(fl.toString(), configurationSection.get(fl.toString(), (Object)fl.getIcon().toString()));
        }
        try {
            conf.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ConfigReader cfg = null;
        try {
            cfg = new ConfigReader(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (cfg == null) {
            return;
        }
        cfg.load();
        cfg.addComment("Global", new String[]{"These are Global Settings for Residence."});
        cfg.addComment("Global.Flags", new String[]{"These are world flags that are applied when the player is NOT within a residence."});
        cfg.addComment("Global.Flags.Global", new String[]{"these are default for all worlds unless specified below, they can be overridden per group", "Using command: false flag will allow you to disable and allow predefined commands. Command list can be difined under CommandLimits section"});
        cfg.addComment("Global.CommandLimits", new String[]{"Provide list of commands you want to allow or block", "This is when using 'command: false' flag for global/world flags", "For example 'res create' under allow section and '*' would block everything except 'res create' command", "Can be defined per world just like world flags can be", "This will NOT apply inside residences. Inside residence command limits are based on residence command flag and its set commands limits", "Residence itself will need to have 'command: false' to override global command limits with specific to that residence ones"});
        cfg.addComment("Global.CommandLimits.Global.Inherit", new String[]{"When enabled allowed and blocked commands inside residence will be inherited from global list and combined with residence command limits"});
        cfg.addComment("Global.FlagPermission", new String[]{"This gives permission to change certain flags to all groups, unless specifically denied to the group."});
        cfg.addComment("Global.FlagGui", new String[]{"This sets GUI items to represent each flag, if not given, then gray wool will be used"});
        cfg.addComment("Global.ResidenceDefault", new String[]{"These are default flags applied to all residences from any user group."});
        cfg.addComment("Global.CreatorDefault", new String[]{"These are default flags applied to the residence creator of any group."});
        cfg.addComment("Global.RentedDefault", new String[]{"These are default flags applied to the residence renter of any group."});
        cfg.addComment("Global.GroupedFlags", new String[]{"These are grouped flags, so when using /res pset nickname redstone true, player will get all flags in list, same when setting to false or removing them."});
        cfg.addComment("Global.GroupedFlags.trusted", new String[]{"This group of flags will be used for padd sub command"});
        cfg.addComment("Global.TotalFlagDisabling", new String[]{"Completely disables defined flag which will no longer be accesable even with resadmin command", "Can save some of the server processing resources if you dont want to utilize specific checks for specific flags"});
        cfg.addComment("Global.GroupDefault", new String[]{"These are default group flags applied to a residence made by a user of any group."});
        cfg.addComment("ItemList", new String[]{"this is where you can create blacklists / whitelists"});
        cfg.addComment("ItemList.DefaultList", new String[]{"list name is not important, as long as it is unique. Its good to use a descripive name."});
        cfg.addComment("ItemList.DefaultList.Type", new String[]{"type of the list, can be blacklist, whitelist, or ignorelist"});
        cfg.addComment("ItemList.DefaultList.Items", new String[]{"If you want, you can have this list only apply to one world, otherwise it applies to all worlds", "World: world", "You can also have the list apply only to one group, otherwise it applies for all groups", "Group: default", "this is the actual list of material names that this list allows or disallows", "You can look up the material name by item ID in game by typing /res material <id>", "Alternativly, you can simply use the item ID in the list, but its less descriptive and harder to see what the list allows or dissallows at a glance"});
        Flags[] flagsArray2 = Flags.values();
        int n3 = flagsArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Flags fl = flagsArray2[n4];
            cfg.addComment("Global.FlagPermission." + (Object)((Object)fl), new String[]{"Applies to: " + (Object)((Object)fl.getFlagMode())});
            ++n4;
        }
        cfg.save();
    }

    public void UpdateGroupedFlagsFile() {
        File f = new File(this.plugin.getDataFolder(), "flags.yml");
        YamlConfiguration conf = YamlConfiguration.loadConfiguration((File)f);
        if (!conf.isConfigurationSection("Global.GroupedFlags")) {
            conf.createSection("Global.GroupedFlags");
            conf.set("Global.GroupedFlags.redstone", Arrays.asList(Flags.note.toString(), Flags.pressure.toString(), Flags.lever.toString(), Flags.button.toString(), Flags.diode.toString()));
            conf.set("Global.GroupedFlags.crafting", Arrays.asList(Flags.brew.toString(), Flags.table.toString(), Flags.enchant.toString()));
            conf.set("Global.GroupedFlags.trusted", Arrays.asList(Flags.use.toString(), Flags.tp.toString(), Flags.build.toString(), Flags.container.toString(), Flags.move.toString(), Flags.leash.toString(), Flags.animalkilling.toString(), Flags.mobkilling.toString(), Flags.shear.toString(), Flags.chat.toString()));
            conf.set("Global.GroupedFlags.fire", Arrays.asList(Flags.ignite.toString(), Flags.firespread.toString()));
            try {
                conf.save(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Flags[] flagsArray = Flags.values();
        int n = flagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Flags one = flagsArray[n2];
            one.resetGroups();
            ++n2;
        }
        for (String oneGroup : conf.getConfigurationSection("Global.GroupedFlags").getKeys(false)) {
            for (String oneFlag : conf.getStringList("Global.GroupedFlags." + oneGroup)) {
                Flags flag = Flags.getFlag(oneFlag);
                if (flag != null) {
                    flag.addGroup(oneGroup);
                }
                FlagPermissions.addFlagToFlagGroup(oneGroup, oneFlag);
            }
        }
    }

    public void UpdateConfigFile() {
        int CenterZ;
        int CenterX2;
        int MinCoord;
        int MaxCoord;
        boolean enabled;
        String path;
        ConfigurationSection sec;
        World world;
        String defaultWorldName = Bukkit.getServer().getWorlds().size() > 0 ? ((World)Bukkit.getServer().getWorlds().get(0)).getName() : "World";
        ConfigReader c = null;
        try {
            c = new ConfigReader((Plugin)Residence.getInstance(), "config.yml");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (c == null) {
            return;
        }
        c.copyDefaults(true);
        c.addComment("Global", new String[]{"These are Global Settings for Residence."});
        c.addComment("Global.UUIDConvertion", new String[]{"Starts UUID conversion on plugin startup", "DONT change this if you are not sure what you doing"});
        this.UUIDConvertion = c.get("Global.UUIDConvertion", Boolean.valueOf(true));
        c.addComment("Global.OfflineMode", new String[]{"STRONGLY not recomended to be used anymore. Only enable if you are sure you want to use this", "If you running offline server. Suggestion would be to keep this at false and base residence ownership from UUID and not on players name"});
        this.OfflineMode = c.get("Global.OfflineMode", Boolean.valueOf(false));
        c.addComment("Global.versionCheck", new String[]{"Players with residence.versioncheck permission node will be noticed about new residence version on login"});
        this.versionCheck = c.get("Global.versionCheck", Boolean.valueOf(true));
        c.addComment("Global.Language", new String[]{"This loads the <language>.yml file in the Residence Language folder", "All Residence text comes from this file. (NOT DONE YET)"});
        this.language = c.get("Global.Language", "English");
        c.addComment("Global.SelectionToolId", new String[]{"Wooden Hoe is the default selection tool for Residence."});
        this.selectionTool = CMIMaterial.get((String)c.get("Global.SelectionToolId", CMIMaterial.WOODEN_HOE.name()));
        c.addComment("Global.Selection.IgnoreY", new String[]{"By setting this to true, all selections will be made from bedrock to sky ignoring Y coordinates"});
        this.SelectionIgnoreY = c.get("Global.Selection.IgnoreY", Boolean.valueOf(false));
        c.addComment("Global.Selection.IgnoreYInSubzone", new String[]{"When this set to true, selections inside existing residence will be from bottom to top of that residence", "When this set to false, selections inside existing residence will be exactly as they are"});
        this.SelectionIgnoreYInSubzone = c.get("Global.Selection.IgnoreYInSubzone", Boolean.valueOf(false));
        c.addComment("Global.Selection.netherHeight", new String[]{"Defines height of nether when creating residences. This mostly applies when performing commands like /res select vert or /res auto which will expand residence to defined height", "This cant be higher than 319 or lower than 1"});
        this.SelectionNetherHeight = c.get("Global.Selection.netherHeight", 128);
        this.SelectionNetherHeight = this.SelectionNetherHeight > 319 ? 319 : (this.SelectionNetherHeight < 1 ? 1 : this.SelectionNetherHeight);
        c.addComment("Global.Selection.NoCostForYBlocks", new String[]{"By setting this to true, player will only pay for x*z blocks ignoring height", "This will lower residence price by up to 319 times, so adjust block price BEFORE enabling this"});
        this.NoCostForYBlocks = c.get("Global.Selection.NoCostForYBlocks", Boolean.valueOf(false));
        c.addComment("Global.Selection.WorldEditIntegration", new String[]{"Enable or disable world edit integration into Residence plugin"});
        this.WorldEditIntegration = c.get("Global.Selection.WorldEditIntegration", Boolean.valueOf(true));
        c.addComment("Global.InfoToolId", new String[]{"This determins which tool you can use to see info on residences, default is String.", "Simply equip this tool and hit a location inside the residence and it will display the info for it."});
        this.infoTool = CMIMaterial.get((String)c.get("Global.InfoToolId", Material.STRING.toString()));
        c.addComment("Global.Optimizations.LoadEveryWorld", new String[]{"When enabled we will load data from every single world file even if world doesn't exist but might be loaded later on", "Usually only useful when you have multiverse plugin which loads worlds durring server work time"});
        this.LoadEveryWorld = c.get("Global.Optimizations.LoadEveryWorld", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.CleanerStartupLog", new String[]{"While enabled we will avoid showing extra feedback lines on startup"});
        this.CleanerStartupLog = c.get("Global.Optimizations.CleanerStartupLog", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.CanTeleportIncludeOwner", new String[]{"This will slightly change behavior of groups file CanTeleport section which will include server owner into check", "When this is set to false and CanTeleport set to false, players will not have option to teleport to other player residences, only to their own", "When this is set to true and CanTeleport set to false, players will not have option to teleport to residences in general", "Keep in mind that this only applies for commands like /res tp"});
        this.CanTeleportIncludeOwner = c.get("Global.Optimizations.CanTeleportIncludeOwner", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.DefaultWorld", new String[]{"Name of your main residence world. Usually normal starting world 'World'. Capitalization essential"});
        this.DefaultWorld = c.get("Global.Optimizations.DefaultWorld", defaultWorldName);
        c.addComment("Global.Optimizations.DisabledWorlds.List", new String[]{"List Of Worlds where this plugin is disabled", "Make sure that world names capitalization is correct"});
        this.DisabledWorldsList = c.get("Global.Optimizations.DisabledWorlds.List", Arrays.asList("worldNamesHere"));
        c.addComment("Global.Optimizations.DisabledWorlds.DisableListeners", new String[]{"Disables all listeners in included worlds"});
        this.DisableListeners = c.get("Global.Optimizations.DisabledWorlds.DisableListeners", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.DisabledWorlds.DisableCommands", new String[]{"Disables any command usage in included worlds"});
        this.DisableCommands = c.get("Global.Optimizations.DisabledWorlds.DisableCommands", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.DisabledWorlds.DisableResidenceCreation", new String[]{"Disables residence creation in included worlds"});
        this.DisableResidenceCreation = c.get("Global.Optimizations.DisabledWorlds.DisableResidenceCreation", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.ItemPickUpDelay", new String[]{"Delay in seconds between item pickups after residence flag prevents it", "Keep it at arround 10 sec to lower unesecery checks"});
        this.ItemPickUpDelay = c.get("Global.Optimizations.ItemPickUpDelay", 10);
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.CheckCollision", new String[]{"When set to true /res auto command will check for new area collision with other residences to avoid overlapping.", "Set it to false to gain some performace but new residence can often overlap with old ones"});
        this.ARCCheckCollision = c.get("Global.Optimizations.AutomaticResidenceCreation.CheckCollision", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.Ratio", new String[]{"Weird shaped residence detection when using automatic residence creation", "This will inform player about residence shape being iregular cuboid before creation of it"});
        this.ARCRatioInform = c.get("Global.Optimizations.AutomaticResidenceCreation.Ratio.Inform", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.Confirmation", new String[]{"While enabled player will be required to click on chat message or perform /res create [resName] to finalize creation of residence when its in a weird shape"});
        this.ARCRatioConfirmation = c.get("Global.Optimizations.AutomaticResidenceCreation.Ratio.Confirmation", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.Ratio.Value", new String[]{"Defines value of ration when residence will be counted as weird shaped ones", "Value of 3 will mean that one of the sides of cuboid is atleast 3 times bigger than one of the remaining ones"});
        this.ARCRatioValue = c.get("Global.Optimizations.AutomaticResidenceCreation.Ratio.Value", 3);
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.OldMethod", new String[]{"Enabled this will switch to old method for calculating new residence area", "Old method is allot less efficient, so its not recomended to be used when you have residence areas over 100"});
        this.ARCOldMethod = c.get("Global.Optimizations.AutomaticResidenceCreation.OldMethod", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.IncrementFormat", new String[]{"Defines new residence name increment when using automatic residence creation command if residence with that name already exist"});
        this.ARCIncrementFormat = c.get("Global.Optimizations.AutomaticResidenceCreation.IncrementFormat", "_[number]");
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.Size.Enabled", new String[]{"When enabled we will try to create region by defined bounds"});
        this.ARCSizeEnabled = c.get("Global.Optimizations.AutomaticResidenceCreation.Size.Enabled", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.Size.Percentage", new String[]{"Value between 1 and 100 which will define size of residence we will create in percentage depending on players permission group"});
        this.ARCSizePercentage = c.get("Global.Optimizations.AutomaticResidenceCreation.Size.Percentage", 50);
        this.ARCSizePercentage = this.ARCSizePercentage < 1 ? 1 : (this.ARCSizePercentage > 100 ? 100 : this.ARCSizePercentage);
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.Size.Min", new String[]{"Value in blocks. While previous percentage will determine general size, this can be used to avoid having tiny residences", "For example if player has access to 30x30 residence and Percentage is set to 50% then instead of using 15 block size we will use 20 (default)", "Keep in mind that this will not override actual max/min residence sizes player can have"});
        this.ARCSizeMin = c.get("Global.Optimizations.AutomaticResidenceCreation.Size.Min", 5);
        this.ARCSizeMin = this.ARCSizeMin < 1 ? 1 : this.ARCSizeMin;
        c.addComment("Global.Optimizations.AutomaticResidenceCreation.Size.Max", new String[]{"Value in blocks. While previous percentage will determine general size, this can be used to avoid having huge residences", "For example if player has access to 500x500 residence and Percentage is set to 50% then instead of using 250 block size we will use 100 (default)", "Keep in mind that this will not override actual max/min residence sizes player can have"});
        this.ARCSizeMax = c.get("Global.Optimizations.AutomaticResidenceCreation.Size.Max", 100);
        this.ARCSizeMax = this.ARCSizeMax < this.ARCSizeMin ? this.ARCSizeMin : this.ARCSizeMax;
        c.addComment("Global.Optimizations.GlobalChat.Enabled", new String[]{"Enables or disables chat modification by including players main residence name"});
        this.GlobalChatEnabled = c.get("Global.Optimizations.GlobalChat.Enabled", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.GlobalChat.SelfModify", new String[]{"Modifys chat to add chat titles.  If you're using a chat manager, you may add the tag {residence} to your chat format and disable this."});
        this.GlobalChatSelfModify = c.get("Global.Optimizations.GlobalChat.SelfModify", Boolean.valueOf(true));
        this.GlobalChatFormat = c.get("Global.Optimizations.GlobalChat.Format", "&c[&e%1&c]");
        c.addComment("Global.Optimizations.BlockAnyTeleportation", new String[]{"When this set to true, any teleportation to residence where player dont have tp flag, action will be denyied", "This can prevent from teleporting players to residence with 3rd party plugins like esentials /tpa"});
        this.BlockAnyTeleportation = c.get("Global.Optimizations.BlockAnyTeleportation", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.OverridePvp", new String[]{"By setting this to true, regular pvp flag will be acting as overridepvp flag", "Overridepvp flag tries to ignore any pvp protection in that residence by any other plugin"});
        this.OverridePvp = c.get("Global.Optimizations.OverridePvp", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.KickLocation.Use", new String[]{"By setting this to true, when player kicks another player from residence, he will be teleported to this location instead of getting outside residence"});
        Boolean UseKick = c.get("Global.Optimizations.KickLocation.Use", Boolean.valueOf(false));
        String KickLocationWorld = c.get("Global.Optimizations.KickLocation.World", defaultWorldName);
        Double KickLocationX = c.get("Global.Optimizations.KickLocation.X", Double.valueOf(0.5));
        Double KickLocationY = c.get("Global.Optimizations.KickLocation.Y", Double.valueOf(63.0));
        Double KickLocationZ = c.get("Global.Optimizations.KickLocation.Z", Double.valueOf(0.5));
        c.addComment("Global.Optimizations.KickLocation.Pitch", new String[]{"Less than 0 - head up, more than 0 - head down. Range from -90 to 90"});
        Double KickPitch = c.get("Global.Optimizations.KickLocation.Pitch", Double.valueOf(0.0));
        c.addComment("Global.Optimizations.KickLocation.Yaw", new String[]{"Head position to left and right. Range from -180 to 180"});
        Double KickYaw = c.get("Global.Optimizations.KickLocation.Yaw", Double.valueOf(0.0));
        if (UseKick.booleanValue() && (world = Bukkit.getWorld((String)KickLocationWorld)) != null) {
            this.KickLocation = new Location(world, KickLocationX.doubleValue(), KickLocationY.doubleValue(), KickLocationZ.doubleValue());
            this.KickLocation.setPitch(KickPitch.floatValue());
            this.KickLocation.setYaw(KickYaw.floatValue());
        }
        c.addComment("Global.Optimizations.FlyLandLocation.World", new String[]{"Used when players fly state is being turned to false because of fly flag and there is no solid land where to land for player"});
        String FlyLocationWorld = c.get("Global.Optimizations.FlyLandLocation.World", defaultWorldName);
        Double FlyLocationX = c.get("Global.Optimizations.FlyLandLocation.X", Double.valueOf(0.5));
        Double FlyLocationY = c.get("Global.Optimizations.FlyLandLocation.Y", Double.valueOf(63.0));
        Double FlyLocationZ = c.get("Global.Optimizations.FlyLandLocation.Z", Double.valueOf(0.5));
        c.addComment("Global.Optimizations.FlyLandLocation.Pitch", new String[]{"Less than 0 - head up, more than 0 - head down. Range from -90 to 90"});
        Double FlyPitch = c.get("Global.Optimizations.FlyLandLocation.Pitch", Double.valueOf(0.0));
        c.addComment("Global.Optimizations.FlyLandLocation.Yaw", new String[]{"Head position to left and right. Range from -180 to 180"});
        Double FlyYaw = c.get("Global.Optimizations.FlyLandLocation.Yaw", Double.valueOf(0.0));
        World world2 = Bukkit.getWorld((String)FlyLocationWorld);
        if (world2 != null) {
            this.FlyLandLocation = new Location(world2, FlyLocationX.doubleValue(), FlyLocationY.doubleValue(), FlyLocationZ.doubleValue());
            this.FlyLandLocation.setPitch(FlyPitch.floatValue());
            this.FlyLandLocation.setYaw(FlyYaw.floatValue());
        }
        c.addComment("Global.Optimizations.InfoCommand.ShortInformation", new String[]{"By setting this to true, when checking residence info with /res info, you will get only names in list, by hovering on them, you will get flag list"});
        this.ShortInfoUse = c.get("Global.Optimizations.InfoCommand.ShortInformation", Boolean.valueOf(c.getC().getBoolean("Global.Optimizations.ShortInfo.Use", true)));
        c.addComment("Global.Optimizations.InfoCommand.ExcludeDefaultFlags", new String[]{"When set to true default residence flags set in flags.yml file will get excluded from info command output and will not be shown", "If flag gets different state then it will be shown"});
        this.InfoExcludeDFlags = c.get("Global.Optimizations.InfoCommand.ExcludeDefaultFlags", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.Vote.RangeFrom", new String[]{"Range players can vote to, by default its from 0 to 10 points"});
        this.VoteRangeFrom = c.get("Global.Optimizations.Vote.RangeFrom", 0);
        this.VoteRangeTo = c.get("Global.Optimizations.Vote.RangeTo", 10);
        c.addComment("Global.Optimizations.Vote.OnlyLike", new String[]{"If this true, players can only give like for shop instead of point voting"});
        this.OnlyLike = c.get("Global.Optimizations.Vote.OnlyLike", Boolean.valueOf(false));
        c.addComment("Global.Optimizations.ConsoleLogs.ShowFlagChanges", new String[]{"If this true, flag changes throw GUI will be recorded in console"});
        this.ConsoleLogsShowFlagChanges = c.get("Global.Optimizations.ConsoleLogs.ShowFlagChanges", Boolean.valueOf(true));
        c.addComment("Global.Optimizations.Intervals.Heal", new String[]{"How often in seconds to heal/feed players in residence with appropriate flag", "Bigger numbers can save some server resources", "Set to 0 if you want to disable specific checks entirely. Recommended in case you are not using specific flags"});
        this.HealInterval = c.get("Global.Optimizations.Intervals.Heal", 1);
        this.FeedInterval = c.get("Global.Optimizations.Intervals.Feed", 5);
        this.SafeZoneInterval = c.get("Global.Optimizations.Intervals.SafeZone", 3);
        c.addComment("Global.Optimizations.NegativePotionEffects", new String[]{"Potions containing one of thos effects will be ignored if residence dont have pvp true flag set"});
        this.NegativePotionEffects = c.get("Global.Optimizations.NegativePotionEffects", Arrays.asList("blindness", "confusion", "harm", "hunger", "poison", "slow", "slow_digging", "weakness", "wither"));
        this.NegativeLingeringPotionEffects = c.get("Global.Optimizations.NegativeLingeringPotions", Arrays.asList("slowness", "instant_damage", "poison", "slowness"));
        c.addComment("Global.Optimizations.WalkSpeed", new String[]{"Defines speed for particular wspeed1 and wspeed2 flags. It can be from 0 up to 5"});
        this.WalkSpeed1 = c.get("Global.Optimizations.WalkSpeed.1", Double.valueOf(0.5));
        this.WalkSpeed1 = this.WalkSpeed1 < 0.0 ? 0.0 : this.WalkSpeed1;
        this.WalkSpeed1 = this.WalkSpeed1 > 5.0 ? 5.0 : this.WalkSpeed1;
        this.WalkSpeed1 /= 5.0;
        this.WalkSpeed2 = c.get("Global.Optimizations.WalkSpeed.2", Double.valueOf(2.0));
        this.WalkSpeed2 = this.WalkSpeed2 < 0.0 ? 0.0 : this.WalkSpeed2;
        this.WalkSpeed2 = this.WalkSpeed2 > 5.0 ? 5.0 : this.WalkSpeed2;
        this.WalkSpeed2 /= 5.0;
        this.SignsMaxPerResidence = c.get("Global.Signs.MaxPerResidence", 5);
        this.SignsMaxPerResidence = this.SignsMaxPerResidence < 0 ? 0 : this.SignsMaxPerResidence;
        c.addComment("Global.MoveCheckInterval", new String[]{"The interval, in milliseconds, between movement checks.", "Reducing this will increase the load on the server.", "Increasing this will allow players to move further in movement restricted zones before they are teleported out."});
        this.minMoveUpdate = c.get("Global.MoveCheckInterval", 500);
        c.addComment("Global.Tp.TeleportDelay", new String[]{"The interval, in seconds, for teleportation.", "Use 0 to disable"});
        this.TeleportDelay = c.get("Global.Tp.TeleportDelay", 3);
        c.addComment("Global.Tp.TeleportTitleMessage", new String[]{"Show aditional message in title message area when player is teleporting to residence"});
        this.TeleportTitleMessage = c.get("Global.Tp.TeleportTitleMessage", Boolean.valueOf(true));
        HashSet<World> worlds = new HashSet<World>();
        int i = 0;
        while (i < 3 && i < Bukkit.getWorlds().size()) {
            worlds.add((World)Bukkit.getWorlds().get(i));
            ++i;
        }
        worlds.addAll(Bukkit.getWorlds());
        this.RTeleport.clear();
        boolean commented = false;
        if (c.getC().isConfigurationSection("Global.RandomTeleportation.Worlds") && (sec = c.getC().getConfigurationSection("Global.RandomTeleportation.Worlds")) != null) {
            for (Object one : sec.getKeys(false)) {
                path = "Global.RandomTeleportation.Worlds." + (String)one + ".";
                enabled = c.get(String.valueOf(path) + "Enabled", Boolean.valueOf(true));
                if (!commented) {
                    c.addComment("Global.RandomTeleportation.Worlds." + (String)one, new String[]{"World name to use this feature. Add annother one with appropriate name to enable random teleportation"});
                }
                if (!commented) {
                    c.addComment(String.valueOf(path) + "MaxCoord", new String[]{"Max coordinate to teleport, setting to 1000, player can be teleported between -1000 and 1000 coordinates"});
                }
                MaxCoord = c.get(String.valueOf(path) + "MaxCoord", 1000);
                if (!commented) {
                    c.addComment(String.valueOf(path) + "MinCoord", new String[]{"If maxcoord set to 1000 and mincoord to 500, then player can be teleported between -1000 to -500 and 500 to 1000 coordinates"});
                }
                MinCoord = c.get(String.valueOf(path) + "MinCoord", c.getC().getInt(String.valueOf(path) + "MinCord", 500));
                CenterX2 = c.get(String.valueOf(path) + "CenterX", 0);
                CenterZ = c.get(String.valueOf(path) + "CenterZ", 0);
                World w = this.getWorld((String)one);
                if (w == null) {
                    this.plugin.consoleMessage("&cCan't find world with (" + (String)one + ") name");
                    continue;
                }
                commented = true;
                worlds.remove(w);
                if (!enabled) continue;
                this.RTeleport.add(new RandomTeleport(w, MaxCoord, MinCoord, CenterX2, CenterZ));
            }
        }
        for (World one : worlds) {
            String name = one.getName();
            name = name.replace(".", "_");
            path = "Global.RandomTeleportation.Worlds." + name + ".";
            enabled = c.get(String.valueOf(path) + "Enabled", Boolean.valueOf(true));
            MaxCoord = c.get(String.valueOf(path) + "MaxCoord", 1000);
            MinCoord = c.get(String.valueOf(path) + "MinCoord", c.getC().getInt(String.valueOf(path) + "MinCord", 500));
            CenterX2 = c.get(String.valueOf(path) + "CenterX", 0);
            CenterZ = c.get(String.valueOf(path) + "CenterZ", 0);
            if (!enabled) continue;
            this.RTeleport.add(new RandomTeleport(one, MaxCoord, MinCoord, CenterX2, CenterZ));
        }
        c.addComment("Global.RandomTeleportation.Cooldown", new String[]{"How long force player to wait before using command again."});
        this.rtCooldown = c.get("Global.RandomTeleportation.Cooldown", 5);
        c.addComment("Global.RandomTeleportation.MaxTries", new String[]{"How many times to try find correct location for teleportation.", "Keep it at low number, as player always can try again after delay"});
        this.rtMaxTries = c.get("Global.RandomTeleportation.MaxTries", 20);
        c.addComment("Global.SaveInterval", new String[]{"The interval, in minutes, between residence saves."});
        this.autoSaveInt = c.get("Global.SaveInterval", 10);
        c.addComment("Global.NewSaveMechanic", new String[]{"New save mechanic can minimize save file couple times and speedup save/load time in general", "Bigger files have bigger impact"});
        this.NewSaveMechanic = c.get("Global.NewSaveMechanic", Boolean.valueOf(true));
        c.addComment("Global.Backup.AutoCleanUp.Use", new String[]{"Do you want to automatically remove backup files from main backup folder if they are older than defined day amount"});
        this.BackupAutoCleanUpUse = c.get("Global.Backup.AutoCleanUp.Use", Boolean.valueOf(false));
        this.BackupAutoCleanUpDays = c.get("Global.Backup.AutoCleanUp.Days", 30);
        c.addComment("Global.Backup.UseZip", new String[]{"Do you want to backup files by creating zip files in main residence folder in backup folder", "This wont have effect on regular backuped files made in save folder"});
        this.UseZipBackup = c.get("Global.Backup.UseZip", Boolean.valueOf(true));
        this.BackupWorldFiles = c.get("Global.Backup.IncludeFiles.Worlds", Boolean.valueOf(true));
        this.BackupforsaleFile = c.get("Global.Backup.IncludeFiles.forsale", Boolean.valueOf(true));
        this.BackupleasesFile = c.get("Global.Backup.IncludeFiles.leases", Boolean.valueOf(true));
        this.BackuppermlistsFile = c.get("Global.Backup.IncludeFiles.permlists", Boolean.valueOf(true));
        this.BackuprentFile = c.get("Global.Backup.IncludeFiles.rent", Boolean.valueOf(true));
        this.BackupflagsFile = c.get("Global.Backup.IncludeFiles.flags", Boolean.valueOf(true));
        this.BackupgroupsFile = c.get("Global.Backup.IncludeFiles.groups", Boolean.valueOf(true));
        this.BackupconfigFile = c.get("Global.Backup.IncludeFiles.config", Boolean.valueOf(true));
        c.addComment("Global.AutoCleanUp.Use", new String[]{"HIGHLY EXPERIMENTAL residence cleaning on server startup if player is offline for x days.", "Players can bypass this with residence.cleanbypass permission node"});
        this.AutoCleanUp = c.get("Global.AutoCleanUp.Use", Boolean.valueOf(false));
        c.addComment("Global.AutoCleanUp.Days", new String[]{"For how long player should be offline to delete hes residence"});
        this.AutoCleanUpDays = c.get("Global.AutoCleanUp.Days", 60);
        c.addComment("Global.AutoCleanUp.Regenerate", new String[]{"Extra heavy on server and will lag it out while regeneration is ongoing", "Do you want to regenerate old residence area", "This requires world edit to be present"});
        this.AutoCleanUpRegenerate = c.get("Global.AutoCleanUp.Regenerate", Boolean.valueOf(false));
        c.addComment("Global.AutoCleanUp.Worlds", new String[]{"Worlds to be included in check list"});
        this.AutoCleanUpWorlds = c.get("Global.AutoCleanUp.Worlds", Arrays.asList(defaultWorldName));
        int i2 = 0;
        while (i2 < this.AutoCleanUpWorlds.size()) {
            this.AutoCleanUpWorlds.set(i2, this.AutoCleanUpWorlds.get(i2).toLowerCase());
            ++i2;
        }
        c.addComment("Global.AutoCleanUp.TrasnferToUser", new String[]{"When enabled we will transfer residence to defined user instead of removing it", "Defined user will be excluded from cleanup operation"});
        this.AutoCleanTrasnferToUser = c.get("Global.AutoCleanUp.TrasnferToUser", Boolean.valueOf(false));
        c.addComment("Global.AutoCleanUp.UserName", new String[]{"Name of the user which receives removed residence"});
        this.AutoCleanUserName = c.get("Global.AutoCleanUp.UserName", "Server_Land");
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            this.LwcMatList.clear();
            c.addComment("Global.Lwc.OnDelete", new String[]{"Removes lwc protection from all defined objects when removing residence"});
            this.LwcOnDelete = c.get("Global.Lwc.OnDelete", Boolean.valueOf(true));
            c.addComment("Global.Lwc.OnBuy", new String[]{"Removes lwc protection from all defined objects when buying residence"});
            this.LwcOnBuy = c.get("Global.Lwc.OnBuy", Boolean.valueOf(true));
            c.addComment("Global.Lwc.OnUnrent", new String[]{"Removes lwc protection from all defined objects when unrenting residence"});
            this.LwcOnUnrent = c.get("Global.Lwc.OnUnrent", Boolean.valueOf(true));
            c.addComment("Global.Lwc.MaterialList", new String[]{"List of blocks you want to remove protection from"});
            for (String oneName : c.get("Global.Lwc.MaterialList", Arrays.asList("CHEST", "TRAPPED_CHEST", "furnace", "dispenser"))) {
                Material mat = Material.getMaterial((String)oneName.toUpperCase());
                if (mat != null) {
                    this.LwcMatList.add(mat);
                    continue;
                }
                Bukkit.getConsoleSender().sendMessage("Incorrect Lwc material name for " + oneName);
            }
        }
        c.addComment("Global.AntiGreef.RangeGaps", new String[]{"Distance in blocks between residences to be left out", "This will prevent from residences being created back to back", "In case owner of old residence and new one is the same this range restriction wont be taken into effect", "Set to 0 or an empty list if you want to disable this", "Use 'all' if you want to use same limitation on all worlds", "Use specific world name if you only want to use this limitation on this world", "Specific world name will override 'all' value"});
        List ls = new ArrayList<String>();
        if (c.getC().isInt("Global.AntiGreef.RangeGap")) {
            ls.add("all-" + c.getC().getInt("Global.AntiGreef.RangeGap"));
            c.get("Global.AntiGreef.RangeGaps", Arrays.asList("all-" + c.getC().getInt("Global.AntiGreef.RangeGap")));
        } else {
            ls = c.get("Global.AntiGreef.RangeGaps", Arrays.asList("all-8"));
        }
        for (Object one : ls) {
            String[] split = ((String)one).split("-");
            if (split.length < 2) continue;
            try {
                String worldName = ((String)one).substring(0, ((String)one).length() - split[split.length - 1].length() - 1);
                int range = Integer.parseInt(split[split.length - 1]);
                this.AntiGreefRangeGaps.put(worldName.toLowerCase(), range);
            }
            catch (Throwable worldName) {
                // empty catch block
            }
        }
        c.addComment("Global.AntiGreef.TNT.ExplodeBelow", new String[]{"When set to true will allow tnt and minecart with tnt to explode below 62 (default) level outside of residence", "This will allow mining with tnt and more vanilla play"});
        this.TNTExplodeBelow = c.get("Global.AntiGreef.TNT.ExplodeBelow", Boolean.valueOf(false));
        this.TNTExplodeBelowLevel = c.get("Global.AntiGreef.TNT.level", 62);
        c.addComment("Global.AntiGreef.Creeper.ExplodeBelow", new String[]{"When set to true will allow Creeper explode below 62 (default) level outside of residence", "This will give more realistic game play", "For this to work properly you will need to disable creeper explosion in the world in general. This can be done in flags file under global world section"});
        this.CreeperExplodeBelow = c.get("Global.AntiGreef.Creeper.ExplodeBelow", Boolean.valueOf(false));
        this.CreeperExplodeBelowLevel = c.get("Global.AntiGreef.Creeper.level", 62);
        c.addComment("Global.AntiGreef.Flow.Level", new String[]{"Level from which one to start lava and water flow blocking", "This dont have effect in residence area"});
        this.FlowLevel = c.get("Global.AntiGreef.Flow.Level", 63);
        c.addComment("Global.AntiGreef.Flow.NoLavaFlow", new String[]{"With this set to true, lava flow outside residence is blocked"});
        this.NoLava = c.get("Global.AntiGreef.Flow.NoLavaFlow", Boolean.valueOf(false));
        c.addComment("Global.AntiGreef.Flow.NoWaterFlow", new String[]{"With this set to true, water flow outside residence is blocked"});
        this.NoWater = c.get("Global.AntiGreef.Flow.NoWaterFlow", Boolean.valueOf(false));
        this.NoFlowWorlds = c.get("Global.AntiGreef.Flow.Worlds", Arrays.asList(defaultWorldName));
        c.addComment("Global.AntiGreef.Place.Level", new String[]{"Level from which one to start block lava and water place", "This don't have effect in residence area"});
        this.PlaceLevel = c.get("Global.AntiGreef.Place.Level", 63);
        c.addComment("Global.AntiGreef.Place.NoLavaPlace", new String[]{"With this set to true, playrs cant place lava outside residence"});
        this.NoLavaPlace = c.get("Global.AntiGreef.Place.NoLavaPlace", Boolean.valueOf(false));
        c.addComment("Global.AntiGreef.Place.NoWaterPlace", new String[]{"With this set to true, players cant place water outside residence"});
        this.NoWaterPlace = c.get("Global.AntiGreef.Place.NoWaterPlace", Boolean.valueOf(false));
        this.NoPlaceWorlds = c.get("Global.AntiGreef.Place.Worlds", Arrays.asList(defaultWorldName));
        c.addComment("Global.AntiGreef.BlockFall.Use", new String[]{"With this set to true, falling blocks will be deleted if they will land in different area"});
        this.useBlockFall = c.get("Global.AntiGreef.BlockFall.Use", Boolean.valueOf(true));
        c.addComment("Global.AntiGreef.BlockFall.Level", new String[]{"Level from which one to start block block's fall", "This don't have effect in residence area or outside"});
        this.BlockFallLevel = c.get("Global.AntiGreef.BlockFall.Level", 62);
        this.BlockFallWorlds = c.get("Global.AntiGreef.BlockFall.Worlds", Arrays.asList(defaultWorldName));
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            this.CleanBlocks.clear();
            c.addComment("Global.AntiGreef.ResCleaning.Use", new String[]{"With this set to true, after player removes its residence, all blocks listed below, will be replaced with air blocks", "Effective way to prevent residence creating near greefing target and then remove it", "ATTENTION! Bigger residence areas could want to create bigger loads on server when cleaning up areas. So dont use this if regular player have access to huge residences. 15 million blocks would be a max limit"});
            this.UseClean = c.get("Global.AntiGreef.ResCleaning.Use", Boolean.valueOf(false));
            c.addComment("Global.AntiGreef.ResCleaning.Level", new String[]{"Level from whichone you want to replace blocks"});
            this.CleanLevel = c.get("Global.AntiGreef.ResCleaning.Level", 63);
            c.addComment("Global.AntiGreef.ResCleaning.Blocks", new String[]{"Block list to be replaced", "By default only water and lava will be replaced"});
            List pls = c.get("Global.AntiGreef.ResCleaning.Blocks", Arrays.asList(CMIMaterial.WATER.toString(), CMIMaterial.LAVA.toString()));
            for (Object one : pls) {
                CMIMaterial mat = CMIMaterial.get((String)String.valueOf(one));
                if (mat == CMIMaterial.NONE || mat.getMaterial() == null || mat.isAir()) continue;
                this.CleanBlocks.add(mat.getMaterial());
            }
            this.CleanWorlds = c.get("Global.AntiGreef.ResCleaning.Worlds", Arrays.asList(defaultWorldName));
            int i3 = 0;
            while (i3 < this.CleanWorlds.size()) {
                this.CleanWorlds.set(i3, this.CleanWorlds.get(i3).toLowerCase());
                ++i3;
            }
        }
        c.addComment("Global.AntiGreef.Flags.Prevent", new String[]{"By setting this to true flags from list will be protected from change while there is some one inside residence besides owner", "Protects in example from people inviting some one and changing pvp flag to true to kill them"});
        this.PvPFlagPrevent = c.get("Global.AntiGreef.Flags.Prevent", Boolean.valueOf(true));
        this.FlagsList = c.get("Global.AntiGreef.Flags.list", Arrays.asList("pvp"));
        c.addComment("Global.DefaultGroup", new String[]{"The default group to use if Permissions fails to attach or your not using Permissions."});
        this.defaultGroup = c.get("Global.DefaultGroup", "default");
        c.addComment("Global.UseLeaseSystem", new String[]{"Enable / Disable the Lease System."});
        this.useLeases = c.get("Global.UseLeaseSystem", Boolean.valueOf(false));
        c.addComment("Global.DateFormat", new String[]{"Sets date format when shown in example lease or rent expire date", "How to use it properly, more information can be found at http://www.tutorialspoint.com/java/java_date_time.htm"});
        this.DateFormat = c.get("Global.DateFormat", "E yyyy.MM.dd 'at' hh:mm:ss a zzz");
        c.addComment("Global.DateFormatShort", new String[]{"Sets date format when shown in example lease or rent expire date", "How to use it properly, more information can be found at http://www.tutorialspoint.com/java/java_date_time.htm"});
        this.DateFormatShort = c.get("Global.DateFormatShort", "MM.dd hh:mm");
        c.addComment("Global.TimeZone", new String[]{"Sets time zone for showing date, useful when server is in different country then main server player base", "Full list of possible time zones can be found at http://www.mkyong.com/java/java-display-list-of-timezone-with-gmt/"});
        this.TimeZone = c.get("Global.TimeZone", Calendar.getInstance().getTimeZone().getID());
        c.addComment("Global.ResMoneyBack", new String[]{"Enable / Disable money returning on residence removal."});
        this.ResMoneyBack = c.get("Global.ResMoneyBack", Boolean.valueOf(false));
        c.addComment("Global.ResBankBack", new String[]{"Enable / Disable money returning from residence bank on residence removal."});
        this.ResBankBack = c.get("Global.ResBankBack", Boolean.valueOf(true));
        c.addComment("Global.LeaseCheckInterval", new String[]{"The interval, in minutes, between residence lease checks (if leases are enabled)."});
        this.leaseCheckInterval = c.get("Global.LeaseCheckInterval", 10);
        c.addComment("Global.LeaseAutoRenew", new String[]{"Allows leases to automatically renew so long as the player has the money, if economy is disabled, this setting does nothing."});
        this.leaseAutoRenew = c.get("Global.LeaseAutoRenew", Boolean.valueOf(true));
        c.addComment("Global.EnablePermissions", new String[]{"Whether or not to use the Permissions system in conjunction with this config."});
        c.get("Global.EnablePermissions", Boolean.valueOf(true));
        c.addComment("Global.EnableEconomy", new String[]{"Enable / Disable Residence's Economy System (iConomy, MineConomy, Essentials, BOSEconomy, and RealEconomy supported)."});
        this.enableEconomy = c.get("Global.EnableEconomy", Boolean.valueOf(true));
        c.addComment("Global.ChargeWhen", new String[]{"Defines when we should charge money. Only works if economy is enabled"});
        c.addComment("Global.ChargeWhen.Creating", new String[]{"Charges money on residence creation, this includes /res create and /res auto"});
        this.chargeOnCreation = c.get("Global.ChargeWhen.Creating", Boolean.valueOf(true));
        c.addComment("Global.ChargeWhen.Expanding", new String[]{"Charges money on residence area expansion"});
        this.chargeOnExpansion = c.get("Global.ChargeWhen.Expanding", Boolean.valueOf(true));
        c.addComment("Global.ChargeWhen.AreaAdd", new String[]{"Charges money on area addition"});
        this.chargeOnAreaAdd = c.get("Global.ChargeWhen.AreaAdd", Boolean.valueOf(true));
        c.addComment("Global.Type", new String[]{"Defaults to None which will start by looking to default economy engine throw vault API and if it fails to any supported economy engine", "Custom economy engines can be defined to access economy directly", "Supported variables: " + EconomyType.toStringLine()});
        this.VaultEconomy = EconomyType.getByName(c.get("Global.Type", "None"));
        if (this.VaultEconomy == null) {
            this.plugin.consoleMessage("&cCould not determine economy from " + c.get("Global.Type", "Vault"));
            this.plugin.consoleMessage("&cTrying to find suitable economy system");
            this.VaultEconomy = EconomyType.None;
        }
        c.addComment("Global.ExtraEnterMessage", new String[]{"When enabled extra message will appear in chat if residence is for rent or for sell to inform how he can rent/buy residence with basic information."});
        this.ExtraEnterMessage = c.get("Global.ExtraEnterMessage", Boolean.valueOf(true));
        c.addComment("Global.Sell.Subzone", new String[]{"If set to true, this will allow to sell subzones. Its recommended to keep it false tho"});
        this.SellSubzone = c.get("Global.Sell.Subzone", Boolean.valueOf(false));
        c.addComment("Global.EnableRentSystem", new String[]{"Enables or disables the Rent System"});
        this.enableRentSystem = c.get("Global.EnableRentSystem", Boolean.valueOf(true));
        c.addComment("Global.Rent.PreventRemoval", new String[]{"Prevents residence/subzone removal if its subzone is still rented by some one"});
        this.RentPreventRemoval = c.get("Global.Rent.PreventRemoval", Boolean.valueOf(true));
        c.addComment("Global.Rent.DeductFromBank", new String[]{"When set to true residence rent can be renewed from residence bank"});
        this.DeductFromBank = c.get("Global.Rent.DeductFromBank", Boolean.valueOf(false));
        c.addComment("Global.Rent.DeductFromBankThenPlayer", new String[]{"When set to true residence rent can be renewed from residence bank and if there is not enough money then we will deduct rest of it from player", "This will override behavior of DeductFromBank"});
        this.DeductFromBankThenPlayer = c.get("Global.Rent.DeductFromBankThenPlayer", Boolean.valueOf(false));
        c.addComment("Global.Rent.Inform.OnEnding", new String[]{"Informs players on rent time ending"});
        this.RentInformOnEnding = c.get("Global.Rent.Inform.OnEnding", Boolean.valueOf(true));
        c.addComment("Global.Rent.Inform.Before", new String[]{"Time range in minutes when to start informing about ending rent"});
        this.RentInformBefore = c.get("Global.Rent.Inform.Before", 1440);
        c.addComment("Global.Rent.Inform.Delay", new String[]{"Time range in seconds for how long to wait after player logs in to inform about ending rents"});
        this.RentInformDelay = c.get("Global.Rent.Inform.Delay", 60);
        c.addComment("Global.Rent.DefaultValues.AllowRenewing", new String[]{"Default values used when putting residence for rent"});
        this.RentAllowRenewing = c.get("Global.Rent.DefaultValues.AllowRenewing", Boolean.valueOf(true));
        this.RentStayInMarket = c.get("Global.Rent.DefaultValues.StayInMarket", Boolean.valueOf(true));
        this.RentAllowAutoPay = c.get("Global.Rent.DefaultValues.AllowAutoPay", Boolean.valueOf(true));
        c.addComment("Global.Rent.DefaultValues.PlayerAutoPay", new String[]{"If set to true, when player is not defining auto pay on renting, then this value will be used"});
        this.RentPlayerAutoPay = c.get("Global.Rent.DefaultValues.PlayerAutoPay", Boolean.valueOf(true));
        c.addComment("Global.Rent.Schematics.RestoreAfterRentEnds", new String[]{"EXPERIMENTAL!!! If set to true, residence will be restored to state it was when backup flag was set to true", "For securoty reassons only players with aditional residence.backup permission node can set backup flag"});
        this.RestoreAfterRentEnds = c.get("Global.Rent.Schematics.RestoreAfterRentEnds", Boolean.valueOf(true));
        c.addComment("Global.Rent.Schematics.SaveOnFlagChange", new String[]{"When set to true, area state will be saved only when setting backup to true value", "When set to false, area state will be saved before each renting to have always up to date area look", "Keep in mind that when its set to false, there is slightly bigger server load as it has to save area each time when some one rents it"});
        this.SchematicsSaveOnFlagChange = c.get("Global.Rent.Schematics.SaveOnFlagChange", Boolean.valueOf(true));
        c.addComment("Global.Bank.Capacity", new String[]{"Defines max amount residence bank can hold", "Setting to 0 will disable limitations"});
        this.BankCapacity = c.get("Global.Bank.Capacity", Double.valueOf(0.0));
        c.addComment("Global.RentCheckInterval", new String[]{"The interval, in minutes, between residence rent expiration checks (if the rent system is enabled)."});
        this.rentCheckInterval = c.get("Global.RentCheckInterval", 10);
        ELMessageType old = c.getC().isBoolean("Global.ActionBar.General") && c.getC().getBoolean("Global.ActionBar.General") ? ELMessageType.ActionBar : ELMessageType.ChatBox;
        old = c.getC().isBoolean("Global.TitleBar.EnterLeave") && c.getC().getBoolean("Global.TitleBar.EnterLeave") ? ELMessageType.TitleBar : old;
        c.addComment("Global.Messages.GeneralMessages", new String[]{"Defines where you want to send residence enter/leave/deny move and similar messages. Possible options: " + ELMessageType.getAllValuesAsString(), "TitleBar can have %subtitle% variable to define second line"});
        this.EnterLeaveMessageType = ELMessageType.getByName(c.get("Global.Messages.GeneralMessages", old.toString()));
        if (this.EnterLeaveMessageType == null || Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            this.EnterLeaveMessageType = ELMessageType.ChatBox;
        }
        this.ActionBarOnSelection = c.get("Global.ActionBar.ShowOnSelection", Boolean.valueOf(true));
        c.addComment("Global.ResidenceChatEnable", new String[]{"Enable or disable residence chat channels."});
        this.chatEnable = c.get("Global.ResidenceChatEnable", Boolean.valueOf(true));
        c.addComment("Global.ResidenceChatColor", new String[]{"Color of residence chat."});
        try {
            this.chatColor = CMIChatColor.getColor((String)c.get("Global.ResidenceChatColor", "DARK_PURPLE"));
        }
        catch (Exception ex) {
            this.chatColor = CMIChatColor.DARK_PURPLE;
        }
        if (this.chatColor == null) {
            CMIMessages.consoleMessage((String)"&cCan't find color by name for ResidenceChatColor");
            this.chatColor = CMIChatColor.DARK_PURPLE;
        }
        c.addComment("Global.ResidenceChatListening", new String[]{"When enabled players with access to chat flag will be able to listen to residence chat without joining it"});
        this.chatListening = c.get("Global.ResidenceChatListening", Boolean.valueOf(false));
        c.addComment("Global.ResidenceChatPrefixLength", new String[]{"Max lenght of residence chat prefix including color codes"});
        this.chatPrefixLength = c.get("Global.ResidenceChatPrefixLength", 16);
        c.addComment("Global.AdminOnlyCommands", new String[]{"Whether or not to ignore the usual Permission flags and only allow OPs and groups with 'residence.admin' to change residences."});
        this.adminsOnly = c.get("Global.AdminOnlyCommands", Boolean.valueOf(false));
        c.addComment("Global.AdminOPs", new String[]{"Setting this to true makes server OPs admins."});
        this.adminOps = c.get("Global.AdminOPs", Boolean.valueOf(true));
        c.addComment("Global.AdminFullAccess", new String[]{"Setting this to true server administration wont need to use /resadmin command to access admin command if they are op or have residence.admin permission node."});
        this.AdminFullAccess = c.get("Global.AdminFullAccess", Boolean.valueOf(false));
        c.addComment("Global.MultiWorldPlugin", new String[]{"This is the name of the plugin you use for multiworld, if you dont have a multiworld plugin you can safely ignore this.", "The only thing this does is check to make sure the multiworld plugin is enabled BEFORE Residence, to ensure properly loading residences for other worlds."});
        this.multiworldPlugin = c.get("Global.MultiWorldPlugin", "Multiverse-Core");
        c.addComment("Global.ResidenceFlagsInherit", new String[]{"Setting this to true causes subzones to inherit flags from their parent zones."});
        this.flagsInherit = c.get("Global.ResidenceFlagsInherit", Boolean.valueOf(true));
        c.addComment("Global.PreventRentModify", new String[]{"Setting this to false will allow rented residences to be modified by the renting player."});
        this.preventBuildInRent = c.get("Global.PreventRentModify", Boolean.valueOf(true));
        c.addComment("Global.PreventSubZoneRemoval", new String[]{"Setting this to true will prevent subzone deletion when subzone owner is not same as parent zone owner."});
        this.PreventSubZoneRemoval = c.get("Global.PreventSubZoneRemoval", Boolean.valueOf(true));
        c.addComment("Global.StopOnSaveFault", new String[]{"Setting this to false will cause residence to continue to load even if a error is detected in the save file."});
        this.stopOnSaveError = c.get("Global.StopOnSaveFault", Boolean.valueOf(true));
        c.addComment("This is the residence name filter, that filters out invalid characters.  Google 'Java RegEx' or 'Java Regular Expressions' for more info on how they work.", new String[0]);
        this.namefix = c.get("Global.ResidenceNameRegex", "[^a-zA-Z0-9\\-\\_]");
        c.addComment("Global.ShowIntervalMessages", new String[]{"Setting this to true sends a message to the console every time Residence does a rent expire check or a lease expire check."});
        this.showIntervalMessages = c.get("Global.ShowIntervalMessages", Boolean.valueOf(false));
        c.addComment("Global.ShowNoobMessage", new String[]{"Setting this to true sends a tutorial message to the new player when he places chest on ground."});
        this.ShowNoobMessage = c.get("Global.ShowNoobMessage", Boolean.valueOf(true));
        c.addComment("Global.NewPlayer", new String[]{"Setting this to true creates residence around players placed chest if he don't have any.", "Only once every server restart if he still don't have any residence"});
        this.NewPlayerUse = c.get("Global.NewPlayer.Use", Boolean.valueOf(false));
        c.addComment("Global.NewPlayer.Free", new String[]{"Setting this to true, residence will be created for free", "By setting to false, money will be taken from player, if he has them"});
        this.NewPlayerFree = c.get("Global.NewPlayer.Free", Boolean.valueOf(true));
        c.addComment("Global.NewPlayer.Range", new String[]{"Range from placed chest to both sides. By setting to 5, residence will be 5+5+1 = 11 blocks wide in total"});
        this.NewPlayerRangeX = c.get("Global.NewPlayer.Range.X", 5);
        this.NewPlayerRangeY = c.get("Global.NewPlayer.Range.Y", 5);
        this.NewPlayerRangeZ = c.get("Global.NewPlayer.Range.Z", 5);
        c.addComment("Global.CustomContainers", new String[]{"Experimental - The following settings are lists of block IDs to be used as part of the checks for the 'container' and 'use' flags when using mods."});
        List pls = c.get("Global.CustomContainers", new ArrayList());
        for (Object one : pls) {
            CMIMaterial mat = CMIMaterial.get((String)String.valueOf(one));
            if (mat == CMIMaterial.NONE) continue;
            this.customContainers.add(mat);
        }
        pls = c.get("Global.CustomBothClick", new ArrayList());
        for (Object one : pls) {
            CMIMaterial mat = CMIMaterial.get((String)String.valueOf(one));
            if (mat == CMIMaterial.NONE) continue;
            this.customBothClick.add(mat);
        }
        pls = c.get("Global.CustomRightClick", new ArrayList());
        for (Object one : pls) {
            CMIMaterial mat = CMIMaterial.get((String)String.valueOf(one));
            if (mat == CMIMaterial.NONE) continue;
            this.customRightClick.add(mat);
        }
        c.addComment("Global.Visualizer.Use", new String[]{"With this enabled player will see particle effects to mark selection boundaries"});
        this.useVisualizer = c.get("Global.Visualizer.Use", Boolean.valueOf(true));
        c.addComment("Global.Visualizer.Range", new String[]{"Range in blocks to draw particle effects for player", "Keep it no more as 30, as player cant see more than 16 blocks"});
        this.VisualizerRange = c.get("Global.Visualizer.Range", 16);
        c.addComment("Global.Visualizer.ShowFor", new String[]{"For how long in miliseconds (5000 = 5sec) to show particle effects"});
        this.VisualizerShowFor = c.get("Global.Visualizer.ShowFor", 5000);
        c.addComment("Global.Visualizer.updateInterval", new String[]{"How often in ticks to update particles for player"});
        this.VisualizerUpdateInterval = c.get("Global.Visualizer.updateInterval", 20);
        c.addComment("Global.Visualizer.RowSpacing", new String[]{"Spacing in blocks between particle effects for rows"});
        this.VisualizerRowSpacing = c.get("Global.Visualizer.RowSpacing", 1);
        if (this.VisualizerRowSpacing < 1) {
            this.VisualizerRowSpacing = 1;
        }
        c.addComment("Global.Visualizer.CollumnSpacing", new String[]{"Spacing in blocks between particle effects for collums"});
        this.VisualizerCollumnSpacing = c.get("Global.Visualizer.CollumnSpacing", 1);
        if (this.VisualizerCollumnSpacing < 1) {
            this.VisualizerCollumnSpacing = 1;
        }
        c.addComment("Global.Visualizer.SkipBy", new String[]{"Defines by how many particles we need to skip", "This will create moving particle effect and will improve overall look of selection", "By increasing this number, you can decrease update interval"});
        this.VisualizerSkipBy = c.get("Global.Visualizer.SkipBy", 2);
        if (this.VisualizerSkipBy < 1) {
            this.VisualizerSkipBy = 1;
        }
        c.addComment("Global.Visualizer.FrameCap", new String[]{"Maximum amount of frame particles to show for one player"});
        this.VisualizerFrameCap = c.get("Global.Visualizer.FrameCap", 500);
        if (this.VisualizerFrameCap < 1) {
            this.VisualizerFrameCap = 1;
        }
        c.addComment("Global.Visualizer.SidesCap", new String[]{"Maximum amount of sides particles to show for one player"});
        this.VisualizerSidesCap = c.get("Global.Visualizer.SidesCap", 2000);
        if (this.VisualizerSidesCap < 1) {
            this.VisualizerSidesCap = 1;
        }
        StringBuilder effectsList = new StringBuilder();
        Effect[] CenterX2 = Effect.values();
        MinCoord = CenterX2.length;
        int mat = 0;
        while (mat < MinCoord) {
            Effect one = CenterX2[mat];
            if (one != null && one.name() != null) {
                if (!effectsList.toString().isEmpty()) {
                    effectsList.append(", ");
                }
                effectsList.append(one.name().toLowerCase());
            }
            ++mat;
        }
        c.addComment("Global.Visualizer.Selected", new String[]{"Particle effect names. possible: explode, largeexplode, hugeexplosion, fireworksSpark, splash, wake, crit, magicCrit", " smoke, largesmoke, spell, instantSpell, mobSpell, mobSpellAmbient, witchMagic, dripWater, dripLava, angryVillager, happyVillager, townaura", " note, portal, enchantmenttable, flame, lava, footstep, cloud, reddust, snowballpoof, snowshovel, slime, heart, barrier", " droplet, take, mobappearance", "", "If using spigot based server different particles can be used:", effectsList.toString()});
        String efname = c.get("Global.Visualizer.Selected.Frame", "happyVillager");
        this.SelectedFrame = CMIEffectManager.CMIParticle.getCMIParticle((String)efname);
        if (this.SelectedFrame == null) {
            this.SelectedFrame = CMIEffectManager.CMIParticle.HAPPY_VILLAGER;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Selected Frame with this name, it was set to default");
        }
        efname = c.get("Global.Visualizer.Selected.Sides", "reddust");
        this.SelectedSides = CMIEffectManager.CMIParticle.getCMIParticle((String)efname);
        if (this.SelectedSides == null) {
            this.SelectedSides = CMIEffectManager.CMIParticle.COLOURED_DUST;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Selected Sides with this name, it was set to default");
        }
        efname = c.get("Global.Visualizer.Overlap.Frame", "FLAME");
        this.OverlapFrame = CMIEffectManager.CMIParticle.getCMIParticle((String)efname);
        if (this.OverlapFrame == null) {
            this.OverlapFrame = CMIEffectManager.CMIParticle.FLAME;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Overlap Frame with this name, it was set to default");
        }
        efname = c.get("Global.Visualizer.Overlap.Sides", "FLAME");
        this.OverlapSides = CMIEffectManager.CMIParticle.getCMIParticle((String)efname);
        if (this.OverlapSides == null) {
            this.OverlapSides = CMIEffectManager.CMIParticle.FLAME;
            Bukkit.getConsoleSender().sendMessage("Can't find effect for Selected Sides with this name, it was set to default");
        }
        c.addComment("Global.Visualizer.EnterAnimation", new String[]{"Shows particle effect when player enters residence. Only applies to main residence area"});
        this.EnterAnimation = c.get("Global.Visualizer.EnterAnimation", Boolean.valueOf(true));
        c.addComment("Global.BounceAnimation", new String[]{"Shows particle effect when player are being pushed back"});
        this.BounceAnimation = c.get("Global.BounceAnimation", Boolean.valueOf(true));
        c.addComment("Global.GUI.Enabled", new String[]{"Enable or disable flag GUI"});
        this.useFlagGUI = c.get("Global.GUI.Enabled", Boolean.valueOf(true));
        c.addComment("Global.GUI.setTrue", new String[]{"Item id and data to use when flag is set to true"});
        CMIMaterial Mat = CMIMaterial.get((String)c.get("Global.GUI.setTrue", "GREEN_WOOL"));
        if (Mat == null) {
            Mat = CMIMaterial.GREEN_WOOL;
        }
        this.guiBottonStates.put(FlagPermissions.FlagState.TRUE, Mat.newItemStack());
        c.addComment("Global.GUI.setFalse", new String[]{"Item id and data to use when flag is set to false"});
        Mat = CMIMaterial.get((String)c.get("Global.GUI.setFalse", "RED_WOOL"));
        if (Mat == null) {
            Mat = CMIMaterial.RED_WOOL;
        }
        this.guiBottonStates.put(FlagPermissions.FlagState.FALSE, Mat.newItemStack());
        c.addComment("Global.GUI.setRemove", new String[]{"Item id and data to use when flag is set to remove"});
        Mat = CMIMaterial.get((String)c.get("Global.GUI.setRemove", "LIGHT_GRAY_WOOL"));
        if (Mat == null) {
            Mat = CMIMaterial.LIGHT_GRAY_WOOL;
        }
        this.guiBottonStates.put(FlagPermissions.FlagState.NEITHER, Mat.newItemStack());
        c.addComment("Global.AutoMobRemoval", new String[]{"Default = false. Enabling this, residences with flag nomobs will be cleared from monsters in regular intervals.", "This is quite heavy on server side, so enable only if you really need this feature"});
        this.AutoMobRemoval = c.get("Global.AutoMobRemoval.Use", Boolean.valueOf(false));
        c.addComment("Global.AutoMobRemoval.Interval", new String[]{"How often in seconds to check for monsters in residences. Keep it at reasonable amount"});
        this.AutoMobRemovalInterval = c.get("Global.AutoMobRemoval.Interval", 5);
        this.enforceAreaInsideArea = c.get("Global.EnforceAreaInsideArea", Boolean.valueOf(false));
        this.spoutEnable = c.get("Global.EnableSpout", Boolean.valueOf(false));
        this.enableLeaseMoneyAccount = c.get("Global.EnableLeaseMoneyAccount", Boolean.valueOf(true));
        c.addComment("Global.Couldroncompatibility", new String[]{"By setting this to true, partial compatibility for kCouldron servers will be enabled. Action bar messages and selection visualizer will be disabled automatically as off incorrect compatibility"});
        this.Couldroncompatibility = c.get("Global.Couldroncompatibility", Boolean.valueOf(false));
        if (this.Couldroncompatibility) {
            this.useVisualizer = false;
            this.EnterLeaveMessageType = ELMessageType.ChatBox;
            this.ActionBarOnSelection = false;
        }
        c.addComment("DynMap.Use", new String[]{"Enables or disable DynMap Support"});
        this.DynMapUse = c.get("DynMap.Use", Boolean.valueOf(false));
        c.addComment("DynMap.HideByDefault", new String[]{"When set to true we will hide residence areas by default on dynmap window", "Residences can still be enabled throw provided DynMap option on left top side"});
        this.DynMapHideByDefault = c.get("DynMap.HideByDefault", Boolean.valueOf(false));
        c.addComment("DynMap.ShowFlags", new String[]{"Shows or hides residence flags"});
        this.DynMapShowFlags = c.get("DynMap.ShowFlags", Boolean.valueOf(true));
        c.addComment("DynMap.ExcludeDefaultFlags", new String[]{"When enabled default flags will not be included in residence overview"});
        this.DynMapExcludeDefaultFlags = c.get("DynMap.ExcludeDefaultFlags", Boolean.valueOf(true));
        c.addComment("DynMap.HideHidden", new String[]{"If set true, residence with hidden flag set to true will be hidden from dynmap"});
        this.DynMapHideHidden = c.get("DynMap.HideHidden", Boolean.valueOf(true));
        c.addComment("DynMap.Layer.3dRegions", new String[]{"Enables 3D zones"});
        this.DynMapLayer3dRegions = c.get("DynMap.Layer.3dRegions", Boolean.valueOf(true));
        c.addComment("DynMap.Layer.SubZoneDepth", new String[]{"How deep to go into subzones to show"});
        this.DynMapLayerSubZoneDepth = c.get("DynMap.Layer.SubZoneDepth", 2);
        c.addComment("DynMap.Border.Color", new String[]{"Color of border. Pick color from this page http://www.w3schools.com/colors/colors_picker.asp"});
        this.DynMapBorderColor = c.get("DynMap.Border.Color", "#FF0000");
        c.addComment("DynMap.Border.Opacity", new String[]{"Transparency. 0.3 means that only 30% of color will be visible"});
        this.DynMapBorderOpacity = c.get("DynMap.Border.Opacity", Double.valueOf(0.3));
        c.addComment("DynMap.Border.Weight", new String[]{"Border thickness"});
        this.DynMapBorderWeight = c.get("DynMap.Border.Weight", 3);
        this.DynMapFillOpacity = c.get("DynMap.Fill.Opacity", Double.valueOf(0.3));
        this.DynMapFillColor = c.get("DynMap.Fill.Color", "#FFFF00");
        this.DynMapFillForRent = c.get("DynMap.Fill.ForRent", "#33cc33");
        this.DynMapFillRented = c.get("DynMap.Fill.Rented", "#99ff33");
        this.DynMapFillForSale = c.get("DynMap.Fill.ForSale", "#0066ff");
        c.addComment("DynMap.VisibleRegions", new String[]{"Shows only regions on this list"});
        this.DynMapVisibleRegions = c.get("DynMap.VisibleRegions", new ArrayList());
        c.addComment("DynMap.HiddenRegions", new String[]{"Hides region on map even if its not hidden in game"});
        this.DynMapHiddenRegions = c.get("DynMap.HiddenRegions", new ArrayList());
        c.addComment("Pl3xMap.Use", new String[]{"Enables or disable Pl3xMap Support"});
        this.Pl3xMapUse = c.get("Pl3xMap.Use", Boolean.valueOf(false));
        c.addComment("Pl3xMap.HideByDefault", new String[]{"When set to true we will hide residence areas by default on Pl3xMap window", "Residences can still be enabled throw provided Pl3xMap option on left top side"});
        this.Pl3xMapHideByDefault = c.get("Pl3xMap.HideByDefault", Boolean.valueOf(false));
        c.addComment("Pl3xMap.ShowFlags", new String[]{"Shows or hides residence flags"});
        this.Pl3xMapShowFlags = c.get("Pl3xMap.ShowFlags", Boolean.valueOf(true));
        c.addComment("Pl3xMap.ExcludeDefaultFlags", new String[]{"When enabled default flags will not be included in residence overview"});
        this.Pl3xMapExcludeDefaultFlags = c.get("Pl3xMap.ExcludeDefaultFlags", Boolean.valueOf(true));
        c.addComment("Pl3xMap.HideHidden", new String[]{"If set true, residence with hidden flag set to true will be hidden from Pl3xMap"});
        this.Pl3xMapHideHidden = c.get("Pl3xMap.HideHidden", Boolean.valueOf(true));
        c.addComment("Pl3xMap.Layer.SubZoneDepth", new String[]{"How deep to go into subzones to show"});
        this.Pl3xMapLayerSubZoneDepth = c.get("Pl3xMap.Layer.SubZoneDepth", 2);
        c.addComment("Pl3xMap.Border.Color", new String[]{"Color of border. Pick color from this page http://www.w3schools.com/colors/colors_picker.asp"});
        Color Pl3xFill = this.processColor(c.get("Pl3xMap.Border.Color", "#FF0000"));
        c.addComment("Pl3xMap.Border.Opacity", new String[]{"Transparency. 0.3 means that only 30% of color will be visible"});
        Double Pl3xMapBorderOpacity = c.get("Pl3xMap.Border.Opacity", Double.valueOf(0.3));
        this.Pl3xFillColor = ConfigManager.argb(CMINumber.clamp((int)((int)(Pl3xMapBorderOpacity * 255.0)), (int)0, (int)255), Pl3xFill);
        c.addComment("Pl3xMap.Border.Weight", new String[]{"Border thickness"});
        this.Pl3xMapBorderWeight = c.get("Pl3xMap.Border.Weight", 3);
        Double Pl3xMapFillOpacity = c.get("Pl3xMap.Fill.Opacity", Double.valueOf(0.3));
        Color Pl3xMapFillColor = this.processColor(c.get("Pl3xMap.Fill.Color", "#FF0000"));
        this.Pl3xBorderColor = ConfigManager.argb(CMINumber.clamp((int)((int)(Pl3xMapFillOpacity * 255.0)), (int)0, (int)255), Pl3xMapFillColor);
        this.Pl3xMapFillForRent = ConfigManager.argb(CMINumber.clamp((int)((int)(Pl3xMapFillOpacity * 255.0)), (int)0, (int)255), this.processColor(c.get("Pl3xMap.Fill.ForRent", "#33cc33")));
        this.Pl3xMapFillRented = ConfigManager.argb(CMINumber.clamp((int)((int)(Pl3xMapFillOpacity * 255.0)), (int)0, (int)255), this.processColor(c.get("Pl3xMap.Fill.Rented", "#99ff33")));
        this.Pl3xMapFillForSale = ConfigManager.argb(CMINumber.clamp((int)((int)(Pl3xMapFillOpacity * 255.0)), (int)0, (int)255), this.processColor(c.get("Pl3xMap.Fill.ForSale", "#0066ff")));
        c.addComment("Pl3xMap.VisibleRegions", new String[]{"Shows only regions on this list"});
        this.Pl3xMapVisibleRegions = c.get("Pl3xMap.VisibleRegions", new ArrayList());
        c.addComment("Pl3xMap.HiddenRegions", new String[]{"Hides region on map even if its not hidden in game"});
        this.Pl3xMapHiddenRegions = c.get("Pl3xMap.HiddenRegions", new ArrayList());
        c.addComment("Raid", new String[]{"In development"});
        c.addComment("Raid.Enabled", new String[]{"Determines if you want to enable raid feature for your server", "When residence is under raid, attackers can move inside residence even if residence has move false flag"});
        RaidEnabled = c.get("Raid.Enabled", Boolean.valueOf(false));
        c.addComment("Raid.PreTimer", new String[]{"Time in seconds before raid starts", "This will allow defenders to get back to residence and prepare for attack"});
        PreRaidTimer = c.get("Raid.PreTimer", 120);
        c.addComment("Raid.Timer", new String[]{"Time in seconds raid should be", "During this time attackers can steal and kill defenders"});
        RaidTimer = c.get("Raid.Timer", 120);
        c.addComment("Raid.Cooldown", new String[]{"Time in seconds residence is immune for next raid", "Default is 79200 seconds which results into 22 hours, this might reset if you have server restart"});
        RaidCooldown = c.get("Raid.Cooldown", 79200);
        c.addComment("Raid.PlayerCooldown", new String[]{"Time in seconds player is immune for next raid", "In case player has more than one residence, this can prevent player from being attacked again", "Default is 79200 seconds which results into 22 hours, this might reset if you have server restart"});
        RaidPlayerCooldown = c.get("Raid.PlayerCooldown", 79200);
        c.addComment("Raid.Allow.Attacker.blockBreak", new String[]{"Allows to break blocks inside raided residence even if it has destroy false", "This only applies for attackers and for raid time"});
        RaidAttackerBlockBreak = c.get("Raid.Allow.Attacker.blockBreak", Boolean.valueOf(true));
        c.addComment("Raid.Allow.Attacker.blockPlace", new String[]{"Allows to place blocks inside raided residence even if it has place false", "This only applies for attackers and for raid time"});
        RaidAttackerBlockPlace = c.get("Raid.Allow.Attacker.blockPlace", Boolean.valueOf(true));
        c.addComment("Raid.Allow.Defender.blockBreak", new String[]{"Allows to break blocks inside raided residence even if it has destroy false", "This only applies for defenders and for raid time"});
        RaidDefenderBlockBreak = c.get("Raid.Allow.Defender.blockBreak", Boolean.valueOf(true));
        c.addComment("Raid.Allow.Defender.blockPlace", new String[]{"Allows to place blocks inside raided residence even if it has place false", "This only applies for defenders and for raid time"});
        RaidDefenderBlockPlace = c.get("Raid.Allow.Defender.blockPlace", Boolean.valueOf(true));
        c.addComment("Raid.Allow.Defender.Teleport", new String[]{"Allows to teleport into raided residence, includes /res tp and other 3rd party teleport commands", "This only applies for defenders and for raid time", "keep in mind that attackers will not have this option and will be prevented from teleporting inside raided residence"});
        RaidDefenderTeleport = c.get("Raid.Allow.Defender.Teleport", Boolean.valueOf(false));
        c.addComment("Raid.Allow.Defender.containerUsage", new String[]{"Allows to use containers, such as chests, during raid time", "This only applies for defenders and for raid time", "Keeping this at false might prevent from players moving their items to another residence which is not in raid", "Attackers will have access to any container in your residence during raid"});
        RaidDefenderContainerUsage = c.get("Raid.Allow.Defender.containerUsage", Boolean.valueOf(false));
        c.addComment("Raid.FriendlyFire", new String[]{"When set to false players in same teams (attackers or defenders) will not cause each other damage"});
        RaidFriendlyFire = c.get("Raid.FriendlyFire", Boolean.valueOf(true));
        c.save();
    }

    private Color processColor(String cls) {
        try {
            CMIChatColor col;
            if (cls.startsWith("#")) {
                cls = cls.substring(1);
                cls = "{#" + cls + "}";
            }
            if ((col = CMIChatColor.getColor((String)cls)) != null && col.getJavaColor() != null) {
                return col.getJavaColor();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Color(125, 125, 125);
    }

    public void loadFlags() {
        YamlConfiguration flags2 = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "flags.yml"));
        if (flags2.isList("Global.TotalFlagDisabling")) {
            List globalDisable = flags2.getStringList("Global.TotalFlagDisabling");
            Flags[] flagsArray = Flags.values();
            int n = flagsArray.length;
            int n2 = 0;
            while (n2 < n) {
                Flags one = flagsArray[n2];
                one.setGlobalyEnabled(true);
                ++n2;
            }
            for (String fl : globalDisable) {
                Flags flag = Flags.getFlag(fl);
                if (flag == null) continue;
                flag.setGlobalyEnabled(false);
            }
        }
        this.globalCreatorDefaults = FlagPermissions.parseFromConfigNode("CreatorDefault", flags2.getConfigurationSection("Global"));
        this.globalRentedDefaults = FlagPermissions.parseFromConfigNode("RentedDefault", flags2.getConfigurationSection("Global"));
        this.globalResidenceDefaults = FlagPermissions.parseFromConfigNode("ResidenceDefault", flags2.getConfigurationSection("Global"));
        this.loadGroups();
    }

    public void loadGroups() {
        Set keys;
        YamlConfiguration groups = YamlConfiguration.loadConfiguration((File)new File(this.plugin.dataFolder, "groups.yml"));
        ConfigurationSection node = groups.getConfigurationSection("Global.GroupDefault");
        if (node != null && (keys = node.getConfigurationSection(this.defaultGroup).getKeys(false)) != null) {
            for (String key : keys) {
                this.globalGroupDefaults.put(key, FlagPermissions.parseFromConfigNodeAsList(this.defaultGroup, "false"));
            }
        }
    }

    public World getWorld(String name) {
        name = name.replace("_", "").replace(".", "");
        for (World one : Bukkit.getWorlds()) {
            if (!one.getName().replace("_", "").replace(".", "").equalsIgnoreCase(name)) continue;
            return one;
        }
        return null;
    }

    public boolean isGlobalChatEnabled() {
        return this.GlobalChatEnabled;
    }

    public boolean isGlobalChatSelfModify() {
        return this.GlobalChatSelfModify;
    }

    public String getGlobalChatFormat() {
        return this.GlobalChatFormat;
    }

    public int getRentInformDelay() {
        return this.RentInformDelay;
    }

    public int getRentInformBefore() {
        return this.RentInformBefore;
    }

    public boolean isRentAllowAutoPay() {
        return this.RentAllowAutoPay;
    }

    public boolean isRentPlayerAutoPay() {
        return this.RentPlayerAutoPay;
    }

    public boolean isRentStayInMarket() {
        return this.RentStayInMarket;
    }

    public boolean isSellSubzone() {
        return this.SellSubzone;
    }

    public boolean isRentAllowRenewing() {
        return this.RentAllowRenewing;
    }

    public boolean isRentPreventRemoval() {
        return this.RentPreventRemoval;
    }

    public boolean isRentInformOnEnding() {
        return this.RentInformOnEnding;
    }

    public boolean isTNTExplodeBelow() {
        return this.TNTExplodeBelow;
    }

    public int getTNTExplodeBelowLevel() {
        return this.TNTExplodeBelowLevel;
    }

    public boolean isCreeperExplodeBelow() {
        return this.CreeperExplodeBelow;
    }

    public int getCreeperExplodeBelowLevel() {
        return this.CreeperExplodeBelowLevel;
    }

    public boolean useVisualizer() {
        return this.useVisualizer;
    }

    public int getVisualizerRange() {
        return this.VisualizerRange;
    }

    public int getVisualizerShowFor() {
        return this.VisualizerShowFor;
    }

    public int getNewPlayerRangeX() {
        return this.NewPlayerRangeX;
    }

    public int getNewPlayerRangeY() {
        return this.NewPlayerRangeY;
    }

    public int getNewPlayerRangeZ() {
        return this.NewPlayerRangeZ;
    }

    public int getVisualizerRowSpacing() {
        return this.VisualizerRowSpacing;
    }

    public int getVisualizerCollumnSpacing() {
        return this.VisualizerCollumnSpacing;
    }

    public int getVisualizerSkipBy() {
        return this.VisualizerSkipBy;
    }

    public int getVisualizerUpdateInterval() {
        return this.VisualizerUpdateInterval;
    }

    public CMIEffectManager.CMIParticle getSelectedFrame() {
        return this.SelectedFrame;
    }

    public CMIEffectManager.CMIParticle getSelectedSides() {
        return this.SelectedSides;
    }

    public CMIEffectManager.CMIParticle getOverlapFrame() {
        return this.OverlapFrame;
    }

    public CMIEffectManager.CMIParticle getOverlapSides() {
        return this.OverlapSides;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getSelectedSpigotFrame() {
        return this.SelectedFrame;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getSelectedSpigotSides() {
        return this.SelectedSides;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getOverlapSpigotFrame() {
        return this.OverlapFrame;
    }

    @Deprecated
    public CMIEffectManager.CMIParticle getOverlapSpigotSides() {
        return this.OverlapSides;
    }

    public int getTeleportDelay() {
        return this.TeleportDelay;
    }

    public boolean isTeleportTitleMessage() {
        return this.TeleportTitleMessage;
    }

    public String getDefaultGroup() {
        return this.defaultGroup;
    }

    public String getResidenceNameRegex() {
        return this.namefix;
    }

    public boolean isExtraEnterMessage() {
        return this.ExtraEnterMessage;
    }

    public boolean enableEconomy() {
        return this.enableEconomy && this.plugin.getEconomyManager() != null;
    }

    public boolean enabledRentSystem() {
        return this.enableRentSystem && this.enableEconomy();
    }

    public boolean useLeases() {
        return this.useLeases;
    }

    public boolean useResMoneyBack() {
        return this.ResMoneyBack;
    }

    public boolean allowAdminsOnly() {
        return this.adminsOnly;
    }

    public boolean allowEmptyResidences() {
        return this.allowEmptyResidences;
    }

    public boolean isNoLava() {
        return this.NoLava;
    }

    public boolean isNoWater() {
        return this.NoWater;
    }

    public boolean isNoLavaPlace() {
        return this.NoLavaPlace;
    }

    public boolean isBlockFall() {
        return this.useBlockFall;
    }

    public boolean isNoWaterPlace() {
        return this.NoWaterPlace;
    }

    public List<Material> getLwcMatList() {
        return this.LwcMatList;
    }

    public boolean isRemoveLwcOnUnrent() {
        return this.LwcOnUnrent;
    }

    public boolean isRemoveLwcOnBuy() {
        return this.LwcOnBuy;
    }

    public boolean isRemoveLwcOnDelete() {
        return this.LwcOnDelete;
    }

    public boolean isUseResidenceFileClean() {
        return this.AutoCleanUp;
    }

    public int getResidenceFileCleanDays() {
        return this.AutoCleanUpDays;
    }

    public boolean isAutoCleanUpRegenerate() {
        return this.AutoCleanUpRegenerate;
    }

    public boolean isUseClean() {
        return this.UseClean;
    }

    public boolean isPvPFlagPrevent() {
        return this.PvPFlagPrevent;
    }

    public boolean isOverridePvp() {
        return this.OverridePvp;
    }

    public boolean isBlockAnyTeleportation() {
        return this.BlockAnyTeleportation;
    }

    @Deprecated
    public int getInfoToolID() {
        return this.infoTool.getId();
    }

    public CMIMaterial getInfoTool() {
        return this.infoTool;
    }

    public CMIMaterial getSelectionTool() {
        return this.selectionTool;
    }

    @Deprecated
    public int getSelectionTooldID() {
        return this.selectionTool.getId();
    }

    public boolean getOpsAreAdmins() {
        return this.adminOps;
    }

    public boolean getAdminFullAccess() {
        return this.AdminFullAccess;
    }

    public String getMultiworldPlugin() {
        return this.multiworldPlugin;
    }

    public boolean autoRenewLeases() {
        return this.leaseAutoRenew;
    }

    public boolean isShortInfoUse() {
        return this.ShortInfoUse;
    }

    public boolean isOnlyLike() {
        return this.OnlyLike;
    }

    public int getRentCheckInterval() {
        return this.rentCheckInterval;
    }

    public int getChatPrefixLength() {
        return this.chatPrefixLength;
    }

    public int getLeaseCheckInterval() {
        return this.leaseCheckInterval;
    }

    public int getAutoSaveInterval() {
        return this.autoSaveInt;
    }

    public boolean isNewSaveMechanic() {
        return this.NewSaveMechanic;
    }

    public boolean BackupAutoCleanUpUse() {
        return this.BackupAutoCleanUpUse;
    }

    public int BackupAutoCleanUpDays() {
        return this.BackupAutoCleanUpDays;
    }

    public boolean UseZipBackup() {
        return this.UseZipBackup;
    }

    public boolean BackupWorldFiles() {
        return this.BackupWorldFiles;
    }

    public boolean BackupforsaleFile() {
        return this.BackupforsaleFile;
    }

    public boolean BackupleasesFile() {
        return this.BackupleasesFile;
    }

    public boolean BackuppermlistsFile() {
        return this.BackuppermlistsFile;
    }

    public boolean BackuprentFile() {
        return this.BackuprentFile;
    }

    public boolean BackupflagsFile() {
        return this.BackupflagsFile;
    }

    public boolean BackupgroupsFile() {
        return this.BackupgroupsFile;
    }

    public boolean BackupconfigFile() {
        return this.BackupconfigFile;
    }

    public int getFlowLevel() {
        return this.FlowLevel;
    }

    public int getPlaceLevel() {
        return this.PlaceLevel;
    }

    public int getBlockFallLevel() {
        return this.BlockFallLevel;
    }

    public int getCleanLevel() {
        return this.CleanLevel;
    }

    public boolean flagsInherit() {
        return this.flagsInherit;
    }

    public boolean isIgnoreGroupedFlagAcess() {
        return this.ignoreGroupedFlagAcess;
    }

    public boolean chatEnabled() {
        return this.chatEnable;
    }

    public boolean useActionBarOnSelection() {
        return this.ActionBarOnSelection;
    }

    public CMIChatColor getChatColor() {
        return this.chatColor;
    }

    public int getMinMoveUpdateInterval() {
        return this.minMoveUpdate;
    }

    public int getVoteRangeFrom() {
        return this.VoteRangeFrom;
    }

    public int getHealInterval() {
        return this.HealInterval;
    }

    public int getFeedInterval() {
        return this.FeedInterval;
    }

    public int getSafeZoneInterval() {
        return this.SafeZoneInterval;
    }

    public int getVoteRangeTo() {
        return this.VoteRangeTo;
    }

    public FlagPermissions getGlobalCreatorDefaultFlags() {
        return this.globalCreatorDefaults;
    }

    public FlagPermissions getGlobalRentedDefaultFlags() {
        return this.globalRentedDefaults;
    }

    public FlagPermissions getGlobalResidenceDefaultFlags() {
        return this.globalResidenceDefaults;
    }

    public Map<String, FlagPermissions> getGlobalGroupDefaultFlags() {
        return this.globalGroupDefaults;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDefaultWorld() {
        return this.DefaultWorld;
    }

    public String getDateFormat() {
        return this.DateFormat;
    }

    public String getDateFormatShort() {
        return this.DateFormatShort;
    }

    public String getTimeZone() {
        return this.TimeZone;
    }

    public boolean preventRentModify() {
        return this.preventBuildInRent;
    }

    public boolean isPreventSubZoneRemoval() {
        return this.PreventSubZoneRemoval;
    }

    public boolean stopOnSaveError() {
        return this.stopOnSaveError;
    }

    public boolean showIntervalMessages() {
        return this.showIntervalMessages;
    }

    public boolean ShowNoobMessage() {
        return this.ShowNoobMessage;
    }

    public boolean isNewPlayerUse() {
        return this.NewPlayerUse;
    }

    public boolean isNewPlayerFree() {
        return this.NewPlayerFree;
    }

    public boolean enableSpout() {
        return this.spoutEnable;
    }

    public boolean AutoMobRemoval() {
        return this.AutoMobRemoval;
    }

    public int AutoMobRemovalInterval() {
        return this.AutoMobRemovalInterval;
    }

    public boolean enableLeaseMoneyAccount() {
        return this.enableLeaseMoneyAccount;
    }

    public boolean CouldronCompatibility() {
        return this.Couldroncompatibility;
    }

    public boolean debugEnabled() {
        return this.enableDebug;
    }

    public boolean isSelectionIgnoreY() {
        return this.SelectionIgnoreY;
    }

    public boolean isSelectionIgnoreYInSubzone() {
        return this.SelectionIgnoreYInSubzone;
    }

    public boolean isNoCostForYBlocks() {
        return this.NoCostForYBlocks;
    }

    public boolean versionCheck() {
        return this.versionCheck;
    }

    public boolean isUUIDConvertion() {
        return this.UUIDConvertion;
    }

    public boolean isOfflineMode() {
        return this.OfflineMode;
    }

    public List<CMIMaterial> getCustomContainers() {
        return this.customContainers;
    }

    public List<CMIMaterial> getCustomBothClick() {
        return this.customBothClick;
    }

    public List<CMIMaterial> getCustomRightClick() {
        return this.customRightClick;
    }

    public List<Material> getCleanBlocks() {
        return this.CleanBlocks;
    }

    public List<String> getNoFlowWorlds() {
        return this.NoFlowWorlds;
    }

    public List<String> getAutoCleanUpWorlds() {
        return this.AutoCleanUpWorlds;
    }

    public List<String> getNoPlaceWorlds() {
        return this.NoPlaceWorlds;
    }

    public List<String> getBlockFallWorlds() {
        return this.BlockFallWorlds;
    }

    public List<String> getNegativePotionEffects() {
        return this.NegativePotionEffects;
    }

    public List<String> getNegativeLingeringPotionEffects() {
        return this.NegativeLingeringPotionEffects;
    }

    public List<String> getCleanWorlds() {
        return this.CleanWorlds;
    }

    public List<String> getProtectedFlagsList() {
        return this.FlagsList;
    }

    public boolean getEnforceAreaInsideArea() {
        return this.enforceAreaInsideArea;
    }

    public List<RandomTeleport> getRandomTeleport() {
        return this.RTeleport;
    }

    public int getrtCooldown() {
        return this.rtCooldown;
    }

    public Location getKickLocation() {
        return this.KickLocation;
    }

    public Location getFlyLandLocation() {
        return this.FlyLandLocation;
    }

    public int getrtMaxTries() {
        return this.rtMaxTries;
    }

    public boolean useFlagGUI() {
        return this.useFlagGUI;
    }

    public boolean BounceAnimation() {
        return this.BounceAnimation;
    }

    public int getVisualizerFrameCap() {
        return this.VisualizerFrameCap;
    }

    public int getVisualizerSidesCap() {
        return this.VisualizerSidesCap;
    }

    public Double getWalkSpeed1() {
        return this.WalkSpeed1;
    }

    public Double getWalkSpeed2() {
        return this.WalkSpeed2;
    }

    public int getItemPickUpDelay() {
        return this.ItemPickUpDelay;
    }

    public boolean isConsoleLogsShowFlagChanges() {
        return this.ConsoleLogsShowFlagChanges;
    }

    public EconomyType getEconomyType() {
        return this.VaultEconomy;
    }

    public boolean isCanTeleportIncludeOwner() {
        return this.CanTeleportIncludeOwner;
    }

    public ELMessageType getEnterLeaveMessageType() {
        return this.EnterLeaveMessageType;
    }

    public boolean isEnterAnimation() {
        return this.EnterAnimation;
    }

    public boolean isDeductFromBank() {
        return this.DeductFromBank;
    }

    public boolean isDeductFromBankThenPlayer() {
        return this.DeductFromBankThenPlayer;
    }

    public ItemStack getGuiBottonStates(FlagPermissions.FlagState state) {
        return this.guiBottonStates.get((Object)state);
    }

    public int getSelectionNetherHeight() {
        return this.SelectionNetherHeight;
    }

    public boolean isInfoExcludeDFlags() {
        return this.InfoExcludeDFlags;
    }

    public boolean isChatListening() {
        return this.chatListening;
    }

    public boolean isLoadEveryWorld() {
        return this.LoadEveryWorld;
    }

    public boolean isARCCheckCollision() {
        return this.ARCCheckCollision;
    }

    public String ARCIncrementFormat() {
        return this.ARCIncrementFormat;
    }

    public int getARCSizePercentage() {
        return this.ARCSizePercentage;
    }

    public int getARCSizeMin() {
        return this.ARCSizeMin;
    }

    public int getARCSizeMax() {
        return this.ARCSizeMax;
    }

    public boolean isARCSizeEnabled() {
        return this.ARCSizeEnabled;
    }

    public boolean isARCOldMethod() {
        return this.ARCOldMethod;
    }

    public boolean isChargeOnCreation() {
        return this.chargeOnCreation;
    }

    public boolean isChargeOnExpansion() {
        return this.chargeOnExpansion;
    }

    public boolean isChargeOnAreaAdd() {
        return this.chargeOnAreaAdd;
    }

    public int getAntiGreefRangeGaps(String worldName) {
        if (this.AntiGreefRangeGaps.isEmpty() || worldName == null) {
            return 0;
        }
        Integer specific = this.AntiGreefRangeGaps.get(worldName.toLowerCase());
        if (specific != null) {
            return specific;
        }
        Integer all = this.AntiGreefRangeGaps.get("all");
        if (all != null) {
            return all;
        }
        return 0;
    }

    public boolean isARCRatioInform() {
        return this.ARCRatioInform;
    }

    public int getARCRatioValue() {
        return this.ARCRatioValue;
    }

    public boolean isARCRatioConfirmation() {
        return this.ARCRatioConfirmation;
    }

    public boolean isWorldEditIntegration() {
        return this.WorldEditIntegration;
    }

    public int getSignsMaxPerResidence() {
        return this.SignsMaxPerResidence;
    }

    public boolean isResBankBack() {
        return this.ResBankBack;
    }

    public boolean isAutoCleanTrasnferToUser() {
        return this.AutoCleanTrasnferToUser;
    }

    public String getAutoCleanUserName() {
        return this.AutoCleanUserName;
    }

    public boolean isDisableResidenceCreation() {
        return this.DisableResidenceCreation;
    }
}

