/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.Placeholders;

import com.bekvon.bukkit.residence.Placeholders.CMIPlaceholderCache;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.Zrips.CMILib.Chat.ChatFilterRule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Placeholder {
    private Residence plugin;
    private static ChatFilterRule numericalRule = new ChatFilterRule().setPattern("(\\$)(\\d)");
    static LinkedHashMap<String, CMIPlaceHolders> byNameStatic = new LinkedHashMap();
    static LinkedHashMap<String, LinkedHashSet<CMIPlaceHolders>> byNameComplex = new LinkedHashMap();
    Pattern placeholderPatern = Pattern.compile("(%)([^\"^%]*)(%)");

    public Placeholder(Residence plugin) {
        this.plugin = plugin;
    }

    public List<String> updatePlaceHolders(Player player, List<String> messages) {
        ArrayList<String> ms = new ArrayList<String>(messages);
        int i = 0;
        int l = messages.size();
        while (i < l) {
            ms.set(i, this.updatePlaceHolders(player, messages.get(i)));
            ++i;
        }
        return ms;
    }

    public String updatePlaceHolders(Player player, String message2) {
        if (message2 == null) {
            return null;
        }
        if (message2.contains("%")) {
            message2 = this.translateOwnPlaceHolder(player, message2);
        }
        if (!this.plugin.isPlaceholderAPIEnabled()) {
            return message2;
        }
        if (message2.contains("%")) {
            message2 = PlaceholderAPI.setPlaceholders((Player)player, (String)message2);
        }
        return message2;
    }

    private String translateOwnPlaceHolder(Player player, String message2) {
        if (message2 == null) {
            return null;
        }
        if (message2.contains("%")) {
            Matcher match = this.placeholderPatern.matcher(message2);
            while (match.find()) {
                String with;
                String cmd2 = match.group(2);
                if (!message2.contains("%")) break;
                CMIPlaceHolders place = CMIPlaceHolders.getByNameExact(cmd2);
                if (place == null || (with = this.getValue(player, place, cmd2)) == null) continue;
                message2 = place.isComplex() ? message2.replace("%" + cmd2 + "%", with) : message2.replace(place.getFull(), with);
            }
        }
        return message2;
    }

    @Deprecated
    public String getValue(Player player, CMIPlaceHolders placeHolder) {
        return this.getValue(player, placeHolder, null);
    }

    public String getValue(Player player, CMIPlaceHolders placeHolder, String value) {
        if (placeHolder == null) {
            return null;
        }
        Object cached = placeHolder.getCachedValue(player != null ? player.getUniqueId() : null);
        if (cached != null) {
            return (String)cached;
        }
        ResidencePlayer user = this.plugin.getPlayerManager().getResidencePlayer(player);
        String result = null;
        if (user != null) {
            if (!placeHolder.isComplex()) {
                switch (placeHolder) {
                    case residence_user_admin: {
                        result = this.variable(Residence.getInstance().getPermissionManager().isResidenceAdmin((CommandSender)player));
                        break;
                    }
                    case residence_user_amount: {
                        result = String.valueOf(user.getResAmount());
                        break;
                    }
                    case residence_user_blockcost: {
                        if (Residence.getInstance().getEconomyManager() == null) break;
                        result = String.valueOf(user.getGroup().getCostperarea());
                        break;
                    }
                    case residence_user_blocksell: {
                        if (Residence.getInstance().getEconomyManager() == null) break;
                        result = String.valueOf(user.getGroup().getSellperarea());
                        break;
                    }
                    case residence_user_cancreate: {
                        result = this.variable(user.getGroup().canCreateResidences());
                        break;
                    }
                    case residence_user_group: {
                        result = user.getGroup().getGroupName();
                        break;
                    }
                    case residence_user_maxew: {
                        PermissionGroup group = user.getGroup();
                        result = String.valueOf(group.getMinX()) + "-" + user.getMaxX();
                        break;
                    }
                    case residence_user_maxns: {
                        PermissionGroup group = user.getGroup();
                        result = String.valueOf(group.getMinZ()) + "-" + user.getMaxZ();
                        break;
                    }
                    case residence_user_maxrentdays: {
                        result = String.valueOf(user.getGroup().getMaxRentDays());
                        break;
                    }
                    case residence_user_maxrents: {
                        result = String.valueOf(user.getMaxRents());
                        break;
                    }
                    case residence_user_maxres: {
                        result = String.valueOf(user.getMaxRes());
                        break;
                    }
                    case residence_user_maxsub: {
                        result = String.valueOf(user.getMaxSubzones());
                        break;
                    }
                    case residence_user_maxsubdepth: {
                        result = String.valueOf(user.getMaxSubzoneDepth());
                        break;
                    }
                    case residence_user_maxud: {
                        PermissionGroup group = user.getGroup();
                        result = String.valueOf(group.getMinY()) + "-" + group.getMaxY();
                        break;
                    }
                    case residence_user_current_owner: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null ? "" : res.getOwner();
                        break;
                    }
                    case residence_user_current_res: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null ? "" : res.getName();
                        break;
                    }
                    case residence_user_current_bank: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null ? "0" : res.getBank().getStoredMoneyFormated();
                        break;
                    }
                    case residence_user_current_qsize: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null ? "0" : String.valueOf(res.getTotalSize());
                        break;
                    }
                    case residence_user_current_ssize: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null ? "0" : String.valueOf(res.getXZSize());
                        break;
                    }
                    case residence_user_current_forsale: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null ? "" : String.valueOf(res.isForSell());
                        break;
                    }
                    case residence_user_current_saleprice: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null || !res.isForSell() ? "" : String.valueOf(res.getSellPrice());
                        break;
                    }
                    case residence_user_current_rentprice: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null || !res.isForRent() ? "" : String.valueOf(res.getRentable().cost);
                        break;
                    }
                    case residence_user_current_rentdays: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null || !res.isForRent() ? "" : String.valueOf(res.getRentable().days);
                        break;
                    }
                    case residence_user_current_rentedby: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null || !res.isForRent() || res.getRentedLand() == null || res.getRentedLand().player == null ? "" : res.getRentedLand().player;
                        break;
                    }
                    case residence_user_current_rentends: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null || !res.isForRent() || res.getRentedLand() == null || res.getRentedLand().player == null ? "" : GetTime.getTime(res.getRentedLand().endTime, true);
                        break;
                    }
                    case residence_user_current_forrent: {
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        result = res == null ? "" : String.valueOf(res.isForRent());
                        break;
                    }
                }
                if (placeHolder.isCache() && placeHolder.getCachedValue(user.getUniqueId()) == null) {
                    placeHolder.addCachedValue(user.getUniqueId(), result, placeHolder.getCacheForMS());
                }
            } else if (value != null && player != null) {
                switch (placeHolder) {
                    case residence_user_current_flag_$1: {
                        List<String> values = placeHolder.getComplexValues(value);
                        if (values.size() < 1) {
                            return "";
                        }
                        ClaimedResidence res = this.plugin.getResidenceManager().getByLoc(user.getPlayer().getLocation());
                        if (res == null) {
                            return null;
                        }
                        Flags flag = Flags.getFlag(values.get(0));
                        if (flag == null) {
                            return "";
                        }
                        return this.variable(res.getPermissions().playerHas(player, flag, FlagPermissions.FlagCombo.TrueOrNone));
                    }
                }
            }
        }
        return result;
    }

    private String variable(Boolean state) {
        return state != false ? this.plugin.getLM().getMessage(lm.General_True, new Object[0]) : this.plugin.getLM().getMessage(lm.General_False, new Object[0]);
    }

    public static enum CMIPlaceHolders {
        residence_user_amount,
        residence_user_group,
        residence_user_admin,
        residence_user_cancreate,
        residence_user_maxres,
        residence_user_maxew,
        residence_user_maxns,
        residence_user_maxud,
        residence_user_maxsub,
        residence_user_maxsubdepth,
        residence_user_maxrents,
        residence_user_maxrentdays,
        residence_user_blockcost,
        residence_user_blocksell,
        residence_user_current_owner,
        residence_user_current_res,
        residence_user_current_bank,
        residence_user_current_qsize,
        residence_user_current_ssize,
        residence_user_current_forsale,
        residence_user_current_saleprice,
        residence_user_current_forrent,
        residence_user_current_rentprice,
        residence_user_current_rentedby,
        residence_user_current_rentdays,
        residence_user_current_rentends,
        residence_user_current_flag_$1("Get flags from current residence by flag name", "flagName");

        private String[] vars;
        private List<Integer> groups = new ArrayList<Integer>();
        private ChatFilterRule rule = null;
        private boolean cache = true;
        private String desc = null;
        private int cacheForMS = 1000;
        private int MAX_ENTRIES = 20;
        LinkedHashMap<UUID, CMIPlaceholderCache> map = new LinkedHashMap<UUID, CMIPlaceholderCache>(this, this.MAX_ENTRIES + 1, 0.75f, false){
            final /* synthetic */ CMIPlaceHolders this$1;
            {
                this.this$1 = cMIPlaceHolders;
                super($anonymous0, $anonymous1, $anonymous2);
            }

            @Override
            protected boolean removeEldestEntry(Map.Entry<UUID, CMIPlaceholderCache> eldest) {
                return this.size() > this.this$1.MAX_ENTRIES;
            }
        };

        static {
            CMIPlaceHolders[] cMIPlaceHoldersArray = CMIPlaceHolders.values();
            int n = cMIPlaceHoldersArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMIPlaceHolders one = cMIPlaceHoldersArray[n2];
                String fullName = one.toString();
                if (!one.isComplex()) {
                    byNameStatic.put(fullName.toLowerCase(), one);
                } else {
                    String[] split = fullName.split("_");
                    String first = String.valueOf(split[0]) + "_" + split[1];
                    LinkedHashSet<CMIPlaceHolders> old = byNameComplex.getOrDefault(first, new LinkedHashSet());
                    old.add(one);
                    byNameComplex.put(first, old);
                }
                ++n2;
            }
        }

        private CMIPlaceHolders() {
        }

        private CMIPlaceHolders(String desc, String ... vars) {
            this(desc, true, vars);
        }

        private CMIPlaceHolders(String desc, boolean cache, String ... vars) {
            this.desc = desc;
            this.vars = vars;
            this.cache = cache;
            try {
                Matcher matcher = numericalRule.getMatcher(this.toString());
                if (matcher != null) {
                    this.rule = new ChatFilterRule();
                    ArrayList<String> ls = new ArrayList<String>();
                    ls.add("(%)" + this.toString().replaceAll("\\$\\d", "([^\"^%]*)") + "(%)");
                    ls.add("(\\{)" + this.toString().replaceAll("\\$\\d", "([^\"^%]*)") + "(\\})");
                    this.rule.setPattern(ls);
                    while (matcher.find()) {
                        try {
                            int id = Integer.parseInt(matcher.group(2));
                            this.groups.add(id);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }

        public Object getCachedValue(UUID uuid) {
            if (!this.isCache() || this.isComplex() || uuid == null) {
                return null;
            }
            CMIPlaceholderCache cache = this.map.get(uuid);
            if (cache == null || System.currentTimeMillis() > cache.getValidUntil()) {
                return null;
            }
            return cache.getResult();
        }

        public void addCachedValue(UUID uuid, String value, int validForMiliSeconds) {
            if (uuid == null) {
                return;
            }
            CMIPlaceholderCache cache = this.map.getOrDefault(uuid, new CMIPlaceholderCache());
            cache.setResult(value);
            cache.setValidUntil(System.currentTimeMillis() + (long)validForMiliSeconds);
            this.map.put(uuid, cache);
        }

        public static CMIPlaceHolders getByName(String name) {
            CMIPlaceHolders got;
            if (name.startsWith("%") || name.startsWith("{")) {
                name = name.replaceAll("%|\\{|\\}", "");
            }
            if ((got = byNameStatic.get(name)) != null) {
                return got;
            }
            String original = name;
            String[] split = name.split("_");
            if (split.length < 3) {
                return null;
            }
            String prefix = String.valueOf(split[0]) + "_" + split[1];
            Set main = byNameComplex.get(prefix);
            if (main == null) {
                return null;
            }
            for (CMIPlaceHolders mainOne : main) {
                if (mainOne.getComplexRegexMatchers(original).isEmpty()) continue;
                return mainOne;
            }
            return null;
        }

        public static CMIPlaceHolders getByNameExact(String name) {
            return CMIPlaceHolders.getByName(name);
        }

        public String getFull() {
            if (this.isComplex()) {
                String name = this.name();
                int i = 0;
                String[] stringArray = this.name().split("_");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String one = stringArray[n2];
                    if (one.startsWith("$")) {
                        if (this.vars.length >= i - 1) {
                            name = name.replace(one, "[" + this.vars[i] + "]");
                        }
                        ++i;
                    }
                    ++n2;
                }
                return "%" + name + "%";
            }
            return "%" + this.name() + "%";
        }

        /*
         * Unable to fully structure code
         */
        public List<String> getComplexRegexMatchers(String text) {
            lsInLs = new ArrayList<String>();
            if (!this.isComplex()) {
                return lsInLs;
            }
            if (!text.startsWith("%") && !text.endsWith("%")) {
                text = "%" + text + "%";
            }
            if ((matcher = this.getRule().getMatcher(text)) != null) ** GOTO lbl10
            return lsInLs;
lbl-1000:
            // 1 sources

            {
                lsInLs.add(matcher.group());
lbl10:
                // 2 sources

                ** while (matcher.find())
            }
lbl11:
            // 1 sources

            return lsInLs;
        }

        public List<String> getComplexValues(String text) {
            Matcher matcher;
            ArrayList<String> lsInLs = new ArrayList<String>();
            if (!this.isComplex() || text == null) {
                return lsInLs;
            }
            if (!text.startsWith("%") && !text.endsWith("%")) {
                text = "%" + text + "%";
            }
            if ((matcher = this.getRule().getMatcher(text)) == null) {
                return lsInLs;
            }
            if (matcher.find()) {
                try {
                    for (Integer oneG : this.groups) {
                        lsInLs.add(matcher.group(oneG + 1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return lsInLs;
        }

        public boolean isComplex() {
            return this.rule != null;
        }

        public ChatFilterRule getRule() {
            return this.rule;
        }

        public void setRule(ChatFilterRule rule) {
            this.rule = rule;
        }

        public String getDescription() {
            return this.desc;
        }

        public boolean isCache() {
            return this.cache;
        }

        public int getCacheForMS() {
            return this.cacheForMS;
        }
    }
}

