/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.residence.LocaleManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.ArrayList;
import java.util.Arrays;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class lease
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=3900)
    public Boolean perform(Residence plugin, CommandSender sender, String[] args, boolean resadmin2) {
        if (!(sender instanceof Player)) {
            return false;
        }
        Player player = (Player)sender;
        if (args.length == 1 || args.length == 2 || args.length == 3) {
            if (args[0].equals("set")) {
                int days;
                if (!resadmin2) {
                    plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
                    return true;
                }
                if (args[2].equals("infinite")) {
                    if (plugin.getLeaseManager().isLeased(plugin.getResidenceManager().getByName(args[1]))) {
                        plugin.getLeaseManager().removeExpireTime(plugin.getResidenceManager().getByName(args[1]));
                        plugin.msg((CommandSender)player, lm.Economy_LeaseInfinite, new Object[0]);
                    } else {
                        plugin.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
                    }
                    return true;
                }
                try {
                    days = Integer.parseInt(args[2]);
                }
                catch (Exception ex) {
                    plugin.msg((CommandSender)player, lm.Invalid_Days, new Object[0]);
                    return true;
                }
                plugin.getLeaseManager().setExpireTime(player, plugin.getResidenceManager().getByName(args[1]), days);
                return true;
            }
            if (args[0].equals("expires")) {
                String until;
                ClaimedResidence res = null;
                if (args.length == 1) {
                    res = plugin.getResidenceManager().getByLoc(player.getLocation());
                    if (res == null) {
                        plugin.msg((CommandSender)player, lm.Residence_NotIn, new Object[0]);
                        return true;
                    }
                } else {
                    res = plugin.getResidenceManager().getByName(args[1]);
                    if (res == null) {
                        plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
                        return true;
                    }
                }
                if ((until = plugin.getLeaseManager().getExpireTime(res)) != null) {
                    plugin.msg((CommandSender)player, lm.Economy_LeaseRenew, until);
                }
                return true;
            }
            if (args[0].equals("renew")) {
                if (args.length == 2) {
                    plugin.getLeaseManager().renewArea(plugin.getResidenceManager().getByName(args[1]), player);
                } else {
                    ClaimedResidence res = plugin.getResidenceManager().getByLoc(player.getLocation());
                    if (res != null) {
                        plugin.getLeaseManager().renewArea(res, player);
                    } else {
                        return false;
                    }
                }
                return true;
            }
            if (args[0].equals("list")) {
                ClaimedResidence res = null;
                int page = -1;
                if (args.length > 1) {
                    try {
                        page = Integer.parseInt(args[1]);
                    }
                    catch (Exception e) {
                        res = plugin.getResidenceManager().getByName(args[1]);
                    }
                }
                if (args.length > 2 && page == -1) {
                    try {
                        page = Integer.parseInt(args[2]);
                    }
                    catch (Exception e) {
                        res = plugin.getResidenceManager().getByName(args[2]);
                    }
                }
                if (res == null) {
                    res = plugin.getResidenceManager().getByLoc(player.getLocation());
                }
                if (res == null) {
                    return false;
                }
                ArrayList<ClaimedResidence> list2 = new ArrayList<ClaimedResidence>();
                if (plugin.getLeaseManager().isLeased(res)) {
                    list2.add(res);
                }
                for (ClaimedResidence one : res.getSubzones()) {
                    if (!plugin.getLeaseManager().isLeased(one)) continue;
                    list2.add(one);
                }
                PageInfo pi = new PageInfo(3, list2.size(), page);
                plugin.msg((CommandSender)player, lm.General_Separator, new Object[0]);
                for (ClaimedResidence one : list2) {
                    if (!pi.isEntryOk()) continue;
                    if (pi.isBreak()) break;
                    if (res.isOwner(player)) {
                        plugin.msg((CommandSender)player, lm.Economy_LeaseList, pi.getPositionForOutput(), one.getName(), plugin.getLeaseManager().getExpireTime(one), one.getOwner());
                        continue;
                    }
                    plugin.msg((CommandSender)player, lm.Economy_LeaseList, pi.getPositionForOutput(), one.getName(), "", "");
                }
                pi.autoPagination(sender, "res lease list " + res.getName());
                return true;
            }
            if (args[0].equals("cost")) {
                if (args.length == 2) {
                    ClaimedResidence res = plugin.getResidenceManager().getByName(args[1]);
                    if (res == null || plugin.getLeaseManager().isLeased(res)) {
                        double cost = plugin.getLeaseManager().getRenewCostD(res);
                        plugin.msg((CommandSender)player, lm.Economy_LeaseRenewalCost, args[1], plugin.getEconomyManager().format(cost));
                    } else {
                        plugin.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
                    }
                    return true;
                }
                ClaimedResidence res = plugin.getResidenceManager().getByLoc(player.getLocation());
                if (res == null) {
                    plugin.msg((CommandSender)player, lm.Invalid_Area, new Object[0]);
                    return true;
                }
                String area2 = res.getName();
                if (plugin.getLeaseManager().isLeased(res)) {
                    double cost = plugin.getLeaseManager().getRenewCostD(res);
                    plugin.msg((CommandSender)player, lm.Economy_LeaseRenewalCost, area2, plugin.getEconomyManager().format(cost));
                } else {
                    plugin.msg((CommandSender)player, lm.Economy_LeaseNotExpire, new Object[0]);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void getLocale() {
        ConfigReader c = Residence.getInstance().getLocaleManager().getLocaleConfig();
        c.get("Description", "Manage residence leases");
        c.get("Info", Arrays.asList("&eUsage: &6/res lease [renew/cost] [residence]", "/res lease cost will show the cost of renewing a residence lease.", "/res lease renew will renew the residence provided you have enough money."));
        c.setFullPath(String.valueOf(c.getPath()) + "SubCommands.");
        c.get("set.Description", "Set the lease time");
        c.get("set.Info", Arrays.asList("&eUsage: &6/resadmin lease set [residence] [#days/infinite]", "Sets the lease time to a specified number of days, or infinite."));
        LocaleManager.addTabCompleteSub(this, "set", "[residence]");
        c.get("renew.Description", "Renew the lease time");
        c.get("renew.Info", Arrays.asList("&eUsage: &6/resadmin lease renew <residence>", "Renews the lease time for current or specified residence."));
        LocaleManager.addTabCompleteSub(this, "renew", "[residence]");
        c.get("list.Description", "Show lease list of current residence");
        c.get("list.Info", Arrays.asList("&eUsage: &6/resadmin lease list <residence> <page>", "Prints out all subzones lease times"));
        LocaleManager.addTabCompleteSub(this, "list", "[residence]");
        c.get("expires.Description", "Lease end date");
        c.get("expires.Info", Arrays.asList("&eUsage: &6/resadmin lease expires <residence>", "Shows when expires residence lease time."));
        LocaleManager.addTabCompleteSub(this, "expires", "[residence]");
        c.get("cost.Description", "Shows renew cost");
        c.get("cost.Info", Arrays.asList("&eUsage: &6/resadmin lease cost <residence>", "Shows how much money you need to renew residence lease."));
        LocaleManager.addTabCompleteSub(this, "cost", "[residence]");
    }
}

