/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidenceInterface;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.MinimizeFlags;
import com.bekvon.bukkit.residence.containers.MinimizeMessages;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.economy.rent.RentedLand;
import com.bekvon.bukkit.residence.event.ResidenceCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.listeners.ResidenceLWCListener;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.permissions.PermissionManager;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.protection.ResidencePermissions;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class ResidenceManager
implements ResidenceInterface {
    protected ConcurrentHashMap<String, ClaimedResidence> residences;
    protected Map<String, Map<ChunkRef, List<ClaimedResidence>>> chunkResidences;
    protected List<ClaimedResidence> shops = new ArrayList<ClaimedResidence>();
    private Residence plugin;
    HashMap<String, List<MinimizeMessages>> optimizeMessages = new HashMap();
    HashMap<String, List<MinimizeFlags>> optimizeFlags = new HashMap();
    HashMap<String, HashMap<Integer, MinimizeMessages>> cacheMessages = new HashMap();
    HashMap<String, HashMap<Integer, MinimizeFlags>> cacheFlags = new HashMap();
    int chunkCount = 0;

    public ResidenceManager(Residence plugin) {
        this.residences = new ConcurrentHashMap();
        this.chunkResidences = new HashMap<String, Map<ChunkRef, List<ClaimedResidence>>>();
        this.shops = new ArrayList<ClaimedResidence>();
        this.plugin = plugin;
    }

    public boolean isOwnerOfLocation(Player player, Location loc) {
        ClaimedResidence res = this.getByLoc(loc);
        return res != null && res.isOwner(player);
    }

    public ClaimedResidence getByLoc(Player player) {
        return this.getByLoc(player.getLocation());
    }

    @Override
    public ClaimedResidence getByLoc(Location loc) {
        if (loc == null) {
            return null;
        }
        World world = loc.getWorld();
        if (world == null) {
            return null;
        }
        String worldName = world.getName();
        if (worldName == null) {
            return null;
        }
        Map<ChunkRef, List<ClaimedResidence>> ChunkMap = this.chunkResidences.get(worldName);
        if (ChunkMap == null) {
            return null;
        }
        List<ClaimedResidence> residences = ChunkMap.get(new ChunkRef(loc));
        if (residences == null) {
            return null;
        }
        for (ClaimedResidence residence : residences) {
            if (residence == null || !residence.containsLoc(loc)) continue;
            ClaimedResidence subres = residence.getSubzoneByLoc(loc);
            return subres == null ? residence : subres;
        }
        return null;
    }

    public List<ClaimedResidence> getByChunk(Chunk chunk) {
        ArrayList<ClaimedResidence> list2 = new ArrayList<ClaimedResidence>();
        if (chunk == null) {
            return list2;
        }
        World world = chunk.getWorld();
        if (world == null) {
            return list2;
        }
        String worldName = world.getName();
        if (worldName == null) {
            return list2;
        }
        if (!this.chunkResidences.containsKey(worldName)) {
            return list2;
        }
        ChunkRef chunkRef = new ChunkRef(chunk.getX(), chunk.getZ());
        Map<ChunkRef, List<ClaimedResidence>> ChunkMap = this.chunkResidences.get(worldName);
        List<ClaimedResidence> ls = ChunkMap.get(chunkRef);
        return ls == null ? list2 : new ArrayList<ClaimedResidence>(ls);
    }

    @Override
    public ClaimedResidence getByName(String name) {
        if (name == null) {
            return null;
        }
        String[] split = name.split("\\.");
        if (split.length == 1) {
            return this.residences.get(name.toLowerCase());
        }
        ClaimedResidence res = this.residences.get(split[0].toLowerCase());
        int i = 1;
        while (i < split.length) {
            if (res == null) {
                return null;
            }
            res = res.getSubzone(split[i].toLowerCase());
            ++i;
        }
        return res;
    }

    @Override
    public String getSubzoneNameByRes(ClaimedResidence res) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> check2 : set2) {
            if (check2.getValue() == res) {
                return check2.getKey();
            }
            String n = check2.getValue().getSubzoneNameByRes(res);
            if (n == null) continue;
            return n;
        }
        return null;
    }

    @Override
    public void addShop(String resName) {
        ClaimedResidence res = this.getByName(resName);
        if (res != null) {
            this.shops.add(res);
        }
    }

    @Override
    public void addShop(ClaimedResidence res) {
        this.shops.add(res);
    }

    @Override
    public void removeShop(ClaimedResidence res) {
        this.shops.remove(res);
    }

    @Override
    public void removeShop(String resName) {
        for (ClaimedResidence one : this.shops) {
            if (!one.getName().equalsIgnoreCase(resName)) continue;
            this.shops.remove(one);
            break;
        }
    }

    @Override
    public List<ClaimedResidence> getShops() {
        return this.shops;
    }

    @Override
    public boolean addResidence(String name, Location loc1, Location loc2) {
        return this.addResidence(name, this.plugin.getServerLandName(), loc1, loc2);
    }

    @Override
    public boolean addResidence(String name, String owner, Location loc1, Location loc2) {
        return this.addResidence(null, owner, name, loc1, loc2, true);
    }

    @Override
    public boolean addResidence(Player player, String name, Location loc1, Location loc2, boolean resadmin2) {
        return this.addResidence(player, player.getName(), name, loc1, loc2, resadmin2);
    }

    public boolean addResidence(Player player, String owner, String name, Location loc1, Location loc2, boolean resadmin2) {
        return this.addResidence(player, owner, null, name, loc1, loc2, resadmin2);
    }

    @Override
    public boolean addResidence(Player player, String resName, boolean resadmin2) {
        return this.addResidence(player, player.getName(), player.getUniqueId(), resName, this.plugin.getSelectionManager().getPlayerLoc1(player), this.plugin.getSelectionManager().getPlayerLoc2(player), resadmin2);
    }

    public boolean addResidence(Player player, String owner, UUID ownerUUId, String resName, Location loc1, Location loc2, boolean resadmin2) {
        if (!this.plugin.validName(resName)) {
            this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        if (loc1 == null || loc2 == null || !loc1.getWorld().getName().equals(loc2.getWorld().getName())) {
            this.plugin.msg((CommandSender)player, lm.Select_Points, new Object[0]);
            return false;
        }
        if (this.plugin.isDisabledWorld(loc1.getWorld()) && this.plugin.getConfigManager().isDisableResidenceCreation()) {
            this.plugin.msg((CommandSender)player, lm.General_CantCreate, new Object[0]);
            return false;
        }
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        if (!(resadmin2 || group.canCreateResidences() || PermissionManager.ResPerm.create.hasPermission((CommandSender)player, lm.General_NoPermission))) {
            return false;
        }
        if (!resadmin2 && !PermissionManager.ResPerm.create.hasPermission((CommandSender)player, true, new String[0])) {
            return false;
        }
        if (rPlayer.getResAmount() >= rPlayer.getMaxRes() && !resadmin2) {
            this.plugin.msg((CommandSender)player, lm.Residence_TooMany, new Object[0]);
            return false;
        }
        CuboidArea newArea = new CuboidArea(loc1, loc2);
        ClaimedResidence newRes = new ClaimedResidence(owner, ownerUUId, loc1.getWorld().getName());
        newRes.getPermissions().applyDefaultFlags();
        newRes.setEnterMessage(group.getDefaultEnterMessage());
        newRes.setLeaveMessage(group.getDefaultLeaveMessage());
        newRes.setName(resName);
        newRes.setCreateTime();
        if (this.residences.containsKey(resName.toLowerCase())) {
            this.plugin.msg((CommandSender)player, lm.Residence_AlreadyExists, this.residences.get(resName.toLowerCase()).getResidenceName());
            return false;
        }
        newRes.BlockSellPrice = group.getSellPerBlock();
        if (!newRes.addArea(player, newArea, "main", resadmin2, false)) {
            return false;
        }
        ResidenceCreationEvent resevent = new ResidenceCreationEvent(player, resName, newRes, newArea);
        this.plugin.getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return false;
        }
        if (Residence.getInstance().getConfigManager().isChargeOnCreation() && !newRes.isSubzone() && this.plugin.getConfigManager().enableEconomy() && !resadmin2) {
            double chargeamount = newArea.getCost(group);
            if (!this.plugin.getTransactionManager().chargeEconomyMoney(player, chargeamount)) {
                newRes.removeArea("main");
                return false;
            }
        }
        this.residences.put(resName.toLowerCase(), newRes);
        this.calculateChunks(resName);
        this.plugin.getLeaseManager().removeExpireTime(newRes);
        this.plugin.getPlayerManager().addResidence(newRes.getOwner(), newRes);
        if (player != null) {
            Visualizer v = new Visualizer(player);
            v.setAreas(newArea);
            this.plugin.getSelectionManager().showBounds(player, v);
            this.plugin.getAutoSelectionManager().getList().remove(player.getUniqueId());
            this.plugin.msg((CommandSender)player, lm.Area_Create, "main");
            this.plugin.msg((CommandSender)player, lm.Residence_Create, resName);
        }
        if (this.plugin.getConfigManager().useLeases()) {
            this.plugin.getLeaseManager().setExpireTime(player, newRes, group.getLeaseGiveTime());
        }
        return true;
    }

    public void listResidences(CommandSender sender) {
        this.listResidences(sender, sender.getName(), 1);
    }

    public void listResidences(CommandSender sender, boolean resadmin2) {
        this.listResidences(sender, sender.getName(), 1, false, false, resadmin2);
    }

    public void listResidences(CommandSender sender, String targetplayer, boolean showhidden) {
        this.listResidences(sender, targetplayer, 1, showhidden, false, showhidden);
    }

    public void listResidences(CommandSender sender, String targetplayer, int page) {
        this.listResidences(sender, targetplayer, page, false, false, false);
    }

    public void listResidences(CommandSender sender, int page, boolean showhidden) {
        this.listResidences(sender, sender.getName(), page, showhidden, false, showhidden);
    }

    public void listResidences(CommandSender sender, int page, boolean showhidden, boolean onlyHidden) {
        this.listResidences(sender, sender.getName(), page, showhidden, onlyHidden, showhidden);
    }

    public void listResidences(CommandSender sender, String string, int page, boolean showhidden) {
        this.listResidences(sender, string, page, showhidden, false, showhidden);
    }

    public void listResidences(CommandSender sender, String targetplayer, int page, boolean showhidden, boolean onlyHidden, boolean resadmin2) {
        this.listResidences(sender, targetplayer, page, showhidden, onlyHidden, resadmin2, null);
    }

    public void listResidences(CommandSender sender, String targetplayer, int page, boolean showhidden, boolean onlyHidden, boolean resadmin2, World world) {
        if (targetplayer == null) {
            targetplayer = sender.getName();
        }
        if (showhidden && !this.plugin.isResAdminOn(sender) && !sender.getName().equalsIgnoreCase(targetplayer)) {
            showhidden = false;
        } else if (sender.getName().equalsIgnoreCase(targetplayer)) {
            showhidden = true;
        }
        boolean hidden = showhidden;
        TreeMap<String, ClaimedResidence> ownedResidences = this.plugin.getPlayerManager().getResidencesMap(targetplayer, hidden, onlyHidden, world);
        ownedResidences.putAll(this.plugin.getRentManager().getRentsMap(targetplayer, onlyHidden, world));
        ownedResidences.putAll(this.plugin.getPlayerManager().getTrustedResidencesMap(targetplayer, hidden, onlyHidden, world));
        this.plugin.getInfoPageManager().printListInfo(sender, targetplayer, ownedResidences, page, resadmin2, world);
    }

    public void listAllResidences(CommandSender sender, int page) {
        this.listAllResidences(sender, page, false);
    }

    public void listAllResidences(CommandSender sender, int page, boolean showhidden, World world) {
        TreeMap<String, ClaimedResidence> list2 = this.getFromAllResidencesMap(showhidden, false, world);
        this.plugin.getInfoPageManager().printListInfo(sender, null, list2, page, showhidden, world);
    }

    public void listAllResidences(CommandSender sender, int page, boolean showhidden) {
        this.listAllResidences(sender, page, showhidden, false);
    }

    public void listAllResidences(CommandSender sender, int page, boolean showhidden, boolean onlyHidden) {
        TreeMap<String, ClaimedResidence> list2 = this.getFromAllResidencesMap(showhidden, onlyHidden, null);
        this.plugin.getInfoPageManager().printListInfo(sender, null, list2, page, showhidden, null);
    }

    public String[] getResidenceList() {
        return this.getResidenceList(true, true).toArray(new String[0]);
    }

    public Map<String, ClaimedResidence> getResidenceMapList(String targetplayer, boolean showhidden) {
        HashMap<String, ClaimedResidence> temp = new HashMap<String, ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
            if (!res.getValue().isOwner(targetplayer)) continue;
            boolean hidden = res.getValue().getPermissions().has("hidden", false);
            if (!showhidden && (showhidden || hidden)) continue;
            temp.put(res.getValue().getName().toLowerCase(), res.getValue());
        }
        return temp;
    }

    public ArrayList<String> getResidenceList(boolean showhidden, boolean showsubzones) {
        return this.getResidenceList(null, showhidden, showsubzones, false);
    }

    public ArrayList<String> getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones) {
        return this.getResidenceList(targetplayer, showhidden, showsubzones, false, false);
    }

    public ArrayList<String> getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones, boolean onlyHidden) {
        return this.getResidenceList(targetplayer, showhidden, showsubzones, false, onlyHidden);
    }

    public ArrayList<String> getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones, boolean formattedOutput, boolean onlyHidden) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
            this.getResidenceList(targetplayer, showhidden, showsubzones, "", res.getKey(), res.getValue(), list2, formattedOutput, onlyHidden);
        }
        return list2;
    }

    public ArrayList<ClaimedResidence> getFromAllResidences(boolean showhidden, boolean onlyHidden, World world) {
        ArrayList<ClaimedResidence> list2 = new ArrayList<ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
            boolean hidden = res.getValue().getPermissions().has("hidden", false);
            if (onlyHidden && !hidden || world != null && !world.getName().equalsIgnoreCase(res.getValue().getWorld()) || !showhidden && (showhidden || hidden)) continue;
            list2.add(res.getValue());
        }
        return list2;
    }

    public TreeMap<String, ClaimedResidence> getFromAllResidencesMap(boolean showhidden, boolean onlyHidden, World world) {
        TreeMap<String, ClaimedResidence> list2 = new TreeMap<String, ClaimedResidence>();
        for (Map.Entry<String, ClaimedResidence> res : this.residences.entrySet()) {
            boolean hidden = res.getValue().getPermissions().has("hidden", false);
            if (onlyHidden && !hidden || world != null && !world.getName().equalsIgnoreCase(res.getValue().getWorld()) || !showhidden && (showhidden || hidden)) continue;
            list2.put(res.getKey(), res.getValue());
        }
        return list2;
    }

    private void getResidenceList(String targetplayer, boolean showhidden, boolean showsubzones, String parentzone, String resname, ClaimedResidence res, ArrayList<String> list2, boolean formattedOutput, boolean onlyHidden) {
        boolean hidden = res.getPermissions().has("hidden", false);
        if (onlyHidden && !hidden) {
            return;
        }
        if (showhidden || !showhidden && !hidden) {
            if (targetplayer == null || res.getPermissions().getOwner().equals(targetplayer)) {
                if (formattedOutput) {
                    list2.add(String.valueOf(this.plugin.msg(lm.Residence_List, parentzone, resname, res.getWorld())) + (hidden ? this.plugin.msg(lm.Residence_Hidden, new Object[0]) : ""));
                } else {
                    list2.add(String.valueOf(parentzone) + resname);
                }
            }
            if (showsubzones) {
                for (Map.Entry<String, ClaimedResidence> sz : res.subzones.entrySet()) {
                    this.getResidenceList(targetplayer, showhidden, showsubzones, String.valueOf(parentzone) + resname + ".", sz.getKey(), sz.getValue(), list2, formattedOutput, onlyHidden);
                }
            }
        }
    }

    public String checkAreaCollision(CuboidArea newarea, ClaimedResidence parentResidence) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            ClaimedResidence check2 = entry.getValue();
            if (check2 == parentResidence || !check2.checkCollision(newarea)) continue;
            return entry.getKey();
        }
        return null;
    }

    public String checkAreaCollision(CuboidArea newarea, ClaimedResidence parentResidence, UUID ignoredOwner) {
        Set<Map.Entry<String, ClaimedResidence>> set2 = this.residences.entrySet();
        for (Map.Entry<String, ClaimedResidence> entry : set2) {
            ClaimedResidence check2 = entry.getValue();
            if (check2 == parentResidence || !check2.checkCollision(newarea) || ignoredOwner != null && entry.getValue().isOwner(ignoredOwner)) continue;
            return entry.getKey();
        }
        return null;
    }

    public Set<ClaimedResidence> getResidences(String worldName, List<ChunkRef> chunks) {
        Map<ChunkRef, List<ClaimedResidence>> refs = this.chunkResidences.get(worldName);
        HashSet<ClaimedResidence> resSet = new HashSet<ClaimedResidence>();
        if (refs == null) {
            return resSet;
        }
        for (ChunkRef one : chunks) {
            List<ClaimedResidence> res = refs.get(one);
            if (res == null) continue;
            resSet.addAll(res);
        }
        return resSet;
    }

    public ClaimedResidence collidesWithResidence(CuboidArea newarea) {
        Set<ClaimedResidence> res = this.getResidences(newarea.getWorldName(), newarea.getChunks());
        for (ClaimedResidence check2 : res) {
            if (!check2.checkCollision(newarea)) continue;
            return check2;
        }
        return null;
    }

    public void removeResidence(ClaimedResidence res) {
        this.removeResidence((Player)null, res.getName(), true);
    }

    public void removeResidence(String name) {
        this.removeResidence((Player)null, name, true);
    }

    public void removeResidence(CommandSender sender, String name, boolean resadmin2) {
        if (sender instanceof Player) {
            this.removeResidence((Player)sender, name, resadmin2);
        } else {
            this.removeResidence((Player)null, name, true);
        }
    }

    @Deprecated
    public void removeResidence(Player player, String name, boolean resadmin2) {
        ClaimedResidence res = this.getByName(name);
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        this.removeResidence(player, res, resadmin2);
    }

    @Deprecated
    public void removeResidence(Player player, ClaimedResidence res, boolean resadmin2) {
        this.removeResidence(this.plugin.getPlayerManager().getResidencePlayer(player), res, resadmin2);
    }

    public void removeResidence(ResidencePlayer rPlayer, ClaimedResidence res, boolean resadmin2) {
        this.removeResidence(rPlayer, res, resadmin2, false);
    }

    public void removeResidence(ResidencePlayer rPlayer, ClaimedResidence res, boolean resadmin2, boolean regenerate) {
        Player player = null;
        if (rPlayer != null) {
            player = rPlayer.getPlayer();
        }
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return;
        }
        String name = res.getName();
        if (this.plugin.getConfigManager().isRentPreventRemoval() && !resadmin2) {
            ClaimedResidence rented = res.getRentedSubzone();
            if (rented != null) {
                this.plugin.msg((CommandSender)player, lm.Residence_CantRemove, res.getName(), rented.getName(), rented.getRentedLand().player);
                return;
            }
            if (player != null && res.isRented() && !player.getName().equalsIgnoreCase(res.getRentedLand().player)) {
                this.plugin.msg((CommandSender)player, lm.Residence_CantRemove, res.getName(), res.getName(), res.getRentedLand().player);
                return;
            }
        }
        if (!(player == null || resadmin2 || res.getPermissions().hasResidencePermission((CommandSender)player, true) || resadmin2 || res.getParent() == null || res.getParent().isOwner(player))) {
            this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
            return;
        }
        if (rPlayer != null) {
            rPlayer.forceUpdateGroup();
        }
        ResidenceDeleteEvent resevent = new ResidenceDeleteEvent(player, res, rPlayer == null ? ResidenceDeleteEvent.DeleteCause.OTHER : ResidenceDeleteEvent.DeleteCause.PLAYER_DELETE);
        this.plugin.getServ().getPluginManager().callEvent((Event)resevent);
        if (resevent.isCancelled()) {
            return;
        }
        ClaimedResidence parent = res.getParent();
        if (parent == null) {
            this.removeChunkList(name);
            this.residences.remove(name.toLowerCase());
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1) && this.plugin.getConfigManager().isUseClean() && this.plugin.getConfigManager().getCleanWorlds().contains(res.getWorld())) {
                CuboidArea[] arr = res.getAreaArray();
                CMIScheduler.runTaskAsynchronously(() -> {
                    ChunkSnapshot chunkSnapshot = null;
                    int chunkX = 0;
                    int chunkZ = 0;
                    HashSet<Location> locations = new HashSet<Location>();
                    CuboidArea[] cuboidAreaArray2 = arr;
                    int n = arr.length;
                    int n2 = 0;
                    while (n2 < n) {
                        CuboidArea area2 = cuboidAreaArray2[n2];
                        Location low = area2.getLowLocation().clone();
                        Location high = area2.getHighLocation().clone();
                        if (high.getBlockY() > this.plugin.getConfigManager().getCleanLevel()) {
                            if (low.getBlockY() < this.plugin.getConfigManager().getCleanLevel()) {
                                low.setY((double)this.plugin.getConfigManager().getCleanLevel());
                            }
                            World world = low.getWorld();
                            int x = low.getBlockX();
                            while (x <= high.getBlockX()) {
                                int z = low.getBlockZ();
                                while (z <= high.getBlockZ()) {
                                    int hy = world.getHighestBlockYAt(x, z);
                                    if (high.getBlockY() < hy) {
                                        hy = high.getBlockY();
                                    }
                                    int cx = Math.abs(x % 16);
                                    int cz = Math.abs(z % 16);
                                    if (chunkSnapshot == null || x >> 4 != chunkX || z >> 4 != chunkZ) {
                                        if (!world.getBlockAt(x, 0, z).getChunk().isLoaded()) {
                                            world.getBlockAt(x, 0, z).getChunk().load();
                                            chunkSnapshot = world.getBlockAt(x, 0, z).getChunk().getChunkSnapshot(false, false, false);
                                            world.getBlockAt(x, 0, z).getChunk().unload();
                                        } else {
                                            chunkSnapshot = world.getBlockAt(x, 0, z).getChunk().getChunkSnapshot();
                                        }
                                        chunkX = x >> 4;
                                        chunkZ = z >> 4;
                                    }
                                    if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
                                        int y = low.getBlockY();
                                        while (y <= hy) {
                                            BlockData type = chunkSnapshot.getBlockData(cx, y, cz);
                                            if (this.plugin.getConfigManager().getCleanBlocks().contains(type.getMaterial())) {
                                                locations.add(new Location(world, (double)x, (double)y, (double)z));
                                            }
                                            ++y;
                                        }
                                    }
                                    ++z;
                                }
                                ++x;
                            }
                        }
                        ++n2;
                    }
                    CMIScheduler.runTask(() -> {
                        for (Location one : locations) {
                            CMIScheduler.runAtLocation((Location)one, () -> one.getBlock().setType(Material.AIR));
                        }
                    });
                });
            }
            if (this.plugin.getConfigManager().isRemoveLwcOnDelete() && this.plugin.isLwcPresent()) {
                ResidenceLWCListener.removeLwcFromResidence(player, res);
            }
            if (regenerate) {
                CuboidArea[] cuboidAreaArray = res.getAreaArray();
                int n = cuboidAreaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CuboidArea one = cuboidAreaArray[n2];
                    this.plugin.getSelectionManager().regenerate(one);
                    ++n2;
                }
            }
            this.plugin.msg((CommandSender)player, lm.Residence_Remove, name);
        } else {
            String[] split = name.split("\\.");
            if (player != null) {
                parent.removeSubzone(player, split[split.length - 1], true);
            } else {
                parent.removeSubzone(split[split.length - 1]);
            }
        }
        this.plugin.getLeaseManager().removeExpireTime(res);
        for (ClaimedResidence oneSub : res.getSubzones()) {
            this.plugin.getPlayerManager().removeResFromPlayer(res.getOwnerUUID(), oneSub);
            this.plugin.getRentManager().removeRentable(String.valueOf(name) + "." + oneSub.getResidenceName());
            this.plugin.getTransactionManager().removeFromSale(String.valueOf(name) + "." + oneSub.getResidenceName());
        }
        this.plugin.getPlayerManager().removeResFromPlayer(res.getOwnerUUID(), res);
        this.plugin.getRentManager().removeRentable(name);
        this.plugin.getTransactionManager().removeFromSale(name);
        if (!res.isServerLand()) {
            if (parent == null && this.plugin.getConfigManager().enableEconomy() && this.plugin.getConfigManager().useResMoneyBack()) {
                double chargeamount = res.getWorth();
                if (!res.isOwner(player)) {
                    this.plugin.getTransactionManager().giveEconomyMoney(res.getOwner(), chargeamount);
                } else if (player != null) {
                    this.plugin.getTransactionManager().giveEconomyMoney(player, chargeamount);
                } else if (rPlayer != null) {
                    this.plugin.getTransactionManager().giveEconomyMoney(rPlayer.getPlayerName(), chargeamount);
                }
            }
            if (res.getBank().getStoredMoneyD() > 0.0 && this.plugin.getConfigManager().isResBankBack()) {
                this.plugin.getTransactionManager().giveEconomyMoney(res.getOwner(), (double)res.getBank().getStoredMoneyD());
            }
        }
    }

    public void removeAllByOwner(String owner) {
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(owner);
        for (ClaimedResidence oneRes : rPlayer.getResList()) {
            this.removeResidence(rPlayer, oneRes, true);
        }
    }

    public int getOwnedZoneCount(String player) {
        ResidencePlayer rPlayer = this.plugin.getPlayerManager().getResidencePlayer(player);
        return rPlayer.getResAmount();
    }

    public boolean hasMaxZones(String player, int target) {
        return this.getOwnedZoneCount(player) < target;
    }

    public void printAreaInfo(String areaname, CommandSender sender) {
        this.printAreaInfo(areaname, sender, false);
    }

    public void printAreaInfo(String areaname, CommandSender sender, boolean resadmin2) {
        String time;
        RawMessage rm;
        ClaimedResidence res = this.getByName(areaname);
        if (res == null) {
            this.plugin.msg(sender, lm.Invalid_Residence, new Object[0]);
            return;
        }
        areaname = res.getName();
        this.plugin.msg(sender, lm.General_Separator, new Object[0]);
        ResidencePermissions perms = res.getPermissions();
        String resNameOwner = "&e" + this.plugin.msg(lm.Residence_Line, areaname);
        resNameOwner = String.valueOf(resNameOwner) + this.plugin.msg(lm.General_Owner, perms.getOwner());
        if (this.plugin.getConfigManager().enableEconomy() && (res.isOwner(sender) || !(sender instanceof Player) || resadmin2)) {
            resNameOwner = String.valueOf(resNameOwner) + this.plugin.msg(lm.Bank_Name, res.getBank().getStoredMoneyFormated());
        }
        resNameOwner = CMIChatColor.translate((String)resNameOwner);
        String worldInfo = this.plugin.msg(lm.General_World, perms.getWorldName());
        if (res.getAreaArray().length > 0 && (res.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || resadmin2)) {
            CuboidArea area2 = res.getAreaArray()[0];
            String cord1 = this.plugin.msg(lm.General_CoordsTop, area2.getHighVector().getBlockX(), area2.getHighVector().getBlockY(), area2.getHighVector().getBlockZ());
            String cord2 = this.plugin.msg(lm.General_CoordsBottom, area2.getLowVector().getBlockX(), area2.getLowVector().getBlockY(), area2.getLowVector().getBlockZ());
            worldInfo = String.valueOf(worldInfo) + CMIChatColor.translate((String)this.plugin.msg(lm.General_CoordsLiner, cord1, cord2));
        }
        worldInfo = String.valueOf(worldInfo) + "\n" + this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(res.createTime));
        String ResFlagList = perms.listFlags(5);
        if (!(sender instanceof Player)) {
            ResFlagList = perms.listFlags();
        }
        String ResFlagMsg = this.plugin.msg(lm.General_ResidenceFlags, ResFlagList);
        if (perms.getFlags().size() > 2 && sender instanceof Player) {
            ResFlagMsg = String.valueOf(this.plugin.msg(lm.General_ResidenceFlags, perms.listFlags(5, 3))) + "...";
        }
        if (sender instanceof Player) {
            rm = new RawMessage();
            rm.addText(resNameOwner).addHover(worldInfo);
            rm.show(sender);
            rm = new RawMessage();
            rm.addText(ResFlagMsg).addHover(ResFlagList);
            rm.show(sender);
        } else {
            this.plugin.msg(sender, resNameOwner);
            this.plugin.msg(sender, worldInfo);
            this.plugin.msg(sender, ResFlagMsg);
        }
        if (!this.plugin.getConfigManager().isShortInfoUse() || !(sender instanceof Player)) {
            sender.sendMessage(this.plugin.msg(lm.General_PlayersFlags, perms.listPlayersFlags()));
        } else if (this.plugin.getConfigManager().isShortInfoUse() || sender instanceof Player) {
            rm = perms.listPlayersFlagsRaw(sender.getName(), this.plugin.msg(lm.General_PlayersFlags, ""));
            rm.addCommand("res info " + res.getName() + " -players");
            rm.show(sender);
        }
        String groupFlags = perms.listGroupFlags();
        if (groupFlags.length() > 0) {
            this.plugin.msg(sender, lm.General_GroupFlags, groupFlags);
        }
        RawMessage rm2 = new RawMessage();
        rm2.addText(this.plugin.msg(lm.General_TotalResSize, res.getTotalSize(), res.getXZSize()));
        try {
            rm2.addHover(Arrays.asList(this.plugin.msg(lm.General_ResSize_eastWest, res.getMainArea().getXSize()), this.plugin.msg(lm.General_ResSize_northSouth, res.getMainArea().getZSize()), this.plugin.msg(lm.General_ResSize_upDown, res.getMainArea().getYSize())));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        rm2.show(sender);
        if (this.plugin.getEconomyManager() != null) {
            this.plugin.msg(sender, lm.General_TotalWorth, this.plugin.getEconomyManager().format(res.getWorthByOwner()), this.plugin.getEconomyManager().format(res.getWorth()));
        }
        if (res.getSubzonesAmount(false) > 0) {
            this.plugin.msg(sender, lm.General_TotalSubzones, res.getSubzonesAmount(false), res.getSubzonesAmount(true));
        }
        if (this.plugin.getConfigManager().useLeases() && this.plugin.getLeaseManager().isLeased(res) && (time = this.plugin.getLeaseManager().getExpireTime(res)) != null) {
            this.plugin.msg(sender, lm.Economy_LeaseExpire, time);
        }
        if (this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isForRent(areaname) && !this.plugin.getRentManager().isRented(areaname)) {
            String forRentMsg = this.plugin.msg(lm.Rent_isForRent, new Object[0]);
            RentableLand rentable = this.plugin.getRentManager().getRentableLand(areaname);
            StringBuilder rentableString = new StringBuilder();
            if (rentable != null) {
                rentableString.append(String.valueOf(this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days)) + "\n");
                rentableString.append(String.valueOf(this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing)) + "\n");
                rentableString.append(String.valueOf(this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket)) + "\n");
                rentableString.append(this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
            }
            if (sender instanceof Player) {
                rm2 = new RawMessage();
                rm2.addText(forRentMsg).addHover(rentableString.toString());
                rm2.show(sender);
            } else {
                this.plugin.msg(sender, forRentMsg);
            }
        } else if (this.plugin.getConfigManager().enabledRentSystem() && this.plugin.getRentManager().isRented(areaname)) {
            String RentedMsg = this.plugin.msg(lm.Residence_RentedBy, this.plugin.getRentManager().getRentingPlayer(areaname));
            RentableLand rentable = this.plugin.getRentManager().getRentableLand(areaname);
            RentedLand rented = this.plugin.getRentManager().getRentedLand(areaname);
            StringBuilder rentableString = new StringBuilder();
            if (rented != null) {
                rentableString.append(String.valueOf(this.plugin.msg(lm.Rent_Expire, GetTime.getTime(rented.endTime))) + "\n");
                if (rented.player.equals(sender.getName()) || resadmin2 || res.isOwner(sender)) {
                    rentableString.append(String.valueOf(rented.AutoPay ? this.plugin.msg(lm.Rent_AutoPayTurnedOn, new Object[0]) : this.plugin.msg(lm.Rent_AutoPayTurnedOff, new Object[0])) + "\n");
                }
            }
            if (rentable != null) {
                rentableString.append(String.valueOf(this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days)) + "\n");
                rentableString.append(String.valueOf(this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing)) + "\n");
                rentableString.append(String.valueOf(this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket)) + "\n");
                rentableString.append(this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
            }
            if (sender instanceof Player) {
                rm2 = new RawMessage();
                rm2.addText(RentedMsg).addHover(rentableString.toString());
                rm2.show(sender);
            } else {
                this.plugin.msg(sender, RentedMsg);
            }
        } else if (this.plugin.getTransactionManager().isForSale(areaname)) {
            int amount = this.plugin.getTransactionManager().getSaleAmount(areaname);
            String SellMsg = String.valueOf(this.plugin.msg(lm.Economy_LandForSale, new Object[0])) + " " + amount;
            this.plugin.msg(sender, SellMsg);
        }
        this.plugin.msg(sender, lm.General_Separator, new Object[0]);
    }

    public void printAreaPlayers(String areaname, final CommandSender sender, int page) {
        final ClaimedResidence res = this.getByName(areaname);
        if (res == null) {
            this.plugin.msg(sender, lm.Invalid_Residence, new Object[0]);
            return;
        }
        areaname = res.getName();
        this.plugin.msg(sender, lm.General_Separator, new Object[0]);
        ResidencePermissions perms = res.getPermissions();
        perms.listPlayers(sender, null, page);
        PageInfo pi = new PageInfo(10, perms.getPlayerFlags().size(), page){

            public Boolean pageChange(int page) {
                ResidenceManager.this.printAreaPlayers(res.getName(), sender, page);
                return null;
            }
        };
        pi.autoPagination(sender, "res info " + areaname + " -players", "-p:");
    }

    public void mirrorPerms(Player reqPlayer, String targetArea, String sourceArea, boolean resadmin2) {
        ClaimedResidence reciever = this.getByName(targetArea);
        ClaimedResidence source = this.getByName(sourceArea);
        if (source == null || reciever == null) {
            this.plugin.msg((CommandSender)reqPlayer, lm.Invalid_Residence, new Object[0]);
            return;
        }
        if (!(resadmin2 || reciever.getPermissions().hasResidencePermission((CommandSender)reqPlayer, true) && source.getPermissions().hasResidencePermission((CommandSender)reqPlayer, true))) {
            this.plugin.msg((CommandSender)reqPlayer, lm.General_NoPermission, new Object[0]);
            return;
        }
        reciever.getPermissions().applyTemplate(reqPlayer, source.getPermissions(), resadmin2);
    }

    public Map<String, Object> save() {
        this.clearSaveChache();
        LinkedHashMap<String, Object> worldmap = new LinkedHashMap<String, Object>();
        for (String worldName : this.getWorldNames()) {
            LinkedHashMap<String, Map<String, Object>> resmap = new LinkedHashMap<String, Map<String, Object>>();
            for (Map.Entry<String, ClaimedResidence> res : new TreeMap<String, ClaimedResidence>(this.residences).entrySet()) {
                if (!res.getValue().getWorld().equals(worldName)) continue;
                try {
                    resmap.put(res.getValue().getResidenceName(), res.getValue().save());
                }
                catch (Throwable ex) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + ChatColor.RED + " Failed to save residence (" + res.getKey() + ")!");
                    Logger.getLogger(ResidenceManager.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            worldmap.put(worldName, resmap);
        }
        return worldmap;
    }

    private void clearSaveChache() {
        this.optimizeMessages.clear();
        this.optimizeFlags.clear();
    }

    public MinimizeMessages addMessageToTempCache(String world, String enter, String leave) {
        List<MinimizeMessages> ls = this.optimizeMessages.get(world);
        if (ls == null) {
            ls = new ArrayList<MinimizeMessages>();
        }
        for (MinimizeMessages one : ls) {
            if (!one.add(enter, leave)) continue;
            return one;
        }
        MinimizeMessages m = new MinimizeMessages(ls.size() + 1, enter, leave);
        ls.add(m);
        this.optimizeMessages.put(world, ls);
        return m;
    }

    public HashMap<Integer, Object> getMessageCatch(String world) {
        HashMap<Integer, Object> t = new HashMap<Integer, Object>();
        List<MinimizeMessages> ls = this.optimizeMessages.get(world);
        if (ls == null) {
            return null;
        }
        for (MinimizeMessages one : ls) {
            HashMap<String, String> root = new HashMap<String, String>();
            root.put("EnterMessage", one.getEnter());
            root.put("LeaveMessage", one.getLeave());
            t.put(one.getId(), root);
        }
        return t;
    }

    public MinimizeFlags addFlagsTempCache(String world, Map<String, Boolean> map) {
        if (world == null) {
            return null;
        }
        List<MinimizeFlags> ls = this.optimizeFlags.get(world);
        if (ls == null) {
            ls = new ArrayList<MinimizeFlags>();
        }
        for (MinimizeFlags one : ls) {
            if (!one.add(map)) continue;
            return one;
        }
        MinimizeFlags m = new MinimizeFlags(ls.size() + 1, map);
        ls.add(m);
        this.optimizeFlags.put(world, ls);
        return m;
    }

    public HashMap<Integer, Object> getFlagsCatch(String world) {
        HashMap<Integer, Object> t = new HashMap<Integer, Object>();
        List<MinimizeFlags> ls = this.optimizeFlags.get(world);
        if (ls == null) {
            return null;
        }
        for (MinimizeFlags one : ls) {
            t.put(one.getId(), one.getFlags());
        }
        return t;
    }

    private void clearLoadChache() {
        this.cacheMessages.clear();
        this.cacheFlags.clear();
    }

    public HashMap<String, HashMap<Integer, MinimizeMessages>> getCacheMessages() {
        return this.cacheMessages;
    }

    public HashMap<String, HashMap<Integer, MinimizeFlags>> getCacheFlags() {
        return this.cacheFlags;
    }

    public String getChacheMessageEnter(String world, int id) {
        HashMap<Integer, MinimizeMessages> c = this.cacheMessages.get(world);
        if (c == null) {
            return null;
        }
        MinimizeMessages m = c.get(id);
        if (m == null) {
            return null;
        }
        return m.getEnter();
    }

    public String getChacheMessageLeave(String world, int id) {
        HashMap<Integer, MinimizeMessages> c = this.cacheMessages.get(world);
        if (c == null) {
            return null;
        }
        MinimizeMessages m = c.get(id);
        if (m == null) {
            return null;
        }
        return m.getLeave();
    }

    public Map<String, Boolean> getChacheFlags(String world, int id) {
        HashMap<Integer, MinimizeFlags> c = this.cacheFlags.get(world);
        if (c == null) {
            return null;
        }
        MinimizeFlags m = c.get(id);
        if (m == null) {
            return null;
        }
        return m.getFlags();
    }

    public Set<String> getWorldNames() {
        HashSet<String> worldnames = new HashSet<String>();
        File saveFolder = new File(this.plugin.dataFolder, "Save");
        try {
            File worldFolder = new File(saveFolder, "Worlds");
            if (this.plugin.getConfigManager().isLoadEveryWorld()) {
                File[] fileArray = worldFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name;
                    File f = fileArray[n2];
                    if (f.isFile() && (name = f.getName()).startsWith("res_")) {
                        worldnames.add(name.substring("res_".length(), name.length() - 4));
                    }
                    ++n2;
                }
            }
            this.plugin.getServ().getWorlds().forEach(w -> worldnames.add(w.getName()));
        }
        catch (Exception ex) {
            this.plugin.getServ().getWorlds().forEach(w -> worldnames.add(w.getName()));
            Logger.getLogger(Residence.class.getName()).log(Level.SEVERE, null, ex);
            throw ex;
        }
        return worldnames;
    }

    public void load(Map<String, Object> root) throws Exception {
        if (root == null) {
            return;
        }
        this.residences.clear();
        for (String worldName : this.getWorldNames()) {
            long pass;
            String PastTime;
            Map reslist;
            long time;
            block6: {
                time = System.currentTimeMillis();
                reslist = (Map)root.get(worldName);
                if (!this.plugin.isDisabledWorld(worldName) && !this.plugin.getConfigManager().CleanerStartupLog) {
                    Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Loading " + worldName + " data into memory...");
                }
                if (reslist != null) {
                    try {
                        this.chunkResidences.put(worldName, this.multithreadLoadMap(worldName, reslist));
                    }
                    catch (Exception ex) {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + ChatColor.RED + "Error in loading save file for world: " + worldName);
                        if (!this.plugin.getConfigManager().stopOnSaveError()) break block6;
                        throw ex;
                    }
                }
            }
            String string = PastTime = (pass = System.currentTimeMillis() - time) > 1000L ? String.valueOf(String.format("%.2f", Float.valueOf((float)pass / 1000.0f))) + " sec" : String.valueOf(pass) + " ms";
            if (this.plugin.isDisabledWorld(worldName)) continue;
            Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " Loaded " + worldName + " data into memory. (" + PastTime + ") -> " + (reslist == null ? "0" : Integer.valueOf(reslist.size())) + " residences");
        }
        this.clearLoadChache();
    }

    public Map<ChunkRef, List<ClaimedResidence>> multithreadLoadMap(String worldName, Map<String, Object> root) throws InterruptedException, ExecutionException {
        ConcurrentHashMap<ChunkRef, List<ClaimedResidence>> retRes = new ConcurrentHashMap<ChunkRef, List<ClaimedResidence>>();
        if (root == null) {
            return retRes;
        }
        this.chunkCount = 0;
        int numCores = Runtime.getRuntime().availableProcessors();
        ExecutorService executorService = Executors.newFixedThreadPool(numCores);
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        int batchSize = (int)Math.ceil((double)root.entrySet().size() / (double)numCores);
        batchSize = CMINumber.clamp((int)batchSize, (int)500, (int)root.entrySet().size());
        int i = 0;
        ArrayList<Map.Entry<String, Object>> batch = new ArrayList<Map.Entry<String, Object>>();
        int total = root.entrySet().size() - 1;
        for (Map.Entry<String, Object> entry : root.entrySet()) {
            batch.add(entry);
            if (batch.size() < batchSize && i < total) {
                ++i;
                continue;
            }
            ArrayList<Map.Entry<String, Object>> currentBatch = batch;
            batch = new ArrayList();
            ++i;
            Future<Void> future = executorService.submit(() -> {
                for (Map.Entry currentEntry : currentBatch) {
                    try {
                        ClaimedResidence residence = ClaimedResidence.load(worldName, (Map)currentEntry.getValue(), null, this.plugin);
                        if (residence == null || residence.getPermissions().getOwnerUUID().toString().equals(this.plugin.getServerLandUUID()) && !residence.getOwner().equalsIgnoreCase("Server land") && !residence.getOwner().equalsIgnoreCase(this.plugin.getServerLandName())) continue;
                        if (residence.getOwner().equalsIgnoreCase("Server land")) {
                            residence.getPermissions().setOwner(this.plugin.getServerLandName(), false);
                        }
                        String resName = ((String)currentEntry.getKey()).toLowerCase();
                        int increment = this.getNameIncrement(resName);
                        if (residence.getResidenceName() == null) {
                            residence.setName((String)currentEntry.getKey());
                        }
                        if (increment > 0) {
                            residence.setName(String.valueOf(residence.getResidenceName()) + increment);
                            resName = String.valueOf(resName) + increment;
                        }
                        for (ChunkRef chunk : ResidenceManager.getChunks(residence)) {
                            retRes.compute(chunk, (k, v) -> {
                                if (v == null) {
                                    v = new ArrayList<ClaimedResidence>();
                                }
                                v.add(residence);
                                return v;
                            });
                        }
                        this.plugin.getPlayerManager().addResidence(residence.getOwner(), residence);
                        this.residences.put(resName, residence);
                    }
                    catch (Exception ex) {
                        Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + ChatColor.RED + " Failed to load residence (" + (String)currentEntry.getKey() + ")! Reason:" + ex.getMessage() + " Error Log:");
                        Logger.getLogger(ResidenceManager.class.getName()).log(Level.SEVERE, null, ex);
                        if (!this.plugin.getConfigManager().stopOnSaveError()) continue;
                        throw new RuntimeException(ex);
                    }
                }
                return null;
            });
            futures.add(future);
        }
        for (Future future : futures) {
            future.get();
        }
        executorService.shutdown();
        return retRes;
    }

    public Map<ChunkRef, List<ClaimedResidence>> loadMap(String worldName, Map<String, Object> root) throws Exception {
        HashMap<ChunkRef, List<ClaimedResidence>> retRes = new HashMap<ChunkRef, List<ClaimedResidence>>();
        if (root == null) {
            return retRes;
        }
        int i = 0;
        int y = 0;
        for (Map.Entry<String, Object> res : root.entrySet()) {
            if (i == 100 && this.plugin.getConfigManager().isUUIDConvertion()) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + " " + worldName + " UUID conversion done: " + y + " of " + root.size());
            }
            if (i >= 100) {
                i = 0;
            }
            ++i;
            ++y;
            try {
                ClaimedResidence residence = ClaimedResidence.load(worldName, (Map)res.getValue(), null, this.plugin);
                if (residence == null || residence.getPermissions().getOwnerUUID().toString().equals(this.plugin.getServerLandUUID()) && !residence.getOwner().equalsIgnoreCase("Server land") && !residence.getOwner().equalsIgnoreCase(this.plugin.getServerLandName())) continue;
                if (residence.getOwner().equalsIgnoreCase("Server land")) {
                    residence.getPermissions().setOwner(this.plugin.getServerLandName(), false);
                }
                String resName = res.getKey().toLowerCase();
                int increment = this.getNameIncrement(resName);
                if (residence.getResidenceName() == null) {
                    residence.setName(res.getKey());
                }
                if (increment > 0) {
                    residence.setName(String.valueOf(residence.getResidenceName()) + increment);
                    resName = String.valueOf(resName) + increment;
                }
                for (ChunkRef chunk : ResidenceManager.getChunks(residence)) {
                    ArrayList<ClaimedResidence> ress = new ArrayList<ClaimedResidence>();
                    if (retRes.containsKey(chunk)) {
                        ress.addAll((Collection)retRes.get(chunk));
                    }
                    ress.add(residence);
                    retRes.put(chunk, ress);
                }
                this.plugin.getPlayerManager().addResidence(residence.getOwner(), residence);
                this.residences.put(resName.toLowerCase(), residence);
            }
            catch (Exception ex) {
                Bukkit.getConsoleSender().sendMessage(String.valueOf(this.plugin.getPrefix()) + ChatColor.RED + " Failed to load residence (" + res.getKey() + ")! Reason:" + ex.getMessage() + " Error Log:");
                Logger.getLogger(ResidenceManager.class.getName()).log(Level.SEVERE, null, ex);
                if (!this.plugin.getConfigManager().stopOnSaveError()) continue;
                throw ex;
            }
        }
        return retRes;
    }

    private int getNameIncrement(String name) {
        String orName = name;
        int i = 0;
        while (i < 1000) {
            if (!this.residences.containsKey(name.toLowerCase())) break;
            name = String.valueOf(orName) + ++i;
        }
        return i;
    }

    private static List<ChunkRef> getChunks(ClaimedResidence res) {
        ArrayList<ChunkRef> chunks = new ArrayList<ChunkRef>();
        res.getAreaMap().values().forEach(area2 -> {
            boolean bl = chunks.addAll(area2.getChunks());
        });
        return chunks;
    }

    public boolean renameResidence(String oldName, String newName) {
        return this.renameResidence(null, oldName, newName, true);
    }

    public boolean renameResidence(Player player, String oldName, String newName, boolean resadmin2) {
        if (!PermissionManager.ResPerm.rename.hasPermission((CommandSender)player, true, new String[0])) {
            return false;
        }
        if (!this.plugin.validName(newName)) {
            this.plugin.msg((CommandSender)player, lm.Invalid_NameCharacters, new Object[0]);
            return false;
        }
        ClaimedResidence res = this.getByName(oldName);
        if (res == null) {
            this.plugin.msg((CommandSender)player, lm.Invalid_Residence, new Object[0]);
            return false;
        }
        if (res.getRaid().isRaidInitialized() && !resadmin2) {
            this.plugin.msg((CommandSender)player, lm.Raid_cantDo, new Object[0]);
            return false;
        }
        oldName = res.getName();
        if (res.getPermissions().hasResidencePermission((CommandSender)player, true) || resadmin2) {
            if (res.getParent() == null) {
                if (this.residences.containsKey(newName.toLowerCase())) {
                    this.plugin.msg((CommandSender)player, lm.Residence_AlreadyExists, newName);
                    return false;
                }
                ResidenceRenameEvent resevent = new ResidenceRenameEvent(res, newName, oldName);
                this.plugin.getServ().getPluginManager().callEvent((Event)resevent);
                this.removeChunkList(oldName);
                res.setName(newName);
                this.residences.put(newName.toLowerCase(), res);
                this.residences.remove(oldName.toLowerCase());
                this.calculateChunks(newName);
                this.plugin.getSignUtil().updateSignResName(res);
                this.plugin.msg((CommandSender)player, lm.Residence_Rename, oldName, newName);
                return true;
            }
            String[] oldname = oldName.split("\\.");
            ClaimedResidence parent = res.getParent();
            boolean feed = parent.renameSubzone(player, oldname[oldname.length - 1], newName, resadmin2);
            this.plugin.getSignUtil().updateSignResName(res);
            return feed;
        }
        this.plugin.msg((CommandSender)player, lm.General_NoPermission, new Object[0]);
        return false;
    }

    public void giveResidence(Player reqPlayer, String targPlayer, String residence, boolean resadmin2) {
        this.giveResidence(reqPlayer, targPlayer, residence, resadmin2, false);
    }

    public void giveResidence(Player reqPlayer, String targPlayer, String residence, boolean resadmin2, boolean includeSubzones) {
        this.giveResidence(reqPlayer, targPlayer, this.getByName(residence), resadmin2, includeSubzones);
    }

    public void giveResidence(Player reqPlayer, String targPlayer, ClaimedResidence res, boolean resadmin2, boolean includeSubzones) {
        ResidencePlayer rPlayer;
        PermissionGroup group;
        if (res == null) {
            this.plugin.msg((CommandSender)reqPlayer, lm.Invalid_Residence, new Object[0]);
            return;
        }
        String residence = res.getName();
        if (!res.getPermissions().hasResidencePermission((CommandSender)reqPlayer, true) && !resadmin2) {
            this.plugin.msg((CommandSender)reqPlayer, lm.General_NoPermission, new Object[0]);
            return;
        }
        Player giveplayer = this.plugin.getServ().getPlayer(targPlayer);
        if (giveplayer == null || !giveplayer.isOnline()) {
            this.plugin.msg((CommandSender)reqPlayer, lm.General_NotOnline, new Object[0]);
            return;
        }
        CuboidArea[] areas = res.getAreaArray();
        if (areas.length > (group = (rPlayer = this.plugin.getPlayerManager().getResidencePlayer(giveplayer)).getGroup()).getMaxPhysicalPerResidence() && !resadmin2) {
            this.plugin.msg((CommandSender)reqPlayer, lm.Residence_GiveLimits, new Object[0]);
            return;
        }
        if (!this.hasMaxZones(giveplayer.getName(), rPlayer.getMaxRes()) && !resadmin2) {
            this.plugin.msg((CommandSender)reqPlayer, lm.Residence_GiveLimits, new Object[0]);
            return;
        }
        if (!resadmin2) {
            CuboidArea[] cuboidAreaArray = areas;
            int n = areas.length;
            int n2 = 0;
            while (n2 < n) {
                CuboidArea area2 = cuboidAreaArray[n2];
                if (!res.isSubzone() && !res.isSmallerThanMax(giveplayer, area2, resadmin2) || res.isSubzone() && !res.isSmallerThanMaxSubzone(giveplayer, area2, resadmin2)) {
                    this.plugin.msg((CommandSender)reqPlayer, lm.Residence_GiveLimits, new Object[0]);
                    return;
                }
                ++n2;
            }
        }
        if (!res.getPermissions().setOwner(giveplayer, true)) {
            return;
        }
        this.plugin.msg((CommandSender)reqPlayer, lm.Residence_Give, residence, giveplayer.getName());
        this.plugin.msg((CommandSender)giveplayer, lm.Residence_Recieve, residence, reqPlayer.getName());
        this.plugin.getSignUtil().updateSignResName(res);
        if (includeSubzones) {
            for (ClaimedResidence one : res.getSubzones()) {
                this.giveResidence(reqPlayer, targPlayer, one, resadmin2, includeSubzones);
            }
        }
    }

    public void removeAllFromWorld(CommandSender sender, String world) {
        this.removeAllFromWorld(sender, world, null);
    }

    public void removeAllFromWorld(CommandSender sender, String world, List<String> playerExceptions) {
        int count = 0;
        Iterator<ClaimedResidence> it = this.residences.values().iterator();
        while (it.hasNext()) {
            ClaimedResidence next = it.next();
            if (!next.getPermissions().getWorldName().equals(world) || playerExceptions != null && !playerExceptions.isEmpty() && (playerExceptions.contains(next.getOwner().toLowerCase()) || playerExceptions.contains(next.getOwnerUUID().toString()))) continue;
            it.remove();
            ++count;
        }
        this.chunkResidences.remove(world);
        this.chunkResidences.put(world, new HashMap());
        if (count == 0) {
            sender.sendMessage(ChatColor.RED + "No residences found in world: " + ChatColor.YELLOW + world);
        } else {
            sender.sendMessage(ChatColor.RED + "Removed " + ChatColor.YELLOW + count + ChatColor.RED + " residences in world: " + ChatColor.YELLOW + world);
        }
    }

    public int getResidenceCount() {
        return this.residences.size();
    }

    public Map<String, ClaimedResidence> getResidences() {
        return this.residences;
    }

    public void removeChunkList(String name) {
        if (name == null) {
            return;
        }
        ClaimedResidence res = this.residences.get(name = name.toLowerCase());
        if (res == null) {
            return;
        }
        String world = res.getWorld();
        if (this.chunkResidences.get(world) == null) {
            return;
        }
        for (ChunkRef chunk : ResidenceManager.getChunks(res)) {
            ArrayList ress = new ArrayList();
            if (this.chunkResidences.get(world).containsKey(chunk)) {
                ress.addAll(this.chunkResidences.get(world).get(chunk));
            }
            ress.remove(res);
            this.chunkResidences.get(world).put(chunk, ress);
        }
    }

    public void calculateChunks(String name) {
        if (name == null) {
            return;
        }
        ClaimedResidence res = this.residences.get(name = name.toLowerCase());
        if (res == null) {
            return;
        }
        String world = res.getWorld();
        if (this.chunkResidences.get(world) == null) {
            this.chunkResidences.put(world, new HashMap());
        }
        for (ChunkRef chunk : ResidenceManager.getChunks(res)) {
            ArrayList<ClaimedResidence> ress = new ArrayList<ClaimedResidence>();
            if (this.chunkResidences.get(world).containsKey(chunk)) {
                ress.addAll((Collection)this.chunkResidences.get(world).get(chunk));
            }
            ress.add(res);
            this.chunkResidences.get(world).put(chunk, ress);
        }
    }

    public static final class ChunkRef {
        private final int z;
        private final int x;

        public static int getChunkCoord(int val) {
            return val >> 4;
        }

        public ChunkRef(Location loc) {
            this.x = ChunkRef.getChunkCoord(loc.getBlockX());
            this.z = ChunkRef.getChunkCoord(loc.getBlockZ());
        }

        public ChunkRef(int x, int z) {
            this.x = x;
            this.z = z;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChunkRef other = (ChunkRef)obj;
            return this.x == other.x && this.z == other.z;
        }

        public int hashCode() {
            return this.x ^ this.z;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ x: ").append(this.x).append(", z: ").append(this.z).append(" }");
            return sb.toString();
        }

        public int getZ() {
            return this.z;
        }

        public int getX() {
            return this.x;
        }
    }
}

