/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.selection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Visualizer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.SimpleChunkLocation;
import org.kingdoms.manager.game.GameManagement;

public class KingdomsUtil {
    private Residence plugin;

    public KingdomsUtil(Residence residence) {
        this.plugin = residence;
    }

    private Land getRegion(CuboidArea area2) {
        if (this.plugin.getKingdomsManager() == null) {
            return null;
        }
        if (area2 == null) {
            return null;
        }
        Chunk loc1 = area2.getLowLocation().getChunk();
        Chunk loc2 = area2.getHighLocation().getChunk();
        World world = loc1.getWorld();
        int x = loc1.getX();
        while (x <= loc2.getX()) {
            int z = loc1.getZ();
            while (z <= loc2.getZ()) {
                Chunk tchunk = world.getChunkAt(x, z);
                SimpleChunkLocation sChunk = new SimpleChunkLocation(tchunk);
                Land land = GameManagement.getLandManager().getOrLoadLand(sChunk);
                if (land != null && land.getOwner() != null) {
                    return land;
                }
                ++z;
            }
            ++x;
        }
        return null;
    }

    public boolean isSelectionInArea(Player player) {
        if (this.plugin.getKingdomsManager() == null) {
            return false;
        }
        Land land = this.getRegion(this.plugin.getSelectionManager().getSelectionCuboid(player));
        if (land == null) {
            return false;
        }
        this.plugin.msg((CommandSender)player, lm.Select_KingdomsOverlap, land.getOwner());
        SimpleChunkLocation sl = land.getLoc();
        World world = Bukkit.getWorld((String)sl.getWorld());
        Location lowLoc = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player).getWorld(), (double)(sl.getX() * 16), 0.0, (double)(sl.getZ() * 16));
        Location highLoc = new Location(this.plugin.getSelectionManager().getPlayerLoc1(player).getWorld(), (double)(sl.getX() * 16 + 16), (double)world.getMaxHeight(), (double)(sl.getZ() * 16 + 16));
        Visualizer v = new Visualizer(player);
        v.setAreas(this.plugin.getSelectionManager().getSelectionCuboid(player));
        v.setErrorAreas(new CuboidArea(lowLoc, highLoc));
        this.plugin.getSelectionManager().showBounds(player, v);
        return true;
    }
}

