/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.commands;

import com.bekvon.bukkit.residence.LocaleManager;
import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.CommandAnnotation;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.cmd;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.selection.SelectionManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Random;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.RawMessages.RawMessage;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class auto
implements cmd {
    @Override
    @CommandAnnotation(simple=true, priority=150, regVar={0, 1, 2}, consoleVar={666})
    public Boolean perform(Residence plugin, CommandSender sender, String[] args, boolean resadmin2) {
        double ratioX;
        Player player = (Player)sender;
        String resName = null;
        int length = -1;
        if (args.length == 1) {
            try {
                length = Integer.parseInt(args[0]);
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        resName = args.length > 0 && length == -1 ? args[0] : player.getName();
        if (args.length == 2) {
            resName = args[0];
            try {
                length = Integer.parseInt(args[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Residence.getInstance().getPlayerManager().getResidencePlayer(player).forceUpdateGroup();
        Location loc = player.getLocation();
        int minY = loc.getBlockY();
        int maxY = loc.getBlockY();
        if (plugin.getConfigManager().isSelectionIgnoreY()) {
            minY = plugin.getSelectionManager().getSelection(player).getMinYAllowed();
            maxY = plugin.getSelectionManager().getSelection(player).getMaxYAllowed();
        }
        loc.setY((double)minY);
        plugin.getSelectionManager().placeLoc1(player, loc.clone(), false);
        loc.setY((double)maxY);
        plugin.getSelectionManager().placeLoc2(player, loc.clone(), false);
        CuboidArea cuboid = plugin.getSelectionManager().getSelectionCuboid(player);
        boolean result = false;
        result = plugin.getConfigManager().isARCOldMethod() ? auto.resize(plugin, player, cuboid, true, length) : auto.optimizedResize(plugin, player, cuboid, true, length);
        plugin.getSelectionManager().afterSelectionUpdate(player, true);
        if (!result) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_SizeLimit, new Object[0]);
            return true;
        }
        ClaimedResidence collision = Residence.getInstance().getResidenceManager().collidesWithResidence(plugin.getSelectionManager().getSelectionCuboid(player));
        if (collision != null) {
            Residence.getInstance().msg((CommandSender)player, lm.Area_Collision, collision.getResidenceName());
            return null;
        }
        if (plugin.getResidenceManager().getByName(resName) != null) {
            int i = 1;
            while (i < 50) {
                String tempName = String.valueOf(resName) + plugin.getConfigManager().ARCIncrementFormat().replace("[number]", String.valueOf(i));
                if (plugin.getResidenceManager().getByName(tempName) == null) {
                    resName = tempName;
                    break;
                }
                ++i;
            }
        }
        if (resName == null) {
            resName = String.valueOf(sender.getName()) + plugin.getConfigManager().ARCIncrementFormat().replace("[number]", String.valueOf(new Random().nextInt(99950) + 50));
        }
        SelectionManager.Selection selection = plugin.getSelectionManager().getSelection(player);
        String maxSide = "";
        String minSide = "";
        double maxRatio = 0.0;
        if (plugin.getConfigManager().isSelectionIgnoreY()) {
            ratioX = this.getRatio(selection.getBaseArea().getXSize(), selection.getBaseArea().getXSize(), selection.getBaseArea().getZSize());
            double ratioZ = this.getRatio(selection.getBaseArea().getZSize(), selection.getBaseArea().getXSize(), selection.getBaseArea().getXSize());
            if (ratioX > maxRatio) {
                maxSide = "Z";
                minSide = "X";
                maxRatio = ratioX;
            }
            if (ratioZ > maxRatio) {
                maxSide = "X";
                minSide = "Z";
                maxRatio = ratioZ;
            }
        } else {
            ratioX = this.getRatio(selection.getBaseArea().getXSize(), selection.getBaseArea().getYSize(), selection.getBaseArea().getZSize());
            double ratioY = this.getRatio(selection.getBaseArea().getYSize(), selection.getBaseArea().getZSize(), selection.getBaseArea().getXSize());
            double ratioZ = this.getRatio(selection.getBaseArea().getZSize(), selection.getBaseArea().getYSize(), selection.getBaseArea().getXSize());
            if (ratioX > maxRatio) {
                maxSide = "Z";
                minSide = "X";
                maxRatio = ratioX;
            }
            if (ratioZ > maxRatio) {
                maxSide = "X";
                minSide = "Z";
                maxRatio = ratioZ;
            }
            if (ratioY > maxRatio) {
                maxSide = "X";
                minSide = "Y";
                maxRatio = ratioY;
            }
        }
        if (maxRatio > (double)plugin.getConfigManager().getARCRatioValue()) {
            if (plugin.getConfigManager().isARCRatioInform()) {
                Residence.getInstance().msg((CommandSender)player, lm.Area_WeirdShape, maxSide, (double)((int)(maxRatio * 100.0)) / 100.0, minSide);
            }
            if (plugin.getConfigManager().isARCRatioConfirmation()) {
                RawMessage rm = new RawMessage();
                rm.addText(Residence.getInstance().msg(lm.info_clickToConfirm, new Object[0]));
                rm.addHover(Residence.getInstance().msg(lm.info_clickToConfirm, new Object[0]));
                rm.addCommand(String.valueOf(resadmin2 ? "resadmin" : "res") + " create " + resName);
                rm.show(sender);
                return true;
            }
        }
        player.performCommand(String.valueOf(resadmin2 ? "resadmin" : "res") + " create " + resName);
        return true;
    }

    private double getRatio(int v1, int v2, int v3) {
        double ratio = (double)v2 / (double)v1;
        if ((double)(v3 / v1) > ratio) {
            ratio = (double)v3 / (double)v1;
        }
        return ratio;
    }

    private static int getMax(int max) {
        if (!Residence.getInstance().getConfigManager().isARCSizeEnabled()) {
            return max;
        }
        int arcmin = Residence.getInstance().getConfigManager().getARCSizeMin();
        int arcmax = Residence.getInstance().getConfigManager().getARCSizeMax();
        int maxV = (int)((double)max * ((double)Residence.getInstance().getConfigManager().getARCSizePercentage() / 100.0));
        maxV = maxV < arcmin && arcmin < max ? arcmin : maxV;
        maxV = maxV > arcmax ? arcmax : maxV;
        return maxV;
    }

    private static int getMin(int min, int max) {
        if (!Residence.getInstance().getConfigManager().isARCSizeEnabled()) {
            return min;
        }
        int percent = (int)((double)max * ((double)Residence.getInstance().getConfigManager().getARCSizePercentage() / 100.0));
        int arcmin = Residence.getInstance().getConfigManager().getARCSizeMin();
        int arcmax = Residence.getInstance().getConfigManager().getARCSizeMax();
        int pmin = arcmin < percent ? percent : arcmin;
        int newmin = min < pmin ? pmin : min;
        newmin = newmin > arcmax ? arcmin : newmin;
        int n = newmin = newmin > max ? max : newmin;
        if (newmin >= max) {
            newmin = (int)((double)min + (double)(max - min) * ((double)Residence.getInstance().getConfigManager().getARCSizePercentage() / 100.0));
        }
        return newmin;
    }

    public static boolean resize(Residence plugin, Player player, CuboidArea cuboid, boolean checkBalance, int max) {
        ResidencePlayer rPlayer = plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        double cost = cuboid.getCost(group);
        double balance = 0.0;
        if (plugin.getEconomyManager() != null) {
            balance = plugin.getEconomyManager().getBalance(player.getName());
        }
        direction dir = direction.Top;
        ArrayList<direction> locked = new ArrayList<direction>();
        boolean checkCollision = plugin.getConfigManager().isARCCheckCollision();
        int skipped = 0;
        int done = 0;
        int groupMaxX = rPlayer.getMaxX();
        int groupMaxZ = rPlayer.getMaxZ();
        int maxX = auto.getMax(groupMaxX);
        int maxY = auto.getMax(group.getMaxY());
        int maxZ = auto.getMax(groupMaxZ);
        if (maxX > max && max > 0) {
            maxX = max;
        }
        if (maxY > max && max > 0) {
            maxY = max;
        }
        if (maxZ > max && max > 0) {
            maxZ = max;
        }
        if (maxX <= 1) {
            maxX = (rPlayer.getMaxX() - group.getMinX()) / 2 + group.getMinX();
        }
        if (maxY <= 1) {
            maxY = (group.getMaxY() - group.getMinY()) / 2 + group.getMinY();
        }
        if (maxZ <= 1) {
            maxZ = (rPlayer.getMaxZ() - group.getMinZ()) / 2 + group.getMinZ();
        }
        int minY = CMIWorld.getMinHeight((World)cuboid.getWorld());
        while (true) {
            if (Residence.getInstance().getConfigManager().isSelectionIgnoreY() && (dir.equals((Object)direction.Top) || dir.equals((Object)direction.Bottom))) {
                dir = dir.getNext();
                continue;
            }
            if (skipped >= 6 || ++done > 100000) break;
            if (locked.contains((Object)dir)) {
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            CuboidArea c = new CuboidArea();
            c.setLowLocation(cuboid.getLowLocation().clone().add(-dir.getLow().getX(), -dir.getLow().getY(), -dir.getLow().getZ()));
            c.setHighLocation(cuboid.getHighLocation().clone().add(dir.getHigh().getX(), dir.getHigh().getY(), dir.getHigh().getZ()));
            if ((dir.equals((Object)direction.Top) || dir.equals((Object)direction.Bottom)) && c.getLowVector().getY() < (double)minY) {
                c.getLowVector().setY(minY);
                locked.add(dir);
                dir = dir.getNext();
                if (Residence.getInstance().getConfigManager().isSelectionIgnoreY()) continue;
                ++skipped;
                continue;
            }
            if ((dir.equals((Object)direction.Top) || dir.equals((Object)direction.Bottom)) && c.getHighVector().getY() >= (double)c.getWorld().getMaxHeight()) {
                c.getHighVector().setY(c.getWorld().getMaxHeight() - 1);
                locked.add(dir);
                dir = dir.getNext();
                if (Residence.getInstance().getConfigManager().isSelectionIgnoreY()) continue;
                ++skipped;
                continue;
            }
            if (checkCollision && plugin.getResidenceManager().collidesWithResidence(c) != null) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (maxX > 0 && maxX < c.getXSize() || c.getXSize() > groupMaxX) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (!Residence.getInstance().getConfigManager().isSelectionIgnoreY() && (maxY > 0 && maxY < c.getYSize() || c.getYSize() > group.getMaxY() + -group.getMinY())) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            if (maxZ > 0 && maxZ < c.getZSize() || c.getZSize() > groupMaxZ) {
                locked.add(dir);
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            skipped = 0;
            if (checkBalance && plugin.getConfigManager().enableEconomy()) {
                cost = c.getCost(group);
                if (!Residence.getInstance().getEconomyManager().canAfford(player, cost)) {
                    plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
                    return false;
                }
            }
            cuboid.setLowLocation(c.getLowLocation());
            cuboid.setHighLocation(c.getHighLocation());
            dir = dir.getNext();
        }
        plugin.getSelectionManager().placeLoc1(player, cuboid.getLowLocation());
        plugin.getSelectionManager().placeLoc2(player, cuboid.getHighLocation());
        cuboid = plugin.getSelectionManager().getSelectionCuboid(player);
        return cuboid.getXSize() <= groupMaxX && cuboid.getYSize() <= group.getMaxY() + -group.getMinY() && cuboid.getZSize() <= groupMaxZ;
    }

    private static void fillMaps(HashMap<direction, Integer> directionMap, HashMap<direction, Integer> maxMap, direction dir, int max, int cubeSize) {
        int maxV = (int)((double)max / 2.0 - (double)cubeSize / 2.0);
        directionMap.put(dir, maxV);
        maxMap.put(dir, maxV);
    }

    public static boolean optimizedResize(Residence plugin, Player player, CuboidArea cuboid, boolean checkBalance, int max) {
        ResidencePlayer rPlayer = plugin.getPlayerManager().getResidencePlayer(player);
        PermissionGroup group = rPlayer.getGroup();
        direction dir = direction.Top;
        ArrayList<direction> locked = new ArrayList<direction>();
        ArrayList<direction> permaLocked = new ArrayList<direction>();
        boolean checkCollision = plugin.getConfigManager().isARCCheckCollision();
        if (checkCollision && plugin.getResidenceManager().collidesWithResidence(cuboid) != null) {
            return false;
        }
        int skipped = 0;
        int done = 0;
        int maxWorldY = group.getMaxY();
        int minWorldY = group.getMinY();
        int groupMaxX = rPlayer.getMaxX();
        int groupMaxZ = rPlayer.getMaxZ();
        int maxX = auto.getMax(groupMaxX);
        int maxY = auto.getMax(group.getMaxY());
        int maxZ = auto.getMax(groupMaxZ);
        if (maxX > max && max > 0) {
            maxX = max;
        }
        if (!Residence.getInstance().getConfigManager().isSelectionIgnoreY() && maxY > max && max > 0) {
            maxY = max;
        }
        if (maxZ > max && max > 0) {
            maxZ = max;
        }
        if (maxX <= 1) {
            maxX = (groupMaxX - group.getMinX()) / 2 + group.getMinX();
        }
        if (maxY <= 1) {
            maxY = (group.getMaxY() - group.getMinY()) / 2 + group.getMinY();
        }
        if (maxZ <= 1) {
            maxZ = (groupMaxZ - group.getMinZ()) / 2 + group.getMinZ();
        }
        int gap = plugin.getConfigManager().getAntiGreefRangeGaps(cuboid.getWorldName());
        HashMap<direction, Integer> directionMap = new HashMap<direction, Integer>();
        HashMap<direction, Integer> maxMap = new HashMap<direction, Integer>();
        CuboidArea originalCuboid = new CuboidArea(cuboid.getLowLocation(), cuboid.getHighLocation());
        int smallestRange = maxX - cuboid.getXSize() < maxY - cuboid.getYSize() ? maxX - cuboid.getXSize() : maxY - cuboid.getYSize();
        smallestRange = smallestRange < maxZ - cuboid.getZSize() ? smallestRange : maxZ - cuboid.getZSize();
        smallestRange /= 4;
        int minYaltitude = group.getMinHeight();
        int maxYaltitude = group.getMaxHeight();
        while (++done <= 100 && Math.abs(smallestRange) >= 1) {
            CuboidArea c = new CuboidArea();
            c.setLowLocation(cuboid.getLowLocation().clone().add((double)(-smallestRange), (double)(-smallestRange), (double)(-smallestRange)));
            c.setHighLocation(cuboid.getHighLocation().clone().add((double)smallestRange, (double)smallestRange, (double)smallestRange));
            if (c.getHighVector().getBlockY() > maxYaltitude) {
                c.setHighVector(c.getHighVector().setY(maxYaltitude));
            }
            if (c.getLowVector().getBlockY() > maxWorldY - 1) {
                c.setLowVector(c.getLowVector().setY(maxWorldY - 1));
            } else if (c.getLowVector().getBlockY() < minYaltitude) {
                c.setLowVector(c.getLowVector().setY(minYaltitude));
            }
            if (checkCollision) {
                if (gap > 0) {
                    CuboidArea temp = new CuboidArea(c.getLowLocation().clone().add((double)(-gap), (double)(-gap), (double)(-gap)), c.getHighLocation().clone().add((double)gap, (double)gap, (double)gap));
                    if (plugin.getResidenceManager().collidesWithResidence(temp) != null) {
                        smallestRange = (int)(-Math.ceil((double)Math.abs(smallestRange) / 2.0));
                        cuboid.setLowLocation(c.getLowLocation());
                        cuboid.setHighLocation(c.getHighLocation());
                        continue;
                    }
                } else if (plugin.getResidenceManager().collidesWithResidence(c) != null) {
                    smallestRange = (int)(-Math.ceil((double)Math.abs(smallestRange) / 2.0));
                    cuboid.setLowLocation(c.getLowLocation());
                    cuboid.setHighLocation(c.getHighLocation());
                    continue;
                }
                if (smallestRange == -1) {
                    cuboid.setLowLocation(cuboid.getLowLocation().clone().add(1.0, 1.0, 1.0));
                    cuboid.setHighLocation(cuboid.getHighLocation().clone().add(-1.0, -1.0, -1.0));
                    break;
                }
            }
            int sr = (int)Math.ceil((double)Math.abs(smallestRange) / 2.0);
            if (maxX > 0 && maxX < c.getXSize() || c.getXSize() > groupMaxX || !Residence.getInstance().getConfigManager().isSelectionIgnoreY() && (maxY > 0 && maxY < c.getYSize() || c.getYSize() > group.getMaxY() + -group.getMinY()) || maxZ > 0 && maxZ < c.getZSize() || c.getZSize() > groupMaxZ) break;
            cuboid.setLowLocation(c.getLowLocation());
            cuboid.setHighLocation(c.getHighLocation());
            smallestRange = sr;
        }
        if (cuboid.getXSize() < 1) {
            int center = (int)(originalCuboid.getLowVector().getX() + (originalCuboid.getHighVector().getX() - originalCuboid.getLowVector().getX()) / 2.0);
            cuboid.getLowVector().setX(center);
            cuboid.getHighVector().setX(center);
        }
        if (cuboid.getZSize() < 1) {
            int center = (int)(originalCuboid.getLowVector().getZ() + (originalCuboid.getHighVector().getZ() - originalCuboid.getLowVector().getZ()) / 2.0);
            cuboid.getLowVector().setZ(center);
            cuboid.getHighVector().setZ(center);
        }
        if (cuboid.getYSize() < 1) {
            int center = (int)(originalCuboid.getLowVector().getY() + (originalCuboid.getHighVector().getY() - originalCuboid.getLowVector().getY()) / 2.0);
            cuboid.getLowVector().setY(center);
            cuboid.getHighVector().setY(center);
        }
        auto.fillMaps(directionMap, maxMap, direction.East, maxX, cuboid.getXSize());
        auto.fillMaps(directionMap, maxMap, direction.West, maxX + 1, cuboid.getXSize());
        auto.fillMaps(directionMap, maxMap, direction.South, maxZ, cuboid.getZSize());
        auto.fillMaps(directionMap, maxMap, direction.North, maxZ + 1, cuboid.getZSize());
        auto.fillMaps(directionMap, maxMap, direction.Top, maxY, cuboid.getYSize());
        auto.fillMaps(directionMap, maxMap, direction.Bottom, maxY + 1, cuboid.getYSize());
        while (true) {
            double newOffset;
            if (Residence.getInstance().getConfigManager().isSelectionIgnoreY() && (dir.equals((Object)direction.Top) || dir.equals((Object)direction.Bottom))) {
                dir = dir.getNext();
                continue;
            }
            if (skipped >= 6 || ++done > 100) break;
            if (locked.contains((Object)dir)) {
                dir = dir.getNext();
                ++skipped;
                continue;
            }
            skipped = 0;
            Integer offset = directionMap.get((Object)dir);
            if (Math.abs(offset) == 0) {
                if (dir == direction.East && locked.contains((Object)direction.West) && !permaLocked.contains((Object)direction.West)) {
                    maxMap.put(direction.West, maxX - (player.getLocation().getBlockX() - cuboid.getHighVector().getBlockX()));
                    directionMap.put(direction.West, maxMap.get((Object)direction.West) / 2);
                    locked.remove((Object)direction.West);
                    permaLocked.add(dir);
                }
                if (dir == direction.West && locked.contains((Object)direction.East) && !permaLocked.contains((Object)direction.East)) {
                    maxMap.put(direction.East, maxX - (player.getLocation().getBlockX() - cuboid.getHighVector().getBlockX()));
                    directionMap.put(direction.East, maxMap.get((Object)direction.East) / 2);
                    locked.remove((Object)direction.East);
                    permaLocked.add(dir);
                }
                if (dir == direction.North && locked.contains((Object)direction.South) && !permaLocked.contains((Object)direction.South)) {
                    maxMap.put(direction.South, maxX - (player.getLocation().getBlockZ() - cuboid.getHighVector().getBlockZ()));
                    directionMap.put(direction.South, maxMap.get((Object)direction.South) / 2);
                    locked.remove((Object)direction.South);
                    permaLocked.add(dir);
                }
                if (dir == direction.South && locked.contains((Object)direction.North) && !permaLocked.contains((Object)direction.North)) {
                    maxMap.put(direction.North, maxX - (player.getLocation().getBlockZ() - cuboid.getHighVector().getBlockZ()));
                    directionMap.put(direction.North, maxMap.get((Object)direction.North) / 2);
                    locked.remove((Object)direction.North);
                    permaLocked.add(dir);
                }
                if (dir == direction.Top && !locked.contains((Object)direction.Bottom) && !permaLocked.contains((Object)direction.Bottom)) {
                    maxMap.put(direction.Bottom, maxY - Math.abs(player.getLocation().getBlockY() - cuboid.getLowVector().getBlockY()));
                    directionMap.put(direction.Bottom, maxMap.get((Object)direction.Bottom) / 2);
                    permaLocked.add(dir);
                }
                locked.add(dir);
                dir = dir.getNext();
                continue;
            }
            CuboidArea c = new CuboidArea();
            c.setLowLocation(cuboid.getLowLocation().clone().add(-dir.getLow().getX() * (double)offset.intValue(), -dir.getLow().getY() * (double)offset.intValue(), -dir.getLow().getZ() * (double)offset.intValue()));
            c.setHighLocation(cuboid.getHighLocation().clone().add(dir.getHigh().getX() * (double)offset.intValue(), dir.getHigh().getY() * (double)offset.intValue(), dir.getHigh().getZ() * (double)offset.intValue()));
            if (c.getHighVector().getBlockY() > maxYaltitude) {
                c.setHighVector(c.getHighVector().setY(maxYaltitude));
                if (locked.contains((Object)direction.Top) && !locked.contains((Object)direction.Bottom) && !permaLocked.contains((Object)direction.Top)) {
                    maxMap.put(direction.Top, maxY - Math.abs(c.getHighVector().getBlockY() - player.getLocation().getBlockY()));
                    directionMap.put(direction.Top, maxMap.get((Object)direction.Top) / 2);
                    locked.remove((Object)direction.Top);
                    permaLocked.add(direction.Bottom);
                }
            }
            if (c.getLowVector().getBlockY() > maxYaltitude - 1) {
                c.setLowVector(c.getLowVector().setY(maxYaltitude - 1));
            } else if (c.getLowVector().getBlockY() < minYaltitude) {
                c.setLowVector(c.getLowVector().setY(minYaltitude));
                if (!(locked.contains((Object)direction.Top) || locked.contains((Object)direction.Bottom) || permaLocked.contains((Object)direction.Bottom))) {
                    maxMap.put(direction.Bottom, maxY - Math.abs(player.getLocation().getBlockY() - c.getLowVector().getBlockY()));
                    directionMap.put(direction.Bottom, maxMap.get((Object)direction.Bottom) / 2);
                    permaLocked.add(direction.Top);
                }
            }
            if (checkCollision) {
                boolean collides = false;
                if (gap > 0) {
                    CuboidArea temp = new CuboidArea(c.getLowLocation().clone().add((double)(-gap), (double)(-gap), (double)(-gap)), c.getHighLocation().clone().add((double)gap, (double)gap, (double)gap));
                    collides = plugin.getResidenceManager().collidesWithResidence(temp) != null;
                } else {
                    boolean bl = collides = plugin.getResidenceManager().collidesWithResidence(c) != null;
                }
                if (collides) {
                    int newOffset2 = (int)((double)Math.abs(offset) / 2.0);
                    if (newOffset2 < 1) {
                        newOffset2 = 1;
                    }
                    directionMap.put(dir, -newOffset2);
                    cuboid.setLowLocation(c.getLowLocation());
                    cuboid.setHighLocation(c.getHighLocation());
                    continue;
                }
            }
            if (maxMap.get((Object)dir).equals(Math.abs(offset))) {
                locked.add(dir);
            }
            offset = (newOffset = (double)Math.abs(offset) / 2.0) > 1.0 ? (int)Math.ceil(newOffset) : (int)newOffset;
            directionMap.put(dir, offset);
            if (maxX > 0 && maxX < c.getXSize() || c.getXSize() > groupMaxX) {
                if (Math.abs(offset) < 1) {
                    locked.add(dir);
                }
                dir = dir.getNext();
                continue;
            }
            if (!Residence.getInstance().getConfigManager().isSelectionIgnoreY() && (maxY > 0 && maxY < c.getYSize() || c.getYSize() > group.getMaxY() + -group.getMinY())) {
                if (Math.abs(offset) < 1) {
                    locked.add(dir);
                }
                dir = dir.getNext();
                continue;
            }
            if (maxZ > 0 && maxZ < c.getZSize() || c.getZSize() > groupMaxZ) {
                if (Math.abs(offset) < 1) {
                    locked.add(dir);
                }
                dir = dir.getNext();
                continue;
            }
            if (checkBalance && plugin.getConfigManager().enableEconomy() && !Residence.getInstance().getEconomyManager().canAfford(player, c.getCost(group))) {
                plugin.msg((CommandSender)player, lm.Economy_NotEnoughMoney, new Object[0]);
                return false;
            }
            cuboid.setLowLocation(c.getLowLocation());
            cuboid.setHighLocation(c.getHighLocation());
            dir = dir.getNext();
        }
        plugin.getSelectionManager().placeLoc1(player, cuboid.getLowLocation());
        plugin.getSelectionManager().placeLoc2(player, cuboid.getHighLocation());
        cuboid = plugin.getSelectionManager().getSelectionCuboid(player);
        return cuboid.getXSize() <= groupMaxX && cuboid.getYSize() <= group.getMaxY() + -group.getMinY() && cuboid.getZSize() <= groupMaxZ;
    }

    @Override
    public void getLocale() {
        ConfigReader c = Residence.getInstance().getLocaleManager().getLocaleConfig();
        c.get("Description", "Create maximum allowed residence around you");
        c.get("Info", Arrays.asList("&eUsage: &6/res auto (residence name) (radius)"));
        LocaleManager.addTabCompleteMain(this, new String[0]);
    }

    public static enum direction {
        Top(new Vector(0, 1, 0), new Vector(0, 0, 0)),
        Bottom(new Vector(0, 0, 0), new Vector(0, 1, 0)),
        East(new Vector(1, 0, 0), new Vector(0, 0, 0)),
        West(new Vector(0, 0, 0), new Vector(1, 0, 0)),
        North(new Vector(0, 0, 1), new Vector(0, 0, 0)),
        South(new Vector(0, 0, 0), new Vector(0, 0, 1));

        private Vector low;
        private Vector high;

        private direction(Vector low, Vector high) {
            this.low = low;
            this.high = high;
        }

        public Vector getLow() {
            return this.low;
        }

        public Vector getHigh() {
            return this.high;
        }

        public direction getNext() {
            boolean next = false;
            direction dir = Top;
            direction[] directionArray = direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                direction one = directionArray[n2];
                if (next) {
                    dir = one;
                    next = false;
                    break;
                }
                if (this.equals((Object)one)) {
                    next = true;
                }
                ++n2;
            }
            return dir;
        }
    }
}

