/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.protection;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.api.ResidencePlayerInterface;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.ResidencePlayer;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.permissions.PermissionGroup;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class PlayerManager
implements ResidencePlayerInterface {
    private ConcurrentHashMap<String, ResidencePlayer> players = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ResidencePlayer> playersUuid = new ConcurrentHashMap();
    private Residence plugin;

    public PlayerManager(Residence plugin) {
        this.plugin = plugin;
    }

    public void addPlayer(ResidencePlayer resPlayer) {
        if (resPlayer == null) {
            return;
        }
        this.addPlayer(resPlayer.getName(), resPlayer.getUniqueId(), resPlayer);
    }

    public void addPlayer(Player player, ResidencePlayer resPlayer) {
        if (player == null) {
            return;
        }
        this.addPlayer(player.getName(), player.getUniqueId(), resPlayer);
    }

    public void addPlayer(String name, UUID uuid, ResidencePlayer resPlayer) {
        if (name != null) {
            this.players.put(name.toLowerCase(), resPlayer);
        }
        if (uuid != null) {
            this.playersUuid.put(uuid.toString(), resPlayer);
        }
    }

    public ResidencePlayer playerJoin(Player player) {
        ResidencePlayer resPlayer = this.playersUuid.get(player.getUniqueId().toString());
        if (resPlayer == null) {
            resPlayer = new ResidencePlayer(player);
            this.addPlayer(resPlayer);
        } else {
            resPlayer.updatePlayer(player);
        }
        return resPlayer;
    }

    public ResidencePlayer playerJoin(UUID uuid) {
        OfflinePlayer off;
        ResidencePlayer resPlayer = this.playersUuid.get(uuid.toString());
        if (resPlayer == null && (off = Bukkit.getOfflinePlayer((UUID)uuid)) != null) {
            resPlayer = new ResidencePlayer(off);
            this.addPlayer(resPlayer);
        }
        return resPlayer;
    }

    public ResidencePlayer playerJoin(String player) {
        if (!this.players.containsKey(player.toLowerCase())) {
            ResidencePlayer resPlayer = new ResidencePlayer(player);
            this.addPlayer(resPlayer);
            return resPlayer;
        }
        return null;
    }

    public ResidencePlayer playerJoin(String player, UUID uuid) {
        if (!this.players.containsKey(player.toLowerCase())) {
            ResidencePlayer resPlayer = new ResidencePlayer(player, uuid);
            this.addPlayer(resPlayer);
            return resPlayer;
        }
        return null;
    }

    public int getResidenceCount(UUID uuid) {
        ResidencePlayer resPlayer = this.playersUuid.get(uuid.toString());
        if (resPlayer != null) {
            return resPlayer.getResList().size();
        }
        return 0;
    }

    @Override
    public ArrayList<String> getResidenceList(UUID uuid) {
        ArrayList<String> temp = new ArrayList<String>();
        ResidencePlayer resPlayer = this.playersUuid.get(uuid.toString());
        if (resPlayer != null) {
            for (ClaimedResidence one : resPlayer.getResList()) {
                temp.add(one.getName());
            }
            return temp;
        }
        return temp;
    }

    @Override
    public ArrayList<String> getResidenceList(String name) {
        Player player = Bukkit.getPlayer((String)name);
        if (player != null) {
            return this.getResidenceList(player.getUniqueId());
        }
        ArrayList<String> temp = new ArrayList<String>();
        ResidencePlayer resPlayer = this.getResidencePlayer(name);
        if (resPlayer != null) {
            for (ClaimedResidence one : resPlayer.getResList()) {
                temp.add(one.getName());
            }
            return temp;
        }
        return temp;
    }

    @Override
    public ArrayList<String> getResidenceList(String player, boolean showhidden) {
        return this.getResidenceList(player, showhidden, false);
    }

    public ArrayList<String> getResidenceList(String player, boolean showhidden, boolean onlyHidden) {
        ArrayList<String> temp = new ArrayList<String>();
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer == null) {
            return temp;
        }
        for (ClaimedResidence one : resPlayer.getResList()) {
            boolean hidden = one.getPermissions().has("hidden", false);
            if (!showhidden && hidden || onlyHidden && !hidden) continue;
            temp.add(String.valueOf(this.plugin.msg(lm.Residence_List, "", one.getName(), one.getWorld())) + (hidden ? this.plugin.msg(lm.Residence_Hidden, new Object[0]) : ""));
        }
        Collections.sort(temp, String.CASE_INSENSITIVE_ORDER);
        return temp;
    }

    public ArrayList<ClaimedResidence> getResidences(String player, boolean showhidden) {
        return this.getResidences(player, showhidden, false);
    }

    public ArrayList<ClaimedResidence> getResidences(String player, boolean showhidden, boolean onlyHidden) {
        return this.getResidences(player, showhidden, onlyHidden, null);
    }

    public ArrayList<ClaimedResidence> getResidences(String player, boolean showhidden, boolean onlyHidden, World world) {
        ArrayList<ClaimedResidence> temp = new ArrayList<ClaimedResidence>();
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer == null) {
            return temp;
        }
        for (ClaimedResidence one : resPlayer.getResList()) {
            boolean hidden = one.getPermissions().has(Flags.hidden, false);
            if (!showhidden && hidden || onlyHidden && !hidden || world != null && !world.getName().equalsIgnoreCase(one.getWorld())) continue;
            temp.add(one);
        }
        return temp;
    }

    public TreeMap<String, ClaimedResidence> getResidencesMap(String player, boolean showhidden, boolean onlyHidden, World world) {
        TreeMap<String, ClaimedResidence> temp = new TreeMap<String, ClaimedResidence>();
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer == null) {
            return temp;
        }
        for (ClaimedResidence one : resPlayer.getResList()) {
            boolean hidden = one.getPermissions().has(Flags.hidden, false);
            if (!showhidden && hidden || onlyHidden && !hidden || world != null && !world.getName().equalsIgnoreCase(one.getWorld())) continue;
            temp.put(one.getName(), one);
        }
        return temp;
    }

    public TreeMap<String, ClaimedResidence> getTrustedResidencesMap(String player, boolean showhidden, boolean onlyHidden, World world) {
        TreeMap<String, ClaimedResidence> temp = new TreeMap<String, ClaimedResidence>();
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer == null) {
            return temp;
        }
        Iterator<ClaimedResidence> iter = resPlayer.getTrustedResidenceList().iterator();
        while (iter.hasNext()) {
            ClaimedResidence one = iter.next();
            boolean hidden = one.getPermissions().has(Flags.hidden, false);
            if (!showhidden && hidden || onlyHidden && !hidden || world != null && !world.getName().equalsIgnoreCase(one.getWorld())) continue;
            if (!one.isTrusted(player)) {
                iter.remove();
                continue;
            }
            temp.put(one.getName(), one);
        }
        return temp;
    }

    @Override
    public PermissionGroup getGroup(String player) {
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer != null) {
            return resPlayer.getGroup();
        }
        return null;
    }

    @Override
    public int getMaxResidences(String player) {
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer != null) {
            return resPlayer.getMaxRes();
        }
        return -1;
    }

    @Override
    public int getMaxSubzones(String player) {
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer != null) {
            return resPlayer.getMaxSubzones();
        }
        return -1;
    }

    @Override
    public int getMaxSubzoneDepth(String player) {
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer != null) {
            return resPlayer.getMaxSubzoneDepth();
        }
        return -1;
    }

    @Override
    public int getMaxRents(String player) {
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer != null) {
            return resPlayer.getMaxRents();
        }
        return -1;
    }

    public ResidencePlayer getResidencePlayer(Player player) {
        ResidencePlayer resPlayer = null;
        if (player == null) {
            return null;
        }
        resPlayer = this.playersUuid.get(player.getUniqueId().toString());
        if (resPlayer != null) {
            resPlayer.updatePlayer(player);
        } else {
            resPlayer = this.playerJoin(player);
        }
        return resPlayer;
    }

    @Override
    public ResidencePlayer getResidencePlayer(String player) {
        if (player == null) {
            return null;
        }
        if (player.equalsIgnoreCase("CONSOLE")) {
            return null;
        }
        Player p = Bukkit.getPlayer((String)player);
        if (p != null) {
            return this.getResidencePlayer(p);
        }
        ResidencePlayer rplayer = this.players.get(player.toLowerCase());
        if (rplayer != null) {
            return rplayer;
        }
        return this.playerJoin(player);
    }

    public ResidencePlayer getResidencePlayer(UUID uuid) {
        Player p = Bukkit.getPlayer((UUID)uuid);
        if (p != null) {
            return this.getResidencePlayer(p);
        }
        ResidencePlayer resPlayer = this.playersUuid.get(uuid.toString());
        if (resPlayer != null) {
            return resPlayer;
        }
        return this.playerJoin(uuid);
    }

    public ResidencePlayer getResidencePlayer(String name, UUID uuid) {
        if (uuid.toString().equals(this.plugin.getServerLandUUID())) {
            return null;
        }
        Player p = Bukkit.getPlayer((UUID)uuid);
        if (p != null) {
            return this.getResidencePlayer(p);
        }
        ResidencePlayer resPlayer = this.playersUuid.get(uuid.toString());
        if (resPlayer != null) {
            return resPlayer;
        }
        if (name != null && (resPlayer = this.players.get(name.toLowerCase())) != null && resPlayer.getUniqueId() == null) {
            resPlayer.setUuid(uuid);
            this.playersUuid.put(uuid.toString(), resPlayer);
        }
        if (resPlayer != null) {
            return resPlayer;
        }
        return this.playerJoin(name, uuid);
    }

    public void addResidence(UUID uuid, ClaimedResidence residence) {
        ResidencePlayer resPlayer = this.getResidencePlayer(uuid);
        if (resPlayer != null) {
            resPlayer.addResidence(residence);
        }
    }

    public void addResidence(Player player, ClaimedResidence residence) {
        this.addResidence(player.getUniqueId(), residence);
    }

    public void addResidence(String player, ClaimedResidence residence) {
        ResidencePlayer resPlayer = this.getResidencePlayer(player, residence.getOwnerUUID());
        if (resPlayer != null) {
            if (resPlayer.getUniqueId() == null) {
                Bukkit.getConsoleSender().sendMessage(" <--------------------- " + resPlayer.getUniqueId() + "  " + residence.getOwnerUUID());
            }
            resPlayer.addResidence(residence);
        }
        try {
            if (residence.perms.playerFlags != null) {
                for (Map.Entry one : residence.perms.playerFlags.entrySet()) {
                    String name = (String)one.getKey();
                    if (name.length() == 36) {
                        name = (String)residence.perms.cachedPlayerNameUUIDs.get(UUID.fromString((String)one.getKey()));
                    }
                    if (!residence.isTrusted(name)) continue;
                    ResidencePlayer rplayer = null;
                    rplayer = ((String)one.getKey()).length() == 36 ? Residence.getInstance().getPlayerManager().getResidencePlayer(UUID.fromString((String)one.getKey())) : Residence.getInstance().getPlayerManager().getResidencePlayer(name);
                    if (rplayer == null) continue;
                    rplayer.addTrustedResidence(residence);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void removeResFromPlayer(ClaimedResidence residence) {
        if (residence == null) {
            return;
        }
        this.removeResFromPlayer(residence.getOwnerUUID(), residence);
    }

    public void removeResFromPlayer(UUID uuid, ClaimedResidence residence) {
        ResidencePlayer resPlayer = this.playersUuid.get(uuid.toString());
        if (resPlayer != null) {
            resPlayer.removeResidence(residence);
        }
    }

    public void removeResFromPlayer(OfflinePlayer player, ClaimedResidence residence) {
        this.removeResFromPlayer(player.getUniqueId(), residence);
    }

    public void removeResFromPlayer(Player player, ClaimedResidence residence) {
        this.removeResFromPlayer(player.getUniqueId(), residence);
    }

    public void removeResFromPlayer(String player, ClaimedResidence residence) {
        ResidencePlayer resPlayer = this.getResidencePlayer(player);
        if (resPlayer != null) {
            resPlayer.removeResidence(residence);
        }
    }
}

