/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.shopStuff;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.event.ResidenceCreationEvent;
import com.bekvon.bukkit.residence.event.ResidenceDeleteEvent;
import com.bekvon.bukkit.residence.event.ResidenceFlagChangeEvent;
import com.bekvon.bukkit.residence.event.ResidenceRenameEvent;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.shopStuff.Board;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;

public class ShopListener
implements Listener {
    public static List<String> Delete = new ArrayList<String>();
    private Residence plugin;

    public ShopListener(Residence residence) {
        this.plugin = residence;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignInteract(PlayerInteractEvent event) {
        if (this.plugin.isDisabledWorldListener(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!(block.getState() instanceof Sign)) {
            return;
        }
        Player player = event.getPlayer();
        Location loc = block.getLocation();
        if (Delete.contains(player.getName())) {
            Board Found = null;
            for (Board one : this.plugin.getShopSignUtilManager().getAllBoards()) {
                for (Location location : one.GetLocations()) {
                    if (!loc.getWorld().getName().equalsIgnoreCase(location.getWorld().getName()) || loc.getBlockX() != location.getBlockX() || loc.getBlockY() != location.getBlockY() || loc.getBlockZ() != location.getBlockZ()) continue;
                    Found = one;
                    break;
                }
                if (Found != null) break;
            }
            if (Found != null) {
                this.plugin.getShopSignUtilManager().getAllBoards().remove(Found);
                this.plugin.getShopSignUtilManager().saveSigns();
                this.plugin.msg((CommandSender)player, lm.Shop_DeletedBoard, new Object[0]);
            } else {
                this.plugin.msg((CommandSender)player, lm.Shop_IncorrectBoard, new Object[0]);
            }
            Delete.remove(player.getName());
            return;
        }
        String resName = null;
        for (Board one : this.plugin.getShopSignUtilManager().getAllBoards()) {
            resName = one.getResNameByLoc(loc);
            if (resName != null) break;
        }
        if (resName != null) {
            Bukkit.dispatchCommand((CommandSender)event.getPlayer(), (String)("res tp " + resName));
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFlagChangeShop(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getFlag().equalsIgnoreCase("shop")) {
            return;
        }
        switch (event.getNewState()) {
            case FALSE: 
            case NEITHER: {
                this.plugin.getResidenceManager().removeShop(event.getResidence());
                this.plugin.getShopSignUtilManager().boardUpdate();
                this.plugin.getShopSignUtilManager().saveSigns();
                break;
            }
            case INVALID: {
                break;
            }
            case TRUE: {
                this.plugin.getResidenceManager().addShop(event.getResidence().getName());
                event.getResidence().getPermissions().setFlag("tp", FlagPermissions.FlagState.TRUE);
                event.getResidence().getPermissions().setFlag("move", FlagPermissions.FlagState.TRUE);
                event.getResidence().getPermissions().setFlag("pvp", FlagPermissions.FlagState.FALSE);
                this.plugin.getShopSignUtilManager().boardUpdate();
                this.plugin.getShopSignUtilManager().saveSigns();
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceRename(ResidenceRenameEvent event) {
        if (!event.getResidence().GetShopVotes().isEmpty()) {
            this.plugin.getResidenceManager().addShop(event.getResidence());
            this.plugin.getResidenceManager().removeShop(event.getOldResidenceName());
            this.plugin.getShopSignUtilManager().saveShopVotes();
            this.plugin.getShopSignUtilManager().boardUpdateDelayed();
            this.plugin.getShopSignUtilManager().saveSigns();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onFlagChange(ResidenceFlagChangeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getFlag().equalsIgnoreCase("tp") && event.getNewState() == FlagPermissions.FlagState.TRUE) {
            return;
        }
        if (event.getFlag().equalsIgnoreCase("move") && event.getNewState() == FlagPermissions.FlagState.TRUE) {
            return;
        }
        if (event.getFlag().equalsIgnoreCase("pvp") && event.getNewState() == FlagPermissions.FlagState.FALSE) {
            return;
        }
        if (!(event.getFlag().equalsIgnoreCase("move") || event.getFlag().equalsIgnoreCase("tp") || event.getFlag().equalsIgnoreCase("pvp"))) {
            return;
        }
        if (!event.getResidence().getPermissions().has("shop", false)) {
            return;
        }
        event.setCancelled(true);
        this.plugin.msg((CommandSender)event.getPlayer(), lm.Shop_ChantChange, new Object[0]);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceCreate(ResidenceCreationEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getResidence().getPermissions().has("shop", false)) {
            return;
        }
        this.plugin.getResidenceManager().addShop(event.getResidence().getName());
        this.plugin.getShopSignUtilManager().boardUpdate();
        this.plugin.getShopSignUtilManager().saveSigns();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onResidenceRemove(ResidenceDeleteEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!event.getResidence().getPermissions().has("shop", true)) {
            return;
        }
        this.plugin.getResidenceManager().removeShop(event.getResidence());
        this.plugin.getShopSignUtilManager().boardUpdate();
        this.plugin.getShopSignUtilManager().saveSigns();
    }
}

