/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.text.help;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.Flags;
import com.bekvon.bukkit.residence.containers.lm;
import com.bekvon.bukkit.residence.economy.rent.RentableLand;
import com.bekvon.bukkit.residence.protection.ClaimedResidence;
import com.bekvon.bukkit.residence.protection.CuboidArea;
import com.bekvon.bukkit.residence.protection.FlagPermissions;
import com.bekvon.bukkit.residence.utils.GetTime;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class InformationPager {
    Residence plugin;

    public InformationPager(Residence plugin) {
        this.plugin = plugin;
    }

    public void printInfo(CommandSender sender, String command2, String title, String[] lines, int page) {
        this.printInfo(sender, command2, title, Arrays.asList(lines), page);
    }

    public void printInfo(CommandSender sender, String command2, String title, List<String> lines, int page) {
        PageInfo pi = new PageInfo(6, lines.size(), page);
        if (!pi.isPageOk()) {
            sender.sendMessage(ChatColor.RED + this.plugin.msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        this.plugin.msg(sender, lm.InformationPage_TopSingle, title);
        this.plugin.msg(sender, lm.InformationPage_Page, this.plugin.msg(lm.General_GenericPages, String.format("%d", page), pi.getTotalPages(), lines.size()));
        int i = pi.getStart();
        while (i <= pi.getEnd()) {
            if (lines.size() > i) {
                sender.sendMessage(ChatColor.GREEN + lines.get(i));
            }
            ++i;
        }
        pi.autoPagination(sender, command2);
    }

    public void printListInfo(CommandSender sender, String targetPlayer, TreeMap<String, ClaimedResidence> ownedResidences, int page, boolean resadmin2, World world) {
        int perPage = 20;
        if (sender instanceof Player) {
            perPage = 6;
        }
        if (ownedResidences.isEmpty()) {
            this.plugin.msg(sender, lm.Residence_DontOwn, targetPlayer);
            return;
        }
        PageInfo pi = new PageInfo(perPage, ownedResidences.size(), page);
        if (!(sender instanceof Player) && page == -1) {
            this.printListWithDelay(sender, ownedResidences, 0, resadmin2);
            return;
        }
        if (!(sender instanceof Player) && page == -2) {
            this.printListToFile(ownedResidences, resadmin2);
            return;
        }
        if (!pi.isPageOk()) {
            sender.sendMessage(ChatColor.RED + this.plugin.msg(lm.Invalid_Page, new Object[0]));
            return;
        }
        if (targetPlayer != null) {
            this.plugin.msg(sender, lm.InformationPage_Top, this.plugin.msg(lm.General_Residences, new Object[0]), targetPlayer);
        }
        String cmd2 = "res";
        if (resadmin2) {
            cmd2 = "resadmin";
        }
        int y = -1;
        for (Map.Entry<String, ClaimedResidence> resT : ownedResidences.entrySet()) {
            if (++y > pi.getEnd()) break;
            if (!pi.isInRange(y)) continue;
            ClaimedResidence res = resT.getValue();
            StringBuilder StringB = new StringBuilder();
            StringB.append(this.plugin.msg(lm.General_Owner, res.getOwner()));
            if (res.getAreaArray().length > 0 && (res.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || resadmin2)) {
                StringB.append("\n");
                CuboidArea area2 = res.getAreaArray()[0];
                String cord1 = this.plugin.msg(lm.General_CoordsTop, area2.getHighVector().getBlockX(), area2.getHighVector().getBlockY(), area2.getHighVector().getBlockZ());
                String cord2 = this.plugin.msg(lm.General_CoordsBottom, area2.getLowVector().getBlockX(), area2.getLowVector().getBlockY(), area2.getLowVector().getBlockZ());
                String worldInfo = CMIChatColor.translate((String)this.plugin.msg(lm.General_CoordsLiner, cord1, cord2));
                StringB.append(worldInfo);
            }
            StringB.append("\n").append(this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(res.getCreateTime())));
            String ExtraString = "";
            if (res.isForRent()) {
                if (res.isRented()) {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                    StringB.append("\n").append(this.plugin.msg(lm.Residence_RentedBy, res.getRentedLand().player));
                } else {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                }
                RentableLand rentable = res.getRentable();
                StringB.append("\n").append(this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days));
                StringB.append("\n").append(this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing));
                StringB.append("\n").append(this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket));
                StringB.append("\n").append(this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
            }
            if (res.isForSell()) {
                ExtraString = " " + this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                StringB.append("\n " + this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + res.getSellPrice());
            }
            String tpFlag = "";
            String moveFlag = "";
            String msg = this.plugin.msg(lm.Residence_ResList, y + 1, res.getName(), res.getWorld(), String.valueOf(tpFlag) + moveFlag, ExtraString);
            if (sender instanceof Player && !res.isOwner(sender)) {
                tpFlag = res.getPermissions().playerHas((Player)sender, Flags.tp, true) ? this.plugin.msg(lm.General_AllowedTeleportIcon, new Object[0]) : this.plugin.msg(lm.General_BlockedTeleportIcon, new Object[0]);
                String string = moveFlag = res.getPermissions().playerHas(sender.getName(), Flags.move, true) ? this.plugin.msg(lm.General_AllowedMovementIcon, new Object[0]) : this.plugin.msg(lm.General_BlockedMovementIcon, new Object[0]);
                if (res.isTrusted((Player)sender)) {
                    msg = this.plugin.msg(lm.Residence_TrustedResList, y + 1, res.getName(), res.getWorld(), String.valueOf(tpFlag) + moveFlag, ExtraString);
                }
            }
            RawMessage rm = new RawMessage();
            if (sender instanceof Player) {
                rm.addText(msg).addHover(StringB.toString()).addCommand(String.valueOf(cmd2) + " tp " + res.getName());
            } else {
                rm.addText(String.valueOf(msg) + " " + StringB.toString().replace("\n", ""));
            }
            rm.show(sender);
        }
        String worldName = "";
        if (world != null) {
            worldName = " " + world.getName();
        }
        if (targetPlayer != null) {
            pi.autoPagination(sender, String.valueOf(cmd2) + " list " + targetPlayer + worldName);
        } else {
            pi.autoPagination(sender, String.valueOf(cmd2) + " listall" + worldName);
        }
    }

    private void printListWithDelay(CommandSender sender, TreeMap<String, ClaimedResidence> ownedResidences, int start, boolean resadmin2) {
        int i = start;
        int y = 0;
        for (Map.Entry<String, ClaimedResidence> resT : ownedResidences.entrySet()) {
            if (++y < i) continue;
            if (++i >= start + 100 || ownedResidences.size() < i) break;
            ClaimedResidence res = resT.getValue();
            StringBuilder StringB = new StringBuilder();
            StringB.append(this.plugin.msg(lm.General_Owner, res.getOwner()));
            if (res.getAreaArray().length > 0 && (res.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || resadmin2)) {
                CuboidArea area2 = res.getAreaArray()[0];
                String cord1 = this.plugin.msg(lm.General_CoordsTop, area2.getHighVector().getBlockX(), area2.getHighVector().getBlockY(), area2.getHighVector().getBlockZ());
                String cord2 = this.plugin.msg(lm.General_CoordsBottom, area2.getLowVector().getBlockX(), area2.getLowVector().getBlockY(), area2.getLowVector().getBlockZ());
                String worldInfo = CMIChatColor.translate((String)this.plugin.msg(lm.General_CoordsLiner, cord1, cord2));
                StringB.append("\n" + worldInfo);
            }
            StringB.append("\n" + this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(res.getCreateTime())));
            String ExtraString = "";
            if (res.isForRent()) {
                if (res.isRented()) {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                    StringB.append("\n " + this.plugin.msg(lm.Residence_RentedBy, res.getRentedLand().player));
                } else {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                }
                RentableLand rentable = res.getRentable();
                StringB.append("\n" + this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days));
                StringB.append("\n" + this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing));
                StringB.append("\n" + this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket));
                StringB.append("\n" + this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
            }
            if (res.isForSell()) {
                ExtraString = " " + this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                StringB.append("\n" + this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + res.getSellPrice());
            }
            String msg = this.plugin.msg(lm.Residence_ResList, i, res.getName(), res.getWorld(), "", ExtraString);
            msg = CMIChatColor.stripColor((String)(String.valueOf(msg) + " " + StringB.toString().replace("\n", "")));
            msg = msg.replaceAll("\\s{2}", " ");
            sender.sendMessage(msg);
        }
        if (ownedResidences.isEmpty()) {
            return;
        }
        CMIScheduler.runTaskLater(() -> this.printListWithDelay(sender, ownedResidences, start + 100, resadmin2), (long)5L);
    }

    private void printListToFile(TreeMap<String, ClaimedResidence> ownedResidences, boolean resadmin2) {
        Bukkit.getConsoleSender().sendMessage("Saving");
        CMIScheduler.runTaskAsynchronously(() -> {
            Object ExtraString;
            int y = 0;
            StringBuilder sb = new StringBuilder();
            for (Map.Entry resT : ownedResidences.entrySet()) {
                if (ownedResidences.size() < ++y) break;
                ClaimedResidence res = (ClaimedResidence)resT.getValue();
                StringBuilder StringB = new StringBuilder();
                StringB.append(" " + this.plugin.msg(lm.General_Owner, res.getOwner()));
                if (res.getAreaArray().length > 0 && (res.getPermissions().has(Flags.hidden, FlagPermissions.FlagCombo.FalseOrNone) && res.getPermissions().has(Flags.coords, FlagPermissions.FlagCombo.TrueOrNone) || resadmin2)) {
                    CuboidArea area2 = res.getAreaArray()[0];
                    String cord1 = this.plugin.msg(lm.General_CoordsTop, area2.getHighVector().getBlockX(), area2.getHighVector().getBlockY(), area2.getHighVector().getBlockZ());
                    String cord2 = this.plugin.msg(lm.General_CoordsBottom, area2.getLowVector().getBlockX(), area2.getLowVector().getBlockY(), area2.getLowVector().getBlockZ());
                    String worldInfo = CMIChatColor.translate((String)this.plugin.msg(lm.General_CoordsLiner, cord1, cord2));
                    StringB.append("\n" + worldInfo);
                }
                StringB.append("\n " + this.plugin.msg(lm.General_CreatedOn, GetTime.getTime(res.getCreateTime())));
                ExtraString = "";
                if (res.isForRent()) {
                    if (res.isRented()) {
                        ExtraString = " " + this.plugin.msg(lm.Residence_IsRented, new Object[0]);
                        StringB.append("\n " + this.plugin.msg(lm.Residence_RentedBy, res.getRentedLand().player));
                    } else {
                        ExtraString = " " + this.plugin.msg(lm.Residence_IsForRent, new Object[0]);
                    }
                    RentableLand rentable = res.getRentable();
                    StringB.append("\n " + this.plugin.msg(lm.General_Cost, rentable.cost, rentable.days));
                    StringB.append("\n " + this.plugin.msg(lm.Rentable_AllowRenewing, rentable.AllowRenewing));
                    StringB.append("\n " + this.plugin.msg(lm.Rentable_StayInMarket, rentable.StayInMarket));
                    StringB.append("\n " + this.plugin.msg(lm.Rentable_AllowAutoPay, rentable.AllowAutoPay));
                }
                if (res.isForSell()) {
                    ExtraString = " " + this.plugin.msg(lm.Residence_IsForSale, new Object[0]);
                    StringB.append("\n " + this.plugin.msg(lm.Economy_LandForSale, new Object[0]) + " " + res.getSellPrice());
                }
                String msg = this.plugin.msg(lm.Residence_ResList, y, res.getName(), res.getWorld(), "", ExtraString);
                msg = CMIChatColor.stripColor((String)(String.valueOf(msg) + " " + StringB.toString().replace("\n", "")));
                msg = msg.replaceAll("\\s{2}", " ");
                sb.append(msg);
                sb.append(" \n");
            }
            File BackupDir = new File(Residence.getInstance().getDataLocation(), "FullLists");
            if (!BackupDir.isDirectory()) {
                BackupDir.mkdir();
            }
            Date date = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
            File file = new File(BackupDir, String.valueOf(dateFormat.format(date)) + ".txt");
            try {
                ExtraString = null;
                Object var10_12 = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), StandardCharsets.UTF_8));){
                    writer.append(sb.toString());
                    writer.flush();
                }
                catch (Throwable throwable) {
                    if (ExtraString == null) {
                        ExtraString = throwable;
                    } else if (ExtraString != throwable) {
                        ((Throwable)ExtraString).addSuppressed(throwable);
                    }
                    throw ExtraString;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Bukkit.getConsoleSender().sendMessage("Saved file to FullLists folder with " + file.getName() + " name");
        });
    }
}

