/*
 * Decompiled with CFR 0.152.
 */
package com.bekvon.bukkit.residence.utils;

import com.bekvon.bukkit.residence.Residence;
import com.bekvon.bukkit.residence.containers.lm;
import java.util.ArrayList;
import java.util.List;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.NPC;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.WaterMob;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.BlockIterator;

public class Utils {
    public static String to24hourShort(Long ticks) {
        long years = ticks / 1000L / 60L / 60L / 24L / 365L;
        ticks = ticks - years * 1000L * 60L * 60L * 24L * 365L;
        long days = ticks / 1000L / 60L / 60L / 24L;
        ticks = ticks - days * 1000L * 60L * 60L * 24L;
        long hours = ticks / 1000L / 60L / 60L;
        ticks = ticks - hours * 1000L * 60L * 60L;
        long minutes = ticks / 1000L / 60L;
        ticks = ticks - minutes * 1000L * 60L;
        long sec = ticks / 1000L;
        ticks = ticks - sec * 1000L;
        String time = "";
        if (years > 0L) {
            time = String.valueOf(time) + (years == 1L ? Residence.getInstance().getLM().getMessage(lm.info_oneYear, years) : Residence.getInstance().getLM().getMessage(lm.info_years, years));
        }
        if (days > 0L) {
            time = String.valueOf(time) + (days == 1L ? Residence.getInstance().getLM().getMessage(lm.info_oneDay, days) : Residence.getInstance().getLM().getMessage(lm.info_day, days));
        }
        if (hours > 0L) {
            time = String.valueOf(time) + (hours == 1L ? Residence.getInstance().getLM().getMessage(lm.info_oneHour, hours) : Residence.getInstance().getLM().getMessage(lm.info_hour, hours));
        }
        if (minutes > 0L) {
            time = String.valueOf(time) + Residence.getInstance().getLM().getMessage(lm.info_min, minutes);
        }
        if (sec > 0L) {
            time = String.valueOf(time) + Residence.getInstance().getLM().getMessage(lm.info_sec, sec);
        }
        if (time.isEmpty()) {
            time = String.valueOf(time) + Residence.getInstance().getLM().getMessage(lm.info_sec, 0);
        }
        return time;
    }

    public static Block getTargetBlock(Player player, int distance, boolean ignoreNoneSolids) {
        return Utils.getTargetBlock(player, null, distance, ignoreNoneSolids);
    }

    public static Block getTargetBlock(Player player, int distance) {
        return Utils.getTargetBlock(player, null, distance, false);
    }

    public static Block getTargetBlock(Player player, Material lookingFor, int distance) {
        return Utils.getTargetBlock(player, lookingFor, distance, false);
    }

    public static Block getTargetBlock(Player player, Material lookingFor, int distance, boolean ignoreNoneSolids) {
        if (distance > 240) {
            distance = 240;
        }
        if (distance < 1) {
            distance = 1;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)player, distance);
        while (itr.hasNext()) {
            Block block = (Block)itr.next();
            blocks.add(block);
            if (distance != 0 && blocks.size() > distance) {
                blocks.remove(0);
            }
            Material material2 = block.getType();
            if (ignoreNoneSolids && !block.getType().isSolid()) continue;
            if (lookingFor == null) {
                if (CMIMaterial.AIR.equals(material2) || CMIMaterial.CAVE_AIR.equals(material2) || CMIMaterial.VOID_AIR.equals(material2)) continue;
                break;
            }
            if (!lookingFor.equals((Object)material2)) continue;
            return block;
        }
        return !blocks.isEmpty() ? (Block)blocks.get(blocks.size() - 1) : null;
    }

    public static String convertLocToStringTiny(Location loc) {
        String map = "";
        if (loc != null && loc.getWorld() != null) {
            map = String.valueOf(map) + loc.getWorld().getName();
            map = String.valueOf(map) + ";" + loc.getBlockX();
            map = String.valueOf(map) + ";" + loc.getBlockY();
            map = String.valueOf(map) + ";" + loc.getBlockZ();
        }
        return map.replace(",", ".");
    }

    public static String convertLocToStringShort(Location loc) {
        String map = "";
        if (loc != null && loc.getWorld() != null) {
            map = String.valueOf(map) + loc.getWorld().getName();
            map = String.valueOf(map) + ";" + (double)((int)(loc.getX() * 100.0)) / 100.0;
            map = String.valueOf(map) + ";" + (double)((int)(loc.getY() * 100.0)) / 100.0;
            map = String.valueOf(map) + ";" + (double)((int)(loc.getZ() * 100.0)) / 100.0;
        }
        return map.replace(",", ".");
    }

    public static Location convertStringToLocation(String map) {
        World w;
        Location loc = null;
        if (map == null) {
            return null;
        }
        if (!map.contains(";")) {
            return null;
        }
        String[] split = map.replace(",", ".").split(";");
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        float yaw = 0.0f;
        float pitch = 0.0f;
        if (split.length > 0) {
            try {
                x = Double.parseDouble(split[1]);
            }
            catch (Exception e) {
                return loc;
            }
        }
        if (split.length > 1) {
            try {
                y = Double.parseDouble(split[2]);
            }
            catch (Exception e) {
                return loc;
            }
        }
        if (split.length > 2) {
            try {
                z = Double.parseDouble(split[3]);
            }
            catch (Exception e) {
                return loc;
            }
        }
        if (split.length > 3) {
            try {
                yaw = Float.parseFloat(split[4]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (split.length > 4) {
            try {
                pitch = Float.parseFloat(split[5]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((w = Bukkit.getWorld((String)split[0])) == null) {
            return null;
        }
        loc = new Location(w, x, y, z);
        loc.setYaw(yaw);
        loc.setPitch(pitch);
        return loc;
    }

    public static boolean isAnimal(Entity ent) {
        return ent instanceof Animals || ent instanceof WaterMob || ent instanceof NPC || ent instanceof Bat || ent instanceof Snowman || ent instanceof IronGolem;
    }

    public static boolean isArmorStandEntity(EntityType ent) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            return false;
        }
        return ent == EntityType.ARMOR_STAND;
    }

    public static boolean isSpectator(GameMode mode) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            return false;
        }
        return mode == GameMode.SPECTATOR;
    }

    public static boolean isMainHand(PlayerInteractEvent event) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_8_R3)) {
            return true;
        }
        return event.getHand() == EquipmentSlot.HAND;
    }

    public static ItemStack itemInMainHand(Player player) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_8_R3)) {
            return player.getInventory().getItemInHand();
        }
        return player.getInventory().getItemInMainHand();
    }

    public static ItemStack itemInOffHand(Player player) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_8_R3)) {
            return null;
        }
        return player.getInventory().getItemInOffHand();
    }

    public static boolean isChorusTeleport(PlayerTeleportEvent.TeleportCause tpcause) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_8_R3)) {
            return false;
        }
        return tpcause == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT;
    }

    public static List<Block> getPistonRetractBlocks(BlockPistonRetractEvent event) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        if (Version.isCurrentEqualOrLower((Version)Version.v1_7_R4)) {
            blocks.add(event.getBlock());
        } else {
            blocks.addAll(event.getBlocks());
        }
        return blocks;
    }
}

