/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common.inject;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import me.arasple.mc.trchat.taboolib.common.LifeCycle;
import me.arasple.mc.trchat.taboolib.common.TabooLibCommon;
import me.arasple.mc.trchat.taboolib.common.inject.Injector;
import me.arasple.mc.trchat.taboolib.common.inject.InjectorOrder;
import me.arasple.mc.trchat.taboolib.common.io.Project1Kt;
import me.arasple.mc.trchat.taboolib.common.platform.AwakeFunction;
import me.arasple.mc.trchat.taboolib.common.platform.PlatformFactory;
import me.arasple.mc.trchat.taboolib.common.platform.SkipTo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimeInjector {
    private static final TreeMap<Byte, Injectors> propertyMap = new TreeMap();

    public static void register(@NotNull Injector.Fields injector) {
        Injectors injectors = propertyMap.computeIfAbsent(injector.getPriority(), i -> new Injectors());
        injectors.fields.add(injector);
    }

    public static void register(@NotNull Injector.Methods injector) {
        Injectors injectors = propertyMap.computeIfAbsent(injector.getPriority(), i -> new Injectors());
        injectors.methods.add(injector);
    }

    public static void register(@NotNull Injector.Classes injector) {
        Injectors injectors = propertyMap.computeIfAbsent(injector.getPriority(), i -> new Injectors());
        injectors.classes.add(injector);
    }

    public static void injectAll(@NotNull LifeCycle lifeCycle) {
        if (TabooLibCommon.isKotlinEnvironment() && !TabooLibCommon.isStopped()) {
            ArrayList classes = new ArrayList();
            for (Class<?> clazz : Project1Kt.getRunningClasses()) {
                if (!PlatformFactory.INSTANCE.checkPlatform(clazz)) continue;
                classes.add(clazz);
            }
            for (Map.Entry entry : propertyMap.entrySet()) {
                for (Class clazz : classes) {
                    RuntimeInjector.inject(clazz, (Injectors)entry.getValue(), lifeCycle);
                }
            }
        }
    }

    public static void injectAll(@NotNull Class<?> clazz) {
        for (Map.Entry<Byte, Injectors> entry : propertyMap.entrySet()) {
            RuntimeInjector.inject(clazz, entry.getValue(), null);
        }
    }

    public static void inject(@NotNull Class<?> clazz, @NotNull Injectors injectors, @Nullable LifeCycle lifeCycle) {
        Method[] declaredMethods;
        Field[] declaredFields;
        int skip;
        if (TabooLibCommon.isStopped()) {
            return;
        }
        if (lifeCycle != null && clazz.isAnnotationPresent(SkipTo.class) && (skip = clazz.getAnnotation(SkipTo.class).value().ordinal()) > lifeCycle.ordinal()) {
            return;
        }
        Supplier<?> instance = Project1Kt.getInstance(clazz, false);
        if (instance == null) {
            return;
        }
        try {
            declaredFields = clazz.getDeclaredFields();
        }
        catch (NoClassDefFoundError ignored) {
            return;
        }
        try {
            declaredMethods = clazz.getDeclaredMethods();
        }
        catch (NoClassDefFoundError ignored) {
            return;
        }
        for (InjectorOrder inj : injectors.classes) {
            if (lifeCycle != null && lifeCycle != inj.getLifeCycle()) continue;
            inj.inject(clazz, instance);
        }
        for (InjectorOrder inj : injectors.fields) {
            if (lifeCycle != null && lifeCycle != inj.getLifeCycle()) continue;
            for (AccessibleObject accessibleObject : declaredFields) {
                ((Field)accessibleObject).setAccessible(true);
                inj.inject((Field)accessibleObject, clazz, instance);
            }
        }
        for (InjectorOrder inj : injectors.methods) {
            if (lifeCycle != null && lifeCycle != inj.getLifeCycle()) continue;
            for (AccessibleObject accessibleObject : declaredMethods) {
                ((Method)accessibleObject).setAccessible(true);
                inj.inject((Method)accessibleObject, clazz, instance);
            }
        }
        for (InjectorOrder inj : injectors.classes) {
            if (lifeCycle != null && lifeCycle != inj.getLifeCycle()) continue;
            inj.postInject(clazz, instance);
        }
    }

    static {
        try {
            for (LifeCycle value : LifeCycle.values()) {
                RuntimeInjector.register(new AwakeFunction(value));
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    private static class Injectors {
        private final List<Injector.Classes> classes = new ArrayList<Injector.Classes>();
        private final List<Injector.Fields> fields = new ArrayList<Injector.Fields>();
        private final List<Injector.Methods> methods = new ArrayList<Injector.Methods>();

        private Injectors() {
        }
    }
}

