/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common5;

import java.util.regex.Pattern;
import me.arasple.mc.trchat.taboolib.common.Isolated;

@Isolated
public class ColorRegex {
    public static Pattern patternIgnoreColor(String regex) {
        return Pattern.compile(ColorRegex.stringToRegexIgnoreColor(regex), 2);
    }

    public static String stringToRegexIgnoreColor(String regex) {
        return ColorRegex.stringToRegex(regex, "(?:\u00a7.)*", true);
    }

    public static String stringToRegex(String str) {
        return ColorRegex.stringToRegex(str, null, false);
    }

    public static String stringToRegex(String str, String delimiter, boolean ignoreColor) {
        StringBuilder builder = new StringBuilder();
        block13: for (int i = 0; i < str.length(); ++i) {
            char c2 = str.charAt(i);
            if (ignoreColor && c2 == '\u00a7') {
                ++i;
                continue;
            }
            if (delimiter != null) {
                builder.append(delimiter);
            }
            switch (c2) {
                case ':': {
                    builder.append("\\:");
                    continue block13;
                }
                case '+': {
                    builder.append("\\+");
                    continue block13;
                }
                case '*': {
                    builder.append("\\*");
                    continue block13;
                }
                case '?': {
                    builder.append("\\?");
                    continue block13;
                }
                case '^': {
                    builder.append("\\^");
                    continue block13;
                }
                case '$': {
                    builder.append("\\$");
                    continue block13;
                }
                case '.': {
                    builder.append("\\.");
                    continue block13;
                }
                case '(': {
                    builder.append("\\(");
                    continue block13;
                }
                case ')': {
                    builder.append("\\)");
                    continue block13;
                }
                case '[': {
                    builder.append("\\[");
                    continue block13;
                }
                case ']': {
                    builder.append("\\]");
                    continue block13;
                }
                default: {
                    builder.append(c2);
                }
            }
        }
        return builder.toString();
    }
}

