/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common5;

import java.util.Objects;
import me.arasple.mc.trchat.taboolib.common.Isolated;

@Isolated
public class Quat {
    public static final double DBL_EPSILON = Double.longBitsToDouble(4372995238176751616L);
    private final double x;
    private final double y;
    private final double z;
    private final double w;

    public Quat(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Quat rotate(Quat vector) {
        return this.rotate(vector.x(), vector.y(), vector.z());
    }

    public Quat rotate(double x, double y, double z) {
        double length = this.length();
        if (Math.abs(length) < DBL_EPSILON) {
            throw new ArithmeticException("Cannot rotate by zero");
        }
        double nx = this.x / length;
        double ny = this.y / length;
        double nz = this.z / length;
        double nw = this.w / length;
        double px = nw * x + ny * z - nz * y;
        double py = nw * y + nz * x - nx * z;
        double pz = nw * z + nx * y - ny * x;
        double pw = -nx * x - ny * y - nz * z;
        return new Quat(pw * -nx + px * nw - py * nz + pz * ny, pw * -ny + py * nw - pz * nx + px * nz, pw * -nz + pz * nw - px * ny + py * nx, 0.0);
    }

    public Quat rotate2D(double angle, double aboutX, double aboutZ) {
        return this.rotate2D(angle, aboutX, aboutZ, 0.0, 0.0);
    }

    public Quat rotate2D(double angle, double aboutX, double aboutZ, double translateX, double translateZ) {
        angle = Math.toRadians(angle);
        double x = this.x - aboutX;
        double z = this.z - aboutZ;
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        double x2 = x * cos - z * sin;
        double z2 = x * sin + z * cos;
        return new Quat(x2 + aboutX + translateX, this.y, z2 + aboutZ + translateZ, 0.0);
    }

    public Quat getMinimum(Quat v2) {
        return Quat.at(Math.min(this.x, v2.x), Math.min(this.y, v2.y), Math.min(this.z, v2.z));
    }

    public Quat getMaximum(Quat v2) {
        return Quat.at(Math.max(this.x, v2.x), Math.max(this.y, v2.y), Math.max(this.z, v2.z));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Quat)) {
            return false;
        }
        Quat quat = (Quat)o;
        return Double.compare(quat.x, this.x) == 0 && Double.compare(quat.y, this.y) == 0 && Double.compare(quat.z, this.z) == 0 && Double.compare(quat.w, this.w) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return "Quat{x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", w=" + this.w + '}';
    }

    public static Quat one() {
        return Quat.at(1.0, 1.0, 1.0);
    }

    public static Quat zero() {
        return Quat.at(0.0, 0.0, 0.0);
    }

    public static Quat at(double x, double y, double z) {
        return new Quat(x, y, z, 0.0);
    }

    public static Quat at(double x, double y, double z, double w) {
        return new Quat(x, y, z, w);
    }

    public static Quat radiansAxis(double angle, Quat vector) {
        return Quat.radiansAxis(angle, vector.x(), vector.y(), vector.z());
    }

    public static Quat radiansAxis(double angle, double x, double y, double z) {
        double halfAngle = angle / 2.0;
        double q = Math.sin(halfAngle) / Math.sqrt(x * x + y * y + z * z);
        return new Quat(x * q, y * q, z * q, Math.cos(halfAngle));
    }
}

