/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common5;

import java.util.Calendar;
import java.util.function.Function;
import me.arasple.mc.trchat.taboolib.common.Isolated;

@Isolated
public enum RealTime {
    START_IN_SUNDAY(r -> {
        Calendar time = Calendar.getInstance();
        switch (((NextTime)r).unit) {
            case HOUR: {
                time.set(14, 0);
                time.set(13, 0);
                time.set(12, 0);
                time.add(10, ((NextTime)r).value);
                return time.getTimeInMillis();
            }
            case DAY: {
                time.set(14, 0);
                time.set(13, 0);
                time.set(12, 0);
                time.set(11, 0);
                time.add(6, ((NextTime)r).value);
                return time.getTimeInMillis();
            }
            case WEEK: {
                time.set(14, 0);
                time.set(13, 0);
                time.set(12, 0);
                time.set(11, 0);
                time.set(7, 1);
                time.add(3, ((NextTime)r).value);
                return time.getTimeInMillis();
            }
        }
        return 0L;
    }),
    START_IN_MONDAY(r -> {
        Calendar time = Calendar.getInstance();
        switch (((NextTime)r).unit) {
            case DAY: 
            case HOUR: {
                return RealTime.START_IN_SUNDAY.next.apply((NextTime)r);
            }
            case WEEK: {
                if (time.get(7) == 1) {
                    time.add(6, 1 + (((NextTime)r).value - 1) * 7);
                } else {
                    time.add(3, ((NextTime)r).value);
                    time.set(7, 2);
                }
                time.set(11, 0);
                time.set(12, 0);
                time.set(13, 0);
                return time.getTimeInMillis();
            }
        }
        return 0L;
    });

    Function<NextTime, Long> next;

    private RealTime(Function<NextTime, Long> next) {
        this.next = next;
    }

    public long nextTime(Type unit, int value) {
        return this.next.apply(new NextTime(unit, value));
    }

    public static enum Type {
        HOUR,
        DAY,
        WEEK;

    }

    static class NextTime {
        private final Type unit;
        private final int value;

        public NextTime(Type unit, int value) {
            this.unit = unit;
            this.value = value;
        }
    }
}

