/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common5;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Map;
import me.arasple.mc.trchat.taboolib.common.Isolated;

@Isolated
public class TimeCycle {
    private static final Map<String, TimeCycle> cacheMap = Maps.newHashMap();
    private final Type type;
    private int day;
    private int hour;
    private int minute;
    private long time;
    private final Map<Long, Calendar> cacheEnd = Maps.newHashMap();
    private Calendar end;
    private String origin;

    public TimeCycle(long time) {
        this.type = Type.TIME;
        this.time = time;
    }

    public TimeCycle(int hour, int minute) {
        this.type = Type.DAY;
        this.hour = hour;
        this.minute = minute;
    }

    public TimeCycle(Type type2, int day, int hour, int minute) {
        this.type = type2;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
    }

    public TimeCycle origin(String origin) {
        this.origin = origin;
        return this;
    }

    public TimeCycle start(long start) {
        if (this.cacheEnd.containsKey(start)) {
            this.end = this.cacheEnd.get(start);
        } else {
            Calendar startCal = Calendar.getInstance();
            startCal.setTimeInMillis(start);
            Calendar endCal = Calendar.getInstance();
            endCal.setTimeInMillis(start);
            this.end = endCal;
            this.end.set(13, 0);
            this.end.set(14, 0);
            this.cacheEnd.put(start, this.end);
            if (this.type != Type.TIME) {
                switch (this.type) {
                    case DAY: {
                        this.end.set(11, this.hour);
                        this.end.set(12, this.minute);
                        if (!startCal.after(this.end)) break;
                        this.end.add(5, 1);
                        break;
                    }
                    case WEEK: {
                        this.end.set(7, this.day + 1);
                        this.end.set(11, this.hour);
                        this.end.set(12, this.minute);
                        if (!startCal.after(this.end)) break;
                        this.end.add(5, 7);
                        break;
                    }
                    case MONTH: {
                        this.end.set(5, this.day);
                        this.end.set(11, this.hour);
                        this.end.set(12, this.minute);
                        if (!startCal.after(this.end)) break;
                        this.end.add(2, 1);
                    }
                }
            }
        }
        return this;
    }

    public boolean isTimeout(long start) {
        return this.type == Type.TIME ? start + this.time < System.currentTimeMillis() : this.isTimeout();
    }

    public boolean isTimeout() {
        return Calendar.getInstance().after(this.end);
    }

    public boolean isEquals() {
        Calendar calendar = Calendar.getInstance();
        switch (this.type) {
            case DAY: {
                return calendar.get(11) == this.hour && calendar.get(12) == this.minute;
            }
            case WEEK: {
                return calendar.get(7) == this.day && calendar.get(11) == this.hour && calendar.get(12) == this.minute;
            }
            case MONTH: {
                return calendar.get(5) == this.day && calendar.get(11) == this.hour && calendar.get(12) == this.minute;
            }
        }
        return false;
    }

    public Type getType() {
        return this.type;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public long getTime() {
        return this.time;
    }

    public String getOrigin() {
        return this.origin;
    }

    public Calendar getEnd() {
        return this.end;
    }

    public String toString() {
        return "Time{type=" + (Object)((Object)this.type) + ", day=" + this.day + ", hour=" + this.hour + ", minute=" + this.minute + ", time=" + this.time + ", cacheEnd=" + this.cacheEnd + ", end=" + this.end + ", origin='" + this.origin + '\'' + '}';
    }

    public static enum Type {
        TIME,
        DAY,
        WEEK,
        MONTH;

    }
}

