/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether;

import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;

public class LocalizedException
extends RuntimeException {
    private final String node;
    private final Object[] params;

    public LocalizedException(String node, Object[] params) {
        this.node = node;
        this.params = params;
    }

    public String getNode() {
        return this.node;
    }

    public Object[] getParams() {
        return this.params;
    }

    @Override
    public String getLocalizedMessage() {
        return QuestService.instance().getLocalizedText(this.node, this.params);
    }

    public Stream<LocalizedException> stream() {
        return Stream.of(this);
    }

    public LocalizedException then(LocalizedException e2) {
        return LocalizedException.batch(this, e2);
    }

    public static LocalizedException of(String node, Object ... params) {
        return new LocalizedException(node, params);
    }

    public static Supplier<LocalizedException> supply(String node, Object ... params) {
        return () -> LocalizedException.of(node, params);
    }

    public static LocalizedException batch(LocalizedException ... exceptions) {
        return new Concat(exceptions);
    }

    private static class Concat
    extends LocalizedException {
        private final LocalizedException[] exceptions;

        public Concat(LocalizedException ... exceptions) {
            super(exceptions[0].node, exceptions[0].params);
            this.exceptions = exceptions;
        }

        @Override
        public Stream<LocalizedException> stream() {
            return Arrays.stream(this.exceptions);
        }

        @Override
        public String getLocalizedMessage() {
            return this.stream().map(LocalizedException::getLocalizedMessage).collect(Collectors.joining("\n"));
        }

        @Override
        public LocalizedException then(LocalizedException e2) {
            LocalizedException[] arr = new LocalizedException[this.exceptions.length + 1];
            System.arraycopy(this.exceptions, 0, arr, 0, this.exceptions.length);
            arr[this.exceptions.length] = e2;
            return new Concat(arr);
        }
    }
}

