/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether.actions;

import java.util.concurrent.CompletableFuture;
import me.arasple.mc.trchat.taboolib.library.kether.ArgTypes;
import me.arasple.mc.trchat.taboolib.library.kether.ExitStatus;
import me.arasple.mc.trchat.taboolib.library.kether.LoadError;
import me.arasple.mc.trchat.taboolib.library.kether.QuestAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestActionParser;
import me.arasple.mc.trchat.taboolib.library.kether.QuestContext;
import org.jetbrains.annotations.NotNull;

final class ExitAction
extends QuestAction<Void> {
    private final boolean running;
    private final boolean waiting;
    private final long timeout;

    public ExitAction(boolean running, boolean waiting, long timeout) {
        this.running = running;
        this.waiting = waiting;
        this.timeout = timeout;
    }

    @Override
    public CompletableFuture<Void> process(@NotNull QuestContext.Frame frame) {
        long actual = this.timeout == 0L ? 0L : System.currentTimeMillis() + this.timeout;
        frame.context().setExitStatus(new ExitStatus(this.running, this.waiting, actual));
        return CompletableFuture.completedFuture(null);
    }

    public static QuestActionParser parser() {
        return QuestActionParser.of(reader -> {
            String element;
            switch (element = reader.nextToken()) {
                case "success": {
                    return new ExitAction(false, false, 0L);
                }
                case "pause": {
                    return new ExitAction(true, false, 0L);
                }
                case "cooldown": {
                    long l = reader.next(ArgTypes.DURATION).toMillis();
                    return new ExitAction(false, true, l);
                }
            }
            throw LoadError.NOT_MATCH.create("success|pause|cooldown", element);
        });
    }
}

