/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether.actions;

import java.util.concurrent.CompletableFuture;
import me.arasple.mc.trchat.taboolib.common5.Coerce;
import me.arasple.mc.trchat.taboolib.library.kether.ParsedAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestActionParser;
import me.arasple.mc.trchat.taboolib.library.kether.QuestContext;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import org.jetbrains.annotations.NotNull;

final class IfAction<U>
extends QuestAction<U> {
    private final ParsedAction<?> condition;
    private final ParsedAction<U> trueAction;
    private final ParsedAction<U> falseAction;

    public IfAction(ParsedAction<?> condition, ParsedAction<U> trueAction, ParsedAction<U> falseAction) {
        this.condition = condition;
        this.trueAction = trueAction;
        this.falseAction = falseAction;
    }

    @Override
    public CompletableFuture<U> process(@NotNull QuestContext.Frame frame) {
        CompletableFuture future = new CompletableFuture();
        frame.newFrame(this.condition).run().thenAccept(t -> {
            if (Coerce.toBoolean(t)) {
                frame.newFrame(this.trueAction).run().thenAccept(future::complete);
            } else {
                frame.newFrame(this.falseAction).run().thenAccept(future::complete);
            }
        });
        return future;
    }

    public static <U, CTX extends QuestContext> QuestActionParser parser(QuestService<CTX> service) {
        return QuestActionParser.of(resolver -> {
            ParsedAction condition = resolver.nextAction();
            resolver.expect("then");
            ParsedAction trueAction = resolver.nextAction();
            if (resolver.hasNext()) {
                resolver.mark();
                String element = resolver.nextToken();
                if (element.equals("else")) {
                    ParsedAction falseAction = resolver.nextAction();
                    return new IfAction(condition, trueAction, falseAction);
                }
                resolver.reset();
            }
            return new IfAction(condition, trueAction, ParsedAction.noop());
        });
    }
}

