/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.database;

import com.zaxxer.hikari_4_0_3.HikariConfig;
import com.zaxxer.hikari_4_0_3.HikariDataSource;
import java.util.Set;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin1531.jvm.internal.Intrinsics;
import me.arasple.mc.trchat.taboolib.common.env.RuntimeDependency;
import me.arasple.mc.trchat.taboolib.module.configuration.Config;
import me.arasple.mc.trchat.taboolib.module.configuration.Configuration;
import me.arasple.mc.trchat.taboolib.module.database.Host;
import me.arasple.mc.trchat.taboolib.module.database.HostSQL;
import me.arasple.mc.trchat.taboolib.module.database.HostSQLite;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@RuntimeDependency(value="!com.zaxxer:HikariCP:4.0.3", test="!com.zaxxer.hikari_4_0_3.HikariDataSource", relocate={"!com.zaxxer.hikari", "!com.zaxxer.hikari_4_0_3"})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u000e\u001a\u00020\r2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bR \u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00048\u0006@BX\u0087.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lme/arasple/mc/trchat/taboolib/module/database/Database;", "", "()V", "<set-?>", "Lme/arasple/mc/trchat/taboolib/module/configuration/Configuration;", "settingsFile", "getSettingsFile", "()Lme/arasple/mc/trchat/taboolib/module/configuration/Configuration;", "createDataSource", "Ljavax/sql/DataSource;", "host", "Lme/arasple/mc/trchat/taboolib/module/database/Host;", "hikariConfig", "Lcom/zaxxer/hikari_4_0_3/HikariConfig;", "createHikariConfig", "module-database-core"})
public final class Database {
    @NotNull
    public static final Database INSTANCE = new Database();
    @Config(value="datasource.yml")
    private static Configuration settingsFile;

    private Database() {
    }

    @NotNull
    public final Configuration getSettingsFile() {
        Configuration configuration = settingsFile;
        if (configuration != null) {
            return configuration;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"settingsFile");
        throw null;
    }

    @NotNull
    public final DataSource createDataSource(@NotNull Host<?> host, @Nullable HikariConfig hikariConfig) {
        Intrinsics.checkNotNullParameter(host, (String)"host");
        HikariConfig hikariConfig2 = hikariConfig;
        return (DataSource)new HikariDataSource(hikariConfig2 == null ? this.createHikariConfig(host) : hikariConfig2);
    }

    public static /* synthetic */ DataSource createDataSource$default(Database database, Host host, HikariConfig hikariConfig, int n, Object object) {
        if ((n & 2) != 0) {
            hikariConfig = null;
        }
        return database.createDataSource(host, hikariConfig);
    }

    @NotNull
    public final HikariConfig createHikariConfig(@NotNull Host<?> host) {
        Set<String> set2;
        Intrinsics.checkNotNullParameter(host, (String)"host");
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(host.getConnectionUrl());
        Object object = host;
        if (object instanceof HostSQL) {
            config.setDriverClassName(this.getSettingsFile().getString("DefaultSettings.DriverClassName", "com.mysql.jdbc.Driver"));
            config.setUsername(((HostSQL)host).getUser());
            config.setPassword(((HostSQL)host).getPassword());
        } else if (object instanceof HostSQLite) {
            config.setDriverClassName("org.sqlite.JDBC");
        } else {
            String string = Intrinsics.stringPlus((String)"Unsupported host: ", host);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        config.setAutoCommit(this.getSettingsFile().getBoolean("DefaultSettings.AutoCommit", true));
        config.setMinimumIdle(this.getSettingsFile().getInt("DefaultSettings.MinimumIdle", 1));
        config.setMaximumPoolSize(this.getSettingsFile().getInt("DefaultSettings.MaximumPoolSize", 10));
        config.setValidationTimeout(this.getSettingsFile().getLong("DefaultSettings.ValidationTimeout", 5000L));
        config.setConnectionTimeout(this.getSettingsFile().getLong("DefaultSettings.ConnectionTimeout", 30000L));
        config.setIdleTimeout(this.getSettingsFile().getLong("DefaultSettings.IdleTimeout", 600000L));
        config.setMaxLifetime(this.getSettingsFile().getLong("DefaultSettings.MaxLifetime", 1800000L));
        if (this.getSettingsFile().contains("DefaultSettings.ConnectionTestQuery")) {
            config.setConnectionTestQuery(this.getSettingsFile().getString("DefaultSettings.ConnectionTestQuery"));
        }
        if (this.getSettingsFile().contains("DefaultSettings.DataSourceProperty") && (object = this.getSettingsFile().getConfigurationSection("DefaultSettings.DataSourceProperty")) != null && (set2 = object.getKeys(false)) != null) {
            Iterable $this$forEach$iv = set2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl = false;
                config.addDataSourceProperty(key, (Object)INSTANCE.getSettingsFile().getString(Intrinsics.stringPlus((String)"DefaultSettings.DataSourceProperty.", (Object)key)));
            }
        }
        return config;
    }
}

