/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.database.bridge;

import com.google.gson.Gson;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin1531.collections.CollectionsKt;
import kotlin1531.jvm.internal.DefaultConstructorMarker;
import kotlin1531.jvm.internal.Intrinsics;
import me.arasple.mc.trchat.taboolib.common.platform.ProxyPlayer;
import me.arasple.mc.trchat.taboolib.module.configuration.ConfigMigratorKt;
import me.arasple.mc.trchat.taboolib.module.configuration.SecuredFile;
import me.arasple.mc.trchat.taboolib.module.configuration.Update;
import me.arasple.mc.trchat.taboolib.module.database.bridge.BridgeData;
import me.arasple.mc.trchat.taboolib.module.database.bridge.BridgeDatabase;
import me.arasple.mc.trchat.taboolib.module.database.bridge.BridgeKt;
import me.arasple.mc.trchat.taboolib.module.database.bridge.Index;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0005H\u0086\u0002J\u0019\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0002J\u0011\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0086\u0002J\b\u0010!\u001a\u00020\u001eH\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010$\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u0005J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0018\u0010+\u001a\u00020#2\u0006\u0010\u001c\u001a\u00020\u00052\b\u0010,\u001a\u0004\u0018\u00010\rJ\u0010\u0010+\u001a\u00020#2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005J\u000e\u0010+\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R2\u0010\u0016\u001a&\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018 \u0019*\u0012\u0012\f\u0012\n \u0019*\u0004\u0018\u00010\u00180\u0018\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lme/arasple/mc/trchat/taboolib/module/database/bridge/BridgeCollection;", "", "database", "Lme/arasple/mc/trchat/taboolib/module/database/bridge/BridgeDatabase;", "collection", "", "index", "Lme/arasple/mc/trchat/taboolib/module/database/bridge/Index;", "(Lme/arasple/mc/trchat/taboolib/module/database/bridge/BridgeDatabase;Ljava/lang/String;Lme/arasple/mc/trchat/taboolib/module/database/bridge/Index;)V", "getCollection", "()Ljava/lang/String;", "dataMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/arasple/mc/trchat/taboolib/module/database/bridge/BridgeData;", "getDataMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "getDatabase", "()Lme/arasple/mc/trchat/taboolib/module/database/bridge/BridgeDatabase;", "gson", "Lcom/google/gson/Gson;", "getIndex", "()Lme/arasple/mc/trchat/taboolib/module/database/bridge/Index;", "mongoCollection", "Lcom/mongodb/client/MongoCollection;", "Lorg/bson/Document;", "kotlin1531.jvm.PlatformType", "get", "Lme/arasple/mc/trchat/taboolib/module/configuration/SecuredFile;", "id", "cache", "", "player", "Lme/arasple/mc/trchat/taboolib/common/platform/ProxyPlayer;", "hasIndex", "release", "", "remove", "toBson", "", "Lorg/bson/conversions/Bson;", "difference", "", "Lme/arasple/mc/trchat/taboolib/module/configuration/Update;", "update", "data", "module-database-mongodb"})
public final class BridgeCollection {
    @NotNull
    private final BridgeDatabase database;
    @NotNull
    private final String collection;
    @NotNull
    private final Index index;
    @NotNull
    private final ConcurrentHashMap<String, BridgeData> dataMap;
    private final MongoCollection<Document> mongoCollection;
    @NotNull
    private final Gson gson;

    public BridgeCollection(@NotNull BridgeDatabase database, @NotNull String collection, @NotNull Index index) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        Intrinsics.checkNotNullParameter((Object)((Object)index), (String)"index");
        this.database = database;
        this.collection = collection;
        this.index = index;
        this.dataMap = new ConcurrentHashMap();
        this.mongoCollection = this.database.getMongoDatabase().getCollection(this.collection);
        this.gson = new Gson();
        if (!this.hasIndex()) {
            String[] stringArray = new String[]{"id"};
            this.mongoCollection.createIndex(Indexes.ascending((String[])stringArray));
        }
    }

    public /* synthetic */ BridgeCollection(BridgeDatabase bridgeDatabase, String string, Index index, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            index = Index.NONE;
        }
        this(bridgeDatabase, string, index);
    }

    @NotNull
    public final BridgeDatabase getDatabase() {
        return this.database;
    }

    @NotNull
    public final String getCollection() {
        return this.collection;
    }

    @NotNull
    public final Index getIndex() {
        return this.index;
    }

    @NotNull
    public final ConcurrentHashMap<String, BridgeData> getDataMap() {
        return this.dataMap;
    }

    public final void release(@NotNull ProxyPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = this.index == Index.UUID ? player.getUniqueId().toString() : player.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (index == Index.UUID) player.uniqueId.toString() else player.name");
        this.release(string);
    }

    public final void release(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.update(id2, this.dataMap.remove(id2));
    }

    public final void remove(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.dataMap.remove(id2);
    }

    public final void update(@NotNull ProxyPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.update(this.index == Index.UUID ? player.getUniqueId().toString() : player.getName());
    }

    public final void update(@Nullable String id2) {
        if (id2 != null && this.dataMap.containsKey(id2)) {
            this.update(id2, this.dataMap.get(id2));
        }
    }

    public final void update(@NotNull String id2, @Nullable BridgeData data) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (data == null) {
            return;
        }
        Map<String, Object> current = BridgeKt.getValues(data.data());
        if (!data.getChecked() && this.mongoCollection.countDocuments(Filters.eq((String)"id", (Object)id2)) == 0L) {
            this.mongoCollection.insertOne((Object)new Document().append("id", (Object)id2));
        }
        Set<Update> contrast = ConfigMigratorKt.contrastAs(current, (Map<String, ? extends Object>)data.getLastUpdate());
        Collection collection = contrast;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.mongoCollection.updateOne(Filters.eq((String)"id", (Object)id2), Updates.combine(this.toBson(contrast)));
            data.setChecked(true);
            data.getLastUpdate().clear();
            data.getLastUpdate().putAll(current);
        }
    }

    @NotNull
    public final SecuredFile get(@NotNull ProxyPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        String string = this.index == Index.UUID ? player.getUniqueId().toString() : player.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (index == Index.UUID) player.uniqueId.toString() else player.name");
        return this.get(string, true);
    }

    @NotNull
    public final SecuredFile get(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        return this.get(id2, true);
    }

    @NotNull
    public final SecuredFile get(@NotNull String id2, boolean cache) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (cache && this.dataMap.containsKey(id2)) {
            BridgeData bridgeData = this.dataMap.get(id2);
            Intrinsics.checkNotNull((Object)bridgeData);
            return bridgeData.data();
        }
        Document find2 = (Document)this.mongoCollection.find(Filters.eq((String)"id", (Object)id2)).first();
        BridgeData data = null;
        if (find2 != null) {
            data = new BridgeData(id2, (Document)find2.get((Object)"data", Document.class));
            data.setChecked(true);
        } else {
            data = new BridgeData(id2);
        }
        Map map2 = this.dataMap;
        boolean bl = false;
        map2.put(id2, data);
        return data.data();
    }

    private final boolean hasIndex() {
        boolean bl;
        block3: {
            ListIndexesIterable listIndexesIterable = this.mongoCollection.listIndexes();
            Intrinsics.checkNotNullExpressionValue((Object)listIndexesIterable, (String)"mongoCollection.listIndexes()");
            Iterable $this$any$iv = (Iterable)listIndexesIterable;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Document it = (Document)element$iv;
                    boolean bl2 = false;
                    if (!((Document)it.get((Object)"key", Document.class)).containsKey((Object)"id")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Bson> toBson(Set<Update> difference) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = difference;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void update2;
            Update update3 = (Update)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Bson bson = update2.getType() == Update.Type.DELETE ? Updates.unset((String)Intrinsics.stringPlus((String)"data.", (Object)update2.getNode())) : Updates.set((String)Intrinsics.stringPlus((String)"data.", (Object)update2.getNode()), (Object)update2.getValue());
            collection.add(bson);
        }
        return (List)destination$iv$iv;
    }
}

