/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.kether;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import kotlin.Metadata;
import kotlin1531.Lazy;
import kotlin1531.LazyKt;
import kotlin1531.jvm.functions.Function0;
import kotlin1531.jvm.internal.Intrinsics;
import me.arasple.mc.trchat.taboolib.common.util.StringKt;
import me.arasple.mc.trchat.taboolib.library.kether.DefaultRegistry;
import me.arasple.mc.trchat.taboolib.library.kether.Quest;
import me.arasple.mc.trchat.taboolib.library.kether.QuestRegistry;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import me.arasple.mc.trchat.taboolib.library.kether.ServiceHolder;
import me.arasple.mc.trchat.taboolib.module.configuration.Config;
import me.arasple.mc.trchat.taboolib.module.configuration.SecuredFile;
import me.arasple.mc.trchat.taboolib.module.kether.ScriptContext;
import me.arasple.mc.trchat.taboolib.module.kether.ScriptSchedulerExecutor;
import me.arasple.mc.trchat.taboolib.module.kether.ScriptService;
import me.arasple.mc.trchat.taboolib.module.kether.Workspace;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J)\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u001e\"\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010 J\u001a\u0010!\u001a\f\u0012\b\u0012\u00060#j\u0002`$0\"2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u001e\u0010&\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001f0'2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u0018\u0010(\u001a\u0012\u0012\u0004\u0012\u00020\u001b\u0012\b\u0012\u00060#j\u0002`$0'H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u0014\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u00020,H\u0016J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020-2\u0006\u0010.\u001a\u00020\u001bH\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0002H\u0016J\u0010\u00102\u001a\u0002002\u0006\u00101\u001a\u00020\u0002H\u0016R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u00020\b8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lme/arasple/mc/trchat/taboolib/module/kether/ScriptService;", "Lme/arasple/mc/trchat/taboolib/library/kether/QuestService;", "Lme/arasple/mc/trchat/taboolib/module/kether/ScriptContext;", "()V", "asyncExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin1531.jvm.PlatformType", "locale", "Lme/arasple/mc/trchat/taboolib/module/configuration/SecuredFile;", "getLocale", "()Lme/arasple/mc/trchat/taboolib/module/configuration/SecuredFile;", "setLocale", "(Lme/arasple/mc/trchat/taboolib/module/configuration/SecuredFile;)V", "mainspace", "Lme/arasple/mc/trchat/taboolib/module/kether/Workspace;", "getMainspace", "()Lme/arasple/mc/trchat/taboolib/module/kether/Workspace;", "mainspace$delegate", "Lkotlin/Lazy;", "registry", "Lme/arasple/mc/trchat/taboolib/library/kether/DefaultRegistry;", "syncExecutor", "Lme/arasple/mc/trchat/taboolib/module/kether/ScriptSchedulerExecutor;", "getAsyncExecutor", "getExecutor", "Ljava/util/concurrent/Executor;", "getLocalizedText", "", "node", "params", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getQuest", "Ljava/util/Optional;", "Lme/arasple/mc/trchat/taboolib/library/kether/Quest;", "Lme/arasple/mc/trchat/taboolib/module/kether/Script;", "id", "getQuestSettings", "", "getQuests", "getRegistry", "Lme/arasple/mc/trchat/taboolib/library/kether/QuestRegistry;", "getRunningQuests", "Lcom/google/common/collect/Multimap;", "", "playerIdentifier", "startQuest", "", "context", "terminateQuest", "module-kether"})
public final class ScriptService
implements QuestService<ScriptContext> {
    @NotNull
    public static final ScriptService INSTANCE = new ScriptService();
    @NotNull
    private static final DefaultRegistry registry;
    @NotNull
    private static final ScriptSchedulerExecutor syncExecutor;
    private static final ScheduledExecutorService asyncExecutor;
    @Config(value="kether.yml")
    public static SecuredFile locale;
    @NotNull
    private static final Lazy mainspace$delegate;

    private ScriptService() {
    }

    @NotNull
    public final SecuredFile getLocale() {
        SecuredFile securedFile = locale;
        if (securedFile != null) {
            return securedFile;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"locale");
        throw null;
    }

    public final void setLocale(@NotNull SecuredFile securedFile) {
        Intrinsics.checkNotNullParameter((Object)securedFile, (String)"<set-?>");
        locale = securedFile;
    }

    @NotNull
    public final Workspace getMainspace() {
        Lazy lazy = mainspace$delegate;
        boolean bl = false;
        return (Workspace)lazy.getValue();
    }

    @Override
    @NotNull
    public QuestRegistry getRegistry() {
        return registry;
    }

    @Override
    @NotNull
    public Optional<Quest> getQuest(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Optional<Quest> optional = Optional.ofNullable(this.getMainspace().getScripts().get(id2));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(mainspace.scripts[id])");
        return optional;
    }

    @Override
    @NotNull
    public Map<String, Object> getQuestSettings(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Map<String, Object> map2 = Collections.unmodifiableMap(this.getMainspace().getScriptsSetting().getOrDefault(id2, (Map<String, Object>)ImmutableMap.of()));
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(mainspace.scriptsSetting.getOrDefault(id, ImmutableMap.of()))");
        return map2;
    }

    @Override
    @NotNull
    public Map<String, Quest> getQuests() {
        Map<String, Quest> map2 = Collections.unmodifiableMap((Map)this.getMainspace().getScripts());
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(mainspace.scripts)");
        return map2;
    }

    @Override
    @NotNull
    public Multimap<String, ScriptContext> getRunningQuests() {
        return (Multimap)this.getMainspace().getRunningScripts();
    }

    @Override
    @NotNull
    public List<ScriptContext> getRunningQuests(@NotNull String playerIdentifier) {
        Intrinsics.checkNotNullParameter((Object)playerIdentifier, (String)"playerIdentifier");
        List<ScriptContext> list = Collections.unmodifiableList(this.getMainspace().getRunningScripts().get((Object)playerIdentifier));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(mainspace.runningScripts[playerIdentifier])");
        return list;
    }

    @Override
    @NotNull
    public Executor getExecutor() {
        return syncExecutor;
    }

    @Override
    @NotNull
    public ScheduledExecutorService getAsyncExecutor() {
        ScheduledExecutorService scheduledExecutorService = asyncExecutor;
        Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService, (String)"asyncExecutor");
        return scheduledExecutorService;
    }

    @Override
    @NotNull
    public String getLocalizedText(@NotNull String node, Object ... params) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = this.getLocale().getString(node, '{' + node + '}');
        Intrinsics.checkNotNull((Object)string);
        return StringKt.replaceWithOrder(string, Arrays.copyOf(params, params.length));
    }

    @Override
    public void startQuest(@NotNull ScriptContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Workspace workspace = this.getMainspace();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        workspace.runScript(string, context);
    }

    @Override
    public void terminateQuest(@NotNull ScriptContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.getMainspace().terminateScript(context);
    }

    static {
        ServiceHolder.setQuestServiceInstance(INSTANCE);
        registry = new DefaultRegistry();
        syncExecutor = ScriptSchedulerExecutor.INSTANCE;
        asyncExecutor = Executors.newScheduledThreadPool(2);
        mainspace$delegate = LazyKt.lazy((Function0)mainspace.2.INSTANCE);
    }
}

