/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.kether;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin1531.collections.CollectionsKt;
import kotlin1531.io.FilesKt;
import kotlin1531.jvm.internal.DefaultConstructorMarker;
import kotlin1531.jvm.internal.Intrinsics;
import kotlin1531.text.StringsKt;
import me.arasple.mc.trchat.taboolib.common.platform.function.IOKt;
import me.arasple.mc.trchat.taboolib.common5.Coerce;
import me.arasple.mc.trchat.taboolib.library.kether.ExitStatus;
import me.arasple.mc.trchat.taboolib.library.kether.ParsedAction;
import me.arasple.mc.trchat.taboolib.library.kether.Quest;
import me.arasple.mc.trchat.taboolib.library.kether.QuestContext;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import me.arasple.mc.trchat.taboolib.module.kether.KetherScriptLoader;
import me.arasple.mc.trchat.taboolib.module.kether.KetherUtilKt;
import me.arasple.mc.trchat.taboolib.module.kether.ScriptContext;
import me.arasple.mc.trchat.taboolib.module.kether.ScriptService;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\u0007J\u0006\u0010\"\u001a\u00020 J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020 J\u0016\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0012J\u000e\u0010(\u001a\u00020 2\u0006\u0010'\u001a\u00020\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR-\u0010\u000f\u001a\u001e\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00120\u00120\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R5\u0010\u0015\u001a&\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0017j\u0002`\u00180\u0016j\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0017j\u0002`\u0018`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bRI\u0010\u001c\u001a:\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d0\u0016j\u001c\u0012\u0004\u0012\u00020\u0005\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d`\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001b\u00a8\u0006)"}, d2={"Lme/arasple/mc/trchat/taboolib/module/kether/Workspace;", "", "file", "Ljava/io/File;", "extension", "", "namespace", "", "(Ljava/io/File;Ljava/lang/String;Ljava/util/List;)V", "getExtension", "()Ljava/lang/String;", "getFile", "()Ljava/io/File;", "getNamespace", "()Ljava/util/List;", "runningScripts", "Lcom/google/common/collect/ListMultimap;", "kotlin1531.jvm.PlatformType", "Lme/arasple/mc/trchat/taboolib/module/kether/ScriptContext;", "getRunningScripts", "()Lcom/google/common/collect/ListMultimap;", "scripts", "Ljava/util/HashMap;", "Lme/arasple/mc/trchat/taboolib/library/kether/Quest;", "Lme/arasple/mc/trchat/taboolib/module/kether/Script;", "Lkotlin/collections/HashMap;", "getScripts", "()Ljava/util/HashMap;", "scriptsSetting", "", "getScriptsSetting", "cancelAll", "", "getRunningScript", "loadAll", "loadScripts", "loadSettings", "runScript", "id", "context", "terminateScript", "module-kether"})
public final class Workspace {
    @NotNull
    private final File file;
    @NotNull
    private final String extension;
    @NotNull
    private final List<String> namespace;
    @NotNull
    private final HashMap<String, Quest> scripts;
    @NotNull
    private final HashMap<String, Map<String, Object>> scriptsSetting;
    @NotNull
    private final ListMultimap<String, ScriptContext> runningScripts;

    public Workspace(@NotNull File file, @NotNull String extension, @NotNull List<String> namespace) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Intrinsics.checkNotNullParameter(namespace, (String)"namespace");
        this.file = file;
        this.extension = extension;
        this.namespace = namespace;
        this.scripts = new HashMap();
        this.scriptsSetting = new HashMap();
        ListMultimap listMultimap = MultimapBuilder.hashKeys().arrayListValues().build();
        Intrinsics.checkNotNull((Object)listMultimap);
        this.runningScripts = listMultimap;
    }

    public /* synthetic */ Workspace(File file, String string, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = ".ks";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(file, string, list);
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    @NotNull
    public final List<String> getNamespace() {
        return this.namespace;
    }

    @NotNull
    public final HashMap<String, Quest> getScripts() {
        return this.scripts;
    }

    @NotNull
    public final HashMap<String, Map<String, Object>> getScriptsSetting() {
        return this.scriptsSetting;
    }

    @NotNull
    public final ListMultimap<String, ScriptContext> getRunningScripts() {
        return this.runningScripts;
    }

    public final void loadAll() {
        this.loadScripts();
        this.loadSettings();
        Map $this$forEach$iv = this.scripts;
        boolean $i$f$forEach = false;
        Map map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            Map<String, Object> map3 = this.getScriptsSetting().get(((Quest)it.getValue()).getId());
            if (!Coerce.toBoolean(map3 == null ? null : map3.get("autostart"))) continue;
            ScriptService.INSTANCE.startQuest(ScriptContext.Companion.create$default(ScriptContext.Companion, (Quest)it.getValue(), null, 2, null));
        }
    }

    public final void loadSettings() {
        this.scriptsSetting.clear();
        Collection<Quest> collection = this.scripts.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"scripts.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Quest quest = (Quest)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)quest, (String)"quest");
            ScriptContext context = ScriptContext.Companion.create$default(ScriptContext.Companion, quest, null, 2, null);
            quest.getBlock("settings").ifPresent(arg_0 -> Workspace.loadSettings$lambda-3$lambda-2(context, arg_0));
            Map map2 = this.getScriptsSetting();
            String string = quest.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"quest.id");
            Object object = context.rootFrame();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.rootFrame()");
            object = KetherUtilKt.deepVars((QuestContext.Frame)object);
            boolean bl2 = false;
            map2.put(string, object);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void loadScripts() {
        if (!this.file.exists()) {
            this.file.mkdirs();
        }
        this.scripts.clear();
        KetherScriptLoader loader = new KetherScriptLoader();
        Path folder2 = this.file.toPath();
        HashMap scriptMap = new HashMap();
        if (Files.notExists(folder2, new LinkOption[0])) {
            Files.createDirectories(folder2, new FileAttribute[0]);
        }
        Iterator iterator = Files.walk(folder2, new FileVisitOption[0]).iterator();
        while (iterator.hasNext()) {
            Object $this$mapNotNull$iv;
            Object object;
            Path path = (Path)iterator.next();
            if (Files.isDirectory(path, new LinkOption[0])) continue;
            try {
                byte[] bytes;
                void $this$mapNotNullTo$iv$iv;
                String name2 = StringsKt.replace$default((String)((Object)folder2.relativize(path)).toString(), (char)File.separatorChar, (char)'.', (boolean)false, (int)4, null);
                if (!StringsKt.endsWith$default((String)name2, (String)this.extension, (boolean)false, (int)2, null)) continue;
                object = path.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"path.toFile()");
                File file = object;
                object = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"UTF_8");
                List text2 = StringsKt.lines((CharSequence)FilesKt.readText((File)file, (Charset)object));
                $this$mapNotNull$iv = text2;
                boolean $i$f$mapNotNull22 = false;
                Object object2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    String it = (String)element$iv$iv;
                    boolean bl2 = false;
                    String string2 = it;
                    boolean bl3 = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if ((StringsKt.startsWith$default((String)((Object)StringsKt.trim((CharSequence)string3)).toString(), (String)"#", (boolean)false, (int)2, null) ? null : it) == null) continue;
                    string = string;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    String it$iv$iv = string;
                    boolean bl6 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                $this$mapNotNull$iv = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                Object $i$f$mapNotNull22 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapNotNull22, (String)"UTF_8");
                boolean bl = false;
                char[] cArray = $this$mapNotNull$iv;
                if (cArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)cArray.getBytes((Charset)$i$f$mapNotNull22), (String)"(this as java.lang.String).getBytes(charset)");
                $this$mapNotNull$iv = scriptMap;
                $i$f$mapNotNull22 = loader.load((QuestService)ScriptService.INSTANCE, name2, bytes, this.namespace);
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$mapNotNull22, (String)"loader.load(ScriptService, name, bytes, namespace)");
                bl = false;
                $this$mapNotNull$iv.put(name2, $i$f$mapNotNull22);
            }
            catch (Exception e2) {
                Object object3 = new Object[]{"Unexpected exception while parsing kether script:"};
                IOKt.warning(object3);
                object3 = e2.getLocalizedMessage();
                if (object3 == null) continue;
                $this$mapNotNull$iv = new char[]{'\n'};
                object = StringsKt.split$default((CharSequence)((CharSequence)object3), (char[])$this$mapNotNull$iv, (boolean)false, (int)0, (int)6, null);
                if (object == null) continue;
                Iterable $this$forEach$iv = (Iterable)object;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{it};
                    IOKt.warning(objectArray);
                }
            }
        }
        this.scripts.putAll(scriptMap);
    }

    public final void cancelAll() {
        Iterable $this$forEach$iv = this.getRunningScript();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptContext it = (ScriptContext)element$iv;
            boolean bl = false;
            this.terminateScript(it);
        }
    }

    @NotNull
    public final List<ScriptContext> getRunningScript() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)this.runningScripts.values());
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"copyOf(runningScripts.values())");
        return (List)immutableList;
    }

    public final void runScript(@NotNull String id2, @NotNull ScriptContext context) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.setId(id2);
        this.runningScripts.put((Object)id2, (Object)context);
        context.runActions().thenRunAsync(() -> Workspace.runScript$lambda-7(this, id2, context), ScriptService.INSTANCE.getExecutor());
    }

    public final void terminateScript(@NotNull ScriptContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!context.getExitStatus().isPresent()) {
            context.setExitStatus(ExitStatus.paused());
            this.runningScripts.remove((Object)context.getId(), (Object)context);
        }
    }

    private static final void loadSettings$lambda-3$lambda-2(ScriptContext $context, Quest.Block it) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<ParsedAction<?>> list = it.getActions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"it.actions");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParsedAction action = (ParsedAction)element$iv;
            boolean bl = false;
            action.process($context.rootFrame());
        }
    }

    private static final void runScript$lambda-7(Workspace this$0, String $id, ScriptContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        this$0.getRunningScripts().remove((Object)$id, (Object)$context);
    }
}

