/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.ui;

import java.util.Random;
import java.util.stream.IntStream;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class VectorUtil {
    public static Item itemDrop(Player player, ItemStack itemStack) {
        return VectorUtil.itemDrop(player, itemStack, 0.0, 0.4);
    }

    public static Item itemDrop(Player player, ItemStack itemStack, double bulletSpread, double radius) {
        double z;
        double y;
        double x;
        Location location = player.getLocation().add(0.0, 1.5, 0.0);
        Item item2 = player.getWorld().dropItem(location, itemStack);
        double yaw = Math.toRadians(-player.getLocation().getYaw() - 90.0f);
        double pitch = Math.toRadians(-player.getLocation().getPitch());
        double v = Math.cos(pitch) * Math.cos(yaw);
        double v1 = -Math.sin(yaw) * Math.cos(pitch);
        if (bulletSpread > 0.0) {
            double[] spread = new double[]{1.0, 1.0, 1.0};
            IntStream.range(0, 3).forEach(t -> {
                spread[t] = (new Random().nextDouble() - new Random().nextDouble()) * bulletSpread * 0.1;
            });
            x = v + spread[0];
            y = Math.sin(pitch) + spread[1];
            z = v1 + spread[2];
        } else {
            x = v;
            y = Math.sin(pitch);
            z = v1;
        }
        Vector dirVel = new Vector(x, y, z);
        item2.setVelocity(dirVel.normalize().multiply(radius));
        return item2;
    }

    public static void entityPush(Entity entity, Location to, double velocity) {
        Location from = entity.getLocation();
        Vector test = to.clone().subtract(from).toVector();
        double elevation = test.getY();
        Double launchAngle = VectorUtil.calculateLaunchAngle(from, to, velocity, elevation, 20.0);
        double distance = Math.sqrt(Math.pow(test.getX(), 2.0) + Math.pow(test.getZ(), 2.0));
        if (distance != 0.0) {
            if (launchAngle == null) {
                launchAngle = Math.atan((40.0 * elevation + Math.pow(velocity, 2.0)) / (40.0 * elevation + 2.0 * Math.pow(velocity, 2.0)));
            }
            double hangTime = VectorUtil.calculateHangTime(launchAngle, velocity, elevation, 20.0);
            test.setY(Math.tan(launchAngle) * distance);
            test = VectorUtil.normalizeVector(test);
            Vector noise = Vector.getRandom();
            noise = noise.multiply(0.1);
            test.add(noise);
            velocity = velocity + 1.188 * Math.pow(hangTime, 2.0) + (new Random().nextDouble() - 0.8) / 2.0;
            test = test.multiply(velocity / 20.0);
            entity.setVelocity(test);
        }
    }

    private static double calculateHangTime(double launchAngle, double v, double elev, double g) {
        double a = v * Math.sin(launchAngle);
        double b = -2.0 * g * elev;
        return Math.pow(a, 2.0) + b < 0.0 ? 0.0 : (a + Math.sqrt(Math.pow(a, 2.0) + b)) / g;
    }

    private static Vector normalizeVector(Vector victor) {
        double mag = Math.sqrt(Math.pow(victor.getX(), 2.0) + Math.pow(victor.getY(), 2.0) + Math.pow(victor.getZ(), 2.0));
        return mag != 0.0 ? victor.multiply(1.0 / mag) : victor.multiply(0);
    }

    private static Double calculateLaunchAngle(Location from, Location to, double v, double elevation, double g) {
        double check;
        Vector vector = from.clone().subtract(to).toVector();
        double distance = Math.sqrt(Math.pow(vector.getX(), 2.0) + Math.pow(vector.getZ(), 2.0));
        double v2 = Math.pow(v, 2.0);
        double v4 = Math.pow(v, 4.0);
        return v4 < (check = g * (g * Math.pow(distance, 2.0) + 2.0 * elevation * v2)) ? null : Double.valueOf(Math.atan((v2 - Math.sqrt(v4 - check)) / (g * distance)));
    }
}

