/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.util.color;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin1531.collections.CollectionsKt;
import kotlin1531.jvm.functions.Function0;
import kotlin1531.jvm.internal.Intrinsics;
import kotlin1531.jvm.internal.StringCompanionObject;
import kotlin1531.math.MathKt;
import kotlin1531.ranges.RangesKt;
import kotlin1531.text.StringsKt;
import me.arasple.mc.trchat.taboolib.common.platform.Platform;
import me.arasple.mc.trchat.taboolib.common.platform.PlatformSide;
import me.arasple.mc.trchat.taboolib.common5.MirrorKt;
import me.arasple.mc.trchat.taboolib.module.nms.MinecraftVersion;
import me.arasple.mc.trchat.util.color.Hex;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;

@PlatformSide(value={Platform.BUKKIT})
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0006'()*+,B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0012H\u0002J\u0015\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u001eJ\u0015\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0015\u0010\"\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\n\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0016\u0010\u0010\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lme/arasple/mc/trchat/util/color/Hex;", "", "()V", "CHARS_UNTIL_LOOP", "", "GRADIENT_PATTERN", "Ljava/util/regex/Pattern;", "kotlin1531.jvm.PlatformType", "getGRADIENT_PATTERN$implementation_bukkit", "()Ljava/util/regex/Pattern;", "HEX_PATTERNS", "", "getHEX_PATTERNS$implementation_bukkit", "()Ljava/util/List;", "RAINBOW_PATTERN", "getRAINBOW_PATTERN$implementation_bukkit", "STOP", "cleanHex", "", "hex", "colorify", "message", "findStop", "content", "searchAfter", "getCaptureGroup", "matcher", "Ljava/util/regex/Matcher;", "group", "parseGradients", "parseGradients$implementation_bukkit", "parseHex", "parseHex$implementation_bukkit", "parseLegacy", "parseRainbow", "parseRainbow$implementation_bukkit", "translateHex", "color", "Ljava/awt/Color;", "AnimatedGradient", "AnimatedRainbow", "ChatColorHexMapping", "ColorGenerator", "Gradient", "Rainbow", "implementation-bukkit"})
public final class Hex {
    @NotNull
    public static final Hex INSTANCE = new Hex();
    private static final int CHARS_UNTIL_LOOP = 30;
    private static final Pattern RAINBOW_PATTERN = Pattern.compile("<(?<type>rainbow|r)(#(?<speed>\\d+))?(:(?<saturation>\\d*\\.?\\d+))?(:(?<brightness>\\d*\\.?\\d+))?(:(?<loop>l|L|loop))?>");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<(?<type>gradient|g)(#(?<speed>\\d+))?(?<hex>(:#([A-Fa-f\\d]{6}|[A-Fa-f\\d]{3})){2,})(:(?<loop>l|L|loop))?>");
    @NotNull
    private static final List<Pattern> HEX_PATTERNS;
    private static final Pattern STOP;

    private Hex() {
    }

    public final Pattern getRAINBOW_PATTERN$implementation_bukkit() {
        return RAINBOW_PATTERN;
    }

    public final Pattern getGRADIENT_PATTERN$implementation_bukkit() {
        return GRADIENT_PATTERN;
    }

    @NotNull
    public final List<Pattern> getHEX_PATTERNS$implementation_bukkit() {
        return HEX_PATTERNS;
    }

    private final String getCaptureGroup(Matcher matcher, String group) {
        String string;
        try {
            string = matcher.group(group);
        }
        catch (IllegalStateException e2) {
            string = null;
        }
        catch (IllegalArgumentException e3) {
            string = null;
        }
        return string;
    }

    @NotNull
    public final String colorify(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String parsed = message;
        parsed = this.parseRainbow$implementation_bukkit(parsed);
        parsed = this.parseGradients$implementation_bukkit(parsed);
        parsed = this.parseHex$implementation_bukkit(parsed);
        parsed = this.parseLegacy(parsed);
        return parsed;
    }

    @NotNull
    public final String parseRainbow$implementation_bukkit(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (String)MirrorKt.mirrorNow("Handler:Color:Rainbow", (Function0)new Function0<String>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String parsed = this.$message;
                Matcher matcher = Hex.INSTANCE.getRAINBOW_PATTERN$implementation_bukkit().matcher(parsed);
                while (matcher.find()) {
                    String after;
                    String before;
                    int n;
                    char[] chars;
                    String content;
                    StringBuilder parsedRainbow = new StringBuilder();
                    int speed = -1;
                    float saturation = 1.0f;
                    float brightness = 1.0f;
                    Matcher matcher2 = matcher;
                    Intrinsics.checkNotNullExpressionValue((Object)matcher2, (String)"matcher");
                    boolean looping = Hex.access$getCaptureGroup(Hex.INSTANCE, matcher2, "looping") != null;
                    Object object = matcher;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"matcher");
                    String speedGroup = Hex.access$getCaptureGroup(Hex.INSTANCE, (Matcher)object, "speed");
                    if (speedGroup != null) {
                        try {
                            object = speedGroup;
                            boolean bl = false;
                            speed = Integer.parseInt((String)object);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    Object object2 = matcher;
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"matcher");
                    String saturationGroup = Hex.access$getCaptureGroup(Hex.INSTANCE, (Matcher)object2, "saturation");
                    if (saturationGroup != null) {
                        try {
                            object2 = saturationGroup;
                            boolean bl = false;
                            saturation = Float.parseFloat((String)object2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    Object object3 = matcher;
                    Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"matcher");
                    String brightnessGroup = Hex.access$getCaptureGroup(Hex.INSTANCE, (Matcher)object3, "brightness");
                    if (brightnessGroup != null) {
                        try {
                            object3 = brightnessGroup;
                            boolean bl = false;
                            brightness = Float.parseFloat((String)object3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    int stop = Hex.access$findStop(Hex.INSTANCE, parsed, matcher.end());
                    String string = parsed;
                    int n2 = matcher.end();
                    int n3 = 0;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string2.substring(n2, stop), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int contentLength = content.length();
                    String string3 = content;
                    int n4 = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4.toCharArray(), (String)"(this as java.lang.String).toCharArray()");
                    n3 = 0;
                    n4 = chars.length - 1;
                    if (n3 < n4) {
                        do {
                            int i;
                            if (chars[i = n3++] != '&' || StringsKt.indexOf$default((CharSequence)"KkLlMmNnOoRr", (char)chars[i + 1], (int)0, (boolean)false, (int)6, null) <= -1) continue;
                            contentLength -= 2;
                        } while (n3 < n4);
                    }
                    int length = looping ? RangesKt.coerceAtMost((int)contentLength, (int)30) : contentLength;
                    ColorGenerator rainbow = speed == -1 ? (ColorGenerator)new Rainbow(length, saturation, brightness) : (ColorGenerator)new AnimatedRainbow(length, saturation, brightness, speed);
                    String compoundedFormat = "";
                    int i = 0;
                    while (i < chars.length) {
                        int next;
                        ChatColor color;
                        char c2 = chars[i];
                        if (c2 == '&' && i + 1 < chars.length && (color = ChatColor.getByChar((char)(next = chars[i + 1]))) != null && color.isFormat()) {
                            compoundedFormat = compoundedFormat + '\u00a7' + (char)next;
                            n = i;
                            n = i = n + 1;
                            i = n + 1;
                            continue;
                        }
                        parsedRainbow.append(Hex.access$translateHex(Hex.INSTANCE, rainbow.next())).append(compoundedFormat).append(c2);
                        next = i;
                        i = next + '\u0001';
                    }
                    String next = parsed;
                    int n5 = 0;
                    n = matcher.start();
                    boolean bl = false;
                    String string5 = next;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n5, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string6 = parsed;
                    n = 0;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string7.substring(stop), (String)"(this as java.lang.String).substring(startIndex)");
                    parsed = before + parsedRainbow + after;
                    matcher = Hex.INSTANCE.getRAINBOW_PATTERN$implementation_bukkit().matcher(parsed);
                }
                return parsed;
            }
        });
    }

    @NotNull
    public final String parseGradients$implementation_bukkit(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (String)MirrorKt.mirrorNow("Handler:Color:Gradients", (Function0)new Function0<String>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String parsed = this.$message;
                Matcher matcher = Hex.INSTANCE.getGRADIENT_PATTERN$implementation_bukkit().matcher(parsed);
                while (matcher.find()) {
                    String after;
                    String before;
                    int n;
                    ColorGenerator colorGenerator;
                    int length;
                    char[] chars;
                    String content;
                    StringBuilder parsedGradient = new StringBuilder();
                    int speed = -1;
                    Matcher matcher2 = matcher;
                    Intrinsics.checkNotNullExpressionValue((Object)matcher2, (String)"matcher");
                    boolean looping = Hex.access$getCaptureGroup(Hex.INSTANCE, matcher2, "loop") != null;
                    String[] stringArray = matcher;
                    Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"matcher");
                    String string = Hex.access$getCaptureGroup(Hex.INSTANCE, (Matcher)stringArray, "hex");
                    Intrinsics.checkNotNull((Object)string);
                    stringArray = string;
                    int n2 = 1;
                    boolean bl = false;
                    if (stringArray == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = stringArray.substring(n2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    stringArray = new String[]{":"};
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)string2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray222 = false;
                    Collection thisCollection$iv2 = $this$toTypedArray$iv;
                    String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
                    if (stringArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    List<T> hexSteps = Arrays.stream(stringArray2).map(parseGradients.1::invoke$lambda-0).map(parseGradients.1::invoke$lambda-1).collect(Collectors.toList());
                    Object $i$f$toTypedArray222 = matcher;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$toTypedArray222, (String)"matcher");
                    String speedGroup = Hex.access$getCaptureGroup(Hex.INSTANCE, (Matcher)$i$f$toTypedArray222, "speed");
                    if (speedGroup != null) {
                        try {
                            $i$f$toTypedArray222 = speedGroup;
                            boolean thisCollection$iv2 = false;
                            speed = Integer.parseInt((String)$i$f$toTypedArray222);
                        }
                        catch (NumberFormatException $i$f$toTypedArray222) {
                            // empty catch block
                        }
                    }
                    int stop = Hex.access$findStop(Hex.INSTANCE, parsed, matcher.end());
                    String string3 = parsed;
                    int n3 = matcher.end();
                    int n4 = 0;
                    String string4 = string3;
                    if (string4 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string4.substring(n3, stop), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int contentLength = content.length();
                    String string5 = content;
                    int n5 = 0;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string6.toCharArray(), (String)"(this as java.lang.String).toCharArray()");
                    n4 = 0;
                    n5 = chars.length - 1;
                    if (n4 < n5) {
                        do {
                            int i;
                            if (chars[i = n4++] != '&' || StringsKt.indexOf$default((CharSequence)"KkLlMmNnOoRr", (char)chars[i + 1], (int)0, (boolean)false, (int)6, null) <= -1) continue;
                            contentLength -= 2;
                        } while (n4 < n5);
                    }
                    int n6 = length = looping ? RangesKt.coerceAtMost((int)contentLength, (int)30) : contentLength;
                    if (speed == -1) {
                        Intrinsics.checkNotNullExpressionValue(hexSteps, (String)"hexSteps");
                        colorGenerator = new Gradient(hexSteps, length);
                    } else {
                        Intrinsics.checkNotNullExpressionValue(hexSteps, (String)"hexSteps");
                        colorGenerator = new AnimatedGradient(hexSteps, length, speed);
                    }
                    ColorGenerator gradient = colorGenerator;
                    String compoundedFormat = "";
                    int i = 0;
                    while (i < chars.length) {
                        int next;
                        ChatColor color;
                        char c2 = chars[i];
                        if (c2 == '&' && i + 1 < chars.length && (color = ChatColor.getByChar((char)(next = chars[i + 1]))) != null && color.isFormat()) {
                            compoundedFormat = compoundedFormat + '\u00a7' + (char)next;
                            n = i;
                            n = i = n + 1;
                            i = n + 1;
                            continue;
                        }
                        parsedGradient.append(Hex.access$translateHex(Hex.INSTANCE, gradient.next())).append(compoundedFormat).append(c2);
                        next = i;
                        i = next + '\u0001';
                    }
                    String next = parsed;
                    int n7 = 0;
                    n = matcher.start();
                    boolean bl2 = false;
                    String string7 = next;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string7.substring(n7, n), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    String string8 = parsed;
                    n = 0;
                    String string9 = string8;
                    if (string9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)string9.substring(stop), (String)"(this as java.lang.String).substring(startIndex)");
                    parsed = before + parsedGradient + after;
                    matcher = Hex.INSTANCE.getGRADIENT_PATTERN$implementation_bukkit().matcher(parsed);
                }
                return parsed;
            }

            private static final String invoke$lambda-0(String x) {
                String string;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                if (x.length() != 4) {
                    string = x;
                } else {
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string2 = "#%s%s%s%s%s%s";
                    Object[] objectArray = new Object[]{Character.valueOf(x.charAt(1)), Character.valueOf(x.charAt(1)), Character.valueOf(x.charAt(2)), Character.valueOf(x.charAt(2)), Character.valueOf(x.charAt(3)), Character.valueOf(x.charAt(3))};
                    boolean bl = false;
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                }
                return string;
            }

            private static final Color invoke$lambda-1(String nm) {
                return Color.decode(nm);
            }
        });
    }

    @NotNull
    public final String parseHex$implementation_bukkit(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return (String)MirrorKt.mirrorNow("Handler:Color:Hex", (Function0)new Function0<String>(message){
            final /* synthetic */ String $message;
            {
                this.$message = $message;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String parsed = this.$message;
                for (Pattern pattern : Hex.INSTANCE.getHEX_PATTERNS$implementation_bukkit()) {
                    Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"HEX_PATTERNS");
                    Pattern pattern2 = pattern;
                    Matcher matcher = pattern2.matcher(parsed);
                    while (matcher.find()) {
                        String after;
                        String before;
                        String string = matcher.group();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"matcher.group()");
                        String color = Hex.access$translateHex(Hex.INSTANCE, Hex.access$cleanHex(Hex.INSTANCE, string));
                        String string2 = parsed;
                        int n = 0;
                        int n2 = matcher.start();
                        boolean bl = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string3.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String string4 = parsed;
                        n2 = matcher.end();
                        bl = false;
                        String string5 = string4;
                        if (string5 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)string5.substring(n2), (String)"(this as java.lang.String).substring(startIndex)");
                        parsed = before + color + after;
                        matcher = pattern2.matcher(parsed);
                    }
                }
                return parsed;
            }
        });
    }

    private final String parseLegacy(String message) {
        String string = net.md_5.bungee.api.ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"translateAlternateColorCodes('&', message)");
        return string;
    }

    private final int findStop(String content, int searchAfter) {
        Matcher matcher = STOP.matcher(content);
        while (matcher.find()) {
            if (matcher.start() <= searchAfter) continue;
            return matcher.start();
        }
        return content.length();
    }

    private final String cleanHex(String hex) {
        String string;
        if (StringsKt.startsWith$default((String)hex, (String)"<", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)hex, (String)"{", (boolean)false, (int)2, null)) {
            String string2 = hex;
            int n = 1;
            int n2 = hex.length() - 1;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else if (StringsKt.startsWith$default((String)hex, (String)"&", (boolean)false, (int)2, null)) {
            String string5 = hex;
            int n = 1;
            boolean bl = false;
            String string6 = string5;
            if (string6 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.substring(n);
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = hex;
        }
        return string;
    }

    private final String translateHex(String hex) {
        String string;
        if (MinecraftVersion.INSTANCE.getMajorLegacy() >= 11600) {
            String string2 = net.md_5.bungee.api.ChatColor.of((String)hex).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"of(hex).toString()");
            string = string2;
        } else {
            Color color = Color.decode(hex);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"decode(hex)");
            string = this.translateHex(color);
        }
        return string;
    }

    private final String translateHex(Color color) {
        if (MinecraftVersion.INSTANCE.getMajorLegacy() >= 11600) {
            String string = net.md_5.bungee.api.ChatColor.of((Color)color).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"of(color).toString()");
            return string;
        }
        int minDist = Integer.MAX_VALUE;
        net.md_5.bungee.api.ChatColor legacy = net.md_5.bungee.api.ChatColor.WHITE;
        for (ChatColorHexMapping mapping2 : ChatColorHexMapping.values()) {
            int b;
            int g;
            int r = mapping2.getRed() - color.getRed();
            int dist = r * r + (g = mapping2.getGreen() - color.getGreen()) * g + (b = mapping2.getBlue() - color.getBlue()) * b;
            if (dist >= minDist) continue;
            minDist = dist;
            legacy = mapping2.getChatColor();
        }
        String string = legacy.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"legacy.toString()");
        return string;
    }

    public static final /* synthetic */ String access$getCaptureGroup(Hex $this, Matcher matcher, String group) {
        return $this.getCaptureGroup(matcher, group);
    }

    public static final /* synthetic */ int access$findStop(Hex $this, String content, int searchAfter) {
        return $this.findStop(content, searchAfter);
    }

    public static final /* synthetic */ String access$translateHex(Hex $this, Color color) {
        return $this.translateHex(color);
    }

    public static final /* synthetic */ String access$translateHex(Hex $this, String hex) {
        return $this.translateHex(hex);
    }

    public static final /* synthetic */ String access$cleanHex(Hex $this, String hex) {
        return $this.cleanHex(hex);
    }

    static {
        Object[] objectArray = new Pattern[]{Pattern.compile("<#([A-Fa-f\\d]){6}>"), Pattern.compile("\\{#([A-Fa-f\\d]){6}}"), Pattern.compile("&#([A-Fa-f\\d]){6}"), Pattern.compile("#([A-Fa-f\\d]){6}"), Pattern.compile("&\\{#([A-Fa-f\\d]){6}}")};
        HEX_PATTERNS = CollectionsKt.listOf((Object[])objectArray);
        STOP = Pattern.compile("<(rainbow|r)(#(\\d+))?(:(\\d*\\.?\\d+))?(:(\\d*\\.?\\d+))?(:(l|L|loop))?>|<(gradient|g)(#(\\d+))?((:#([A-Fa-f\\d]{6}|[A-Fa-f\\d]{3})){2,})(:(l|L|loop))?>|(&[a-f\\dr])|<#([A-Fa-f\\d]){6}>|\\{#([A-Fa-f\\d]){6}}|&#([A-Fa-f\\d]){6}|#([A-Fa-f\\d]){6}|\u00a7");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001ej\u0002\b\u001f\u00a8\u0006 "}, d2={"Lme/arasple/mc/trchat/util/color/Hex$ChatColorHexMapping;", "", "hex", "", "chatColor", "Lnet/md_5/bungee/api/ChatColor;", "(Ljava/lang/String;IILnet/md_5/bungee/api/ChatColor;)V", "blue", "getBlue", "()I", "getChatColor", "()Lnet/md_5/bungee/api/ChatColor;", "green", "getGreen", "red", "getRed", "BLACK", "DARK_BLUE", "DARK_GREEN", "DARK_AQUA", "DARK_RED", "DARK_PURPLE", "GOLD", "GRAY", "DARK_GRAY", "BLUE", "GREEN", "AQUA", "RED", "LIGHT_PURPLE", "YELLOW", "WHITE", "implementation-bukkit"})
    private static final class ChatColorHexMapping
    extends Enum<ChatColorHexMapping> {
        @NotNull
        private final net.md_5.bungee.api.ChatColor chatColor;
        private final int red;
        private final int green;
        private final int blue;
        public static final /* enum */ ChatColorHexMapping BLACK;
        public static final /* enum */ ChatColorHexMapping DARK_BLUE;
        public static final /* enum */ ChatColorHexMapping DARK_GREEN;
        public static final /* enum */ ChatColorHexMapping DARK_AQUA;
        public static final /* enum */ ChatColorHexMapping DARK_RED;
        public static final /* enum */ ChatColorHexMapping DARK_PURPLE;
        public static final /* enum */ ChatColorHexMapping GOLD;
        public static final /* enum */ ChatColorHexMapping GRAY;
        public static final /* enum */ ChatColorHexMapping DARK_GRAY;
        public static final /* enum */ ChatColorHexMapping BLUE;
        public static final /* enum */ ChatColorHexMapping GREEN;
        public static final /* enum */ ChatColorHexMapping AQUA;
        public static final /* enum */ ChatColorHexMapping RED;
        public static final /* enum */ ChatColorHexMapping LIGHT_PURPLE;
        public static final /* enum */ ChatColorHexMapping YELLOW;
        public static final /* enum */ ChatColorHexMapping WHITE;
        private static final /* synthetic */ ChatColorHexMapping[] $VALUES;

        private ChatColorHexMapping(int hex, net.md_5.bungee.api.ChatColor chatColor) {
            this.chatColor = chatColor;
            this.red = hex >> 16 & 0xFF;
            this.green = hex >> 8 & 0xFF;
            this.blue = hex & 0xFF;
        }

        @NotNull
        public final net.md_5.bungee.api.ChatColor getChatColor() {
            return this.chatColor;
        }

        public final int getRed() {
            return this.red;
        }

        public final int getGreen() {
            return this.green;
        }

        public final int getBlue() {
            return this.blue;
        }

        public static ChatColorHexMapping[] values() {
            return (ChatColorHexMapping[])$VALUES.clone();
        }

        public static ChatColorHexMapping valueOf(String value) {
            return Enum.valueOf(ChatColorHexMapping.class, value);
        }

        static {
            net.md_5.bungee.api.ChatColor chatColor = net.md_5.bungee.api.ChatColor.BLACK;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"BLACK");
            BLACK = new ChatColorHexMapping(0, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.DARK_BLUE;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"DARK_BLUE");
            DARK_BLUE = new ChatColorHexMapping(170, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.DARK_GREEN;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"DARK_GREEN");
            DARK_GREEN = new ChatColorHexMapping(43520, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.DARK_AQUA;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"DARK_AQUA");
            DARK_AQUA = new ChatColorHexMapping(43690, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.DARK_RED;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"DARK_RED");
            DARK_RED = new ChatColorHexMapping(0xAA0000, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.DARK_PURPLE;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"DARK_PURPLE");
            DARK_PURPLE = new ChatColorHexMapping(0xAA00AA, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.GOLD;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"GOLD");
            GOLD = new ChatColorHexMapping(0xFFAA00, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"GRAY");
            GRAY = new ChatColorHexMapping(0xAAAAAA, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.DARK_GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"DARK_GRAY");
            DARK_GRAY = new ChatColorHexMapping(0x555555, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.BLUE;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"BLUE");
            BLUE = new ChatColorHexMapping(0x5555FF, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.GREEN;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"GREEN");
            GREEN = new ChatColorHexMapping(0x55FF55, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.AQUA;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"AQUA");
            AQUA = new ChatColorHexMapping(0x55FFFF, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.RED;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"RED");
            RED = new ChatColorHexMapping(0xFF5555, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.LIGHT_PURPLE;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"LIGHT_PURPLE");
            LIGHT_PURPLE = new ChatColorHexMapping(0xFF55FF, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.YELLOW;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"YELLOW");
            YELLOW = new ChatColorHexMapping(0xFFFF55, chatColor);
            chatColor = net.md_5.bungee.api.ChatColor.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)chatColor, (String)"WHITE");
            WHITE = new ChatColorHexMapping(0xFFFFFF, chatColor);
            $VALUES = chatColorHexMappingArray = new ChatColorHexMapping[]{ChatColorHexMapping.BLACK, ChatColorHexMapping.DARK_BLUE, ChatColorHexMapping.DARK_GREEN, ChatColorHexMapping.DARK_AQUA, ChatColorHexMapping.DARK_RED, ChatColorHexMapping.DARK_PURPLE, ChatColorHexMapping.GOLD, ChatColorHexMapping.GRAY, ChatColorHexMapping.DARK_GRAY, ChatColorHexMapping.BLUE, ChatColorHexMapping.GREEN, ChatColorHexMapping.AQUA, ChatColorHexMapping.RED, ChatColorHexMapping.LIGHT_PURPLE, ChatColorHexMapping.YELLOW, ChatColorHexMapping.WHITE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\t\u0010\u0002\u001a\u00020\u0003H\u00a6\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lme/arasple/mc/trchat/util/color/Hex$ColorGenerator;", "", "next", "Ljava/awt/Color;", "implementation-bukkit"})
    private static interface ColorGenerator {
        @NotNull
        public Color next();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0012B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0004H\u0096\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lme/arasple/mc/trchat/util/color/Hex$Gradient;", "Lme/arasple/mc/trchat/util/color/Hex$ColorGenerator;", "colors", "", "Ljava/awt/Color;", "steps", "", "(Ljava/util/List;I)V", "gradients", "", "Lme/arasple/mc/trchat/util/color/Hex$Gradient$TwoStopGradient;", "step", "", "getStep", "()J", "setStep", "(J)V", "next", "TwoStopGradient", "implementation-bukkit"})
    public static class Gradient
    implements ColorGenerator {
        @NotNull
        private final List<TwoStopGradient> gradients;
        private final int steps;
        private long step;

        public Gradient(@NotNull List<? extends Color> colors, int steps) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            if (colors.size() < 2) {
                throw new IllegalArgumentException("Must provide at least 2 colors");
            }
            this.gradients = new ArrayList();
            this.steps = steps - 1;
            this.step = 0L;
            float increment = (float)this.steps / (float)(colors.size() - 1);
            int n = 0;
            int n2 = colors.size() - 1;
            if (n < n2) {
                do {
                    int i = n++;
                    this.gradients.add(new TwoStopGradient(colors.get(i), colors.get(i + 1), increment * (float)i, increment * (float)(i + 1)));
                } while (n < n2);
            }
        }

        protected final long getStep() {
            return this.step;
        }

        protected final void setStep(long l) {
            this.step = l;
        }

        @Override
        @NotNull
        public Color next() {
            Color color;
            if (MinecraftVersion.INSTANCE.getMajorLegacy() < 11600 || this.steps <= 1) {
                return this.gradients.get(0).colorAt(0);
            }
            double d = (double)this.step * (Math.PI / (double)(2 * this.steps));
            boolean bl = false;
            d = Math.sin(d);
            bl = false;
            d = (double)2 * Math.asin(d) / Math.PI * (double)this.steps;
            bl = false;
            int adjustedStep = MathKt.roundToInt((double)Math.abs(d));
            if (this.gradients.size() < 2) {
                color = this.gradients.get(0).colorAt(adjustedStep);
            } else {
                float segment = (float)this.steps / (float)this.gradients.size();
                double d2 = (float)adjustedStep / segment;
                boolean bl2 = false;
                int index = (int)RangesKt.coerceAtMost((double)Math.floor(d2), (double)(this.gradients.size() - 1));
                color = this.gradients.get(index).colorAt(adjustedStep);
            }
            Color color2 = color;
            Gradient gradient = this;
            long l = gradient.step;
            gradient.step = l + 1L;
            return color2;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/arasple/mc/trchat/util/color/Hex$Gradient$TwoStopGradient;", "", "startColor", "Ljava/awt/Color;", "endColor", "lowerRange", "", "upperRange", "(Ljava/awt/Color;Ljava/awt/Color;FF)V", "calculateHexPiece", "", "step", "channelStart", "channelEnd", "colorAt", "implementation-bukkit"})
        private static final class TwoStopGradient {
            @NotNull
            private final Color startColor;
            @NotNull
            private final Color endColor;
            private final float lowerRange;
            private final float upperRange;

            public TwoStopGradient(@NotNull Color startColor, @NotNull Color endColor, float lowerRange, float upperRange) {
                Intrinsics.checkNotNullParameter((Object)startColor, (String)"startColor");
                Intrinsics.checkNotNullParameter((Object)endColor, (String)"endColor");
                this.startColor = startColor;
                this.endColor = endColor;
                this.lowerRange = lowerRange;
                this.upperRange = upperRange;
            }

            @NotNull
            public final Color colorAt(int step) {
                return new Color(this.calculateHexPiece(step, this.startColor.getRed(), this.endColor.getRed()), this.calculateHexPiece(step, this.startColor.getGreen(), this.endColor.getGreen()), this.calculateHexPiece(step, this.startColor.getBlue(), this.endColor.getBlue()));
            }

            private final int calculateHexPiece(int step, int channelStart, int channelEnd) {
                float range = this.upperRange - this.lowerRange;
                float interval = (float)(channelEnd - channelStart) / range;
                float f = interval * ((float)step - this.lowerRange) + (float)channelStart;
                boolean bl = false;
                boolean bl2 = false;
                float it = f;
                boolean bl3 = false;
                float f2 = it;
                boolean bl4 = false;
                return Float.isNaN(f2) ? 0 : MathKt.roundToInt((float)it);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lme/arasple/mc/trchat/util/color/Hex$AnimatedGradient;", "Lme/arasple/mc/trchat/util/color/Hex$Gradient;", "colors", "", "Ljava/awt/Color;", "steps", "", "speed", "(Ljava/util/List;II)V", "implementation-bukkit"})
    public static final class AnimatedGradient
    extends Gradient {
        public AnimatedGradient(@NotNull List<? extends Color> colors, int steps, int speed) {
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            super(colors, steps);
            this.setStep(System.currentTimeMillis() / (long)speed);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0002R\u0014\u0010\u0006\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\t\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006\u0013"}, d2={"Lme/arasple/mc/trchat/util/color/Hex$Rainbow;", "Lme/arasple/mc/trchat/util/color/Hex$ColorGenerator;", "totalColors", "", "saturation", "", "brightness", "(IFF)V", "getBrightness", "()F", "hue", "getHue", "setHue", "(F)V", "hueStep", "getHueStep", "getSaturation", "next", "Ljava/awt/Color;", "implementation-bukkit"})
    public static class Rainbow
    implements ColorGenerator {
        private final float hueStep;
        private final float saturation;
        private final float brightness;
        private float hue;

        public Rainbow(int totalColors, float saturation, float brightness) {
            this.hueStep = 1.0f / (float)(totalColors < 1 ? 1 : totalColors);
            this.saturation = RangesKt.coerceAtLeast((float)0.0f, (float)RangesKt.coerceAtMost((float)1.0f, (float)saturation));
            this.brightness = RangesKt.coerceAtLeast((float)0.0f, (float)RangesKt.coerceAtMost((float)1.0f, (float)brightness));
            this.hue = 0.0f;
        }

        protected final float getHueStep() {
            return this.hueStep;
        }

        protected final float getSaturation() {
            return this.saturation;
        }

        protected final float getBrightness() {
            return this.brightness;
        }

        protected final float getHue() {
            return this.hue;
        }

        protected final void setHue(float f) {
            this.hue = f;
        }

        @Override
        @NotNull
        public Color next() {
            Color color = Color.getHSBColor(this.hue, this.saturation, this.brightness);
            Rainbow rainbow = this;
            rainbow.hue += this.hueStep;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"color");
            return color;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lme/arasple/mc/trchat/util/color/Hex$AnimatedRainbow;", "Lme/arasple/mc/trchat/util/color/Hex$Rainbow;", "totalColors", "", "saturation", "", "brightness", "speed", "(IFFI)V", "implementation-bukkit"})
    public static final class AnimatedRainbow
    extends Rainbow {
        public AnimatedRainbow(int totalColors, float saturation, float brightness, int speed) {
            super(totalColors, saturation, brightness);
            double d = (double)System.currentTimeMillis() / 50.0;
            boolean bl = false;
            this.setHue((float)(Math.floor(d) / (double)360 * (double)speed % 1.0));
        }
    }
}

