/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.util.proxy.common;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.Comparator;
import java.util.List;
import me.arasple.mc.trchat.util.proxy.common.ByteUtils;
import me.arasple.mc.trchat.util.proxy.common.MessagePacket;
import org.jetbrains.annotations.NotNull;

public class Message {
    private final List<MessagePacket> messages = Lists.newCopyOnWriteArrayList();

    @NotNull
    public String[] build() {
        StringBuilder builder = new StringBuilder();
        this.messages.sort(Comparator.comparingInt(MessagePacket::getIndex));
        this.messages.forEach(message -> builder.append(message.getData()));
        JsonArray json = new JsonParser().parse(ByteUtils.deSerialize(builder.toString())).getAsJsonArray();
        String[] args = new String[json.size()];
        for (int i = 0; i < json.size(); ++i) {
            args[i] = json.get(i).getAsString();
        }
        return args;
    }

    public boolean isCompleted() {
        return !this.messages.isEmpty() && this.messages.size() == this.messages.get(0).getTotal();
    }

    @NotNull
    public List<MessagePacket> getMessages() {
        return this.messages;
    }
}

