/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.util.proxy.common;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import me.arasple.mc.trchat.util.proxy.common.ByteUtils;

public class MessageBuilder {
    public static final int MESSAGE_LENGTH = 30000;

    public static List<byte[]> create(String[] message) throws IOException {
        ArrayList messages = Lists.newArrayList();
        JsonArray array = new JsonArray();
        for (int i = 1; i < message.length; ++i) {
            array.add((JsonElement)new JsonPrimitive(message[i]));
        }
        String source = ByteUtils.serialize(array.toString());
        int times = (int)Math.ceil((double)source.length() / 30000.0);
        for (int i = 0; i < times; ++i) {
            JsonObject json = new JsonObject();
            json.addProperty("uid", message[0]);
            json.addProperty("index", (Number)(i + 1));
            json.addProperty("total", (Number)times);
            if (source.length() < 30000) {
                json.addProperty("data", source);
            } else {
                json.addProperty("data", source.substring(0, source.length() - (source.length() - 30000)));
                source = source.substring(30000);
            }
            messages.add(json.toString().getBytes(StandardCharsets.UTF_8));
        }
        return messages;
    }
}

