/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.commands;

import com.songoda.ultimatetimber.core.chat.ChatMessage;
import com.songoda.ultimatetimber.core.commands.AbstractCommand;
import com.songoda.ultimatetimber.core.commands.SimpleNestedCommand;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MainCommand
extends AbstractCommand {
    String header = null;
    String description;
    boolean sortHelp = false;
    final String command;
    final Plugin plugin;
    protected final SimpleNestedCommand nestedCommands;

    public MainCommand(Plugin plugin, String command) {
        super(AbstractCommand.CommandType.CONSOLE_OK, command);
        this.command = command;
        this.plugin = plugin;
        this.description = "Shows the command help page for /" + command;
        this.nestedCommands = new SimpleNestedCommand(this);
    }

    public MainCommand setHeader(String header) {
        this.header = header;
        return this;
    }

    public MainCommand setDescription(String description) {
        this.description = description;
        return this;
    }

    public MainCommand setSortHelp(boolean sortHelp) {
        this.sortHelp = sortHelp;
        return this;
    }

    public MainCommand addSubCommand(AbstractCommand command) {
        this.nestedCommands.addSubCommand(command);
        return this;
    }

    public MainCommand addSubCommands(AbstractCommand ... commands) {
        this.nestedCommands.addSubCommands(commands);
        return this;
    }

    @Override
    protected AbstractCommand.ReturnType runCommand(CommandSender sender, String ... args) {
        sender.sendMessage("");
        if (this.header != null) {
            sender.sendMessage(this.header);
        } else {
            new ChatMessage().fromText(String.format("#ff8080&l%s &8\u00bb &7Version %s Created with <3 by #ec4e74&l&oS#fa5b65&l&oo#ff6c55&l&on#ff7f44&l&og#ff9432&l&oo#ffaa1e&l&od#f4c009&l&oa", this.plugin.getDescription().getName(), this.plugin.getDescription().getVersion()), sender instanceof ConsoleCommandSender).sendTo(sender);
        }
        sender.sendMessage(ChatColor.DARK_GRAY + "- " + ChatColor.YELLOW + "/songoda" + ChatColor.GRAY + " - Opens the Songoda plugin GUI");
        sender.sendMessage("");
        if (this.nestedCommands != null) {
            List commands = this.nestedCommands.children.values().stream().distinct().map(c -> c.getCommands().get(0)).collect(Collectors.toList());
            if (this.sortHelp) {
                Collections.sort(commands);
            }
            boolean isPlayer = sender instanceof Player;
            sender.sendMessage(ChatColor.DARK_GRAY + "- " + ChatColor.YELLOW + this.getSyntax() + ChatColor.GRAY + " - " + this.getDescription());
            for (String cmdStr : commands) {
                AbstractCommand cmd = this.nestedCommands.children.get(cmdStr);
                if (cmd == null) continue;
                if (!isPlayer) {
                    sender.sendMessage(ChatColor.DARK_GRAY + "- " + ChatColor.YELLOW + cmd.getSyntax() + ChatColor.GRAY + " - " + cmd.getDescription());
                    continue;
                }
                if (cmd.getPermissionNode() != null && !sender.hasPermission(cmd.getPermissionNode())) continue;
                ChatMessage chatMessage = new ChatMessage();
                String c2 = "/" + this.command + " ";
                chatMessage.addMessage(ChatColor.DARK_GRAY + "- ").addPromptCommand(ChatColor.YELLOW + c2 + cmd.getSyntax(), ChatColor.YELLOW + c2 + cmdStr, c2 + cmdStr).addMessage(ChatColor.GRAY + " - " + cmd.getDescription());
                chatMessage.sendTo(sender);
            }
        }
        sender.sendMessage("");
        return AbstractCommand.ReturnType.SUCCESS;
    }

    @Override
    protected List<String> onTab(CommandSender sender, String ... args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return null;
    }

    @Override
    public String getSyntax() {
        return "/" + this.command;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

