/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.compatibility;

import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import com.viaversion.viaversion.api.Via;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import protocolsupport.api.ProtocolSupportAPI;

public class ClientVersion {
    static HashMap<UUID, ServerVersion> players = new HashMap();

    public static ServerVersion getClientVersion(Player player) {
        if (player == null || !players.containsKey(player.getUniqueId())) {
            return ServerVersion.getServerVersion();
        }
        return players.get(player.getUniqueId());
    }

    @Deprecated
    public static void onLoginProtocol(Player p, JavaPlugin plugin) {
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            if (p.isOnline()) {
                int version = ProtocolSupportAPI.getProtocolVersion((Player)p).getId();
                players.put(p.getUniqueId(), ClientVersion.protocolToVersion(version));
            }
        }, 20L);
    }

    @Deprecated
    public static void onLoginVia(Player p, JavaPlugin plugin) {
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            if (p.isOnline()) {
                int version = Via.getAPI().getPlayerVersion(p.getUniqueId());
                players.put(p.getUniqueId(), ClientVersion.protocolToVersion(version));
            }
        }, 20L);
    }

    private static ServerVersion protocolToVersion(int version) {
        switch (version) {
            case 4: 
            case 5: {
                return ServerVersion.V1_7;
            }
            case 47: {
                return ServerVersion.V1_8;
            }
            case 107: 
            case 108: 
            case 109: 
            case 110: {
                return ServerVersion.V1_9;
            }
            case 210: {
                return ServerVersion.V1_10;
            }
            case 315: 
            case 316: {
                return ServerVersion.V1_11;
            }
            case 335: 
            case 338: 
            case 340: {
                return ServerVersion.V1_12;
            }
            case 393: 
            case 401: 
            case 404: {
                return ServerVersion.V1_13;
            }
            case 477: 
            case 485: 
            case 490: 
            case 498: {
                return ServerVersion.V1_14;
            }
            case 573: 
            case 575: 
            case 578: {
                return ServerVersion.V1_15;
            }
            case 735: 
            case 736: 
            case 751: 
            case 753: 
            case 754: {
                return ServerVersion.V1_16;
            }
            case 755: 
            case 756: {
                return ServerVersion.V1_17;
            }
        }
        return version > 756 ? ServerVersion.getServerVersion() : ServerVersion.UNKNOWN;
    }

    @Deprecated
    public static void onLogout(Player p) {
        players.remove(p.getUniqueId());
    }
}

