/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.database;

import com.songoda.ultimatetimber.core.database.DatabaseConnector;
import com.songoda.ultimatetimber.core.database.DatabaseType;
import com.songoda.ultimatetimber.core.database.SQLiteConnector;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DataManagerAbstract {
    protected final DatabaseConnector databaseConnector;
    protected final Plugin plugin;
    protected final DatabaseType type;
    protected final ExecutorService asyncPool = Executors.newSingleThreadExecutor();
    @Deprecated
    private static final Map<String, LinkedList<Runnable>> queues = new HashMap<String, LinkedList<Runnable>>();

    public DataManagerAbstract(DatabaseConnector databaseConnector, Plugin plugin) {
        this.databaseConnector = databaseConnector;
        this.plugin = plugin;
        this.type = databaseConnector.getType();
    }

    public String getTablePrefix() {
        return this.plugin.getDescription().getName().toLowerCase() + '_';
    }

    @Deprecated
    protected int lastInsertedId(Connection connection) {
        return this.lastInsertedId(connection, null);
    }

    @Deprecated
    protected int lastInsertedId(Connection connection, String table) {
        String select = "SELECT * FROM " + this.getTablePrefix() + table + " ORDER BY id DESC LIMIT 1";
        String query = this.databaseConnector instanceof SQLiteConnector ? (table == null ? "SELECT last_insert_rowid()" : select) : (table == null ? "SELECT LAST_INSERT_ID()" : select);
        int id = -1;
        try (Statement statement = connection.createStatement();){
            ResultSet result = statement.executeQuery(query);
            result.next();
            id = result.getInt(1);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return id;
    }

    @Deprecated
    public void async(Runnable runnable) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, runnable);
    }

    public CompletableFuture<Void> asyncFuture(Runnable runnable) {
        return CompletableFuture.runAsync(runnable, this.asyncPool);
    }

    public void sync(Runnable runnable) {
        Bukkit.getScheduler().runTask(this.plugin, runnable);
    }

    public void runAsync(Runnable runnable) {
        this.runAsync(runnable, null);
    }

    public void runAsync(Runnable task, Consumer<Throwable> callback) {
        this.asyncPool.execute(() -> {
            try {
                task.run();
                if (callback != null) {
                    callback.accept(null);
                }
            }
            catch (Throwable th) {
                if (callback != null) {
                    callback.accept(th);
                    return;
                }
                th.printStackTrace();
            }
        });
    }

    public void shutdownTaskQueue() {
        this.asyncPool.shutdown();
    }

    public List<Runnable> forceShutdownTaskQueue() {
        return this.asyncPool.shutdownNow();
    }

    public boolean isTaskQueueTerminated() {
        return this.asyncPool.isTerminated();
    }

    public long getTaskQueueSize() {
        if (this.asyncPool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.asyncPool).getTaskCount();
        }
        return -1L;
    }

    public boolean waitForShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.asyncPool.awaitTermination(timeout, unit);
    }

    @Deprecated
    public void queueAsync(Runnable runnable, String queueKey) {
        if (queueKey == null) {
            return;
        }
        List queue = queues.computeIfAbsent(queueKey, t -> new LinkedList());
        queue.add(runnable);
        if (queue.size() == 1) {
            this.runQueue(queueKey);
        }
    }

    @Deprecated
    private void runQueue(String queueKey) {
        this.doQueue(queueKey, s -> {
            if (!queues.get(queueKey).isEmpty()) {
                this.runQueue(queueKey);
            }
        });
    }

    @Deprecated
    private void doQueue(String queueKey, Consumer<Boolean> callback) {
        Runnable runnable = queues.get(queueKey).getFirst();
        this.async(() -> {
            runnable.run();
            this.sync(() -> {
                queues.get(queueKey).remove(runnable);
                callback.accept(true);
            });
        });
    }

    public String getSyntax(String string, DatabaseType type) {
        if (this.type == type) {
            return string;
        }
        return "";
    }
}

