/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.gui;

import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.gui.Gui;
import com.songoda.ultimatetimber.core.gui.GuiHolder;
import com.songoda.ultimatetimber.core.gui.GuiManager;
import com.songoda.ultimatetimber.core.gui.GuiUtils;
import com.songoda.ultimatetimber.core.gui.events.GuiClickEvent;
import com.songoda.ultimatetimber.core.gui.methods.Clickable;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class SimplePagedGui
extends Gui {
    protected boolean useHeader;
    private int rowsPerPage;
    private int maxCellSlot;
    protected ItemStack headerBackItem;
    protected ItemStack footerBackItem;
    final int nextPageIndex = 4;
    final int prevPageIndex = 6;

    public SimplePagedGui() {
        this((Gui)null);
    }

    public SimplePagedGui(Gui parent) {
        super(parent);
        this.nextPage = GuiUtils.createButtonItem(CompatibleMaterial.ARROW, "Next Page", new String[0]);
        this.prevPage = GuiUtils.createButtonItem(CompatibleMaterial.ARROW, "Previous Page", new String[0]);
    }

    public SimplePagedGui setUseHeader(boolean useHeader) {
        this.useHeader = useHeader;
        return this;
    }

    public ItemStack getHeaderBackItem() {
        return this.headerBackItem;
    }

    public SimplePagedGui setHeaderBackItem(ItemStack headerBackItem) {
        this.headerBackItem = headerBackItem;
        return this;
    }

    public ItemStack getFooterBackItem() {
        return this.footerBackItem;
    }

    public SimplePagedGui setFooterBackItem(ItemStack footerBackItem) {
        this.footerBackItem = footerBackItem;
        return this;
    }

    @Override
    public SimplePagedGui setItem(int row, int col, ItemStack item) {
        return this.setItem(col + row * 9, item);
    }

    @Override
    public SimplePagedGui setItem(int cell, ItemStack item) {
        int cellIndex = cell < 0 ? cell : (this.page == 1 || this.useHeader && cell < 9 ? cell : cell + (this.page - 1) * (this.rowsPerPage * 9));
        this.cellItems.put(cellIndex, item);
        if (this.open && cell >= 0 && cell < this.inventory.getSize()) {
            this.inventory.setItem(cell, item);
        }
        return this;
    }

    @Override
    public void nextPage() {
        if (this.page < this.pages) {
            ++this.page;
            this.showPage();
        }
    }

    @Override
    public void prevPage() {
        if (this.page > 1) {
            --this.page;
            this.showPage();
        }
    }

    public void showPage() {
        int startCell = this.useHeader ? 9 : 0;
        int cellIndex = startCell + (this.page - 1) * (this.rowsPerPage * 9);
        for (int i = startCell; i < (this.rows - 1) * 9; ++i) {
            ItemStack item;
            this.inventory.setItem(i, (item = (ItemStack)this.cellItems.get(cellIndex++)) != null ? item : this.blankItem);
        }
        this.updatePageNavigation();
    }

    @Override
    protected void updatePageNavigation() {
        if (this.page > 1) {
            this.inventory.setItem(this.inventory.getSize() - 6, this.prevPage);
            this.setButton(-6, this.prevPage, ClickType.LEFT, (GuiClickEvent event) -> this.prevPage());
        } else {
            this.inventory.setItem(this.inventory.getSize() - 6, this.footerBackItem != null ? this.footerBackItem : this.blankItem);
            this.setItem(-6, null);
            this.clearActions(-6);
        }
        if (this.pages > 1 && this.page != this.pages) {
            this.inventory.setItem(this.inventory.getSize() - 4, this.nextPage);
            this.setButton(-4, this.nextPage, ClickType.LEFT, (GuiClickEvent event) -> this.nextPage());
        } else {
            this.inventory.setItem(this.inventory.getSize() - 4, this.footerBackItem != null ? this.footerBackItem : this.blankItem);
            this.setItem(-4, null);
            this.clearActions(-4);
        }
    }

    @Override
    protected Inventory generateInventory(GuiManager manager) {
        this.guiManager = manager;
        this.rowsPerPage = this.useHeader ? 4 : 5;
        this.maxCellSlot = this.cellItems.keySet().stream().max(Integer::compare).orElse(0) + 1;
        int maxRows = (int)Math.ceil((double)this.maxCellSlot / 9.0);
        this.pages = (int)Math.max(1.0, Math.ceil((double)maxRows / (double)this.rowsPerPage));
        this.setRows(maxRows + (this.useHeader ? 1 : 0));
        this.createInventory();
        this.setPage(Math.min(this.page, this.pages));
        this.update();
        return this.inventory;
    }

    @Override
    protected void createInventory() {
        int cells = this.rows * 9;
        this.inventory = Bukkit.getServer().createInventory((InventoryHolder)new GuiHolder(this.guiManager, this), cells, this.title == null ? "" : SimplePagedGui.trimTitle(this.title));
    }

    @Override
    public void update() {
        if (this.inventory == null) {
            return;
        }
        this.rowsPerPage = this.useHeader ? 4 : 5;
        this.maxCellSlot = (this.cellItems.isEmpty() ? 0 : (Integer)this.cellItems.keySet().stream().max(Integer::compare).get()) + 1;
        int maxRows = Math.max(this.useHeader ? 1 : 0, (int)Math.ceil((double)this.maxCellSlot / 9.0));
        this.pages = (int)Math.ceil(maxRows / this.rowsPerPage);
        List<Player> toUpdate = null;
        if (Math.min(54, (maxRows + (this.useHeader ? 1 : 0)) * 9) != this.inventory.getSize()) {
            toUpdate = this.getPlayers();
            this.setRows(maxRows + (this.useHeader ? 1 : 0));
            this.createInventory();
        }
        if (this.useHeader) {
            for (int i = 0; i < 9; ++i) {
                ItemStack item = (ItemStack)this.cellItems.get(i);
                this.inventory.setItem(i, item != null ? item : (this.headerBackItem != null ? this.headerBackItem : this.blankItem));
            }
        }
        int cells = this.rows * 9;
        for (int i = cells - 9; i < cells; ++i) {
            this.inventory.setItem(i, this.footerBackItem != null ? this.footerBackItem : this.blankItem);
        }
        this.showPage();
        if (toUpdate != null) {
            this.exit();
            toUpdate.forEach(player -> this.guiManager.showGUI((Player)player, this));
        }
    }

    @Override
    protected boolean onClick(GuiManager manager, Player player, Inventory inventory, InventoryClickEvent event) {
        Clickable button;
        Map conditionals;
        int cell = event.getSlot();
        if (this.useHeader && cell < 9) {
            conditionals = (Map)this.conditionalButtons.get(cell);
        } else if (cell >= (this.rows - 1) * 9) {
            conditionals = (Map)this.conditionalButtons.get(cell - this.rows * 9);
        } else {
            int cellIndex = this.page == 1 ? cell : cell + (this.page - 1) * this.rowsPerPage * 9;
            conditionals = (Map)this.conditionalButtons.get(cellIndex);
        }
        if (conditionals == null || (button = (Clickable)conditionals.get(event.getClick())) == null && (button = (Clickable)conditionals.get(null)) == null) {
            return false;
        }
        button.onClick(new GuiClickEvent(manager, this, player, event, cell, true));
        return true;
    }
}

