/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.hooks.jobs;

import com.gamingmesh.jobs.CMILib.CMIEnchantment;
import com.gamingmesh.jobs.Jobs;
import com.gamingmesh.jobs.actions.BlockActionInfo;
import com.gamingmesh.jobs.actions.CustomKillInfo;
import com.gamingmesh.jobs.actions.EnchantActionInfo;
import com.gamingmesh.jobs.actions.EntityActionInfo;
import com.gamingmesh.jobs.actions.ItemActionInfo;
import com.gamingmesh.jobs.container.ActionInfo;
import com.gamingmesh.jobs.container.ActionType;
import com.gamingmesh.jobs.container.CurrencyType;
import com.gamingmesh.jobs.container.Job;
import com.gamingmesh.jobs.container.JobProgression;
import com.gamingmesh.jobs.container.JobsPlayer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class JobsPlayerHandler {
    protected final JobsPlayer jPlayer;

    protected JobsPlayerHandler(JobsPlayer jPlayer) {
        this.jPlayer = jPlayer;
    }

    public static JobsPlayerHandler loadPlayer(Player player) {
        JobsPlayer jPlayer = Jobs.getPlayerManager().getJobsPlayer(player);
        return jPlayer != null ? new JobsPlayerHandler(jPlayer) : null;
    }

    public double getBoostExp(String job) {
        return this.jPlayer.getBoost(job, CurrencyType.EXP);
    }

    public double getBoostMoney(String job) {
        return this.jPlayer.getBoost(job, CurrencyType.MONEY);
    }

    public double getBoostPoints(String job) {
        return this.jPlayer.getBoost(job, CurrencyType.POINTS);
    }

    public void promoteJob(String jobName) {
        Job job = Jobs.getJob((String)jobName);
        if (job != null) {
            this.jPlayer.promoteJob(job, 1);
        }
    }

    public void promoteJob(String jobName, int levels) {
        Job job = Jobs.getJob((String)jobName);
        if (job != null) {
            this.jPlayer.promoteJob(job, levels);
        }
    }

    public void demoteJob(String jobName) {
        Job job = Jobs.getJob((String)jobName);
        if (job != null) {
            this.jPlayer.demoteJob(job, 1);
        }
    }

    public void demoteJob(String jobName, int levels) {
        Job job = Jobs.getJob((String)jobName);
        if (job != null) {
            this.jPlayer.demoteJob(job, levels);
        }
    }

    public void joinJob(String jobName) {
        Job job = Jobs.getJob((String)jobName);
        if (job != null) {
            this.jPlayer.joinJob(job);
        }
    }

    public void leaveAllJobs() {
        this.jPlayer.leaveAllJobs();
    }

    public void leaveJob(String jobName) {
        Job job = Jobs.getJob((String)jobName);
        if (job != null) {
            this.jPlayer.leaveJob(job);
        }
    }

    public int getTotalLevels() {
        return this.jPlayer.getTotalLevels();
    }

    public int getMaxBrewingStandsAllowed() {
        return this.jPlayer.getMaxBrewingStandsAllowed();
    }

    public int getMaxFurnacesAllowed() {
        return this.jPlayer.getMaxFurnacesAllowed();
    }

    public List<String> getJobs() {
        return this.jPlayer.getJobProgression().stream().map(p -> p.getJob().getName()).collect(Collectors.toList());
    }

    public void eatItem(ItemStack item) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new ItemActionInfo(item, ActionType.EAT));
    }

    public void breakBlock(Block block) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new BlockActionInfo(block, ActionType.BREAK), (Block)block);
    }

    public void tntBreakBlock(Block block) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new BlockActionInfo(block, ActionType.TNTBREAK), (Block)block);
    }

    public void placeBlock(Block block) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new BlockActionInfo(block, ActionType.PLACE), (Block)block);
    }

    public void placeEntity(Entity block) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new EntityActionInfo(block, ActionType.PLACE));
    }

    public void breakEntity(Entity block) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new EntityActionInfo(block, ActionType.BREAK));
    }

    public void breedEntity(LivingEntity entity) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new EntityActionInfo((Entity)entity, ActionType.BREED));
    }

    public void killEntity(LivingEntity entity) {
        this.killEntity(entity, (Entity)this.jPlayer.getPlayer());
    }

    public void tameEntity(LivingEntity entity) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new EntityActionInfo((Entity)entity, ActionType.TAME));
    }

    public void catchFish(ItemStack items) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new ItemActionInfo(items, ActionType.FISH));
    }

    public void killEntity(LivingEntity entity, Entity damageSource) {
        Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new EntityActionInfo((Entity)entity, ActionType.KILL), (Entity)damageSource, (LivingEntity)entity);
        if (entity instanceof Player && !entity.hasMetadata("NPC")) {
            JobsPlayer jVictim = Jobs.getPlayerManager().getJobsPlayer((Player)entity);
            if (jVictim == null) {
                return;
            }
            List jobs = jVictim.getJobProgression();
            if (jobs == null) {
                return;
            }
            for (JobProgression job : jobs) {
                Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new CustomKillInfo(job.getJob().getName(), ActionType.CUSTOMKILL), (Entity)damageSource, (LivingEntity)entity);
            }
        }
    }

    public void itemEnchanted(ItemStack resultStack) {
        Map enchants = resultStack.getEnchantments();
        for (Map.Entry oneEnchant : enchants.entrySet()) {
            Integer level2;
            CMIEnchantment e;
            String enchantName;
            Enchantment enchant = (Enchantment)oneEnchant.getKey();
            if (enchant == null || (enchantName = (e = CMIEnchantment.get((Enchantment)enchant)) == null ? null : e.toString()) == null || (level2 = (Integer)oneEnchant.getValue()) == null) continue;
            Jobs.action((JobsPlayer)this.jPlayer, (ActionInfo)new EnchantActionInfo(enchantName, level2.intValue(), ActionType.ENCHANT));
        }
    }
}

