/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.hooks.mcmmo;

import com.gmail.nossr50.api.AbilityAPI;
import com.gmail.nossr50.api.ExperienceAPI;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.RandomChanceUtil;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillActivationType;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;
import org.bukkit.permissions.Permissible;

public class McMMOHandler {
    static boolean mcmmo_v2 = false;
    static boolean legacy_v13 = false;
    static boolean legacy_v12 = false;
    static boolean legacy_v8 = false;
    static Class mcmmo_SkillType;
    static Method mcmmo_SkillType_valueOf;
    static Method mcmmo_SkillType_getDoubleDropsDisabled;
    static Object mcmmo_ExperienceConfig_instance;
    static Method mcmmo_ExperienceConfig_getXp;
    static Method mcmmo_McMMOPlayer_getSkillLevel;
    static Class mcmmo_PerksUtils;
    static Method mcmmo_PerksUtils_handleLuckyPerks;
    static Class mcmmo_SecondaryAbility;
    static Method mcmmo_SecondaryAbility_valueOf;
    static Method mcmmo_Permissions_secondaryAbilityEnabled;
    static Method mcmmo_SkillUtils_activationSuccessful;

    public static void addMining(Player player, Collection<Block> blocks) {
        if (player == null || blocks == null || blocks.isEmpty()) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            McMMOHandler.addBlockSkillLegacy(player, blocks, "mining");
            return;
        }
        ArrayList blockStates = blocks.stream().map(Block::getState).collect(Collectors.toCollection(ArrayList::new));
        ExperienceAPI.addXpFromBlocksBySkill((ArrayList)blockStates, (McMMOPlayer)UserManager.getPlayer((Player)player), (PrimarySkillType)PrimarySkillType.MINING);
    }

    public static void addExcavation(Player player, Collection<Block> blocks) {
        if (player == null || blocks == null || blocks.isEmpty()) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            McMMOHandler.addBlockSkillLegacy(player, blocks, "excavation");
            return;
        }
        ArrayList blockStates = blocks.stream().map(Block::getState).collect(Collectors.toCollection(ArrayList::new));
        ExperienceAPI.addXpFromBlocksBySkill((ArrayList)blockStates, (McMMOPlayer)UserManager.getPlayer((Player)player), (PrimarySkillType)PrimarySkillType.EXCAVATION);
    }

    public static void addHerbalism(Player player, Collection<Block> blocks) {
        if (player == null || blocks == null || blocks.isEmpty()) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            McMMOHandler.addBlockSkillLegacy(player, blocks, "herbalism");
            return;
        }
        ArrayList blockStates = blocks.stream().map(Block::getState).collect(Collectors.toCollection(ArrayList::new));
        ExperienceAPI.addXpFromBlocksBySkill((ArrayList)blockStates, (McMMOPlayer)UserManager.getPlayer((Player)player), (PrimarySkillType)PrimarySkillType.HERBALISM);
    }

    public static void addWoodcutting(Player player, Collection<Block> blocks) {
        if (player == null || blocks == null || blocks.isEmpty()) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            McMMOHandler.addBlockSkillLegacy(player, blocks, "woodcutting");
            return;
        }
        ArrayList blockStates = blocks.stream().map(Block::getState).collect(Collectors.toCollection(ArrayList::new));
        ExperienceAPI.addXpFromBlocksBySkill((ArrayList)blockStates, (McMMOPlayer)UserManager.getPlayer((Player)player), (PrimarySkillType)PrimarySkillType.WOODCUTTING);
    }

    public static int getAcrobaticsSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "acrobatics");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.ACROBATICS);
    }

    public static int getAlchemySkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "alchemy");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.ALCHEMY);
    }

    public static int getArcherySkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "archery");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.ARCHERY);
    }

    public static int getAxesSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "axes");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.AXES);
    }

    public static int getExcavationSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "excavation");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.EXCAVATION);
    }

    public static int getFishingSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "fishing");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.FISHING);
    }

    public static int getHerbalismSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "herbalism");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.HERBALISM);
    }

    public static int getMiningSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "mining");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.MINING);
    }

    public static int getRepairSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "repair");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.REPAIR);
    }

    public static int getSmeltingSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "smelting");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.SMELTING);
    }

    public static int getSwordsSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "swords");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.SWORDS);
    }

    public static int getTamingSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "taming");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.TAMING);
    }

    public static int getUnarmedSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "unarmed");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.UNARMED);
    }

    public static int getWoodcuttingSkill(Player player) {
        if (player == null) {
            return -1;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.getSkillLegacy(player, "woodcutting");
        }
        return UserManager.getPlayer((Player)player).getSkillLevel(PrimarySkillType.WOODCUTTING);
    }

    public static void addAcrobatics(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"acrobatics", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.ACROBATICS, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addAlchemy(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"alchemy", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.ALCHEMY, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addArchery(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"archery", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.ARCHERY, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addAxes(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"axes", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.AXES, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addExcavation(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"excavation", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.EXCAVATION, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addFishing(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"fishing", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.FISHING, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addHerbalism(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"herbalism", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.HERBALISM, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addMining(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"mining", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.MINING, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addRepair(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"repair", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.REPAIR, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addSmelting(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"smelting", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.SMELTING, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addSwords(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"swords", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.SWORDS, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addTaming(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"taming", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.TAMING, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addUnarmed(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"unarmed", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.UNARMED, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static void addWoodcutting(Player player, int xp) {
        if (player == null) {
            return;
        }
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            ExperienceAPI.addXP((Player)player, (String)"woodcutting", (int)xp);
        }
        UserManager.getPlayer((Player)player).beginXpGain(PrimarySkillType.WOODCUTTING, (float)xp, XPGainReason.UNKNOWN, XPGainSource.CUSTOM);
    }

    public static boolean hasHerbalismDoubleDrops(Player player) {
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.hasBlockDoubleLegacy(player, "herbalism");
        }
        if (PrimarySkillType.HERBALISM.getDoubleDropsDisabled()) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)player, (SubSkillType)SubSkillType.HERBALISM_DOUBLE_DROPS) && RankUtils.hasReachedRank((int)1, (Player)player, (SubSkillType)SubSkillType.HERBALISM_DOUBLE_DROPS) && RandomChanceUtil.isActivationSuccessful((SkillActivationType)SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, (SubSkillType)SubSkillType.HERBALISM_DOUBLE_DROPS, (Player)player);
    }

    public static boolean hasMiningDoubleDrops(Player player) {
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.hasBlockDoubleLegacy(player, "mining");
        }
        if (PrimarySkillType.MINING.getDoubleDropsDisabled()) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)player, (SubSkillType)SubSkillType.MINING_DOUBLE_DROPS) && RankUtils.hasReachedRank((int)1, (Player)player, (SubSkillType)SubSkillType.MINING_DOUBLE_DROPS) && RandomChanceUtil.isActivationSuccessful((SkillActivationType)SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, (SubSkillType)SubSkillType.MINING_DOUBLE_DROPS, (Player)player);
    }

    public static boolean hasWoodcuttingDoubleDrops(Player player) {
        if (legacy_v13 || legacy_v12 || legacy_v8) {
            return McMMOHandler.hasBlockDoubleLegacy(player, "woodcutting");
        }
        if (PrimarySkillType.WOODCUTTING.getDoubleDropsDisabled()) {
            return false;
        }
        return Permissions.isSubSkillEnabled((Permissible)player, (SubSkillType)SubSkillType.WOODCUTTING_HARVEST_LUMBER) && RankUtils.hasReachedRank((int)1, (Player)player, (SubSkillType)SubSkillType.WOODCUTTING_HARVEST_LUMBER) && RandomChanceUtil.isActivationSuccessful((SkillActivationType)SkillActivationType.RANDOM_LINEAR_100_SCALE_WITH_CAP, (SubSkillType)SubSkillType.WOODCUTTING_HARVEST_LUMBER, (Player)player);
    }

    public static boolean isUsingBerserk(Player player) {
        return AbilityAPI.berserkEnabled((Player)player);
    }

    public static boolean isUsingGigaDrill(Player player) {
        return AbilityAPI.gigaDrillBreakerEnabled((Player)player);
    }

    public static boolean isUsingGreenTerra(Player player) {
        return AbilityAPI.greenTerraEnabled((Player)player);
    }

    public static boolean isUsingSerratedStrikes(Player player) {
        return AbilityAPI.serratedStrikesEnabled((Player)player);
    }

    public static boolean isUsingSkullSplitter(Player player) {
        return AbilityAPI.skullSplitterEnabled((Player)player);
    }

    public static boolean isUsingSuperBreaker(Player player) {
        return AbilityAPI.superBreakerEnabled((Player)player);
    }

    public static boolean isUsingTreeFeller(Player player) {
        return AbilityAPI.treeFellerEnabled((Player)player);
    }

    public static boolean isBleeding(LivingEntity victim) {
        return AbilityAPI.isBleeding((LivingEntity)victim);
    }

    protected static boolean hasBlockDoubleLegacy(Player player, String skill) {
        if (player.hasMetadata("mcMMO: Player Data")) {
            try {
                Object skillType = mcmmo_SkillType_valueOf.invoke(null, skill.toUpperCase());
                if (((Boolean)mcmmo_SkillType_getDoubleDropsDisabled.invoke(skillType, new Object[0])).booleanValue()) {
                    return false;
                }
                int skillLevel = (Integer)mcmmo_McMMOPlayer_getSkillLevel.invoke((Object)UserManager.getPlayer((Player)player), skillType);
                int activationChance = (Integer)mcmmo_PerksUtils_handleLuckyPerks.invoke(null, player, skillType);
                Object secondaryDouble = mcmmo_SecondaryAbility_valueOf.invoke(null, skill.toUpperCase() + "_DOUBLE_DROPS");
                if (!((Boolean)mcmmo_Permissions_secondaryAbilityEnabled.invoke(null, player, secondaryDouble)).booleanValue()) {
                    return false;
                }
                return (Boolean)mcmmo_SkillUtils_activationSuccessful.invoke(null, secondaryDouble, player, skillLevel, activationChance);
            }
            catch (Exception ex) {
                Logger.getLogger(McMMOHandler.class.getName()).log(Level.SEVERE, "Failed to invoke McMMO Legacy Hook", ex);
            }
        }
        return false;
    }

    protected static void addBlockSkillLegacy(Player player, Collection<Block> blocks, String skill) {
        try {
            Object skillType = mcmmo_SkillType_valueOf.invoke(null, skill.toUpperCase());
            int xp = 0;
            for (Block block : blocks) {
                xp += ((Integer)mcmmo_ExperienceConfig_getXp.invoke(mcmmo_ExperienceConfig_instance, skillType, McMMOHandler.legacy_getBlock(block))).intValue();
            }
            ExperienceAPI.addXP((Player)player, (String)skill, (int)xp);
        }
        catch (Exception ex) {
            Logger.getLogger(McMMOHandler.class.getName()).log(Level.SEVERE, "Failed to invoke McMMO Legacy Hook", ex);
        }
    }

    protected static Object legacy_getBlock(Block block) {
        if (legacy_v13) {
            return block.getBlockData();
        }
        if (legacy_v12) {
            return block.getState().getData();
        }
        return block.getType();
    }

    protected static int getSkillLegacy(Player player, String skill) {
        if (player.hasMetadata("mcMMO: Player Data")) {
            try {
                Object skillType = mcmmo_SkillType_valueOf.invoke(null, skill.toUpperCase());
                return (Integer)mcmmo_McMMOPlayer_getSkillLevel.invoke((Object)UserManager.getPlayer((Player)player), skillType);
            }
            catch (Exception ex) {
                Logger.getLogger(McMMOHandler.class.getName()).log(Level.SEVERE, "Failed to invoke McMMO Legacy Hook", ex);
            }
        }
        return 0;
    }

    static {
        try {
            Class.forName("com.gmail.nossr50.datatypes.skills.PrimarySkillType");
            mcmmo_v2 = true;
        }
        catch (ClassNotFoundException ex) {
            try {
                mcmmo_SkillType = Class.forName("com.gmail.nossr50.datatypes.skills.SkillType");
                mcmmo_SkillType_valueOf = mcmmo_SkillType.getDeclaredMethod("valueOf", String.class);
                mcmmo_SkillType_getDoubleDropsDisabled = mcmmo_SkillType.getDeclaredMethod("getDoubleDropsDisabled", new Class[0]);
                mcmmo_ExperienceConfig_instance = ExperienceConfig.getInstance();
                mcmmo_McMMOPlayer_getSkillLevel = McMMOPlayer.class.getDeclaredMethod("getSkillLevel", mcmmo_SkillType);
                mcmmo_PerksUtils = Class.forName("com.gmail.nossr50.util.skills.PerksUtils");
                mcmmo_PerksUtils_handleLuckyPerks = mcmmo_PerksUtils.getDeclaredMethod("handleLuckyPerks", Player.class, mcmmo_SkillType);
                mcmmo_SecondaryAbility = Class.forName("com.gmail.nossr50.datatypes.skills.SecondaryAbility");
                mcmmo_SecondaryAbility_valueOf = mcmmo_SecondaryAbility.getDeclaredMethod("valueOf", String.class);
                mcmmo_Permissions_secondaryAbilityEnabled = Permissions.class.getDeclaredMethod("secondaryAbilityEnabled", Permissible.class, mcmmo_SecondaryAbility);
                mcmmo_SkillUtils_activationSuccessful = SkillUtils.class.getDeclaredMethod("activationSuccessful", mcmmo_SecondaryAbility, Player.class, Integer.TYPE, Integer.TYPE);
                if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_13)) {
                    mcmmo_ExperienceConfig_getXp = mcmmo_ExperienceConfig_instance.getClass().getDeclaredMethod("getXp", mcmmo_SkillType, BlockData.class);
                    legacy_v13 = true;
                } else if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_12)) {
                    mcmmo_ExperienceConfig_getXp = mcmmo_ExperienceConfig_instance.getClass().getDeclaredMethod("getXp", mcmmo_SkillType, MaterialData.class);
                    legacy_v12 = true;
                } else {
                    mcmmo_ExperienceConfig_getXp = mcmmo_ExperienceConfig_instance.getClass().getDeclaredMethod("getXp", mcmmo_SkillType, Material.class);
                    legacy_v8 = true;
                }
            }
            catch (Exception ex2) {
                Logger.getLogger(McMMOHandler.class.getName()).log(Level.SEVERE, "Failed to register McMMO Legacy Hook", ex2);
            }
        }
    }
}

