/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.locale;

import com.songoda.ultimatetimber.core.configuration.Config;
import com.songoda.ultimatetimber.core.configuration.ConfigSection;
import com.songoda.ultimatetimber.core.locale.Message;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Locale {
    private static final Pattern OLD_NODE_PATTERN = Pattern.compile("^([^ ]+)\\s*=\\s*\"?(.*?)\"?$");
    private static final String FILE_EXTENSION = ".lang";
    private final Map<String, String> nodes = new HashMap<String, String>();
    private final Plugin plugin;
    private final File file;
    private final String name;

    public Locale(Plugin plugin, File file, String name) {
        this.plugin = plugin;
        this.file = file;
        this.name = name;
    }

    public static Locale loadDefaultLocale(JavaPlugin plugin, String name) {
        Locale.saveDefaultLocale(plugin, name, name);
        return Locale.loadLocale(plugin, name);
    }

    public static Locale loadLocale(JavaPlugin plugin, String name) {
        File localeFolder = new File(plugin.getDataFolder(), "locales/");
        if (!localeFolder.exists()) {
            return null;
        }
        File localeFile = new File(localeFolder, name + FILE_EXTENSION);
        if (!localeFolder.exists()) {
            return null;
        }
        Locale l = new Locale((Plugin)plugin, localeFile, name);
        if (!l.reloadMessages()) {
            return null;
        }
        plugin.getLogger().info("Loaded locale \"" + name + "\"");
        return l;
    }

    public static List<Locale> loadAllLocales(JavaPlugin plugin) {
        File localeFolder = new File(plugin.getDataFolder(), "locales/");
        ArrayList<Locale> all = new ArrayList<Locale>();
        for (File localeFile : localeFolder.listFiles()) {
            Locale l;
            String fileName = localeFile.getName();
            if (!fileName.endsWith(FILE_EXTENSION) || (fileName = fileName.substring(0, fileName.lastIndexOf(46))).split("_").length != 2 || !(l = new Locale((Plugin)plugin, localeFile, fileName)).reloadMessages()) continue;
            plugin.getLogger().info("Loaded locale \"" + fileName + "\"");
            all.add(l);
        }
        return all;
    }

    public static List<String> getLocales(Plugin plugin) {
        File localeFolder = new File(plugin.getDataFolder(), "locales/");
        ArrayList<String> all = new ArrayList<String>();
        for (File localeFile : localeFolder.listFiles()) {
            String fileName = localeFile.getName();
            if (!fileName.endsWith(FILE_EXTENSION) || (fileName = fileName.substring(0, fileName.lastIndexOf(46))).split("_").length != 2) continue;
            all.add(fileName);
        }
        return all;
    }

    public static boolean saveDefaultLocale(JavaPlugin plugin, String locale, String fileName) {
        return Locale.saveLocale((Plugin)plugin, plugin.getResource(locale + FILE_EXTENSION), fileName, true);
    }

    public static boolean saveLocale(Plugin plugin, InputStream in, String fileName) {
        return Locale.saveLocale(plugin, in, fileName, false);
    }

    private static boolean saveLocale(Plugin plugin, InputStream in, String fileName, boolean builtin) {
        boolean bl;
        File destinationFile;
        if (in == null) {
            return false;
        }
        File localeFolder = new File(plugin.getDataFolder(), "locales/");
        if (!localeFolder.exists()) {
            localeFolder.mkdirs();
        }
        if (!fileName.endsWith(FILE_EXTENSION)) {
            fileName = fileName + FILE_EXTENSION;
        }
        if ((destinationFile = new File(localeFolder, fileName)).exists()) {
            return Locale.updateFiles(plugin, in, destinationFile, builtin);
        }
        FileOutputStream outputStream = new FileOutputStream(destinationFile);
        try {
            Locale.copy(in, outputStream);
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            bl = fileName.split("_").length == 2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        ((OutputStream)outputStream).close();
        return bl;
    }

    /*
     * Exception decompiling
     */
    private static boolean updateFiles(Plugin plugin, InputStream defaultFile, File existingFile, boolean builtin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public boolean reloadMessages() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected static BufferedReader translatePropertyToYAML(BufferedReader source, Charset charset) throws IOException {
        String line;
        StringBuilder output = new StringBuilder();
        int lineNumber = 0;
        while ((line = source.readLine()) != null) {
            Matcher matcher;
            if (lineNumber == 0) {
                String line1 = line;
                line = line.replaceAll("[\ufeff\ufffe\u200b]", "");
                if (line1.length() != line.length()) {
                    output.append(line1, 0, line1.length() - line.length());
                }
            }
            if ((line = line.replace('\r', ' ').replaceAll("\\p{C}", "?").replace(";", "")).trim().isEmpty() || line.trim().startsWith("#") || !(matcher = OLD_NODE_PATTERN.matcher(line.trim())).find()) {
                if (line.startsWith("//")) {
                    output.append("#").append(line).append("\n");
                } else {
                    output.append(line).append("\n");
                }
            } else {
                output.append(matcher.group(1)).append(": \"").append(matcher.group(2)).append("\"\n");
            }
            ++lineNumber;
        }
        return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(new ByteArrayInputStream(output.toString().getBytes(charset))), charset));
    }

    protected static void translateMsgRoot(Config lang, File file, Charset charset) throws IOException {
        List msgs = lang.getValues(true).entrySet().stream().filter(e -> e.getValue() instanceof ConfigSection).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!msgs.isEmpty()) {
            try (FileInputStream stream = new FileInputStream(file);
                 BufferedReader source = new BufferedReader(new InputStreamReader((InputStream)stream, charset));){
                String line;
                int lineNumber = 0;
                while ((line = source.readLine()) != null) {
                    Matcher matcher;
                    if (lineNumber == 0) {
                        line = line.replaceAll("[\ufeff\ufffe\u200b]", "");
                    }
                    if (!(line = line.trim()).isEmpty() && !line.startsWith("#") && (matcher = OLD_NODE_PATTERN.matcher(line)).find() && msgs.contains(matcher.group(1))) {
                        lang.set(matcher.group(1) + ".message", matcher.group(2));
                    }
                    ++lineNumber;
                }
            }
        }
    }

    protected static void translateMsgRoot(Config lang, String file, Charset charset) throws IOException {
        List msgs = lang.getValues(true).entrySet().stream().filter(e -> e.getValue() instanceof ConfigSection).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!msgs.isEmpty()) {
            String[] source = file.split("\n");
            for (int lineNumber = 0; lineNumber < source.length; ++lineNumber) {
                Matcher matcher;
                String line = source[lineNumber];
                if (lineNumber == 0) {
                    line = line.replaceAll("[\ufeff\ufffe\u200b]", "");
                }
                if ((line = line.trim()).isEmpty() || line.startsWith("#") || !(matcher = OLD_NODE_PATTERN.matcher(line)).find() || !msgs.contains(matcher.group(1))) continue;
                lang.set(matcher.group(1) + ".message", matcher.group(2));
            }
        }
    }

    private Message supplyPrefix(Message message) {
        return message.setPrefix(this.nodes.getOrDefault("general.nametag.prefix", "[" + this.plugin.getName() + "]"));
    }

    public Message newMessage(String message) {
        return this.supplyPrefix(new Message(message));
    }

    public Message getMessage(String node) {
        if (this.nodes.containsKey(node + ".message")) {
            node = node + ".message";
        }
        return this.getMessageOrDefault(node, node);
    }

    public Message getMessageOrDefault(String node, String defaultValue) {
        if (this.nodes.containsKey(node + ".message")) {
            node = node + ".message";
        }
        return this.supplyPrefix(new Message(this.nodes.getOrDefault(node, defaultValue)));
    }

    public String getName() {
        return this.name;
    }

    private static void copy(InputStream input, OutputStream output) {
        byte[] buffer = new byte[4096];
        try {
            int n;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private /* synthetic */ void lambda$reloadMessages$1(String k, Object v) {
        this.nodes.put(k, v instanceof List ? ((List)v).stream().map(Object::toString).collect(Collectors.joining("\n")) : v.toString());
    }

    private static /* synthetic */ String lambda$updateFiles$0(String s) {
        return s.replaceAll("[\ufeff\ufffe\u200b]", "");
    }
}

