/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.locale;

import com.songoda.ultimatetimber.core.chat.ChatMessage;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import com.songoda.ultimatetimber.core.utils.TextUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Message {
    private static boolean canActionBar = false;
    private ChatMessage prefix = null;
    private ChatMessage message;

    public Message(String message) {
        ChatMessage chatMessage = new ChatMessage();
        chatMessage.fromText(message);
        this.message = chatMessage;
    }

    public Message(ChatMessage message) {
        this.message = message;
    }

    public void sendMessage(Player player) {
        player.sendMessage(this.getMessage());
    }

    public void sendMessage(CommandSender sender) {
        this.message.sendTo(sender);
    }

    public void sendTitle(CommandSender sender) {
        if (sender instanceof Player) {
            if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_11)) {
                ((Player)sender).sendTitle("", this.getMessage(), 10, 30, 10);
                return;
            }
            ((Player)sender).sendTitle("", this.getMessage());
            return;
        }
        sender.sendMessage(this.getMessage());
    }

    public void sendActionBar(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessage());
            return;
        }
        if (!canActionBar) {
            this.sendTitle(sender);
            return;
        }
        ((Player)sender).spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(this.getMessage()));
    }

    public void sendPrefixedMessage(CommandSender sender) {
        this.message.sendTo(this.prefix, sender);
    }

    public String getPrefixedMessage() {
        return TextUtils.formatText((this.prefix == null ? "" : this.prefix.toText()) + " " + this.message.toText());
    }

    public String getMessage() {
        return TextUtils.formatText(this.message.toText());
    }

    public List<String> getMessageLines() {
        return Arrays.asList(ChatColor.translateAlternateColorCodes((char)'&', (String)this.message.toText()).split("[\n|]"));
    }

    public String getUnformattedMessage() {
        return this.message.toText();
    }

    public Message processPlaceholder(String placeholder, Object replacement) {
        String place = Matcher.quoteReplacement(placeholder);
        this.message = this.message.replaceAll("%" + place + "%|\\{" + place + "\\}", replacement == null ? "" : Matcher.quoteReplacement(replacement.toString()));
        return this;
    }

    Message setPrefix(String prefix) {
        this.prefix = new ChatMessage();
        this.prefix.fromText(prefix + " ");
        return this;
    }

    public String toString() {
        return this.message.toString();
    }

    public String toText() {
        return this.message.toText();
    }

    static {
        try {
            Class.forName("net.md_5.bungee.api.ChatMessageType");
            Class.forName("net.md_5.bungee.api.chat.TextComponent");
            Player.Spigot.class.getDeclaredMethod("sendMessage", ChatMessageType.class, TextComponent.class);
            canActionBar = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

