/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.nms.v1_16_R3.world;

import com.songoda.ultimatetimber.core.nms.ReflectionUtils;
import com.songoda.ultimatetimber.core.nms.v1_16_R3.world.SItemStackImpl;
import com.songoda.ultimatetimber.core.nms.v1_16_R3.world.SSpawnerImpl;
import com.songoda.ultimatetimber.core.nms.v1_16_R3.world.SWorldImpl;
import com.songoda.ultimatetimber.core.nms.v1_16_R3.world.spawner.BBaseSpawnerImpl;
import com.songoda.ultimatetimber.core.nms.world.BBaseSpawner;
import com.songoda.ultimatetimber.core.nms.world.SItemStack;
import com.songoda.ultimatetimber.core.nms.world.SSpawner;
import com.songoda.ultimatetimber.core.nms.world.SWorld;
import com.songoda.ultimatetimber.core.nms.world.WorldCore;
import net.minecraft.server.v1_16_R3.BlockPosition;
import net.minecraft.server.v1_16_R3.Chunk;
import net.minecraft.server.v1_16_R3.ChunkCoordIntPair;
import net.minecraft.server.v1_16_R3.ChunkSection;
import net.minecraft.server.v1_16_R3.Fluid;
import net.minecraft.server.v1_16_R3.GameProfilerFiller;
import net.minecraft.server.v1_16_R3.IBlockData;
import net.minecraft.server.v1_16_R3.MobSpawnerAbstract;
import net.minecraft.server.v1_16_R3.World;
import org.bukkit.Location;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.craftbukkit.v1_16_R3.CraftChunk;
import org.bukkit.inventory.ItemStack;

public class WorldCoreImpl
implements WorldCore {
    @Override
    public SSpawner getSpawner(CreatureSpawner spawner) {
        return new SSpawnerImpl(spawner.getLocation());
    }

    @Override
    public SSpawner getSpawner(Location location) {
        return new SSpawnerImpl(location);
    }

    @Override
    public SItemStack getItemStack(ItemStack item) {
        return new SItemStackImpl(item);
    }

    @Override
    public SWorld getWorld(org.bukkit.World world) {
        return new SWorldImpl();
    }

    @Override
    public BBaseSpawner getBaseSpawner(CreatureSpawner spawner) throws NoSuchFieldException, IllegalAccessException {
        Object cTileEntity = ReflectionUtils.getFieldValue(spawner, "tileEntity");
        return new BBaseSpawnerImpl((MobSpawnerAbstract)ReflectionUtils.getFieldValue(cTileEntity, "a"));
    }

    @Override
    public void randomTickChunk(org.bukkit.Chunk bukkitChunk, int tickAmount) {
        Chunk chunk = ((CraftChunk)bukkitChunk).getHandle();
        if (tickAmount <= 0) {
            return;
        }
        GameProfilerFiller profiler = chunk.world.getMethodProfiler();
        ChunkCoordIntPair chunkPos = chunk.getPos();
        int minBlockX = chunkPos.d();
        int minBlockZ = chunkPos.e();
        profiler.enter("tickBlocks");
        for (ChunkSection cSection : chunk.getSections()) {
            if (cSection == Chunk.a || !cSection.d()) continue;
            int bottomBlockY = cSection.getYPosition();
            for (int i = 0; i < tickAmount; ++i) {
                Fluid fluidState;
                BlockPosition randomBlockPos = chunk.world.a(minBlockX, bottomBlockY, minBlockZ, 15);
                profiler.enter("randomTick");
                IBlockData blockState = cSection.getType(randomBlockPos.getX() - minBlockX, randomBlockPos.getY() - bottomBlockY, randomBlockPos.getZ() - minBlockZ);
                if (blockState.isTicking()) {
                    blockState.b(chunk.world, randomBlockPos, chunk.world.random);
                }
                if ((fluidState = blockState.getFluid()).f()) {
                    fluidState.b((World)chunk.world, randomBlockPos, chunk.world.random);
                }
                profiler.exit();
            }
        }
        profiler.exit();
    }
}

