/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.nms.v1_8_R3.world.spawner;

import com.songoda.ultimatetimber.core.nms.ReflectionUtils;
import com.songoda.ultimatetimber.core.nms.world.BBaseSpawner;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.server.v1_8_R3.AxisAlignedBB;
import net.minecraft.server.v1_8_R3.BlockPosition;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.EntityInsentient;
import net.minecraft.server.v1_8_R3.EntityTypes;
import net.minecraft.server.v1_8_R3.EnumParticle;
import net.minecraft.server.v1_8_R3.MobSpawnerAbstract;
import net.minecraft.server.v1_8_R3.World;

public class BBaseSpawnerImpl
implements BBaseSpawner {
    private static Method aEntityBooleanMethod;
    private static Method gMethod;
    private static Method hMethod;
    private final MobSpawnerAbstract spawner;

    public BBaseSpawnerImpl(MobSpawnerAbstract spawner) {
        this.spawner = spawner;
    }

    @Override
    public boolean isNearPlayer() throws InvocationTargetException, IllegalAccessException {
        return (Boolean)gMethod.invoke((Object)this.spawner, new Object[0]);
    }

    @Override
    public void tick() throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        BlockPosition blockposition = this.spawner.b();
        if (this.spawner.a().isClientSide) {
            double d1 = (float)blockposition.getX() + this.spawner.a().random.nextFloat();
            double d2 = (float)blockposition.getY() + this.spawner.a().random.nextFloat();
            double d0 = (float)blockposition.getZ() + this.spawner.a().random.nextFloat();
            this.spawner.a().addParticle(EnumParticle.SMOKE_NORMAL, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
            this.spawner.a().addParticle(EnumParticle.FLAME, d1, d2, d0, 0.0, 0.0, 0.0, new int[0]);
            if (this.spawner.spawnDelay > 0) {
                --this.spawner.spawnDelay;
            }
            double spawnerE = (Double)ReflectionUtils.getFieldValue(this.spawner, "e");
            ReflectionUtils.setFieldValue(this.spawner, "f", spawnerE);
            ReflectionUtils.setFieldValue(this.spawner, "e", (spawnerE + (double)(1000.0f / ((float)this.spawner.spawnDelay + 200.0f))) % 360.0);
            return;
        }
        if (this.spawner.spawnDelay == -1) {
            this.delay(this.spawner);
        }
        if (this.spawner.spawnDelay > 0) {
            --this.spawner.spawnDelay;
            return;
        }
        boolean flag = false;
        int i = 0;
        int spawnCount = (Integer)ReflectionUtils.getFieldValue(this.spawner, "spawnCount");
        int spawnRange = (Integer)ReflectionUtils.getFieldValue(this.spawner, "spawnRange");
        int maxNearbyEntities = (Integer)ReflectionUtils.getFieldValue(this.spawner, "maxNearbyEntities");
        while (true) {
            if (i >= spawnCount) {
                if (!flag) break;
                this.delay(this.spawner);
                break;
            }
            Entity entity = EntityTypes.createEntityByName((String)this.spawner.getMobName(), (World)this.spawner.a());
            if (entity == null) {
                return;
            }
            int j = this.spawner.a().a(entity.getClass(), new AxisAlignedBB((double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ(), (double)(blockposition.getX() + 1), (double)(blockposition.getY() + 1), (double)(blockposition.getZ() + 1)).grow((double)spawnRange, (double)spawnRange, (double)spawnRange)).size();
            if (j >= maxNearbyEntities) {
                this.delay(this.spawner);
                return;
            }
            double d0 = (double)blockposition.getX() + (this.spawner.a().random.nextDouble() - this.spawner.a().random.nextDouble()) * (double)spawnRange + 0.5;
            double d3 = blockposition.getY() + this.spawner.a().random.nextInt(3) - 1;
            double d4 = (double)blockposition.getZ() + (this.spawner.a().random.nextDouble() - this.spawner.a().random.nextDouble()) * (double)spawnRange + 0.5;
            EntityInsentient entityinsentient = entity instanceof EntityInsentient ? (EntityInsentient)entity : null;
            entity.setPositionRotation(d0, d3, d4, this.spawner.a().random.nextFloat() * 360.0f, 0.0f);
            if (entityinsentient == null || entityinsentient.bR() && entityinsentient.canSpawn()) {
                aEntityBooleanMethod.invoke((Object)this.spawner, entity, true);
                this.spawner.a().triggerEffect(2004, blockposition, 0);
                if (entityinsentient != null) {
                    entityinsentient.y();
                }
                flag = true;
            }
            ++i;
        }
    }

    private void delay(MobSpawnerAbstract spawner) throws InvocationTargetException, IllegalAccessException {
        hMethod.invoke((Object)spawner, new Object[0]);
    }

    static {
        try {
            aEntityBooleanMethod = MobSpawnerAbstract.class.getDeclaredMethod("a", Entity.class, Boolean.TYPE);
            aEntityBooleanMethod.setAccessible(true);
            gMethod = MobSpawnerAbstract.class.getDeclaredMethod("g", new Class[0]);
            gMethod.setAccessible(true);
            hMethod = MobSpawnerAbstract.class.getDeclaredMethod("h", new Class[0]);
            hMethod.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
    }
}

