/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.manager;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.manager.Manager;
import com.songoda.ultimatetimber.manager.TreeDefinitionManager;
import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlockType;
import com.songoda.ultimatetimber.tree.TreeDefinition;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;

public class SaplingManager
extends Manager {
    private Random random = new Random();
    private Set<Location> protectedSaplings = new HashSet<Location>();

    public SaplingManager(UltimateTimber ultimateTimber) {
        super(ultimateTimber);
    }

    @Override
    public void reload() {
    }

    @Override
    public void disable() {
    }

    public void replantSapling(TreeDefinition treeDefinition, ITreeBlock treeBlock) {
        if (!ConfigurationManager.Setting.REPLANT_SAPLINGS.getBoolean()) {
            return;
        }
        Block block = treeBlock.getLocation().getBlock();
        if (!block.getType().equals((Object)Material.AIR) || treeBlock.getTreeBlockType().equals((Object)TreeBlockType.LEAF)) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.internalReplant(treeDefinition, treeBlock), 1L);
    }

    public void replantSaplingWithChance(TreeDefinition treeDefinition, ITreeBlock treeBlock) {
        if (!ConfigurationManager.Setting.FALLING_BLOCKS_REPLANT_SAPLINGS.getBoolean() || !treeBlock.getLocation().getBlock().getType().equals((Object)Material.AIR)) {
            return;
        }
        double chance = ConfigurationManager.Setting.FALLING_BLOCKS_REPLANT_SAPLINGS_CHANCE.getDouble();
        if (this.random.nextDouble() > chance / 100.0) {
            return;
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.internalReplant(treeDefinition, treeBlock), 1L);
    }

    private void internalReplant(TreeDefinition treeDefinition, ITreeBlock treeBlock) {
        TreeDefinitionManager treeDefinitionManager = this.plugin.getTreeDefinitionManager();
        Block block = treeBlock.getLocation().getBlock();
        Block blockBelow = block.getRelative(BlockFace.DOWN);
        boolean isValidSoil = false;
        for (CompatibleMaterial soilMaterial : treeDefinitionManager.getPlantableSoilMaterial(treeDefinition)) {
            if (!soilMaterial.equals((Object)CompatibleMaterial.getMaterial(blockBelow))) continue;
            isValidSoil = true;
            break;
        }
        if (!isValidSoil) {
            return;
        }
        CompatibleMaterial material = treeDefinition.getSaplingMaterial();
        material.applyToBlock(block);
        int cooldown = ConfigurationManager.Setting.REPLANT_SAPLINGS_COOLDOWN.getInt();
        if (cooldown != 0) {
            this.protectedSaplings.add(block.getLocation());
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.protectedSaplings.remove(block.getLocation()), (long)cooldown * 20L);
        }
    }

    public boolean isSaplingProtected(Block block) {
        return this.protectedSaplings.contains(block.getLocation());
    }
}

