/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationBlocks;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.api.CubeletEndEvent;
import me.davidml16.acubelets.api.CubeletOpenEvent;
import me.davidml16.acubelets.enums.CubeletBoxState;
import me.davidml16.acubelets.enums.Rotation;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.RepeatingTask;
import me.davidml16.acubelets.utils.Utils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class Animation {
    private Main main;
    private AnimationSettings animationSettings;
    private CubeletMachine cubeletMachine;
    private CubeletType cubeletType;
    private Reward reward;
    private List<Color> colors;
    private Utils.ColorSet<Integer, Integer, Integer> colorRarity;
    private Location corner1;
    private Location corner2;
    private Location corner3;
    private Location corner4;
    private Location boxLocation;
    private int animationTick;
    private int animationRevealTick;
    private int animationId;
    private boolean rewardRevealed;
    private boolean showOutlineParticles;
    private boolean showFloorParticles;
    private boolean showAroundParticles;
    private RepeatingTask hologramAnimation;
    private Map<String, BukkitRunnable> bukkitRunnables;
    private AnimationBlocks animationBlocks;

    public Animation(Main main, AnimationSettings animationSettings) {
        this.main = main;
        this.animationSettings = animationSettings;
        this.animationTick = 0;
        this.animationRevealTick = 0;
        this.rewardRevealed = false;
        this.showOutlineParticles = true;
        this.showFloorParticles = true;
        this.showAroundParticles = false;
        this.bukkitRunnables = new HashMap<String, BukkitRunnable>();
        this.colors = main.getFireworkUtil().getRandomColors();
    }

    public void setCubeletBox(CubeletMachine cubeletMachine) {
        this.cubeletMachine = cubeletMachine;
        this.boxLocation = this.cubeletMachine.getLocation().clone().add(0.5, 0.0, 0.5);
        this.corner1 = this.cubeletMachine.getLocation().clone().add(0.05, cubeletMachine.getPermanentBlockHeight() - 0.325, 0.05);
        this.corner2 = this.cubeletMachine.getLocation().clone().add(0.95, cubeletMachine.getPermanentBlockHeight() - 0.325, 0.05);
        this.corner3 = this.cubeletMachine.getLocation().clone().add(0.95, cubeletMachine.getPermanentBlockHeight() - 0.325, 0.95);
        this.corner4 = this.cubeletMachine.getLocation().clone().add(0.05, cubeletMachine.getPermanentBlockHeight() - 0.325, 0.95);
    }

    public void setCubeletType(CubeletType cubeletType) {
        this.cubeletType = cubeletType;
        this.setReward(this.main.getCubeletRewardHandler().processReward(cubeletType));
    }

    public void start() {
        this.cubeletMachine.setState(CubeletBoxState.ANIMATION);
        this.animationId = Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.main, () -> {
            this.onTick(this.animationTick);
            ++this.animationTick;
            if (this.rewardRevealed) {
                if (this.animationRevealTick == 2) {
                    this.doRewardReveal();
                } else if (this.animationRevealTick == 42) {
                    this.doRewardDuplication();
                } else if (this.animationRevealTick > 2 && this.animationRevealTick < 142) {
                    this.doShowBoxParticles();
                } else if (this.animationRevealTick >= 142) {
                    this.stop();
                }
                ++this.animationRevealTick;
            }
        }, 0L, 1L);
        Bukkit.getPluginManager().callEvent((Event)new CubeletOpenEvent(this.cubeletMachine.getPlayerOpening(), this.cubeletType));
        this.main.getAnimationHandler().getTasks().add(this);
        this.onStart();
    }

    public void stop() {
        if (this.hologramAnimation != null) {
            this.hologramAnimation.cancel();
        }
        this.main.getAnimationHandler().getTasks().remove(this);
        Bukkit.getServer().getScheduler().cancelTask(this.animationId);
        Bukkit.getPluginManager().callEvent((Event)new CubeletEndEvent(this.cubeletMachine.getPlayerOpening(), this.cubeletType, this.cubeletMachine.getLastReward(), this.cubeletMachine.getLastDuplicationPoints()));
        this.main.getCubeletRewardHandler().giveReward(this.cubeletMachine, this.cubeletType, this.reward);
        this.cubeletMachine.setState(CubeletBoxState.EMPTY);
        this.cubeletMachine.setPlayerOpening(null);
        this.cubeletMachine.setLastReward(null);
        this.cubeletMachine.setLastDuplicationPoints(0);
        this.main.getHologramImplementation().reloadHologram(this.cubeletMachine);
        this.onStop();
    }

    public void doPreRewardReveal() {
        this.rewardRevealed = true;
        this.onPreRewardReveal();
    }

    public void doRewardReveal() {
        this.main.getHologramImplementation().rewardHologram(this.cubeletMachine, this.reward);
        this.cubeletMachine.setState(CubeletBoxState.REWARD);
        this.onRewardReveal();
    }

    public void doRewardDuplication() {
        if (!this.main.isDuplicationEnabled()) {
            return;
        }
        this.hologramAnimation = this.main.getCubeletRewardHandler().duplicationTask(this.cubeletMachine, this.reward);
    }

    public void doShowBoxParticles() {
        if (this.showOutlineParticles && this.animationSettings.isOutlineParticles()) {
            UtilParticles.drawParticleLine(this.corner1, this.corner2, Particles.REDSTONE, 10, this.colorRarity.getRed(), this.colorRarity.getGreen(), this.colorRarity.getBlue());
            UtilParticles.drawParticleLine(this.corner2, this.corner3, Particles.REDSTONE, 10, this.colorRarity.getRed(), this.colorRarity.getGreen(), this.colorRarity.getBlue());
            UtilParticles.drawParticleLine(this.corner3, this.corner4, Particles.REDSTONE, 10, this.colorRarity.getRed(), this.colorRarity.getGreen(), this.colorRarity.getBlue());
            UtilParticles.drawParticleLine(this.corner1, this.corner4, Particles.REDSTONE, 10, this.colorRarity.getRed(), this.colorRarity.getGreen(), this.colorRarity.getBlue());
        }
        if (this.showFloorParticles && this.animationSettings.isFloorParticles()) {
            UtilParticles.display(Particles.FLAME, 1.0, 0.0, 1.0, this.boxLocation, 2);
        }
        if (this.showAroundParticles && this.animationSettings.isAroundParticles()) {
            UtilParticles.display(Particles.FLAME, 0.45f, 0.25, 0.45f, this.boxLocation, 10);
        }
    }

    public abstract void onTick(int var1);

    public abstract void onStart();

    public abstract void onStop();

    public abstract void onPreRewardReveal();

    public abstract void onRewardReveal();

    public int getAnimationId() {
        return this.animationId;
    }

    public void setAnimationId(int n) {
        this.animationId = n;
    }

    public Main getMain() {
        return this.main;
    }

    public void setMain(Main main) {
        this.main = main;
    }

    public AnimationSettings getAnimationSettings() {
        return this.animationSettings;
    }

    public void setAnimationSettings(AnimationSettings animationSettings) {
        this.animationSettings = animationSettings;
    }

    public CubeletMachine getCubeletBox() {
        return this.cubeletMachine;
    }

    public CubeletType getCubeletType() {
        return this.cubeletType;
    }

    public Reward getReward() {
        return this.reward;
    }

    public void setReward(Reward reward) {
        int n;
        this.reward = reward;
        this.cubeletMachine.setLastReward(reward);
        String string = reward.getRarity().getDuplicatePointsRange();
        if (!string.contains("-") && StringUtils.isNumeric((String)string)) {
            n = Integer.parseInt(string);
        } else {
            int n2 = Integer.parseInt(string.split("-")[0]);
            int n3 = Integer.parseInt(string.split("-")[1]);
            if (n2 < 1) {
                n2 = 1;
            }
            if (n3 < 1) {
                n3 = 1;
            }
            if (n2 != n3) {
                int n4 = Math.min(n2, n3);
                int n5 = Math.max(n2, n3);
                n = ThreadLocalRandom.current().nextInt(n4, n5);
            } else {
                n = n2;
            }
        }
        this.cubeletMachine.setLastDuplicationPoints(n);
        this.setColorRarity(Utils.getRGBbyColor(Utils.getColorByText(reward.getRarity().getName())));
    }

    public List<Color> getColors() {
        return this.colors;
    }

    public void setColors(List<Color> list) {
        this.colors = list;
    }

    public Utils.ColorSet<Integer, Integer, Integer> getColorRarity() {
        return this.colorRarity;
    }

    public void setColorRarity(Utils.ColorSet<Integer, Integer, Integer> colorSet) {
        this.colorRarity = colorSet;
    }

    public Location getCorner1() {
        return this.corner1;
    }

    public void setCorner1(Location location) {
        this.corner1 = location;
    }

    public Location getCorner2() {
        return this.corner2;
    }

    public void setCorner2(Location location) {
        this.corner2 = location;
    }

    public Location getCorner3() {
        return this.corner3;
    }

    public void setCorner3(Location location) {
        this.corner3 = location;
    }

    public Location getCorner4() {
        return this.corner4;
    }

    public void setCorner4(Location location) {
        this.corner4 = location;
    }

    public Location getBoxLocation() {
        return this.boxLocation;
    }

    public void setBoxLocation(Location location) {
        this.boxLocation = location;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int n) {
        this.animationTick = n;
    }

    public RepeatingTask getHologramAnimation() {
        return this.hologramAnimation;
    }

    public void setHologramAnimation(RepeatingTask repeatingTask) {
        this.hologramAnimation = repeatingTask;
    }

    public int getAnimationRevealTick() {
        return this.animationRevealTick;
    }

    public void setAnimationRevealTick(int n) {
        this.animationRevealTick = n;
    }

    public boolean isRewardRevealed() {
        return this.rewardRevealed;
    }

    public void setRewardRevealed(boolean bl) {
        this.rewardRevealed = bl;
    }

    public boolean isShowOutlineParticles() {
        return this.showOutlineParticles;
    }

    public void setShowOutlineParticles(boolean bl) {
        this.showOutlineParticles = bl;
    }

    public boolean isShowFloorParticles() {
        return this.showFloorParticles;
    }

    public void setShowFloorParticles(boolean bl) {
        this.showFloorParticles = bl;
    }

    public boolean isShowAroundParticles() {
        return this.showAroundParticles;
    }

    public void setShowAroundParticles(boolean bl) {
        this.showAroundParticles = bl;
    }

    public void addRunnable(String string, BukkitRunnable bukkitRunnable) {
        this.bukkitRunnables.put(string, bukkitRunnable);
    }

    public BukkitRunnable getRunnable(String string) {
        return this.bukkitRunnables.get(string);
    }

    public void startRunnable(String string, long l, long l2) {
        if (!this.bukkitRunnables.containsKey(string)) {
            return;
        }
        BukkitRunnable bukkitRunnable = this.bukkitRunnables.get(string);
        bukkitRunnable.runTaskTimer((Plugin)this.main, l, l2);
    }

    public void cancelRunnable(String string) {
        if (!this.bukkitRunnables.containsKey(string)) {
            return;
        }
        BukkitRunnable bukkitRunnable = this.bukkitRunnables.get(string);
        try {
            bukkitRunnable.cancel();
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public void cancelRunnables() {
        for (BukkitRunnable bukkitRunnable : this.bukkitRunnables.values()) {
            try {
                bukkitRunnable.cancel();
            }
            catch (IllegalStateException | NullPointerException runtimeException) {}
        }
    }

    public void setAnimationBlocks(AnimationBlocks animationBlocks) {
        this.animationBlocks = animationBlocks;
    }

    public AnimationBlocks getAnimationBlocks() {
        return this.animationBlocks;
    }

    public void startAnimationBlocks(long l) {
        if (this.animationBlocks == null) {
            return;
        }
        this.animationBlocks.runTaskTimer((Plugin)this.main, l, 1L);
    }

    public void stopAnimationBlocks() {
        if (this.animationBlocks == null) {
            return;
        }
        this.animationBlocks.cancel();
        this.animationBlocks.restore();
    }

    public Location getLocationRotation(double d) {
        switch (this.cubeletMachine.getRotation()) {
            case SOUTH: {
                Location location = this.cubeletMachine.getLocation().clone().add(0.5, d, -0.5);
                location.setYaw(Rotation.SOUTH.value);
                return location;
            }
            case NORTH: {
                Location location = this.cubeletMachine.getLocation().clone().add(0.5, d, 1.5);
                location.setYaw(Rotation.NORTH.value);
                return location;
            }
            case EAST: {
                Location location = this.cubeletMachine.getLocation().clone().add(-0.5, d, 0.5);
                location.setYaw(Rotation.EAST.value);
                return location;
            }
            case WEST: {
                Location location = this.cubeletMachine.getLocation().clone().add(1.5, d, 0.5);
                location.setYaw(Rotation.WEST.value);
                return location;
            }
        }
        return null;
    }

    public Rotation getRotation(boolean bl) {
        if (this.getCubeletBox().getRotation() == Rotation.NORTH) {
            return bl ? Rotation.SOUTH : Rotation.NORTH;
        }
        if (this.getCubeletBox().getRotation() == Rotation.SOUTH) {
            return bl ? Rotation.NORTH : Rotation.SOUTH;
        }
        if (this.getCubeletBox().getRotation() == Rotation.EAST) {
            return bl ? Rotation.WEST : Rotation.EAST;
        }
        if (this.getCubeletBox().getRotation() == Rotation.WEST) {
            return bl ? Rotation.EAST : Rotation.WEST;
        }
        return null;
    }
}

