/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation5;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation5.Animation5_Ball;
import me.davidml16.acubelets.animations.animation.animation5.Animation5_Blocks;
import me.davidml16.acubelets.animations.animation.animation5.Animation5_Music;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class Animation5_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;
    private Set<Animation5_Ball> balls = new HashSet<Animation5_Ball>();
    private double rotSpeed = 0.1;

    public Animation5_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n == 35) {
            Animation5_Ball animation5_Ball = new Animation5_Ball(this.getMain(), this.getBoxLocation().clone().add(2.0, 0.0, 2.0));
            animation5_Ball.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.balls.add(animation5_Ball);
        } else if (n == 45) {
            Animation5_Ball animation5_Ball = new Animation5_Ball(this.getMain(), this.getBoxLocation().clone().add(-2.0, 0.0, 2.0));
            animation5_Ball.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.balls.add(animation5_Ball);
        } else if (n == 55) {
            Animation5_Ball animation5_Ball = new Animation5_Ball(this.getMain(), this.getBoxLocation().clone().add(-2.0, 0.0, -2.0));
            animation5_Ball.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.balls.add(animation5_Ball);
        } else if (n == 65) {
            Animation5_Ball animation5_Ball = new Animation5_Ball(this.getMain(), this.getBoxLocation().clone().add(2.0, 0.0, -2.0));
            animation5_Ball.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.balls.add(animation5_Ball);
        } else if (n == 75) {
            this.startRunnable("music", 0L, 4L);
            this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), this.getCubeletType(), false);
            this.armorStandLocation = this.armorStand.getLocation();
            this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        } else if (n > 75 && n < 175 && this.armorStand != null) {
            if (n <= 125) {
                this.armorStandLocation.add(0.0, 0.02, 0.0);
            }
            this.armorStand.teleport(this.armorStandLocation);
            this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, this.rotSpeed, 0.0));
            this.rotSpeed += 0.003;
        }
        if (n == 173) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.setAnimationBlocks(new Animation5_Blocks(this.getCubeletBox().getLocation()));
        this.startAnimationBlocks(0L);
        this.addRunnable("music", new Animation5_Music(this.getCubeletBox().getLocation()));
        this.setColors(Arrays.asList(Color.YELLOW, Color.WHITE));
    }

    @Override
    public void onStop() {
        this.cancelRunnables();
        try {
            for (Animation5_Ball animation5_Ball : this.balls) {
                animation5_Ball.cancel();
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation5_Ball.getArmorStand())) continue;
                ArmorStand armorStand = animation5_Ball.getArmorStand();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        this.stopAnimationBlocks();
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.BALL_LARGE, this.getColors().get(0), this.getColors().get(1));
    }

    @Override
    public void onRewardReveal() {
        this.cancelRunnable("music");
        this.armorStand.remove();
        this.armorStand = null;
        for (Animation5_Ball animation5_Ball : this.balls) {
            animation5_Ball.cancel();
            if (!this.getMain().getAnimationHandler().getEntities().contains(animation5_Ball.getArmorStand())) continue;
            ArmorStand armorStand = animation5_Ball.getArmorStand();
            if (armorStand != null) {
                armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(armorStand);
        }
    }
}

