/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.commands.cubelets.subcommands;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.objects.Cubelet;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ExecuteInfo {
    private Main main;

    public ExecuteInfo(Main main) {
        this.main = main;
    }

    public boolean executeCommand(CommandSender commandSender, String string, String[] stringArray) {
        if (commandSender instanceof Player && !this.main.playerHasPermission((Player)commandSender, "acubelets.admin")) {
            commandSender.sendMessage(this.main.getLanguageHandler().getMessage("Commands.NoPerms"));
            return false;
        }
        if (stringArray.length == 1) {
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " info [player]"));
            commandSender.sendMessage("");
            return true;
        }
        String string2 = stringArray[1];
        try {
            this.main.getDatabaseHandler().hasName(string2, string3 -> {
                if (string3 == null) {
                    commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis player not exists in the database!"));
                } else if (Bukkit.getPlayer((String)string2) == null) {
                    try {
                        this.main.getDatabaseHandler().getPlayerUUID(string2, string2 -> {
                            UUID uUID = UUID.fromString(string2);
                            commandSender.sendMessage("");
                            this.main.getDatabaseHandler().getCubelets(uUID).thenAccept(list -> {
                                if (list.size() == 0) {
                                    String string2 = this.main.getLanguageHandler().getMessage("Commands.Cubelets.Info.NotHave");
                                    string2 = string2.replaceAll("%player%", Matcher.quoteReplacement(string3));
                                    commandSender.sendMessage(Utils.translate(string2));
                                } else {
                                    String string3 = this.main.getLanguageHandler().getMessage("Commands.Cubelets.Info.Have.Header");
                                    string3 = string3.replaceAll("%player%", Matcher.quoteReplacement(string3));
                                    commandSender.sendMessage(Utils.translate(string3));
                                    for (CubeletType cubeletType : this.main.getCubeletTypesHandler().getTypes().values()) {
                                        long l = list.stream().filter(cubelet -> cubelet.getType().equalsIgnoreCase(cubeletType.getId())).count();
                                        if (l <= 0L) continue;
                                        String string4 = this.main.getLanguageHandler().getMessage("Commands.Cubelets.Info.Have.List");
                                        string4 = string4.replaceAll("%player%", Matcher.quoteReplacement(string3));
                                        string4 = string4.replaceAll("%cubelet%", Matcher.quoteReplacement(cubeletType.getName()));
                                        string4 = string4.replaceAll("%amount%", Matcher.quoteReplacement(Long.toString(l)));
                                        commandSender.sendMessage(Utils.translate(string4));
                                    }
                                    commandSender.sendMessage("");
                                }
                            });
                        });
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                } else {
                    Player player = Bukkit.getPlayer((String)string2);
                    commandSender.sendMessage("");
                    List<Cubelet> list = this.main.getPlayerDataHandler().getData(player).getCubelets();
                    if (list.size() == 0) {
                        String string4 = this.main.getLanguageHandler().getMessage("Commands.Cubelets.Info.NotHave");
                        string4 = string4.replaceAll("%player%", Matcher.quoteReplacement(string3));
                        commandSender.sendMessage(Utils.translate(string4));
                    } else {
                        String string5 = this.main.getLanguageHandler().getMessage("Commands.Cubelets.Info.Have.Header");
                        string5 = string5.replaceAll("%player%", Matcher.quoteReplacement(string3));
                        commandSender.sendMessage(Utils.translate(string5));
                        for (CubeletType cubeletType : this.main.getCubeletTypesHandler().getTypes().values()) {
                            long l = list.stream().filter(cubelet -> cubelet.getType().equalsIgnoreCase(cubeletType.getId())).count();
                            if (l <= 0L) continue;
                            String string6 = this.main.getLanguageHandler().getMessage("Commands.Cubelets.Info.Have.List");
                            string6 = string6.replaceAll("%player%", Matcher.quoteReplacement(string3));
                            string6 = string6.replaceAll("%cubelet%", Matcher.quoteReplacement(cubeletType.getName()));
                            string6 = string6.replaceAll("%amount%", Matcher.quoteReplacement(Long.toString(l)));
                            commandSender.sendMessage(Utils.translate(string6));
                        }
                        commandSender.sendMessage("");
                    }
                }
            });
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return true;
    }
}

