/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.commands.cubelets.subcommands;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.admin.AnimationsMenu;
import me.davidml16.acubelets.menus.admin.rewards.RaritiesMenu;
import me.davidml16.acubelets.menus.admin.rewards.RewardsMenu;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.menus.admin.type.TypeListMenu;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.MemorySection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ExecuteType {
    private List<String> templates;
    private Main main;

    public ExecuteType(Main main) {
        this.main = main;
        this.templates = main.getTemplates();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeCommand(CommandSender commandSender, String string, String[] stringArray) {
        if (commandSender instanceof Player && !this.main.playerHasPermission((Player)commandSender, "acubelets.admin")) {
            commandSender.sendMessage(this.main.getLanguageHandler().getMessage("Commands.NoPerms"));
            return false;
        }
        if (stringArray.length == 1) {
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " type create [id] [name]"));
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " type remove [id]"));
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " type template [name]"));
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " type list"));
            commandSender.sendMessage("");
            return false;
        }
        if (stringArray[1].equalsIgnoreCase("list")) {
            if (!(commandSender instanceof Player)) return true;
            new TypeListMenu(this.main, (Player)commandSender).open();
            return true;
        }
        if (stringArray[1].equalsIgnoreCase("create")) {
            if (stringArray.length <= 3) {
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " type create [id] [name]"));
                return false;
            }
            String string2 = stringArray[2].toLowerCase();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 3; i < stringArray.length; ++i) {
                stringBuilder.append(stringArray[i]).append(stringArray.length - 1 > i ? " " : "");
            }
            if (string2.equalsIgnoreCase("random")) {
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis " + string + " type id its not valid!"));
                return true;
            }
            if (this.main.getCubeletTypesHandler().typeExist(string2)) {
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis " + string + " type already exists!"));
                return true;
            }
            if (!Character.isDigit(string2.charAt(0))) {
                if (!this.main.getCubeletTypesHandler().createType(string2)) return true;
                FileConfiguration fileConfiguration = this.main.getCubeletTypesHandler().getConfig(string2);
                fileConfiguration.set("type.name", (Object)stringBuilder.toString());
                fileConfiguration.set("type.animation", (Object)"animation1");
                fileConfiguration.set("type.expiration", (Object)"2w");
                fileConfiguration.set("type.icon.texture", (Object)"base64:eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYWYyMmI2YTNhMGYyNGJkZWVhYjJhNmFjZDliMWY1MmJiOTU5NGQ1ZjZiMWUyYzA1ZGRkYjIxOTQxMGM4In19fQ==");
                List<String> list = Arrays.asList("&7This is the most common type of", "&7Cubelet. Initial scans indicate", "&7that the contents of this cubelet", "&7will be probably basic.");
                fileConfiguration.set("type.description", list);
                List<String> list2 = Arrays.asList("&5Received: &a%received% ago", "&5Expires: &aIn %expires%", "", "%description%", "", "&6Click to open.");
                fileConfiguration.set("type.lore.opening.available", list2);
                List<String> list3 = Arrays.asList("&5Received: &a%received% ago", "&5Expires: &cExpired", "", "%description%", "");
                fileConfiguration.set("type.lore.opening.expired", list3);
                fileConfiguration.set("type.rarities", new ArrayList());
                fileConfiguration.set("type.rewards", new ArrayList());
                this.main.getCubeletTypesHandler().saveConfig(string2);
                this.main.getPluginHandler().reloadAll();
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &aSuccesfully created " + string + " type &e" + string2 + " &awith the name &e" + stringBuilder));
                return true;
            }
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThe " + string + " type cannot start with a number, use for example 'normal'."));
            return false;
        }
        if (stringArray[1].equalsIgnoreCase("remove")) {
            if (stringArray.length < 3) {
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cUsage: /" + string + " type remove [id]"));
                return false;
            }
            String string3 = stringArray[2].toLowerCase();
            if (!this.main.getCubeletTypesHandler().typeExist(string3)) {
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThis " + string + " type no exists!"));
                return true;
            }
            if (!Character.isDigit(string3.charAt(0))) {
                if (!this.main.getCubeletTypesHandler().removeType(string3)) return true;
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    if (this.main.getMenuHandler().hasOpenedMenu(player, CubeletsMenu.class)) {
                        player.closeInventory();
                    }
                    if (this.main.getMenuHandler().hasOpenedMenu(player, TypeConfigMenu.class)) {
                        player.closeInventory();
                    }
                    if (this.main.getMenuHandler().hasOpenedMenu(player, RewardsMenu.class)) {
                        player.closeInventory();
                    }
                    if (this.main.getMenuHandler().hasOpenedMenu(player, RaritiesMenu.class)) {
                        player.closeInventory();
                    }
                    if (!this.main.getMenuHandler().hasOpenedMenu(player, AnimationsMenu.class)) continue;
                    player.closeInventory();
                }
                this.main.getCubeletTypesHandler().getTypes().remove(string3);
                this.main.getDatabaseHandler().removeCubelet(string3);
                for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                    this.main.getPlayerDataHandler().getData(player).getCubelets().removeIf(cubelet -> cubelet.getType().equalsIgnoreCase(string3));
                }
                commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &aSuccesfully removed " + string + " type &e" + string3 + "&a!"));
                return true;
            }
            commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cThe " + string + " type cannot start with a number, use for example 'normal'."));
            return false;
        }
        if (!stringArray[1].equalsIgnoreCase("template")) return true;
        if (stringArray.length < 3) {
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(" &cUsage: /" + string + " type template [name]"));
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(" &aAvailable templates: &e" + this.templates));
            commandSender.sendMessage("");
            return false;
        }
        String string4 = stringArray[2].toLowerCase();
        if (!string4.equalsIgnoreCase("*")) {
            if (!this.templates.contains(string4.toLowerCase())) {
                commandSender.sendMessage("");
                commandSender.sendMessage(Utils.translate(" &cThis template not exists"));
                commandSender.sendMessage("");
                commandSender.sendMessage(Utils.translate(" &aAvailable templates: &e" + this.templates));
                commandSender.sendMessage("");
                return false;
            }
            commandSender.sendMessage("");
            this.donwloadTemplate(commandSender, string4);
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(" &aPlease use /" + string + " reload, to load it"));
            commandSender.sendMessage("");
            return true;
        } else {
            commandSender.sendMessage("");
            for (String string5 : this.templates) {
                this.donwloadTemplate(commandSender, string5);
            }
            commandSender.sendMessage("");
            commandSender.sendMessage(Utils.translate(" &aPlease use /" + string + " reload, to load it"));
            commandSender.sendMessage("");
        }
        return true;
    }

    public void donwloadTemplate(CommandSender commandSender, String string) {
        File file = new File(this.main.getDataFolder() + "/types/" + string + ".yml");
        if (file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        InputStreamReader inputStreamReader = new InputStreamReader(this.main.getResource("type_templates/" + string + ".yml"));
        YamlConfiguration yamlConfiguration2 = YamlConfiguration.loadConfiguration((Reader)inputStreamReader);
        for (String string2 : yamlConfiguration2.getKeys(true)) {
            if (yamlConfiguration2.get(string2) instanceof MemorySection) continue;
            linkedHashMap.put(string2, yamlConfiguration2.get(string2));
        }
        for (String string2 : linkedHashMap.keySet()) {
            if (yamlConfiguration.isSet(string2)) continue;
            yamlConfiguration.set(string2, linkedHashMap.get(string2));
        }
        for (String string2 : yamlConfiguration.getKeys(true)) {
            if (yamlConfiguration.get(string2) instanceof MemorySection || yamlConfiguration2.isSet(string2)) continue;
            yamlConfiguration.set(string2, null);
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        commandSender.sendMessage(Utils.translate(" &aTemplate '&6" + string + "&a' has been downloaded successfully"));
    }
}

