/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.commands.points;

import java.util.ArrayList;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.commands.points.subcommands.ExecuteGive;
import me.davidml16.acubelets.commands.points.subcommands.ExecuteInfo;
import me.davidml16.acubelets.commands.points.subcommands.ExecuteRemove;
import me.davidml16.acubelets.commands.points.subcommands.ExecuteSet;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CoreCommand
extends Command {
    private final Main main = Main.get();
    private final ExecuteGive executeGive = new ExecuteGive(this.main);
    private final ExecuteRemove executeRemove = new ExecuteRemove(this.main);
    private final ExecuteSet executeSet = new ExecuteSet(this.main);
    private final ExecuteInfo executeInfo = new ExecuteInfo(this.main);

    public CoreCommand(String string) {
        super(string);
    }

    public boolean execute(CommandSender commandSender, String string, String[] stringArray) {
        if (stringArray.length == 0) {
            if (commandSender instanceof Player) {
                commandSender.sendMessage(this.main.getLanguageHandler().getMessage("Commands.Balance.Points").replaceAll("%points_available%", "" + this.main.getPlayerDataHandler().getData((Player)commandSender).getLootPoints()));
                return true;
            }
            return this.sendCommandHelp(commandSender, string);
        }
        switch (stringArray[0]) {
            case "help": {
                return this.sendCommandHelp(commandSender, string);
            }
            case "give": {
                return this.executeGive.executeCommand(commandSender, string, stringArray);
            }
            case "remove": {
                return this.executeRemove.executeCommand(commandSender, string, stringArray);
            }
            case "set": {
                return this.executeSet.executeCommand(commandSender, string, stringArray);
            }
            case "info": {
                return this.executeInfo.executeCommand(commandSender, string, stringArray);
            }
        }
        commandSender.sendMessage("");
        commandSender.sendMessage(Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cInvalid argument, use /" + string + " help to see available commands"));
        commandSender.sendMessage("");
        return false;
    }

    private boolean sendCommandHelp(CommandSender commandSender, String string) {
        if (commandSender instanceof Player && !this.main.playerHasPermission((Player)commandSender, "acubelets.admin")) {
            return false;
        }
        commandSender.sendMessage("");
        commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " give [player] [amount]"));
        commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " remove [player] [amount]"));
        commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " set [player] [amount]"));
        commandSender.sendMessage(Utils.translate("&7 - &a/" + string + " info [player]"));
        commandSender.sendMessage("");
        return true;
    }

    public List<String> tabComplete(CommandSender commandSender, String string, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            return null;
        }
        Player player = (Player)commandSender;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (stringArray.length == 1 && this.main.playerHasPermission(player, "acubelets.admin")) {
            arrayList.add("give");
            arrayList.add("remove");
            arrayList.add("set");
            arrayList.add("info");
        }
        if ((stringArray[0].equalsIgnoreCase("give") || stringArray[0].equalsIgnoreCase("remove") || stringArray[0].equalsIgnoreCase("set") || stringArray[0].equalsIgnoreCase("info")) && stringArray.length == 2 && this.main.playerHasPermission(player, "acubelets.admin")) {
            for (String string2 : this.main.getServer().getOnlinePlayers()) {
                arrayList.add(string2.getName());
            }
        }
        for (String string2 : arrayList) {
            if (!string2.startsWith(stringArray[stringArray.length - 1])) continue;
            arrayList2.add(string2);
        }
        return arrayList2.isEmpty() ? arrayList : arrayList2;
    }
}

