/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.menus.admin.type.TypeSettingsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RenameConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public RenameConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RenameMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"type", (Object)cubeletType);
        conversation.getContext().setSessionData((Object)"typeName", (Object)cubeletType.getName());
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public class RenameMenuOptions
    extends FixedSetPrompt {
        RenameMenuOptions() {
            super(new String[]{"1", "2"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"type");
            Player player = (Player)conversationContext.getSessionData((Object)"player");
            switch (string) {
                case "1": {
                    return new CommonPrompts.CommonStringPrompt(RenameConversation.this.main, (Prompt)this, true, ChatColor.YELLOW + "  Enter cubelet type name, \"cancel\" to return.\n\n ", "typeName");
                }
                case "2": {
                    String string2 = (String)conversationContext.getSessionData((Object)"typeName");
                    cubeletType.setName(string2);
                    RenameConversation.this.main.getCubeletTypesHandler().getConfig(cubeletType.getId()).set("type.name", (Object)string2);
                    RenameConversation.this.main.getCubeletTypesHandler().saveConfig(cubeletType.getId());
                    conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(RenameConversation.this.main.getLanguageHandler().getPrefix() + " &aSaved data of cubelet type &e" + cubeletType.getId() + " &awithout errors!"));
                    Sounds.playSound(player, player.getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                    RenameConversation.this.main.getMenuHandler().reloadAllMenus(TypeConfigMenu.class);
                    RenameConversation.this.main.getMenuHandler().reloadAllMenus(TypeSettingsMenu.class);
                    TypeSettingsMenu typeSettingsMenu = new TypeSettingsMenu(RenameConversation.this.main, player);
                    typeSettingsMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                    typeSettingsMenu.open();
                    RenameConversation.this.main.getConversationHandler().removeConversation(player);
                    return Prompt.END_OF_CONVERSATION;
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET TYPE RENAME MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Rename cubelet type (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)((String)conversationContext.getSessionData((Object)"typeName"))) + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Save and exit\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

